/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayMap<K, V>
implements Iterable<ObjectMap.Entry<K, V>> {
    private Entries entries1;
    private Entries entries2;
    public K[] keys;
    private Keys keys1;
    private Keys keys2;
    public boolean ordered;
    public int size;
    public V[] values;
    private Values values1;
    private Values values2;

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int n) {
        this(true, n);
    }

    public ArrayMap(ArrayMap arrayMap) {
        this(arrayMap.ordered, arrayMap.size, arrayMap.keys.getClass().getComponentType(), arrayMap.values.getClass().getComponentType());
        this.size = arrayMap.size;
        System.arraycopy(arrayMap.keys, 0, this.keys, 0, this.size);
        System.arraycopy(arrayMap.values, 0, this.values, 0, this.size);
    }

    public ArrayMap(Class clazz, Class clazz2) {
        this(false, 16, clazz, clazz2);
    }

    public ArrayMap(boolean bl, int n) {
        this.ordered = bl;
        this.keys = new Object[n];
        this.values = new Object[n];
    }

    public ArrayMap(boolean bl, int n, Class clazz, Class clazz2) {
        this.ordered = bl;
        this.keys = (Object[])ArrayReflection.newInstance(clazz, n);
        this.values = (Object[])ArrayReflection.newInstance(clazz2, n);
    }

    public void clear() {
        K[] KArray = this.keys;
        V[] VArray = this.values;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            KArray[i] = null;
            VArray[i] = null;
        }
        this.size = 0;
    }

    public void clear(int n) {
        if (this.keys.length <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(K k) {
        int n;
        K[] KArray = this.keys;
        if (k == null) {
            while (n >= 0) {
                if (KArray[n] == k) {
                    return true;
                }
                --n;
            }
        } else {
            for (int i = n = this.size - 1; i >= 0; --i) {
                if (!k.equals(KArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean containsValue(V v, boolean bl) {
        int n;
        V[] VArray = this.values;
        int n2 = n = this.size - 1;
        if (!bl) {
            n2 = n;
            if (v == null) {
                n2 = n;
            } else {
                while (n2 >= 0) {
                    if (v.equals(VArray[n2])) {
                        return true;
                    }
                    --n2;
                }
                return false;
            }
        }
        while (n2 >= 0) {
            if (VArray[n2] == v) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.keys.length) {
                this.resize(Math.max(8, n));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            Entries entries = this.entries1;
            entries.index = 0;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        Entries entries = this.entries2;
        entries.index = 0;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayMap)) {
            return false;
        }
        ArrayMap arrayMap = (ArrayMap)object;
        int n = arrayMap.size;
        int n2 = this.size;
        if (n != n2) {
            return false;
        }
        K[] KArray = this.keys;
        V[] VArray = this.values;
        for (n = 0; n < n2; ++n) {
            K k = KArray[n];
            object = VArray[n];
            if (!(object == null ? arrayMap.get(k, ObjectMap.dummy) != null : !object.equals(arrayMap.get(k)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object VArray) {
        if (VArray == this) {
            return true;
        }
        if (!(VArray instanceof ArrayMap)) {
            return false;
        }
        ArrayMap arrayMap = (ArrayMap)VArray;
        int n = arrayMap.size;
        int n2 = this.size;
        if (n != n2) {
            return false;
        }
        K[] KArray = this.keys;
        VArray = this.values;
        for (n = 0; n < n2; ++n) {
            if (VArray[n] == arrayMap.get(KArray[n], ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public K firstKey() {
        if (this.size != 0) {
            return this.keys[0];
        }
        throw new IllegalStateException("Map is empty.");
    }

    public V firstValue() {
        if (this.size != 0) {
            return this.values[0];
        }
        throw new IllegalStateException("Map is empty.");
    }

    public V get(K k) {
        return this.get(k, null);
    }

    public V get(K k, V v) {
        int n;
        K[] KArray = this.keys;
        if (k == null) {
            while (n >= 0) {
                if (KArray[n] == k) {
                    return this.values[n];
                }
                --n;
            }
        } else {
            for (int i = n = this.size - 1; i >= 0; --i) {
                if (!k.equals(KArray[i])) continue;
                return this.values[i];
            }
        }
        return v;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public K getKey(V v, boolean bl) {
        int n;
        V[] VArray = this.values;
        int n2 = n = this.size - 1;
        if (!bl) {
            n2 = n;
            if (v == null) {
                n2 = n;
            } else {
                while (n2 >= 0) {
                    if (v.equals(VArray[n2])) {
                        return this.keys[n2];
                    }
                    --n2;
                }
                return null;
            }
        }
        while (n2 >= 0) {
            if (VArray[n2] == v) {
                return this.keys[n2];
            }
            --n2;
        }
        return null;
    }

    public K getKeyAt(int n) {
        if (n < this.size) {
            return this.keys[n];
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public V getValueAt(int n) {
        if (n < this.size) {
            return this.values[n];
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public int hashCode() {
        K[] KArray = this.keys;
        V[] VArray = this.values;
        int n = this.size;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            K k = KArray[i];
            V v = VArray[i];
            int n3 = n2;
            if (k != null) {
                n3 = n2 + k.hashCode() * 31;
            }
            n2 = n3;
            if (v == null) continue;
            n2 = n3 + v.hashCode();
        }
        return n2;
    }

    public int indexOfKey(K k) {
        int n;
        K[] KArray = this.keys;
        int n2 = 0;
        if (k == null) {
            n2 = this.size;
            for (n = 0; n < n2; ++n) {
                if (KArray[n] != k) continue;
                return n;
            }
        } else {
            int n3 = this.size;
            for (n = n2; n < n3; ++n) {
                if (!k.equals(KArray[n])) continue;
                return n;
            }
        }
        return -1;
    }

    public int indexOfValue(V v, boolean bl) {
        int n;
        V[] VArray = this.values;
        int n2 = 0;
        if (!bl && v != null) {
            n2 = this.size;
            for (n = 0; n < n2; ++n) {
                if (!v.equals(VArray[n])) continue;
                return n;
            }
        } else {
            int n3 = this.size;
            for (n = n2; n < n3; ++n) {
                if (VArray[n] != v) continue;
                return n;
            }
        }
        return -1;
    }

    public void insert(int n, K k, V v) {
        int n2 = this.size;
        if (n <= n2) {
            if (n2 == this.keys.length) {
                this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                Object[] objectArray = this.keys;
                n2 = n + 1;
                System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
                objectArray = this.values;
                System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
            } else {
                Object[] objectArray = this.keys;
                n2 = this.size;
                objectArray[n2] = objectArray[n];
                objectArray = this.values;
                objectArray[n2] = objectArray[n];
            }
            ++this.size;
            this.keys[n] = k;
            this.values[n] = v;
            return;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectMap.Entry<K, V>> iterator() {
        return this.entries();
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            Keys keys = this.keys1;
            keys.index = 0;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        Keys keys = this.keys2;
        keys.index = 0;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public K peekKey() {
        return this.keys[this.size - 1];
    }

    public V peekValue() {
        return this.values[this.size - 1];
    }

    public int put(K k, V v) {
        int n;
        int n2 = n = this.indexOfKey(k);
        if (n == -1) {
            n2 = this.size;
            if (n2 == this.keys.length) {
                this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            n2 = this.size;
            this.size = n2 + 1;
        }
        this.keys[n2] = k;
        this.values[n2] = v;
        return n2;
    }

    public int put(K k, V v, int n) {
        int n2 = this.indexOfKey(k);
        if (n2 != -1) {
            this.removeIndex(n2);
        } else {
            n2 = this.size;
            if (n2 == this.keys.length) {
                this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
        }
        Object[] objectArray = this.keys;
        n2 = n + 1;
        System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
        objectArray = this.values;
        System.arraycopy(objectArray, n, objectArray, n2, this.size - n);
        this.keys[n] = k;
        this.values[n] = v;
        ++this.size;
        return n;
    }

    public void putAll(ArrayMap<? extends K, ? extends V> arrayMap) {
        this.putAll(arrayMap, 0, arrayMap.size);
    }

    public void putAll(ArrayMap<? extends K, ? extends V> arrayMap, int n, int n2) {
        if (n + n2 <= arrayMap.size) {
            int n3 = this.size + n2 - n;
            if (n3 >= this.keys.length) {
                this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
            }
            System.arraycopy(arrayMap.keys, n, this.keys, this.size, n2);
            System.arraycopy(arrayMap.values, n, this.values, this.size, n2);
            this.size += n2;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(arrayMap.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            K[] KArray = this.keys;
            this.size = n2 - 1;
            if (this.ordered) {
                n2 = n + 1;
                System.arraycopy(KArray, n2, KArray, n, this.size - n);
                V[] VArray = this.values;
                System.arraycopy(VArray, n2, VArray, n, this.size - n);
            } else {
                n2 = this.size;
                KArray[n] = KArray[n2];
                V[] VArray = this.values;
                VArray[n] = VArray[n2];
            }
            n = this.size;
            KArray[n] = null;
            this.values[n] = null;
            return;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public V removeKey(K object) {
        int n;
        K[] KArray = this.keys;
        int n2 = 0;
        if (object == null) {
            n2 = this.size;
            for (n = 0; n < n2; ++n) {
                if (KArray[n] != object) continue;
                object = this.values[n];
                this.removeIndex(n);
                return (V)object;
            }
        } else {
            int n3 = this.size;
            for (n = n2; n < n3; ++n) {
                if (!object.equals(KArray[n])) continue;
                object = this.values[n];
                this.removeIndex(n);
                return (V)object;
            }
        }
        return null;
    }

    public boolean removeValue(V v, boolean bl) {
        V[] VArray = this.values;
        if (!bl && v != null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!v.equals(VArray[i])) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (VArray[i] != v) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    protected void resize(int n) {
        Object[] objectArray = (Object[])ArrayReflection.newInstance(this.keys.getClass().getComponentType(), n);
        System.arraycopy(this.keys, 0, objectArray, 0, Math.min(this.size, objectArray.length));
        this.keys = objectArray;
        objectArray = (Object[])ArrayReflection.newInstance(this.values.getClass().getComponentType(), n);
        System.arraycopy(this.values, 0, objectArray, 0, Math.min(this.size, objectArray.length));
        this.values = objectArray;
    }

    public void reverse() {
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            Object object = this.keys;
            Object object2 = object[i];
            object[i] = object[n3];
            object[n3] = object2;
            object2 = this.values;
            object = object2[i];
            object2[i] = object2[n3];
            object2[n3] = object;
        }
    }

    public void setKey(int n, K k) {
        if (n < this.size) {
            this.keys[n] = k;
            return;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public void setValue(int n, V v) {
        if (n < this.size) {
            this.values[n] = v;
            return;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public void shrink() {
        int n = this.keys.length;
        int n2 = this.size;
        if (n == n2) {
            return;
        }
        this.resize(n2);
    }

    public void shuffle() {
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            Object[] objectArray = this.keys;
            K k = objectArray[i];
            objectArray[i] = objectArray[n];
            objectArray[n] = k;
            objectArray = this.values;
            k = objectArray[i];
            objectArray[i] = objectArray[n];
            objectArray[n] = k;
        }
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        K[] KArray = this.keys;
        V[] VArray = this.values;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(KArray[0]);
        stringBuilder.append('=');
        stringBuilder.append(VArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(KArray[i]);
            stringBuilder.append('=');
            stringBuilder.append(VArray[i]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size <= n) {
            return;
        }
        for (int i = n; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = n;
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            Values values = this.values1;
            values.index = 0;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        Values values = this.values2;
        values.index = 0;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<K, V>
    implements Iterable<ObjectMap.Entry<K, V>>,
    Iterator<ObjectMap.Entry<K, V>> {
        ObjectMap.Entry<K, V> entry = new ObjectMap.Entry();
        int index;
        private final ArrayMap<K, V> map;
        boolean valid = true;

        public Entries(ArrayMap<K, V> arrayMap) {
            this.map = arrayMap;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.map.size;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<ObjectMap.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public ObjectMap.Entry<K, V> next() {
            if (this.index < this.map.size) {
                if (this.valid) {
                    this.entry.key = this.map.keys[this.index];
                    ObjectMap.Entry<K, V> entry = this.entry;
                    V[] VArray = this.map.values;
                    int n = this.index;
                    this.index = n + 1;
                    entry.value = VArray[n];
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(this.index));
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }
    }

    public static class Keys<K>
    implements Iterable<K>,
    Iterator<K> {
        int index;
        private final ArrayMap<K, Object> map;
        boolean valid = true;

        public Keys(ArrayMap<K, Object> arrayMap) {
            this.map = arrayMap;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.map.size;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.index < this.map.size) {
                if (this.valid) {
                    K[] KArray = this.map.keys;
                    int n = this.index;
                    this.index = n + 1;
                    return KArray[n];
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(this.index));
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        public Array<K> toArray() {
            return new Array(true, this.map.keys, this.index, this.map.size - this.index);
        }

        public Array<K> toArray(Array array) {
            array.addAll(this.map.keys, this.index, this.map.size - this.index);
            return array;
        }
    }

    public static class Values<V>
    implements Iterable<V>,
    Iterator<V> {
        int index;
        private final ArrayMap<Object, V> map;
        boolean valid = true;

        public Values(ArrayMap<Object, V> arrayMap) {
            this.map = arrayMap;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.map.size;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.index < this.map.size) {
                if (this.valid) {
                    V[] VArray = this.map.values;
                    int n = this.index;
                    this.index = n + 1;
                    return VArray[n];
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(this.index));
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        public Array<V> toArray() {
            return new Array(true, this.map.values, this.index, this.map.size - this.index);
        }

        public Array<V> toArray(Array array) {
            array.addAll(this.map.values, this.index, this.map.size - this.index);
            return array;
        }
    }
}

