/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Predicate;
import com.badlogic.gdx.utils.Select;
import com.badlogic.gdx.utils.Sort;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Array<T>
implements Iterable<T> {
    public T[] items;
    private ArrayIterable iterable;
    public boolean ordered;
    private Predicate.PredicateIterable<T> predicateIterable;
    public int size;

    public Array() {
        this(true, 16);
    }

    public Array(int n) {
        this(true, n);
    }

    public Array(Array<? extends T> array) {
        this(array.ordered, array.size, array.items.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public Array(Class clazz) {
        this(true, 16, clazz);
    }

    public Array(boolean bl, int n) {
        this.ordered = bl;
        this.items = new Object[n];
    }

    public Array(boolean bl, int n, Class clazz) {
        this.ordered = bl;
        this.items = (Object[])ArrayReflection.newInstance(clazz, n);
    }

    public Array(boolean bl, T[] TArray, int n, int n2) {
        this(bl, n2, TArray.getClass().getComponentType());
        this.size = n2;
        System.arraycopy(TArray, n, this.items, 0, this.size);
    }

    public Array(T[] TArray) {
        this(true, TArray, 0, TArray.length);
    }

    public static <T> Array<T> of(Class<T> clazz) {
        return new Array<T>(clazz);
    }

    public static <T> Array<T> of(boolean bl, int n, Class<T> clazz) {
        return new Array<T>(bl, n, clazz);
    }

    public static <T> Array<T> with(T ... TArray) {
        return new Array<T>(TArray);
    }

    public void add(T t) {
        T[] TArray = this.items;
        int n = this.size;
        T[] TArray2 = TArray;
        if (n == TArray.length) {
            TArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        TArray2[n] = t;
    }

    public void add(T t, T t2) {
        T[] TArray = this.items;
        int n = this.size;
        T[] TArray2 = TArray;
        if (n + 1 >= TArray.length) {
            TArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        TArray2[n] = t;
        TArray2[n + 1] = t2;
        this.size = n + 2;
    }

    public void add(T t, T t2, T t3) {
        T[] TArray = this.items;
        int n = this.size;
        T[] TArray2 = TArray;
        if (n + 2 >= TArray.length) {
            TArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        TArray2[n] = t;
        TArray2[n + 1] = t2;
        TArray2[n + 2] = t3;
        this.size = n + 3;
    }

    public void add(T t, T t2, T t3, T t4) {
        T[] TArray = this.items;
        int n = this.size;
        T[] TArray2 = TArray;
        if (n + 3 >= TArray.length) {
            TArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        TArray2[n] = t;
        TArray2[n + 1] = t2;
        TArray2[n + 2] = t3;
        TArray2[n + 3] = t4;
        this.size = n + 4;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int n, int n2) {
        if (n + n2 <= array.size) {
            this.addAll(array.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("start + count must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(array.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(T ... TArray) {
        this.addAll(TArray, 0, TArray.length);
    }

    public void addAll(T[] TArray, int n, int n2) {
        T[] TArray2 = this.items;
        int n3 = this.size + n2;
        T[] TArray3 = TArray2;
        if (n3 > TArray2.length) {
            TArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(TArray, n, TArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        T[] TArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            TArray[i] = null;
        }
        this.size = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean contains(T t, boolean bl) {
        int n;
        T[] TArray = this.items;
        int n2 = n = this.size - 1;
        if (!bl) {
            n2 = n;
            if (t == null) {
                n2 = n;
            } else {
                while (n2 >= 0) {
                    if (t.equals(TArray[n2])) {
                        return true;
                    }
                    --n2;
                }
                return false;
            }
        }
        while (n2 >= 0) {
            if (TArray[n2] == t) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public boolean containsAll(Array<? extends T> array, boolean bl) {
        T[] TArray = array.items;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (this.contains(TArray[i], bl)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Array<? extends T> array, boolean bl) {
        T[] TArray = array.items;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (!this.contains(TArray[i], bl)) continue;
            return true;
        }
        return false;
    }

    public T[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object TArray) {
        if (TArray == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(TArray instanceof Array)) {
            return false;
        }
        Array<T> array = (Array)TArray;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        TArray = this.items;
        T[] TArray2 = array.items;
        for (int i = 0; i < n; ++i) {
            array = TArray[i];
            T t = TArray2[i];
            if (array != null ? ((Object)array).equals(t) : t == null) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object TArray) {
        if (TArray == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(TArray instanceof Array)) {
            return false;
        }
        T[] TArray2 = TArray;
        if (!TArray2.ordered) {
            return false;
        }
        int n = this.size;
        if (n != TArray2.size) {
            return false;
        }
        TArray = this.items;
        TArray2 = TArray2.items;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    public T first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public T get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] TArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 * 31;
            T t = TArray[i];
            n2 = n3;
            if (t == null) continue;
            n2 = n3 + t.hashCode();
        }
        return n2;
    }

    public int indexOf(T t, boolean bl) {
        int n;
        T[] TArray = this.items;
        int n2 = 0;
        if (!bl && t != null) {
            n2 = this.size;
            for (n = 0; n < n2; ++n) {
                if (!t.equals(TArray[n])) continue;
                return n;
            }
        } else {
            int n3 = this.size;
            for (n = n2; n < n3; ++n) {
                if (TArray[n] != t) continue;
                return n;
            }
        }
        return -1;
    }

    public void insert(int n, T object) {
        int n2 = this.size;
        if (n <= n2) {
            T[] TArray;
            T[] TArray2 = TArray = this.items;
            if (n2 == TArray.length) {
                TArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(TArray2, n, TArray2, n + 1, this.size - n);
            } else {
                TArray2[this.size] = TArray2[n];
            }
            ++this.size;
            TArray2[n] = object;
            return;
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("index can't be > size: ");
        ((java.lang.StringBuilder)object).append(n);
        ((java.lang.StringBuilder)object).append(" > ");
        ((java.lang.StringBuilder)object).append(this.size);
        throw new IndexOutOfBoundsException(((java.lang.StringBuilder)object).toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new ArrayIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this);
        }
        return this.iterable.iterator();
    }

    public int lastIndexOf(T t, boolean bl) {
        T[] TArray = this.items;
        if (!bl && t != null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!t.equals(TArray[i])) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (TArray[i] != t) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public T peek() {
        int n = this.size;
        if (n != 0) {
            return this.items[n - 1];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public T pop() {
        int n = this.size;
        if (n != 0) {
            this.size = n - 1;
            T[] TArray = this.items;
            n = this.size;
            T t = TArray[n];
            TArray[n] = null;
            return t;
        }
        throw new IllegalStateException("Array is empty.");
    }

    public T random() {
        int n = this.size;
        if (n == 0) {
            return null;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(Array<? extends T> array, boolean bl) {
        int n;
        int n2 = this.size;
        T[] TArray = this.items;
        boolean bl2 = false;
        if (bl) {
            int n3 = array.size;
            int n4 = n2;
            int n5 = 0;
            while (true) {
                n = n4;
                if (n5 < n3) {
                    T t = array.get(n5);
                    int n6 = 0;
                    while (true) {
                        n = n4;
                        if (n6 >= n4) break;
                        if (t == TArray[n6]) {
                            this.removeIndex(n6);
                            n = n4 - 1;
                            break;
                        }
                        ++n6;
                    }
                    ++n5;
                    n4 = n;
                    continue;
                }
                break;
            }
        } else {
            int n7 = array.size;
            int n8 = n2;
            int n9 = 0;
            while (true) {
                n = n8;
                if (n9 >= n7) break;
                T t = array.get(n9);
                int n10 = 0;
                while (true) {
                    n = n8;
                    if (n10 >= n8) break;
                    if (t.equals(TArray[n10])) {
                        this.removeIndex(n10);
                        n = n8 - 1;
                        break;
                    }
                    ++n10;
                }
                ++n9;
                n8 = n;
            }
        }
        bl = bl2;
        if (n != n2) {
            bl = true;
        }
        return bl;
    }

    public T removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            T[] TArray = this.items;
            T t = TArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(TArray, n + 1, TArray, n, this.size - n);
            } else {
                TArray[n] = TArray[this.size];
            }
            TArray[this.size] = null;
            return t;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                T[] TArray = this.items;
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    n2 = n4 + n;
                    System.arraycopy(TArray, n2, TArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    System.arraycopy(TArray, n2, TArray, n, n3 - n2);
                }
                for (n = n5; n < n3; ++n) {
                    TArray[n] = null;
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        Serializable serializable = new java.lang.StringBuilder();
        serializable.append("end can't be >= size: ");
        serializable.append(n2);
        serializable.append(" >= ");
        serializable.append(this.size);
        serializable = new IndexOutOfBoundsException(serializable.toString());
        throw serializable;
    }

    public boolean removeValue(T t, boolean bl) {
        T[] TArray = this.items;
        if (!bl && t != null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!t.equals(TArray[i])) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    protected T[] resize(int n) {
        T[] TArray = this.items;
        Object[] objectArray = (Object[])ArrayReflection.newInstance(TArray.getClass().getComponentType(), n);
        System.arraycopy(TArray, 0, objectArray, 0, Math.min(this.size, objectArray.length));
        this.items = objectArray;
        return objectArray;
    }

    public void reverse() {
        T[] TArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            T t = TArray[i];
            TArray[i] = TArray[n3];
            TArray[n3] = t;
        }
    }

    public Iterable<T> select(Predicate<T> predicate) {
        Predicate.PredicateIterable<T> predicateIterable;
        if (Collections.allocateIterators) {
            new Predicate.PredicateIterable<T>(this, predicate);
        }
        if ((predicateIterable = this.predicateIterable) == null) {
            this.predicateIterable = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            predicateIterable.set(this, predicate);
        }
        return this.predicateIterable;
    }

    public T selectRanked(Comparator<T> comparator, int n) {
        if (n >= 1) {
            return Select.instance().select(this.items, comparator, n, this.size);
        }
        throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
    }

    public int selectRankedIndex(Comparator<T> comparator, int n) {
        if (n >= 1) {
            return Select.instance().selectIndex(this.items, comparator, n, this.size);
        }
        throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
    }

    public void set(int n, T object) {
        if (n < this.size) {
            this.items[n] = object;
            return;
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("index can't be >= size: ");
        ((java.lang.StringBuilder)object).append(n);
        ((java.lang.StringBuilder)object).append(" >= ");
        ((java.lang.StringBuilder)object).append(this.size);
        throw new IndexOutOfBoundsException(((java.lang.StringBuilder)object).toString());
    }

    public T[] setSize(int n) {
        this.truncate(n);
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    public T[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        T[] TArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            T t = TArray[i];
            TArray[i] = TArray[n];
            TArray[n] = t;
        }
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator<? super T> comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                T[] TArray = this.items;
                T t = TArray[n];
                TArray[n] = TArray[n2];
                TArray[n2] = t;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class<V> objectArray) {
        objectArray = (Object[])ArrayReflection.newInstance(objectArray, this.size);
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(TArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (n >= 0) {
            if (this.size <= n) {
                return;
            }
            for (int i = n; i < this.size; ++i) {
                this.items[i] = null;
            }
            this.size = n;
            return;
        }
        Serializable serializable = new java.lang.StringBuilder();
        serializable.append("newSize must be >= 0: ");
        serializable.append(n);
        serializable = new IllegalArgumentException(serializable.toString());
        throw serializable;
    }

    public static class ArrayIterable<T>
    implements Iterable<T> {
        private final boolean allowRemove;
        private final Array<T> array;
        private ArrayIterator iterator1;
        private ArrayIterator iterator2;

        public ArrayIterable(Array<T> array) {
            this(array, true);
        }

        public ArrayIterable(Array<T> array, boolean bl) {
            this.array = array;
            this.allowRemove = bl;
        }

        @Override
        public Iterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ArrayIterator<T>(this.array, this.allowRemove);
                this.iterator2 = new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                ArrayIterator arrayIterator = this.iterator1;
                arrayIterator.index = 0;
                arrayIterator.valid = true;
                this.iterator2.valid = false;
                return arrayIterator;
            }
            ArrayIterator arrayIterator = this.iterator2;
            arrayIterator.index = 0;
            arrayIterator.valid = true;
            this.iterator1.valid = false;
            return arrayIterator;
        }
    }

    public static class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final boolean allowRemove;
        private final Array<T> array;
        int index;
        boolean valid = true;

        public ArrayIterator(Array<T> array) {
            this(array, true);
        }

        public ArrayIterator(Array<T> array, boolean bl) {
            this.array = array;
            this.allowRemove = bl;
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                boolean bl = this.index < this.array.size;
                return bl;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public T next() {
            if (this.index < this.array.size) {
                if (this.valid) {
                    T[] TArray = this.array.items;
                    int n = this.index;
                    this.index = n + 1;
                    return TArray[n];
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException(String.valueOf(this.index));
        }

        @Override
        public void remove() {
            if (this.allowRemove) {
                --this.index;
                this.array.removeIndex(this.index);
                return;
            }
            throw new GdxRuntimeException("Remove not allowed.");
        }

        public void reset() {
            this.index = 0;
        }
    }
}

