/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Timer;

public class TextField
extends Widget
implements Disableable {
    private static final char BACKSPACE = '\b';
    private static final char BULLET = '\u0095';
    private static final char DELETE = '\u007f';
    protected static final char ENTER_ANDROID = '\n';
    protected static final char ENTER_DESKTOP = '\r';
    private static final char TAB = '\t';
    public static float keyRepeatInitialTime;
    public static float keyRepeatTime;
    private static final Vector2 tmp1;
    private static final Vector2 tmp2;
    private static final Vector2 tmp3;
    final Timer.Task blinkTask;
    float blinkTime = 0.32f;
    Clipboard clipboard;
    protected int cursor;
    boolean cursorOn;
    boolean disabled;
    protected CharSequence displayText;
    TextFieldFilter filter;
    boolean focusTraversal = true;
    boolean focused;
    protected float fontOffset;
    protected final FloatArray glyphPositions;
    protected boolean hasSelection;
    InputListener inputListener;
    final KeyRepeatTask keyRepeatTask;
    OnscreenKeyboard keyboard;
    long lastChangeTime;
    protected final GlyphLayout layout = new GlyphLayout();
    TextFieldListener listener;
    private int maxLength = 0;
    private String messageText;
    boolean onlyFontChars = true;
    private StringBuilder passwordBuffer;
    private char passwordCharacter;
    boolean passwordMode;
    boolean programmaticChangeEvents;
    float renderOffset;
    protected int selectionStart;
    private float selectionWidth;
    private float selectionX;
    TextFieldStyle style;
    protected String text;
    private int textHAlign = 8;
    protected float textHeight;
    protected float textOffset;
    String undoText = "";
    private int visibleTextEnd;
    private int visibleTextStart;
    protected boolean writeEnters;

    static {
        tmp1 = new Vector2();
        tmp2 = new Vector2();
        tmp3 = new Vector2();
        keyRepeatInitialTime = 0.4f;
        keyRepeatTime = 0.1f;
    }

    public TextField(String string2, Skin skin) {
        this(string2, skin.get(TextFieldStyle.class));
    }

    public TextField(String string2, Skin skin, String string3) {
        this(string2, skin.get(string3, TextFieldStyle.class));
    }

    public TextField(String string2, TextFieldStyle textFieldStyle) {
        this.glyphPositions = new FloatArray();
        this.keyboard = new DefaultOnscreenKeyboard();
        this.passwordCharacter = (char)149;
        this.blinkTask = new Timer.Task(){

            @Override
            public void run() {
                TextField textField = TextField.this;
                textField.cursorOn ^= true;
                Gdx.graphics.requestRendering();
            }
        };
        this.keyRepeatTask = new KeyRepeatTask();
        this.setStyle(textFieldStyle);
        this.clipboard = Gdx.app.getClipboard();
        this.initialize();
        this.setText(string2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    private TextField findNextTextField(Array<Actor> array, TextField textField, Vector2 vector2, Vector2 vector22, boolean bl) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Object object;
            Actor actor = array.get(i);
            if (actor instanceof TextField) {
                if (actor == this) {
                    object = textField;
                } else {
                    TextField textField2 = (TextField)actor;
                    object = textField;
                    if (!textField2.isDisabled()) {
                        object = textField;
                        if (textField2.focusTraversal) {
                            if (!textField2.ancestorsVisible()) {
                                object = textField;
                            } else {
                                boolean bl2;
                                boolean bl3;
                                object = actor.getParent().localToStageCoordinates(tmp3.set(actor.getX(), actor.getY()));
                                bl3 = ((Vector2)object).y != vector22.y && (bl3 = ((Vector2)object).y < vector22.y) ^ bl;
                                bl2 = ((Vector2)object).y == vector22.y && (bl2 = ((Vector2)object).x > vector22.x) ^ bl;
                                if (!bl3 && !bl2) {
                                    object = textField;
                                } else {
                                    bl2 = textField == null || ((Vector2)object).y != vector2.y && (bl3 = ((Vector2)object).y > vector2.y) ^ bl;
                                    bl3 = bl2;
                                    if (!bl2) {
                                        bl3 = ((Vector2)object).y == vector2.y && (bl3 = ((Vector2)object).x < vector2.x) ^ bl;
                                    }
                                    if (bl3) {
                                        vector2.set((Vector2)object);
                                        textField = textField2;
                                    }
                                    object = textField;
                                }
                            }
                        }
                    }
                }
            } else {
                object = textField;
                if (actor instanceof Group) {
                    object = this.findNextTextField(((Group)actor).getChildren(), textField, vector2, vector22, bl);
                }
            }
            textField = object;
        }
        return textField;
    }

    private Drawable getBackgroundDrawable() {
        boolean bl = this.hasKeyboardFocus();
        Drawable drawable2 = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : (bl && this.style.focusedBackground != null ? this.style.focusedBackground : this.style.background);
        return drawable2;
    }

    public void appendText(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        this.clearSelection();
        this.cursor = this.text.length();
        this.paste(string3, this.programmaticChangeEvents);
    }

    protected void calculateOffsets() {
        int n;
        float f = this.getWidth();
        Object object = this.getBackgroundDrawable();
        float f2 = f;
        if (object != null) {
            f2 = f - (object.getLeftWidth() + object.getRightWidth());
        }
        int n2 = this.glyphPositions.size;
        object = this.glyphPositions.items;
        Object object2 = object[Math.max(0, this.cursor - 1)];
        f = this.renderOffset;
        Object object3 = object2 + f;
        object2 = 0.0f;
        if (object3 <= 0.0f) {
            this.renderOffset = f - object3;
        } else {
            f = (float)(object[Math.min(n2 - 1, this.cursor + 1)] - f2);
            if (-this.renderOffset < f) {
                this.renderOffset = -f;
            }
        }
        Object object4 = object[n2 - 1];
        f = 0.0f;
        for (n = n2 - 2; n >= 0 && !(object4 - (object3 = object[n]) > f2); --n) {
            f = (float)object3;
        }
        if (-this.renderOffset > f) {
            this.renderOffset = -f;
        }
        this.visibleTextStart = 0;
        n = 0;
        while (true) {
            f = (float)object2;
            if (n >= n2) break;
            if (object[n] >= -this.renderOffset) {
                this.visibleTextStart = n;
                f = (float)object[n];
                break;
            }
            ++n;
        }
        object2 = this.renderOffset;
        n2 = Math.min(this.displayText.length(), n2);
        for (n = this.visibleTextStart + 1; n <= n2 && !(object[n] > f2 - object2); ++n) {
        }
        this.visibleTextEnd = Math.max(0, n - 1);
        n = this.textHAlign;
        if ((n & 8) == 0) {
            this.textOffset = f2 - (object[this.visibleTextEnd] - f);
            if ((n & 1) != 0) {
                this.textOffset = Math.round(this.textOffset * 0.5f);
            }
        } else {
            this.textOffset = f + this.renderOffset;
        }
        if (this.hasSelection) {
            n = Math.min(this.cursor, this.selectionStart);
            n2 = Math.max(this.cursor, this.selectionStart);
            f = Math.max((float)(object[n] - object[this.visibleTextStart]), -this.textOffset);
            f2 = Math.min((float)(object[n2] - object[this.visibleTextStart]), f2 - this.textOffset);
            this.selectionX = f;
            this.selectionWidth = f2 - f - this.style.font.getData().cursorX;
        }
    }

    boolean changeText(String string2, String string3) {
        if (string3.equals(string2)) {
            return false;
        }
        this.text = string3;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean bl = this.fire(changeEvent);
        if (!bl) {
            string2 = string3;
        }
        this.text = string2;
        Pools.free(changeEvent);
        return bl ^ true;
    }

    public void clearSelection() {
        this.hasSelection = false;
    }

    protected boolean continueCursor(int n, int n2) {
        return this.isWordCharacter(this.text.charAt(n + n2));
    }

    public void copy() {
        if (this.hasSelection && !this.passwordMode) {
            this.clipboard.setContents(this.text.substring(Math.min(this.cursor, this.selectionStart), Math.max(this.cursor, this.selectionStart)));
        }
    }

    protected InputListener createInputListener() {
        return new TextFieldClickListener();
    }

    public void cut() {
        this.cut(this.programmaticChangeEvents);
    }

    void cut(boolean bl) {
        if (this.hasSelection && !this.passwordMode) {
            this.copy();
            this.cursor = this.delete(bl);
            this.updateDisplayText();
        }
    }

    int delete(boolean bl) {
        int n = this.selectionStart;
        int n2 = this.cursor;
        int n3 = Math.min(n, n2);
        n2 = Math.max(n, n2);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        String string3 = n3 > 0 ? this.text.substring(0, n3) : "";
        stringBuilder.append(string3);
        string3 = string2;
        if (n2 < this.text.length()) {
            string3 = this.text;
            string3 = string3.substring(n2, string3.length());
        }
        stringBuilder.append(string3);
        string3 = stringBuilder.toString();
        if (bl) {
            this.changeText(this.text, string3);
        } else {
            this.text = string3;
        }
        this.clearSelection();
        return n3;
    }

    @Override
    public void draw(Batch batch, float f) {
        float f2;
        float f3;
        Object object;
        boolean bl = this.hasKeyboardFocus();
        if (bl != this.focused) {
            this.focused = bl;
            this.blinkTask.cancel();
            this.cursorOn = bl;
            if (bl) {
                object = this.blinkTask;
                f3 = this.blinkTime;
                Timer.schedule((Timer.Task)object, f3, f3);
            } else {
                this.keyRepeatTask.cancel();
            }
        } else if (!bl) {
            this.cursorOn = false;
        }
        BitmapFont bitmapFont = this.style.font;
        object = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (bl && this.style.focusedFontColor != null ? this.style.focusedFontColor : this.style.fontColor);
        Drawable drawable2 = this.style.selection;
        Drawable drawable3 = this.style.cursor;
        Drawable drawable4 = this.getBackgroundDrawable();
        Color color2 = this.getColor();
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = this.getWidth();
        f3 = this.getHeight();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        if (drawable4 != null) {
            drawable4.draw(batch, f4, f5, f6, f3);
            f3 = drawable4.getLeftWidth();
            f2 = drawable4.getRightWidth();
        } else {
            f3 = 0.0f;
            f2 = 0.0f;
        }
        float f7 = this.getTextY(bitmapFont, drawable4);
        this.calculateOffsets();
        if (bl && this.hasSelection && drawable2 != null) {
            this.drawSelection(drawable2, batch, bitmapFont, f4 + f3, f5 + f7);
        }
        float f8 = bitmapFont.isFlipped() ? -this.textHeight : 0.0f;
        if (this.displayText.length() == 0) {
            if (!bl && this.messageText != null) {
                object = this.style.messageFont != null ? this.style.messageFont : bitmapFont;
                if (this.style.messageFontColor != null) {
                    ((BitmapFont)object).setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * color2.a * f);
                } else {
                    ((BitmapFont)object).setColor(0.7f, 0.7f, 0.7f, color2.a * f);
                }
                this.drawMessageText(batch, (BitmapFont)object, f4 + f3, f5 + f7 + f8, f6 - f3 - f2);
            }
        } else {
            bitmapFont.setColor(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * color2.a * f);
            this.drawText(batch, bitmapFont, f4 + f3, f5 + f7 + f8);
        }
        if (!this.disabled && this.cursorOn && drawable3 != null) {
            this.drawCursor(drawable3, batch, bitmapFont, f4 + f3, f5 + f7);
        }
    }

    protected void drawCursor(Drawable drawable2, Batch batch, BitmapFont bitmapFont, float f, float f2) {
        drawable2.draw(batch, f + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset + bitmapFont.getData().cursorX, f2 - this.textHeight - bitmapFont.getDescent(), drawable2.getMinWidth(), this.textHeight);
    }

    protected void drawMessageText(Batch batch, BitmapFont bitmapFont, float f, float f2, float f3) {
        String string2 = this.messageText;
        bitmapFont.draw(batch, string2, f, f2, 0, string2.length(), f3, this.textHAlign, false, "...");
    }

    protected void drawSelection(Drawable drawable2, Batch batch, BitmapFont bitmapFont, float f, float f2) {
        drawable2.draw(batch, f + this.textOffset + this.selectionX + this.fontOffset, f2 - this.textHeight - bitmapFont.getDescent(), this.selectionWidth, this.textHeight);
    }

    protected void drawText(Batch batch, BitmapFont bitmapFont, float f, float f2) {
        bitmapFont.draw(batch, this.displayText, f + this.textOffset, f2, this.visibleTextStart, this.visibleTextEnd, 0.0f, 8, false);
    }

    public int getAlignment() {
        return this.textHAlign;
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    public InputListener getDefaultInputListener() {
        return this.inputListener;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    @Override
    public float getPrefHeight() {
        float f;
        Drawable drawable2 = this.style.background;
        float f2 = 0.0f;
        if (drawable2 != null) {
            f = Math.max(0.0f, this.style.background.getBottomHeight() + this.style.background.getTopHeight());
            f2 = Math.max(0.0f, this.style.background.getMinHeight());
        } else {
            f = 0.0f;
        }
        float f3 = f;
        float f4 = f2;
        if (this.style.focusedBackground != null) {
            f3 = Math.max(f, this.style.focusedBackground.getBottomHeight() + this.style.focusedBackground.getTopHeight());
            f4 = Math.max(f2, this.style.focusedBackground.getMinHeight());
        }
        f = f3;
        f2 = f4;
        if (this.style.disabledBackground != null) {
            f = Math.max(f3, this.style.disabledBackground.getBottomHeight() + this.style.disabledBackground.getTopHeight());
            f2 = Math.max(f4, this.style.disabledBackground.getMinHeight());
        }
        return Math.max(f + this.textHeight, f2);
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    public boolean getProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public String getSelection() {
        String string2 = this.hasSelection ? this.text.substring(Math.min(this.selectionStart, this.cursor), Math.max(this.selectionStart, this.cursor)) : "";
        return string2;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public TextFieldStyle getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public TextFieldFilter getTextFieldFilter() {
        return this.filter;
    }

    protected float getTextY(BitmapFont bitmapFont, Drawable drawable2) {
        float f;
        float f2 = this.getHeight();
        float f3 = this.textHeight / 2.0f + bitmapFont.getDescent();
        if (drawable2 != null) {
            f = drawable2.getBottomHeight();
            f = f3 + (f2 - drawable2.getTopHeight() - f) / 2.0f + f;
        } else {
            f = f3 + f2 / 2.0f;
        }
        f2 = f;
        if (bitmapFont.usesIntegerPositions()) {
            f2 = (int)f;
        }
        return f2;
    }

    protected void initialize() {
        InputListener inputListener;
        this.inputListener = inputListener = this.createInputListener();
        this.addListener(inputListener);
    }

    String insert(int n, CharSequence charSequence, String string2) {
        if (string2.length() == 0) {
            return charSequence.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2.substring(0, n));
        stringBuilder.append((Object)charSequence);
        stringBuilder.append(string2.substring(n, string2.length()));
        return stringBuilder.toString();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isPasswordMode() {
        return this.passwordMode;
    }

    protected boolean isWordCharacter(char c) {
        return Character.isLetterOrDigit(c);
    }

    protected int letterUnderCursor(float f) {
        float f2;
        f = f2 = f - (this.textOffset + this.fontOffset - this.style.font.getData().cursorX - this.glyphPositions.get(this.visibleTextStart));
        if (this.getBackgroundDrawable() != null) {
            f = f2 - this.style.background.getLeftWidth();
        }
        int n = this.glyphPositions.size;
        float[] fArray = this.glyphPositions.items;
        for (int i = 1; i < n; ++i) {
            if (!(fArray[i] > f)) continue;
            f2 = fArray[i];
            n = i - 1;
            if (f2 - f <= f - fArray[n]) {
                return i;
            }
            return n;
        }
        return n - 1;
    }

    protected void moveCursor(boolean bl, boolean bl2) {
        int n = 0;
        int n2 = bl ? this.text.length() : 0;
        if (!bl) {
            n = -1;
        }
        do {
            int n3;
            if (bl) {
                this.cursor = n3 = this.cursor + 1;
                if (n3 >= n2) break;
                continue;
            }
            this.cursor = n3 = this.cursor - 1;
            if (n3 <= n2) break;
        } while (bl2 && this.continueCursor(this.cursor, n));
    }

    public void next(boolean bl) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        Vector2 vector2 = this.getParent().localToStageCoordinates(tmp2.set(this.getX(), this.getY()));
        Vector2 vector22 = tmp1;
        TextField textField = this;
        while (true) {
            TextField textField2;
            block10: {
                block9: {
                    block8: {
                        TextField textField3;
                        textField2 = textField3 = textField.findNextTextField(stage.getActors(), null, vector22, vector2, bl);
                        if (textField3 == null) {
                            if (bl) {
                                vector2.set(-3.4028235E38f, -3.4028235E38f);
                            } else {
                                vector2.set(Float.MAX_VALUE, Float.MAX_VALUE);
                            }
                            textField2 = textField.findNextTextField(stage.getActors(), null, vector22, vector2, bl);
                        }
                        if (textField2 != null) break block8;
                        Gdx.input.setOnscreenKeyboardVisible(false);
                        break block9;
                    }
                    if (!stage.setKeyboardFocus(textField2)) break block10;
                    textField2.selectAll();
                }
                return;
            }
            vector2.set(vector22);
            textField = textField2;
        }
    }

    void paste(String string2, boolean bl) {
        int n;
        if (string2 == null) {
            return;
        }
        CharSequence charSequence = new StringBuilder();
        int n2 = n = this.text.length();
        if (this.hasSelection) {
            n2 = n - Math.abs(this.cursor - this.selectionStart);
        }
        BitmapFont.BitmapFontData bitmapFontData = this.style.font.getData();
        int n3 = string2.length();
        for (n = 0; n < n3 && this.withinMaxLength(((StringBuilder)charSequence).length() + n2); ++n) {
            TextFieldFilter textFieldFilter;
            char c = string2.charAt(n);
            if ((!this.writeEnters || c != '\n' && c != '\r') && (c == '\r' || c == '\n' || this.onlyFontChars && !bitmapFontData.hasGlyph(c) || (textFieldFilter = this.filter) != null && !textFieldFilter.acceptChar(this, c))) continue;
            ((StringBuilder)charSequence).append(c);
        }
        string2 = ((StringBuilder)charSequence).toString();
        if (this.hasSelection) {
            this.cursor = this.delete(bl);
        }
        if (bl) {
            charSequence = this.text;
            this.changeText((String)charSequence, this.insert(this.cursor, string2, (String)charSequence));
        } else {
            this.text = this.insert(this.cursor, string2, this.text);
        }
        this.updateDisplayText();
        this.cursor += string2.length();
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void setAlignment(int n) {
        this.textHAlign = n;
    }

    public void setBlinkTime(float f) {
        this.blinkTime = f;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void setCursorPosition(int n) {
        if (n >= 0) {
            this.clearSelection();
            this.cursor = Math.min(n, this.text.length());
            return;
        }
        throw new IllegalArgumentException("cursorPosition must be >= 0");
    }

    @Override
    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public void setFocusTraversal(boolean bl) {
        this.focusTraversal = bl;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMessageText(String string2) {
        this.messageText = string2;
    }

    public void setOnlyFontChars(boolean bl) {
        this.onlyFontChars = bl;
    }

    public void setOnscreenKeyboard(OnscreenKeyboard onscreenKeyboard) {
        this.keyboard = onscreenKeyboard;
    }

    public void setPasswordCharacter(char c) {
        this.passwordCharacter = c;
        if (this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public void setPasswordMode(boolean bl) {
        this.passwordMode = bl;
        this.updateDisplayText();
    }

    public void setProgrammaticChangeEvents(boolean bl) {
        this.programmaticChangeEvents = bl;
    }

    public void setSelection(int n, int n2) {
        if (n >= 0) {
            if (n2 >= 0) {
                int n3 = Math.min(this.text.length(), n);
                n = Math.min(this.text.length(), n2);
                if (n == n3) {
                    this.clearSelection();
                    return;
                }
                int n4 = n3;
                n2 = n;
                if (n < n3) {
                    n2 = n3;
                    n4 = n;
                }
                this.hasSelection = true;
                this.selectionStart = n4;
                this.cursor = n2;
                return;
            }
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        throw new IllegalArgumentException("selectionStart must be >= 0");
    }

    public void setStyle(TextFieldStyle textFieldStyle) {
        if (textFieldStyle != null) {
            this.style = textFieldStyle;
            this.textHeight = textFieldStyle.font.getCapHeight() - textFieldStyle.font.getDescent() * 2.0f;
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void setText(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        if (string3.equals(this.text)) {
            return;
        }
        this.clearSelection();
        string2 = this.text;
        this.text = "";
        this.paste(string3, false);
        if (this.programmaticChangeEvents) {
            this.changeText(string2, this.text);
        }
        this.cursor = 0;
    }

    public void setTextFieldFilter(TextFieldFilter textFieldFilter) {
        this.filter = textFieldFilter;
    }

    public void setTextFieldListener(TextFieldListener textFieldListener) {
        this.listener = textFieldListener;
    }

    void updateDisplayText() {
        int n;
        Object object = this.style.font;
        BitmapFont.BitmapFontData bitmapFontData = ((BitmapFont)object).getData();
        String string2 = this.text;
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            n = 32;
            if (n3 >= n2) break;
            char c = string2.charAt(n3);
            int n4 = n;
            if (bitmapFontData.hasGlyph(c)) {
                n4 = n = (int)c;
            }
            stringBuilder.append((char)n4);
            ++n3;
        }
        string2 = stringBuilder.toString();
        if (this.passwordMode && bitmapFontData.hasGlyph(this.passwordCharacter)) {
            if (this.passwordBuffer == null) {
                this.passwordBuffer = new StringBuilder(string2.length());
            }
            if (this.passwordBuffer.length() > n2) {
                this.passwordBuffer.setLength(n2);
            } else {
                for (n3 = this.passwordBuffer.length(); n3 < n2; ++n3) {
                    this.passwordBuffer.append(this.passwordCharacter);
                }
            }
            this.displayText = this.passwordBuffer;
        } else {
            this.displayText = string2;
        }
        this.layout.setText((BitmapFont)object, this.displayText.toString().replace('\r', ' ').replace('\n', ' '));
        this.glyphPositions.clear();
        n3 = this.layout.runs.size;
        float f = 0.0f;
        if (n3 > 0) {
            object = this.layout.runs.first().xAdvances;
            this.fontOffset = ((FloatArray)object).first();
            n = ((FloatArray)object).size;
            f = 0.0f;
            for (n3 = 1; n3 < n; ++n3) {
                this.glyphPositions.add(f);
                f += ((FloatArray)object).get(n3);
            }
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(f);
        this.visibleTextStart = Math.min(this.visibleTextStart, this.glyphPositions.size - 1);
        this.visibleTextEnd = MathUtils.clamp(this.visibleTextEnd, this.visibleTextStart, this.glyphPositions.size - 1);
        if (this.selectionStart > string2.length()) {
            this.selectionStart = n2;
        }
    }

    boolean withinMaxLength(int n) {
        int n2 = this.maxLength;
        boolean bl = n2 <= 0 || n < n2;
        return bl;
    }

    int[] wordUnderCursor(float f) {
        return this.wordUnderCursor(this.letterUnderCursor(f));
    }

    protected int[] wordUnderCursor(int n) {
        int n2;
        block6: {
            String string2 = this.text;
            int n3 = string2.length();
            if (n >= string2.length()) {
                n = string2.length();
                n2 = 0;
            } else {
                int n4 = n;
                while (true) {
                    n2 = n3;
                    if (n4 >= n3) break;
                    if (!this.isWordCharacter(string2.charAt(n4))) {
                        n2 = n4;
                        break;
                    }
                    ++n4;
                }
                --n;
                while (n > -1) {
                    if (this.isWordCharacter(string2.charAt(n))) {
                        --n;
                        continue;
                    }
                    break block6;
                }
                n = 0;
            }
        }
        return new int[]{++n, n2};
    }

    public static class DefaultOnscreenKeyboard
    implements OnscreenKeyboard {
        @Override
        public void show(boolean bl) {
            Gdx.input.setOnscreenKeyboardVisible(bl);
        }
    }

    class KeyRepeatTask
    extends Timer.Task {
        int keycode;

        KeyRepeatTask() {
        }

        @Override
        public void run() {
            TextField.this.inputListener.keyDown(null, this.keycode);
        }
    }

    public static interface OnscreenKeyboard {
        public void show(boolean var1);
    }

    public class TextFieldClickListener
    extends ClickListener {
        @Override
        public void clicked(InputEvent object, float f, float f2) {
            int n = this.getTapCount() % 4;
            if (n == 0) {
                TextField.this.clearSelection();
            }
            if (n == 2) {
                object = TextField.this.wordUnderCursor(f);
                TextField.this.setSelection((int)object[0], (int)object[1]);
            }
            if (n == 3) {
                TextField.this.selectAll();
            }
        }

        protected void goEnd(boolean bl) {
            TextField textField = TextField.this;
            textField.cursor = textField.text.length();
        }

        protected void goHome(boolean bl) {
            TextField.this.cursor = 0;
        }

        @Override
        public boolean keyDown(InputEvent object, int n) {
            boolean bl;
            boolean bl2;
            block23: {
                boolean bl3;
                boolean bl4;
                boolean bl5;
                block24: {
                    block25: {
                        block28: {
                            block26: {
                                block27: {
                                    block20: {
                                        block16: {
                                            int n2;
                                            block22: {
                                                block17: {
                                                    block18: {
                                                        block21: {
                                                            block19: {
                                                                block14: {
                                                                    block15: {
                                                                        block8: {
                                                                            block9: {
                                                                                block10: {
                                                                                    block11: {
                                                                                        block12: {
                                                                                            block13: {
                                                                                                if (TextField.this.disabled) {
                                                                                                    return false;
                                                                                                }
                                                                                                object = TextField.this;
                                                                                                ((TextField)object).cursorOn = ((TextField)object).focused;
                                                                                                TextField.this.blinkTask.cancel();
                                                                                                if (TextField.this.focused) {
                                                                                                    Timer.schedule(TextField.this.blinkTask, TextField.this.blinkTime, TextField.this.blinkTime);
                                                                                                }
                                                                                                if (!TextField.this.hasKeyboardFocus()) {
                                                                                                    return false;
                                                                                                }
                                                                                                bl2 = UIUtils.ctrl();
                                                                                                bl5 = true;
                                                                                                bl4 = bl2 && !TextField.this.passwordMode;
                                                                                                if (!bl2) break block8;
                                                                                                if (n == 29) break block9;
                                                                                                if (n == 31) break block10;
                                                                                                if (n == 50) break block11;
                                                                                                if (n == 52) break block12;
                                                                                                if (n == 54) break block13;
                                                                                                if (n == 133) break block10;
                                                                                                bl3 = false;
                                                                                                bl2 = false;
                                                                                                break block14;
                                                                                            }
                                                                                            object = TextField.this.text;
                                                                                            TextField textField = TextField.this;
                                                                                            textField.setText(textField.undoText);
                                                                                            textField = TextField.this;
                                                                                            textField.undoText = object;
                                                                                            textField.updateDisplayText();
                                                                                            return true;
                                                                                        }
                                                                                        TextField.this.cut(true);
                                                                                        return true;
                                                                                    }
                                                                                    object = TextField.this;
                                                                                    ((TextField)object).paste(((TextField)object).clipboard.getContents(), true);
                                                                                    bl3 = true;
                                                                                    break block15;
                                                                                }
                                                                                TextField.this.copy();
                                                                                return true;
                                                                            }
                                                                            TextField.this.selectAll();
                                                                            return true;
                                                                        }
                                                                        bl3 = false;
                                                                    }
                                                                    bl2 = true;
                                                                }
                                                                if (!UIUtils.shift()) break block16;
                                                                if (n != 112) {
                                                                    if (n == 133) {
                                                                        object = TextField.this;
                                                                        ((TextField)object).paste(((TextField)object).clipboard.getContents(), true);
                                                                    }
                                                                } else {
                                                                    TextField.this.cut(true);
                                                                }
                                                                n2 = TextField.this.cursor;
                                                                if (n == 3) break block17;
                                                                if (n == 132) break block18;
                                                                if (n == 21) break block19;
                                                                if (n != 22) break block20;
                                                                TextField.this.moveCursor(true, bl4);
                                                                break block21;
                                                            }
                                                            TextField.this.moveCursor(false, bl4);
                                                        }
                                                        bl3 = true;
                                                        break block22;
                                                    }
                                                    this.goEnd(bl4);
                                                    break block22;
                                                }
                                                this.goHome(bl4);
                                            }
                                            bl2 = bl5;
                                            bl = bl3;
                                            if (!TextField.this.hasSelection) {
                                                object = TextField.this;
                                                ((TextField)object).selectionStart = n2;
                                                ((TextField)object).hasSelection = true;
                                                bl2 = bl5;
                                                bl = bl3;
                                            }
                                            break block23;
                                        }
                                        if (n == 3) break block24;
                                        if (n == 132) break block25;
                                        if (n == 21) break block26;
                                        if (n == 22) break block27;
                                    }
                                    bl = bl3;
                                    break block23;
                                }
                                TextField.this.moveCursor(true, bl4);
                                TextField.this.clearSelection();
                                break block28;
                            }
                            TextField.this.moveCursor(false, bl4);
                            TextField.this.clearSelection();
                        }
                        bl = true;
                        bl2 = bl5;
                        break block23;
                    }
                    this.goEnd(bl4);
                    TextField.this.clearSelection();
                    bl2 = bl5;
                    bl = bl3;
                    break block23;
                }
                this.goHome(bl4);
                TextField.this.clearSelection();
                bl = bl3;
                bl2 = bl5;
            }
            object = TextField.this;
            ((TextField)object).cursor = MathUtils.clamp(((TextField)object).cursor, 0, TextField.this.text.length());
            if (bl) {
                this.scheduleKeyRepeatTask(n);
            }
            return bl2;
        }

        @Override
        public boolean keyTyped(InputEvent object, char c) {
            if (TextField.this.disabled) {
                return false;
            }
            if (c != '\r') {
                switch (c) {
                    default: {
                        if (c >= ' ') break;
                        return false;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                }
            }
            if (!TextField.this.hasKeyboardFocus()) {
                return false;
            }
            if (UIUtils.isMac && Gdx.input.isKeyPressed(63)) {
                return true;
            }
            if ((c == '\t' || c == '\n') && TextField.this.focusTraversal) {
                TextField.this.next(UIUtils.shift());
            } else {
                int n = c == '\u007f' ? 1 : 0;
                int n2 = c == '\b' ? 1 : 0;
                boolean bl = c == '\r' || c == '\n';
                boolean bl2 = bl ? TextField.this.writeEnters : !TextField.this.onlyFontChars || TextField.this.style.font.getData().hasGlyph(c);
                boolean bl3 = n2 != 0 || n != 0;
                if (bl2 || bl3) {
                    Object object2;
                    String string2 = TextField.this.text;
                    int n3 = TextField.this.cursor;
                    if (bl3) {
                        if (TextField.this.hasSelection) {
                            object = TextField.this;
                            ((TextField)object).cursor = ((TextField)object).delete(false);
                        } else {
                            if (n2 != 0 && TextField.this.cursor > 0) {
                                TextField textField = TextField.this;
                                object2 = new StringBuilder();
                                ((StringBuilder)object2).append(TextField.this.text.substring(0, TextField.this.cursor - 1));
                                object = TextField.this.text;
                                TextField textField2 = TextField.this;
                                n2 = textField2.cursor;
                                textField2.cursor = n2 - 1;
                                ((StringBuilder)object2).append(((String)object).substring(n2));
                                textField.text = ((StringBuilder)object2).toString();
                                TextField.this.renderOffset = 0.0f;
                            }
                            if (n != 0 && TextField.this.cursor < TextField.this.text.length()) {
                                object2 = TextField.this;
                                object = new StringBuilder();
                                ((StringBuilder)object).append(TextField.this.text.substring(0, TextField.this.cursor));
                                ((StringBuilder)object).append(TextField.this.text.substring(TextField.this.cursor + 1));
                                ((TextField)object2).text = ((StringBuilder)object).toString();
                            }
                        }
                    }
                    if (bl2 && !bl3) {
                        if (!bl && TextField.this.filter != null && !TextField.this.filter.acceptChar(TextField.this, c)) {
                            return true;
                        }
                        object = TextField.this;
                        if (!((TextField)object).withinMaxLength(((TextField)object).text.length())) {
                            return true;
                        }
                        if (TextField.this.hasSelection) {
                            object = TextField.this;
                            ((TextField)object).cursor = ((TextField)object).delete(false);
                        }
                        object = bl ? "\n" : String.valueOf(c);
                        object2 = TextField.this;
                        n = ((TextField)object2).cursor;
                        ((TextField)object2).cursor = n + 1;
                        ((TextField)object2).text = ((TextField)object2).insert(n, (CharSequence)object, TextField.this.text);
                    }
                    object = TextField.this.undoText;
                    object = TextField.this;
                    if (((TextField)object).changeText(string2, ((TextField)object).text)) {
                        long l = System.currentTimeMillis();
                        if (l - 750L > TextField.this.lastChangeTime) {
                            TextField.this.undoText = string2;
                        }
                        TextField.this.lastChangeTime = l;
                    } else {
                        TextField.this.cursor = n3;
                    }
                    TextField.this.updateDisplayText();
                }
            }
            if (TextField.this.listener != null) {
                TextField.this.listener.keyTyped(TextField.this, c);
            }
            return true;
        }

        @Override
        public boolean keyUp(InputEvent inputEvent, int n) {
            if (TextField.this.disabled) {
                return false;
            }
            TextField.this.keyRepeatTask.cancel();
            return true;
        }

        protected void scheduleKeyRepeatTask(int n) {
            if (!TextField.this.keyRepeatTask.isScheduled() || TextField.this.keyRepeatTask.keycode != n) {
                TextField.this.keyRepeatTask.keycode = n;
                TextField.this.keyRepeatTask.cancel();
                Timer.schedule(TextField.this.keyRepeatTask, keyRepeatInitialTime, keyRepeatTime);
            }
        }

        protected void setCursorPosition(float f, float f2) {
            TextField textField = TextField.this;
            textField.cursor = textField.letterUnderCursor(f);
            textField = TextField.this;
            textField.cursorOn = textField.focused;
            TextField.this.blinkTask.cancel();
            if (TextField.this.focused) {
                Timer.schedule(TextField.this.blinkTask, TextField.this.blinkTime, TextField.this.blinkTime);
            }
        }

        @Override
        public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
            if (!super.touchDown((InputEvent)object, f, f2, n, n2)) {
                return false;
            }
            if (n == 0 && n2 != 0) {
                return false;
            }
            if (TextField.this.disabled) {
                return true;
            }
            this.setCursorPosition(f, f2);
            object = TextField.this;
            ((TextField)object).selectionStart = ((TextField)object).cursor;
            object = TextField.this.getStage();
            if (object != null) {
                ((Stage)object).setKeyboardFocus(TextField.this);
            }
            TextField.this.keyboard.show(true);
            TextField.this.hasSelection = true;
            return true;
        }

        @Override
        public void touchDragged(InputEvent inputEvent, float f, float f2, int n) {
            super.touchDragged(inputEvent, f, f2, n);
            this.setCursorPosition(f, f2);
        }

        @Override
        public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
            if (TextField.this.selectionStart == TextField.this.cursor) {
                TextField.this.hasSelection = false;
            }
            super.touchUp(inputEvent, f, f2, n, n2);
        }
    }

    public static interface TextFieldFilter {
        public boolean acceptChar(TextField var1, char var2);

        public static class DigitsOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextField textField, char c) {
                return Character.isDigit(c);
            }
        }
    }

    public static interface TextFieldListener {
        public void keyTyped(TextField var1, char var2);
    }

    public static class TextFieldStyle {
        public Drawable background;
        public Drawable cursor;
        public Drawable disabledBackground;
        public Color disabledFontColor;
        public Drawable focusedBackground;
        public Color focusedFontColor;
        public BitmapFont font;
        public Color fontColor;
        public BitmapFont messageFont;
        public Color messageFontColor;
        public Drawable selection;

        public TextFieldStyle() {
        }

        public TextFieldStyle(BitmapFont bitmapFont, Color color2, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
            this.background = drawable4;
            this.cursor = drawable2;
            this.font = bitmapFont;
            this.fontColor = color2;
            this.selection = drawable3;
        }

        public TextFieldStyle(TextFieldStyle textFieldStyle) {
            this.messageFont = textFieldStyle.messageFont;
            Color color2 = textFieldStyle.messageFontColor;
            if (color2 != null) {
                this.messageFontColor = new Color(color2);
            }
            this.background = textFieldStyle.background;
            this.focusedBackground = textFieldStyle.focusedBackground;
            this.disabledBackground = textFieldStyle.disabledBackground;
            this.cursor = textFieldStyle.cursor;
            this.font = textFieldStyle.font;
            color2 = textFieldStyle.fontColor;
            if (color2 != null) {
                this.fontColor = new Color(color2);
            }
            if ((color2 = textFieldStyle.focusedFontColor) != null) {
                this.focusedFontColor = new Color(color2);
            }
            if ((color2 = textFieldStyle.disabledFontColor) != null) {
                this.disabledFontColor = new Color(color2);
            }
            this.selection = textFieldStyle.selection;
        }
    }
}

