/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class Table
extends WidgetGroup {
    public static Value backgroundBottom;
    public static Value backgroundLeft;
    public static Value backgroundRight;
    public static Value backgroundTop;
    static final Pool<Cell> cellPool;
    private static float[] columnWeightedWidth;
    public static Color debugActorColor;
    public static Color debugCellColor;
    public static Color debugTableColor;
    private static float[] rowWeightedHeight;
    int align = 1;
    Drawable background;
    private final Cell cellDefaults;
    private final Array<Cell> cells = new Array(4);
    private boolean clip;
    private final Array<Cell> columnDefaults = new Array(2);
    private float[] columnMinWidth;
    private float[] columnPrefWidth;
    private float[] columnWidth;
    private int columns;
    Debug debug;
    Array<DebugRect> debugRects;
    private float[] expandHeight;
    private float[] expandWidth;
    private boolean implicitEndRow;
    Value padBottom;
    Value padLeft;
    Value padRight;
    Value padTop = backgroundTop;
    boolean round = true;
    private Cell rowDefaults;
    private float[] rowHeight;
    private float[] rowMinHeight;
    private float[] rowPrefHeight;
    private int rows;
    private boolean sizeInvalid = true;
    private Skin skin;
    private float tableMinHeight;
    private float tableMinWidth;
    private float tablePrefHeight;
    private float tablePrefWidth;

    static {
        debugTableColor = new Color(0.0f, 0.0f, 1.0f, 1.0f);
        debugCellColor = new Color(1.0f, 0.0f, 0.0f, 1.0f);
        debugActorColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);
        cellPool = new Pool<Cell>(){

            @Override
            protected Cell newObject() {
                return new Cell();
            }
        };
        backgroundTop = new Value(){

            @Override
            public float get(Actor object) {
                object = ((Table)object).background;
                float f = object == null ? 0.0f : object.getTopHeight();
                return f;
            }
        };
        backgroundLeft = new Value(){

            @Override
            public float get(Actor object) {
                object = ((Table)object).background;
                float f = object == null ? 0.0f : object.getLeftWidth();
                return f;
            }
        };
        backgroundBottom = new Value(){

            @Override
            public float get(Actor object) {
                object = ((Table)object).background;
                float f = object == null ? 0.0f : object.getBottomHeight();
                return f;
            }
        };
        backgroundRight = new Value(){

            @Override
            public float get(Actor object) {
                object = ((Table)object).background;
                float f = object == null ? 0.0f : object.getRightWidth();
                return f;
            }
        };
    }

    public Table() {
        this((Skin)null);
    }

    public Table(Skin skin) {
        this.padLeft = backgroundLeft;
        this.padBottom = backgroundBottom;
        this.padRight = backgroundRight;
        this.debug = Debug.none;
        this.skin = skin;
        this.cellDefaults = this.obtainCell();
        this.setTransform(false);
        this.setTouchable(Touchable.childrenOnly);
    }

    private void addDebugRect(float f, float f2, float f3, float f4, Color color2) {
        if (this.debugRects == null) {
            this.debugRects = new Array();
        }
        DebugRect debugRect = DebugRect.pool.obtain();
        debugRect.color = color2;
        debugRect.set(f, this.getHeight() - f2 - f4, f3, f4);
        this.debugRects.add(debugRect);
    }

    private void clearDebugRects() {
        if (this.debugRects == null) {
            return;
        }
        DebugRect.pool.freeAll(this.debugRects);
        this.debugRects.clear();
    }

    private void computeSize() {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        this.sizeInvalid = false;
        Array<Cell> array = this.cells;
        int n6 = array.size;
        if (n6 > 0 && !array.peek().endRow) {
            this.endRow();
            this.implicitEndRow = true;
        }
        int n7 = this.columns;
        int n8 = this.rows;
        float[] fArray = this.ensureSize(this.columnMinWidth, n7);
        this.columnMinWidth = fArray;
        float[] fArray2 = this.ensureSize(this.rowMinHeight, n8);
        this.rowMinHeight = fArray2;
        float[] fArray3 = this.ensureSize(this.columnPrefWidth, n7);
        this.columnPrefWidth = fArray3;
        float[] fArray4 = this.ensureSize(this.rowPrefHeight, n8);
        this.rowPrefHeight = fArray4;
        this.columnWidth = this.ensureSize(this.columnWidth, n7);
        this.rowHeight = this.ensureSize(this.rowHeight, n8);
        float[] fArray5 = this.ensureSize(this.expandWidth, n7);
        this.expandWidth = fArray5;
        Object object2 = this.ensureSize(this.expandHeight, n8);
        this.expandHeight = object2;
        float f7 = 0.0f;
        for (n5 = 0; n5 < n6; ++n5) {
            Cell cell = array.get(n5);
            n4 = cell.column;
            n3 = cell.row;
            n2 = cell.colspan;
            object = cell.actor;
            if (cell.expandY != 0 && object2[n3] == 0.0f) {
                object2[n3] = cell.expandY.intValue();
            }
            if (n2 == 1 && cell.expandX != 0 && fArray5[n4] == 0.0f) {
                fArray5[n4] = cell.expandX.intValue();
            }
            f6 = cell.padLeft.get((Actor)object);
            f7 = n4 == 0 ? 0.0f : Math.max(0.0f, cell.spaceLeft.get((Actor)object) - f7);
            cell.computedPadLeft = f6 + f7;
            cell.computedPadTop = cell.padTop.get((Actor)object);
            if (cell.cellAboveIndex != -1) {
                Cell cell2 = array.get(cell.cellAboveIndex);
                cell.computedPadTop += Math.max(0.0f, cell.spaceTop.get((Actor)object) - cell2.spaceBottom.get((Actor)object));
            }
            f5 = cell.spaceRight.get((Actor)object);
            f6 = cell.padRight.get((Actor)object);
            f7 = n4 + n2 == n7 ? 0.0f : f5;
            cell.computedPadRight = f6 + f7;
            f6 = cell.padBottom.get((Actor)object);
            f7 = n3 == n8 - 1 ? 0.0f : cell.spaceBottom.get((Actor)object);
            cell.computedPadBottom = f6 + f7;
            f7 = cell.prefWidth.get((Actor)object);
            float f8 = cell.prefHeight.get((Actor)object);
            f4 = cell.minWidth.get((Actor)object);
            f3 = cell.minHeight.get((Actor)object);
            f2 = cell.maxWidth.get((Actor)object);
            f = cell.maxHeight.get((Actor)object);
            f6 = f7;
            if (f7 < f4) {
                f6 = f4;
            }
            f7 = f8;
            if (f8 < f3) {
                f7 = f3;
            }
            if (f2 > 0.0f && f6 > f2) {
                f6 = f2;
            }
            if (f > 0.0f && f7 > f) {
                f7 = f;
            }
            if (n2 == 1) {
                f = cell.computedPadLeft + cell.computedPadRight;
                fArray3[n4] = Math.max(fArray3[n4], f6 + f);
                fArray[n4] = Math.max(fArray[n4], f4 + f);
            }
            f6 = cell.computedPadTop + cell.computedPadBottom;
            fArray4[n3] = Math.max(fArray4[n3], f7 + f6);
            fArray2[n3] = Math.max(fArray2[n3], f3 + f6);
            f7 = f5;
        }
        f4 = 0.0f;
        f6 = 0.0f;
        f3 = 0.0f;
        f7 = 0.0f;
        for (n3 = 0; n3 < n6; ++n3) {
            block28: {
                object2 = array.get(n3);
                n5 = object2.column;
                n = object2.expandX;
                if (n != 0) {
                    n2 = object2.colspan + n5;
                    for (n4 = n5; n4 < n2; ++n4) {
                        if (fArray5[n4] == 0.0f) {
                            continue;
                        }
                        break block28;
                    }
                    for (n4 = n5; n4 < n2; ++n4) {
                        fArray5[n4] = n;
                    }
                }
            }
            f = f4;
            f5 = f3;
            if (object2.uniformX == Boolean.TRUE) {
                f = f4;
                f5 = f3;
                if (object2.colspan == 1) {
                    f = object2.computedPadLeft + object2.computedPadRight;
                    f5 = Math.max(f3, fArray[n5] - f);
                    f = Math.max(f4, fArray3[n5] - f);
                }
            }
            f3 = f6;
            f2 = f7;
            if (object2.uniformY == Boolean.TRUE) {
                f3 = object2.computedPadTop + object2.computedPadBottom;
                f2 = Math.max(f7, fArray2[object2.row] - f3);
                f3 = Math.max(f6, fArray4[object2.row] - f3);
            }
            f4 = f;
            f6 = f3;
            f3 = f5;
            f7 = f2;
        }
        if (f4 > 0.0f || f6 > 0.0f) {
            for (n5 = 0; n5 < n6; ++n5) {
                object2 = array.get(n5);
                if (f4 > 0.0f && object2.uniformX == Boolean.TRUE && object2.colspan == 1) {
                    f5 = object2.computedPadLeft + object2.computedPadRight;
                    fArray[object2.column] = f3 + f5;
                    fArray3[object2.column] = f5 + f4;
                }
                if (!(f6 > 0.0f) || object2.uniformY != Boolean.TRUE) continue;
                f5 = object2.computedPadTop + object2.computedPadBottom;
                fArray2[object2.row] = f7 + f5;
                fArray4[object2.row] = f5 + f6;
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            object = array.get(n5);
            n = ((Cell)object).colspan;
            if (n == 1) continue;
            n3 = ((Cell)object).column;
            object2 = ((Cell)object).actor;
            f4 = ((Cell)object).minWidth.get((Actor)object2);
            f6 = ((Cell)object).prefWidth.get((Actor)object2);
            f5 = ((Cell)object).maxWidth.get((Actor)object2);
            f7 = f6;
            if (f6 < f4) {
                f7 = f4;
            }
            if (!(f5 > 0.0f) || !(f7 > f5)) {
                f5 = f7;
            }
            f7 = -(((Cell)object).computedPadLeft + ((Cell)object).computedPadRight);
            n2 = n3 + n;
            f3 = f7;
            f6 = 0.0f;
            for (n4 = n3; n4 < n2; ++n4) {
                f7 += fArray[n4];
                f3 += fArray3[n4];
                f6 += fArray5[n4];
            }
            f4 = Math.max(0.0f, f4 - f7);
            f5 = Math.max(0.0f, f5 - f3);
            while (n3 < n2) {
                f7 = f6 == 0.0f ? 1.0f / (float)n : fArray5[n3] / f6;
                fArray[n3] = fArray[n3] + f4 * f7;
                fArray3[n3] = fArray3[n3] + f7 * f5;
                ++n3;
            }
        }
        this.tableMinWidth = 0.0f;
        this.tableMinHeight = 0.0f;
        this.tablePrefWidth = 0.0f;
        this.tablePrefHeight = 0.0f;
        for (n6 = 0; n6 < n7; ++n6) {
            this.tableMinWidth += fArray[n6];
            this.tablePrefWidth += fArray3[n6];
        }
        for (n7 = 0; n7 < n8; ++n7) {
            this.tableMinHeight += fArray2[n7];
            this.tablePrefHeight += Math.max(fArray2[n7], fArray4[n7]);
        }
        f6 = this.padLeft.get(this) + this.padRight.get(this);
        f7 = this.padTop.get(this) + this.padBottom.get(this);
        this.tableMinWidth += f6;
        this.tableMinHeight += f7;
        this.tablePrefWidth = Math.max(this.tablePrefWidth + f6, this.tableMinWidth);
        this.tablePrefHeight = Math.max(this.tablePrefHeight + f7, this.tableMinHeight);
    }

    private void drawDebugRects(ShapeRenderer shapeRenderer) {
        if (this.debugRects != null && this.getDebug()) {
            float f;
            shapeRenderer.set(ShapeRenderer.ShapeType.Line);
            if (this.getStage() != null) {
                shapeRenderer.setColor(this.getStage().getDebugColor());
            }
            boolean bl = this.isTransform();
            float f2 = 0.0f;
            if (!bl) {
                f2 = this.getX();
                f = this.getY();
            } else {
                f = 0.0f;
            }
            int n = this.debugRects.size;
            for (int i = 0; i < n; ++i) {
                DebugRect debugRect = this.debugRects.get(i);
                shapeRenderer.setColor(debugRect.color);
                shapeRenderer.rect(debugRect.x + f2, debugRect.y + f, debugRect.width, debugRect.height);
            }
        }
    }

    private void endRow() {
        Array<Cell> array = this.cells;
        int n = 0;
        for (int i = array.size - 1; i >= 0; --i) {
            Cell cell = array.get(i);
            if (cell.endRow) break;
            n += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, n);
        ++this.rows;
        array.peek().endRow = true;
    }

    private float[] ensureSize(float[] fArray, int n) {
        if (fArray != null && fArray.length >= n) {
            int n2 = fArray.length;
            for (n = 0; n < n2; ++n) {
                fArray[n] = 0.0f;
            }
            return fArray;
        }
        return new float[n];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void layout(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        int n;
        float f9;
        Object object;
        float f10;
        float f11;
        float f12;
        int n2;
        float f13;
        float[] fArray;
        float[] fArray2;
        int n3;
        int n4;
        float f14;
        float f15;
        int n5;
        block59: {
            block58: {
                block57: {
                    float f16;
                    block56: {
                        block55: {
                            block54: {
                                int n6;
                                int n7;
                                Object object2 = this.cells;
                                n5 = ((Array)object2).size;
                                if (this.sizeInvalid) {
                                    this.computeSize();
                                }
                                float f17 = this.padLeft.get(this);
                                f15 = f17 + this.padRight.get(this);
                                f16 = this.padTop.get(this);
                                f14 = f16 + this.padBottom.get(this);
                                n4 = this.columns;
                                n3 = this.rows;
                                float[] fArray3 = this.expandWidth;
                                float[] fArray4 = this.expandHeight;
                                fArray2 = this.columnWidth;
                                fArray = this.rowHeight;
                                f13 = 0.0f;
                                for (n2 = 0; n2 < n4; f13 += fArray3[n2], ++n2) {
                                }
                                f12 = 0.0f;
                                for (n2 = 0; n2 < n3; f12 += fArray4[n2], ++n2) {
                                }
                                f11 = this.tablePrefWidth;
                                f10 = this.tableMinWidth;
                                if ((f11 -= f10) == 0.0f) {
                                    object = this.columnMinWidth;
                                } else {
                                    f9 = Math.min(f11, Math.max(0.0f, f3 - f10));
                                    object = this.ensureSize(columnWeightedWidth, n4);
                                    columnWeightedWidth = object;
                                    float[] fArray5 = this.columnMinWidth;
                                    float[] fArray6 = this.columnPrefWidth;
                                    for (n2 = 0; n2 < n4; ++n2) {
                                        f10 = (fArray6[n2] - fArray5[n2]) / f11;
                                        object[n2] = fArray5[n2] + f10 * f9;
                                    }
                                }
                                f9 = this.tablePrefHeight - this.tableMinHeight;
                                if (f9 == 0.0f) {
                                    float[] fArray7 = this.rowMinHeight;
                                } else {
                                    float[] fArray8 = this.ensureSize(rowWeightedHeight, n3);
                                    rowWeightedHeight = fArray8;
                                    f10 = Math.min(f9, Math.max(0.0f, f4 - this.tableMinHeight));
                                    float[] fArray9 = this.rowMinHeight;
                                    float[] fArray10 = this.rowPrefHeight;
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        f11 = (fArray10[n2] - fArray9[n2]) / f9;
                                        fArray8[n2] = fArray9[n2] + f11 * f10;
                                    }
                                }
                                n = 0;
                                float[] fArray11 = object;
                                object = object2;
                                n2 = n3;
                                for (n3 = n; n3 < n5; ++n3) {
                                    void var25_35;
                                    Cell cell = (Cell)((Array)object).get(n3);
                                    n7 = cell.column;
                                    int n8 = cell.row;
                                    object2 = cell.actor;
                                    n6 = cell.colspan;
                                    f9 = 0.0f;
                                    for (n = n7; n < n7 + n6; f9 += fArray11[n], ++n) {
                                    }
                                    void var31_46 = var25_35[n8];
                                    f11 = cell.prefWidth.get((Actor)object2);
                                    f8 = cell.prefHeight.get((Actor)object2);
                                    f10 = cell.minWidth.get((Actor)object2);
                                    f7 = cell.minHeight.get((Actor)object2);
                                    f6 = cell.maxWidth.get((Actor)object2);
                                    f5 = cell.maxHeight.get((Actor)object2);
                                    if (!(f11 < f10)) {
                                        f10 = f11;
                                    }
                                    f11 = f8;
                                    if (f8 < f7) {
                                        f11 = f7;
                                    }
                                    f8 = f10;
                                    if (f6 > 0.0f) {
                                        f8 = f10;
                                        if (f10 > f6) {
                                            f8 = f6;
                                        }
                                    }
                                    f10 = f11;
                                    if (f5 > 0.0f) {
                                        f10 = f11;
                                        if (f11 > f5) {
                                            f10 = f5;
                                        }
                                    }
                                    cell.actorWidth = Math.min(f9 - cell.computedPadLeft - cell.computedPadRight, f8);
                                    cell.actorHeight = Math.min((float)(var31_46 - cell.computedPadTop - cell.computedPadBottom), f10);
                                    if (n6 == 1) {
                                        fArray2[n7] = Math.max(fArray2[n7], f9);
                                    }
                                    fArray[n8] = Math.max(fArray[n8], (float)var31_46);
                                }
                                if (f13 > 0.0f) {
                                    f11 = f3 - f15;
                                    n7 = n4;
                                    for (n3 = 0; n3 < n7; f11 -= fArray2[n3], ++n3) {
                                    }
                                    if (f11 > 0.0f) {
                                        n = 0;
                                        f10 = 0.0f;
                                        for (n3 = 0; n3 < n7; ++n3) {
                                            if (fArray3[n3] == 0.0f) continue;
                                            f9 = fArray3[n3] * f11 / f13;
                                            fArray2[n3] = fArray2[n3] + f9;
                                            f10 += f9;
                                            n = n3;
                                        }
                                        fArray2[n] = fArray2[n] + (f11 - f10);
                                    }
                                }
                                if (f12 > 0.0f) {
                                    f11 = f4 - f14;
                                    n7 = n2;
                                    for (n3 = 0; n3 < n7; f11 -= fArray[n3], ++n3) {
                                    }
                                    if (f11 > 0.0f) {
                                        n = 0;
                                        f10 = 0.0f;
                                        for (n3 = 0; n3 < n7; ++n3) {
                                            if (fArray4[n3] == 0.0f) continue;
                                            f13 = fArray4[n3] * f11 / f12;
                                            fArray[n3] = fArray[n3] + f13;
                                            f10 += f13;
                                            n = n3;
                                        }
                                        fArray[n] = fArray[n] + (f11 - f10);
                                    }
                                }
                                for (n = 0; n < n5; ++n) {
                                    Cell cell = (Cell)((Array)object).get(n);
                                    n6 = cell.colspan;
                                    if (n6 == 1) continue;
                                    n7 = cell.column;
                                    f11 = 0.0f;
                                    for (n3 = n7; n3 < n7 + n6; f11 += fArray11[n3] - fArray2[n3], ++n3) {
                                    }
                                    if (!((f11 = (f11 - Math.max(0.0f, cell.computedPadLeft + cell.computedPadRight)) / (float)n6) > 0.0f)) continue;
                                    for (n3 = n7 = cell.column; n3 < n6 + n7; ++n3) {
                                        fArray2[n3] = fArray2[n3] + f11;
                                    }
                                }
                                f13 = f15;
                                for (n3 = 0; n3 < n4; f13 += fArray2[n3], ++n3) {
                                }
                                f9 = f14;
                                for (n4 = 0; n4 < n2; f9 += fArray[n4], ++n4) {
                                }
                                n2 = this.align;
                                f10 = f + f17;
                                if ((n2 & 0x10) == 0) break block54;
                                f11 = f3 - f13;
                                break block55;
                            }
                            f11 = f10;
                            if ((n2 & 8) != 0) break block56;
                            f11 = (f3 - f13) / 2.0f;
                        }
                        f11 = f10 + f11;
                    }
                    f12 = f2 + f16;
                    if ((n2 & 4) == 0) break block57;
                    f10 = f4 - f9;
                    break block58;
                }
                f10 = f12;
                if ((n2 & 2) != 0) break block59;
                f10 = (f4 - f9) / 2.0f;
            }
            f10 = f12 + f10;
        }
        f8 = f11;
        f12 = f10;
        float[] fArray12 = fArray2;
        for (n4 = 0; n4 < n5; ++n4) {
            Cell cell = (Cell)((Array)object).get(n4);
            n3 = cell.column;
            n = cell.colspan;
            f5 = 0.0f;
            for (n2 = n3; n2 < n + n3; f5 += fArray12[n2], ++n2) {
            }
            f5 -= cell.computedPadLeft + cell.computedPadRight;
            f8 += cell.computedPadLeft;
            f7 = cell.fillX.floatValue();
            f6 = cell.fillY.floatValue();
            if (f7 > 0.0f) {
                cell.actorWidth = Math.max(f7 * f5, cell.minWidth.get(cell.actor));
                f7 = cell.maxWidth.get(cell.actor);
                if (f7 > 0.0f) {
                    cell.actorWidth = Math.min(cell.actorWidth, f7);
                }
            }
            if (f6 > 0.0f) {
                cell.actorHeight = Math.max(fArray[cell.row] * f6 - cell.computedPadTop - cell.computedPadBottom, cell.minHeight.get(cell.actor));
                f6 = cell.maxHeight.get(cell.actor);
                if (f6 > 0.0f) {
                    cell.actorHeight = Math.min(cell.actorHeight, f6);
                }
            }
            cell.actorX = ((n2 = cell.align.intValue()) & 8) != 0 ? f8 : ((n2 & 0x10) != 0 ? f8 + f5 - cell.actorWidth : (f5 - cell.actorWidth) / 2.0f + f8);
            cell.actorY = (n2 & 2) != 0 ? cell.computedPadTop + f12 : ((n2 & 4) != 0 ? fArray[cell.row] + f12 - cell.actorHeight - cell.computedPadBottom : (fArray[cell.row] - cell.actorHeight + cell.computedPadTop - cell.computedPadBottom) / 2.0f + f12);
            if (cell.endRow) {
                f5 = f12 + fArray[cell.row];
                f12 = f11;
            } else {
                f8 += f5 + cell.computedPadRight;
                f5 = f12;
                f12 = f8;
            }
            f8 = f12;
            f12 = f5;
        }
        if (this.debug == Debug.none) {
            return;
        }
        this.clearDebugRects();
        if (this.debug == Debug.table || this.debug == Debug.all) {
            this.addDebugRect(f, f2, f3, f4, debugTableColor);
            this.addDebugRect(f11, f10, f13 - f15, f9 - f14, debugTableColor);
        }
        f = f11;
        n4 = 0;
        while (n4 < n5) {
            Cell cell = (Cell)((Array)object).get(n4);
            if (this.debug == Debug.actor || this.debug == Debug.all) {
                this.addDebugRect(cell.actorX, cell.actorY, cell.actorWidth, cell.actorHeight, debugActorColor);
            }
            n3 = cell.column;
            n = cell.colspan;
            f2 = 0.0f;
            for (n2 = n3; n2 < n + n3; f2 += fArray12[n2], ++n2) {
            }
            f2 -= cell.computedPadLeft + cell.computedPadRight;
            f += cell.computedPadLeft;
            if (this.debug == Debug.cell || this.debug == Debug.all) {
                this.addDebugRect(f, f10 + cell.computedPadTop, f2, fArray[cell.row] - cell.computedPadTop - cell.computedPadBottom, debugCellColor);
            }
            if (cell.endRow) {
                f10 += fArray[cell.row];
                f = f11;
            } else {
                f += f2 + cell.computedPadRight;
            }
            ++n4;
        }
        return;
    }

    private Cell obtainCell() {
        Cell cell = cellPool.obtain();
        cell.setTable(this);
        return cell;
    }

    public Cell add() {
        return this.add((T)null);
    }

    public <T extends Actor> Cell<T> add(T t) {
        Object object;
        Cell cell;
        block10: {
            cell = this.obtainCell();
            cell.actor = t;
            if (this.implicitEndRow) {
                this.implicitEndRow = false;
                --this.rows;
                this.cells.peek().endRow = false;
            }
            object = this.cells;
            int n = ((Array)object).size;
            if (n > 0) {
                Cell cell2 = ((Array)object).peek();
                if (!cell2.endRow) {
                    cell.column = cell2.column + cell2.colspan;
                    cell.row = cell2.row;
                } else {
                    cell.column = 0;
                    cell.row = cell2.row + 1;
                }
                if (cell.row > 0) {
                    for (int i = n - 1; i >= 0; --i) {
                        cell2 = ((Array)object).get(i);
                        int n2 = cell2.column;
                        int n3 = cell2.colspan;
                        for (n = n2; n < n3 + n2; ++n) {
                            if (n != cell.column) continue;
                            cell.cellAboveIndex = i;
                            break block10;
                        }
                    }
                }
            } else {
                cell.column = 0;
                cell.row = 0;
            }
        }
        ((Array)object).add((Cell)cell);
        cell.set(this.cellDefaults);
        if (cell.column < this.columnDefaults.size && (object = this.columnDefaults.get(cell.column)) != null) {
            cell.merge((Cell)object);
        }
        cell.merge(this.rowDefaults);
        if (t != null) {
            this.addActor(t);
        }
        return cell;
    }

    public Cell<Label> add(CharSequence charSequence) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.add((T)new Label(charSequence, skin));
        }
        throw new IllegalStateException("Table must have a skin set to use this method.");
    }

    public Cell<Label> add(CharSequence charSequence, String string2) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.add((T)new Label(charSequence, skin.get(string2, Label.LabelStyle.class)));
        }
        throw new IllegalStateException("Table must have a skin set to use this method.");
    }

    public Cell<Label> add(CharSequence charSequence, String string2, Color color2) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.add((T)new Label(charSequence, new Label.LabelStyle(skin.getFont(string2), color2)));
        }
        throw new IllegalStateException("Table must have a skin set to use this method.");
    }

    public Cell<Label> add(CharSequence charSequence, String string2, String string3) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.add((T)new Label(charSequence, new Label.LabelStyle(skin.getFont(string2), this.skin.getColor(string3))));
        }
        throw new IllegalStateException("Table must have a skin set to use this method.");
    }

    public Table add(Actor ... actorArray) {
        int n = actorArray.length;
        for (int i = 0; i < n; ++i) {
            this.add((T)actorArray[i]);
        }
        return this;
    }

    public Table align(int n) {
        this.align = n;
        return this;
    }

    public Table background(Drawable drawable2) {
        this.setBackground(drawable2);
        return this;
    }

    public Table background(String string2) {
        this.setBackground(string2);
        return this;
    }

    public Table bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Table center() {
        this.align = 1;
        return this;
    }

    @Override
    public void clearChildren() {
        Object object = this.cells;
        for (int i = ((Array)object).size - 1; i >= 0; --i) {
            Actor actor = ((Array)object).get((int)i).actor;
            if (actor == null) continue;
            actor.remove();
        }
        cellPool.freeAll((Array<Cell>)object);
        ((Array)object).clear();
        this.rows = 0;
        this.columns = 0;
        object = this.rowDefaults;
        if (object != null) {
            cellPool.free((Cell)object);
        }
        this.rowDefaults = null;
        this.implicitEndRow = false;
        super.clearChildren();
    }

    public Cell columnDefaults(int n) {
        Cell cell = this.columnDefaults.size > n ? this.columnDefaults.get(n) : null;
        Cell cell2 = cell;
        if (cell == null) {
            cell2 = this.obtainCell();
            cell2.clear();
            if (n >= this.columnDefaults.size) {
                for (int i = this.columnDefaults.size; i < n; ++i) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell2);
            } else {
                this.columnDefaults.set(n, cell2);
            }
        }
        return cell2;
    }

    @Override
    public Table debug() {
        super.debug();
        return this;
    }

    public Table debug(Debug debug) {
        boolean bl = debug != Debug.none;
        super.setDebug(bl);
        if (this.debug != debug) {
            this.debug = debug;
            if (debug == Debug.none) {
                this.clearDebugRects();
            } else {
                this.invalidate();
            }
        }
        return this;
    }

    public Table debugActor() {
        super.setDebug(true);
        if (this.debug != Debug.actor) {
            this.debug = Debug.actor;
            this.invalidate();
        }
        return this;
    }

    @Override
    public Table debugAll() {
        super.debugAll();
        return this;
    }

    public Table debugCell() {
        super.setDebug(true);
        if (this.debug != Debug.cell) {
            this.debug = Debug.cell;
            this.invalidate();
        }
        return this;
    }

    public Table debugTable() {
        super.setDebug(true);
        if (this.debug != Debug.table) {
            this.debug = Debug.table;
            this.invalidate();
        }
        return this;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, f, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float f2 = this.padLeft.get(this);
                float f3 = this.padBottom.get(this);
                if (this.clipBegin(f2, f3, this.getWidth() - f2 - this.padRight.get(this), this.getHeight() - f3 - this.padTop.get(this))) {
                    this.drawChildren(batch, f);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, f);
            }
            this.resetTransform(batch);
        } else {
            this.drawBackground(batch, f, this.getX(), this.getY());
            super.draw(batch, f);
        }
    }

    protected void drawBackground(Batch batch, float f, float f2, float f3) {
        if (this.background == null) {
            return;
        }
        Color color2 = this.getColor();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        this.background.draw(batch, f2, f3, this.getWidth(), this.getHeight());
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        if (this.isTransform()) {
            this.applyTransform(shapeRenderer, this.computeTransform());
            this.drawDebugRects(shapeRenderer);
            if (this.clip) {
                float f;
                shapeRenderer.flush();
                float f2 = this.getWidth();
                float f3 = this.getHeight();
                Drawable drawable2 = this.background;
                float f4 = 0.0f;
                if (drawable2 != null) {
                    f4 = this.padLeft.get(this);
                    f = this.padBottom.get(this);
                    f2 -= this.padRight.get(this) + f4;
                    f3 -= this.padTop.get(this) + f;
                } else {
                    f = 0.0f;
                }
                if (this.clipBegin(f4, f, f2, f3)) {
                    this.drawDebugChildren(shapeRenderer);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapeRenderer);
            }
            this.resetTransform(shapeRenderer);
        } else {
            this.drawDebugRects(shapeRenderer);
            super.drawDebug(shapeRenderer);
        }
    }

    @Override
    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
    }

    public int getAlign() {
        return this.align;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public <T extends Actor> Cell<T> getCell(T t) {
        Array<Cell> array = this.cells;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Cell cell = array.get(i);
            if (cell.actor != t) continue;
            return cell;
        }
        return null;
    }

    public Array<Cell> getCells() {
        return this.cells;
    }

    public boolean getClip() {
        return this.clip;
    }

    public float getColumnMinWidth(int n) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnMinWidth[n];
    }

    public float getColumnPrefWidth(int n) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnPrefWidth[n];
    }

    public float getColumnWidth(int n) {
        float[] fArray = this.columnWidth;
        if (fArray == null) {
            return 0.0f;
        }
        return fArray[n];
    }

    public int getColumns() {
        return this.columns;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f = this.tablePrefHeight;
        Drawable drawable2 = this.background;
        float f2 = f;
        if (drawable2 != null) {
            f2 = Math.max(f, drawable2.getMinHeight());
        }
        return f2;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f = this.tablePrefWidth;
        Drawable drawable2 = this.background;
        float f2 = f;
        if (drawable2 != null) {
            f2 = Math.max(f, drawable2.getMinWidth());
        }
        return f2;
    }

    public int getRow(float f) {
        Array<Cell> array = this.cells;
        float f2 = this.getPadTop();
        int n = array.size;
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Cell cell = array.get(i);
            if (cell.actorY + cell.computedPadTop < f + f2) break;
            int n3 = n2;
            if (cell.endRow) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return Math.min(n2, this.rows - 1);
    }

    public float getRowHeight(int n) {
        float[] fArray = this.rowHeight;
        if (fArray == null) {
            return 0.0f;
        }
        return fArray[n];
    }

    public float getRowMinHeight(int n) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowMinHeight[n];
    }

    public float getRowPrefHeight(int n) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowPrefHeight[n];
    }

    public int getRows() {
        return this.rows;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public Debug getTableDebug() {
        return this.debug;
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        if (this.clip) {
            if (bl && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (f < 0.0f || f >= this.getWidth() || f2 < 0.0f || f2 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(f, f2, bl);
    }

    @Override
    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    @Override
    public void layout() {
        float f;
        Object object;
        int n;
        int n2;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        this.layout(0.0f, 0.0f, f2, f3);
        Object object2 = this.cells;
        boolean bl = this.round;
        int n3 = 0;
        if (bl) {
            n2 = ((Array)object2).size;
            for (n = 0; n < n2; ++n) {
                object = ((Array)object2).get(n);
                float f4 = Math.round(((Cell)object).actorWidth);
                f2 = Math.round(((Cell)object).actorHeight);
                float f5 = Math.round(((Cell)object).actorX);
                f = f3 - (float)Math.round(((Cell)object).actorY) - f2;
                ((Cell)object).setActorBounds(f5, f, f4, f2);
                object = ((Cell)object).actor;
                if (object == null) continue;
                ((Actor)object).setBounds(f5, f, f4, f2);
            }
        } else {
            n2 = ((Array)object2).size;
            for (n = 0; n < n2; ++n) {
                Cell cell = ((Array)object2).get(n);
                f2 = cell.actorHeight;
                f = f3 - cell.actorY - f2;
                cell.setActorY(f);
                object = cell.actor;
                if (object == null) continue;
                ((Actor)object).setBounds(cell.actorX, f, cell.actorWidth, f2);
            }
        }
        object = this.getChildren();
        n2 = ((Array)object).size;
        for (n = n3; n < n2; ++n) {
            object2 = (Actor)((Array)object).get(n);
            if (!(object2 instanceof Layout)) continue;
            ((Layout)object2).validate();
        }
    }

    public Table left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Table pad(float f) {
        this.pad(Value.Fixed.valueOf(f));
        return this;
    }

    public Table pad(float f, float f2, float f3, float f4) {
        this.padTop = Value.Fixed.valueOf(f);
        this.padLeft = Value.Fixed.valueOf(f2);
        this.padBottom = Value.Fixed.valueOf(f3);
        this.padRight = Value.Fixed.valueOf(f4);
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(Value value) {
        if (value != null) {
            this.padTop = value;
            this.padLeft = value;
            this.padBottom = value;
            this.padRight = value;
            this.sizeInvalid = true;
            return this;
        }
        throw new IllegalArgumentException("pad cannot be null.");
    }

    public Table pad(Value value, Value value2, Value value3, Value value4) {
        if (value != null) {
            if (value2 != null) {
                if (value3 != null) {
                    if (value4 != null) {
                        this.padTop = value;
                        this.padLeft = value2;
                        this.padBottom = value3;
                        this.padRight = value4;
                        this.sizeInvalid = true;
                        return this;
                    }
                    throw new IllegalArgumentException("right cannot be null.");
                }
                throw new IllegalArgumentException("bottom cannot be null.");
            }
            throw new IllegalArgumentException("left cannot be null.");
        }
        throw new IllegalArgumentException("top cannot be null.");
    }

    public Table padBottom(float f) {
        this.padBottom = Value.Fixed.valueOf(f);
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(Value value) {
        if (value != null) {
            this.padBottom = value;
            this.sizeInvalid = true;
            return this;
        }
        throw new IllegalArgumentException("padBottom cannot be null.");
    }

    public Table padLeft(float f) {
        this.padLeft = Value.Fixed.valueOf(f);
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(Value value) {
        if (value != null) {
            this.padLeft = value;
            this.sizeInvalid = true;
            return this;
        }
        throw new IllegalArgumentException("padLeft cannot be null.");
    }

    public Table padRight(float f) {
        this.padRight = Value.Fixed.valueOf(f);
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(Value value) {
        if (value != null) {
            this.padRight = value;
            this.sizeInvalid = true;
            return this;
        }
        throw new IllegalArgumentException("padRight cannot be null.");
    }

    public Table padTop(float f) {
        this.padTop = Value.Fixed.valueOf(f);
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(Value value) {
        if (value != null) {
            this.padTop = value;
            this.sizeInvalid = true;
            return this;
        }
        throw new IllegalArgumentException("padTop cannot be null.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        return this.removeActor(actor, true);
    }

    @Override
    public boolean removeActor(Actor object, boolean bl) {
        if (!super.removeActor((Actor)object, bl)) {
            return false;
        }
        if ((object = this.getCell(object)) != null) {
            ((Cell)object).actor = null;
        }
        return true;
    }

    public void reset() {
        this.clearChildren();
        this.padTop = backgroundTop;
        this.padLeft = backgroundLeft;
        this.padBottom = backgroundBottom;
        this.padRight = backgroundRight;
        this.align = 1;
        this.debug(Debug.none);
        this.cellDefaults.reset();
        int n = this.columnDefaults.size;
        for (int i = 0; i < n; ++i) {
            Cell cell = this.columnDefaults.get(i);
            if (cell == null) continue;
            cellPool.free(cell);
        }
        this.columnDefaults.clear();
    }

    public Table right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    public Cell row() {
        if (this.cells.size > 0) {
            if (!this.implicitEndRow) {
                if (this.cells.peek().endRow) {
                    return this.rowDefaults;
                }
                this.endRow();
            }
            this.invalidate();
        }
        this.implicitEndRow = false;
        Cell cell = this.rowDefaults;
        if (cell != null) {
            cellPool.free(cell);
        }
        this.rowDefaults = this.obtainCell();
        this.rowDefaults.clear();
        return this.rowDefaults;
    }

    public void setBackground(Drawable drawable2) {
        if (this.background == drawable2) {
            return;
        }
        float f = this.getPadTop();
        float f2 = this.getPadLeft();
        float f3 = this.getPadBottom();
        float f4 = this.getPadRight();
        this.background = drawable2;
        float f5 = this.getPadTop();
        float f6 = this.getPadLeft();
        float f7 = this.getPadBottom();
        float f8 = this.getPadRight();
        if (f + f3 == f5 + f7 && f2 + f4 == f6 + f8) {
            if (f != f5 || f2 != f6 || f3 != f7 || f4 != f8) {
                this.invalidate();
            }
        } else {
            this.invalidateHierarchy();
        }
    }

    public void setBackground(String string2) {
        Skin skin = this.skin;
        if (skin != null) {
            this.setBackground(skin.getDrawable(string2));
            return;
        }
        throw new IllegalStateException("Table must have a skin set to use this method.");
    }

    public void setClip(boolean bl) {
        this.clip = bl;
        this.setTransform(bl);
        this.invalidate();
    }

    @Override
    public void setDebug(boolean bl) {
        Debug debug = bl ? Debug.all : Debug.none;
        this.debug(debug);
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public Cell<Stack> stack(Actor ... actorArray) {
        Stack stack = new Stack();
        if (actorArray != null) {
            int n = actorArray.length;
            for (int i = 0; i < n; ++i) {
                stack.addActor(actorArray[i]);
            }
        }
        return this.add((T)stack);
    }

    public Table top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public static enum Debug {
        none,
        all,
        table,
        cell,
        actor;

    }

    public static class DebugRect
    extends Rectangle {
        static Pool<DebugRect> pool = Pools.get(DebugRect.class);
        Color color;
    }
}

