/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class List<T>
extends Widget
implements Cullable {
    private int alignment = 8;
    private Rectangle cullingArea;
    float itemHeight;
    final Array<T> items = new Array();
    private InputListener keyListener;
    int overIndex = -1;
    private float prefHeight;
    private float prefWidth;
    int pressedIndex = -1;
    ArraySelection<T> selection = new ArraySelection<T>(this.items);
    ListStyle style;
    boolean typeToSelect;

    public List(ListStyle object) {
        this.selection.setActor(this);
        this.selection.setRequired(true);
        this.setStyle((ListStyle)object);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.keyListener = object = new InputListener(){
            String prefix;
            long typeTimeout;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean keyDown(InputEvent object, int n) {
                if (List.this.items.isEmpty()) {
                    return false;
                }
                if (n != 3) {
                    if (n != 29) {
                        int n2;
                        if (n != 19) {
                            int n3;
                            if (n != 20) {
                                if (n != 131) {
                                    if (n != 132) return false;
                                    object = List.this;
                                    ((List)object).setSelectedIndex(((List)object).items.size - 1);
                                    return true;
                                }
                                if (List.this.getStage() == null) return true;
                                List.this.getStage().setKeyboardFocus(null);
                                return true;
                            }
                            n = n3 = List.this.items.indexOf(List.this.getSelected(), false) + 1;
                            if (n3 >= List.this.items.size) {
                                n = 0;
                            }
                            List.this.setSelectedIndex(n);
                            return true;
                        }
                        n = n2 = List.this.items.indexOf(List.this.getSelected(), false) - 1;
                        if (n2 < 0) {
                            n = List.this.items.size - 1;
                        }
                        List.this.setSelectedIndex(n);
                        return true;
                    }
                    if (!UIUtils.ctrl() || !List.this.selection.getMultiple()) return false;
                    List.this.selection.clear();
                    List.this.selection.addAll(List.this.items);
                    return true;
                }
                List.this.setSelectedIndex(0);
                return true;
            }

            @Override
            public boolean keyTyped(InputEvent object, char c) {
                if (!List.this.typeToSelect) {
                    return false;
                }
                long l = System.currentTimeMillis();
                if (l > this.typeTimeout) {
                    this.prefix = "";
                }
                this.typeTimeout = l + 300L;
                object = new StringBuilder();
                ((StringBuilder)object).append(this.prefix);
                ((StringBuilder)object).append(Character.toLowerCase(c));
                this.prefix = ((StringBuilder)object).toString();
                int n = List.this.items.size;
                for (int i = 0; i < n; ++i) {
                    object = List.this;
                    if (!((List)object).toString(((List)object).items.get(i)).toLowerCase().startsWith(this.prefix)) continue;
                    List.this.setSelectedIndex(i);
                    break;
                }
                return false;
            }
        };
        this.addListener((EventListener)object);
        this.addListener(new InputListener(){

            @Override
            public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                if (n == 0) {
                    List.this.pressedIndex = -1;
                }
                if (n == -1) {
                    List.this.overIndex = -1;
                }
            }

            @Override
            public boolean mouseMoved(InputEvent object, float f, float f2) {
                object = List.this;
                ((List)object).overIndex = ((List)object).getItemIndexAt(f2);
                return false;
            }

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                if (n == 0 && n2 == 0) {
                    if (List.this.selection.isDisabled()) {
                        return true;
                    }
                    if (List.this.getStage() != null) {
                        List.this.getStage().setKeyboardFocus(List.this);
                    }
                    if (List.this.items.size == 0) {
                        return true;
                    }
                    n = List.this.getItemIndexAt(f2);
                    if (n == -1) {
                        return true;
                    }
                    List.this.selection.choose(List.this.items.get(n));
                    List.this.pressedIndex = n;
                }
                return true;
            }

            @Override
            public void touchDragged(InputEvent object, float f, float f2, int n) {
                object = List.this;
                ((List)object).overIndex = ((List)object).getItemIndexAt(f2);
            }

            @Override
            public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
                if (n == 0 && n2 == 0) {
                    List.this.pressedIndex = -1;
                }
            }
        });
    }

    public List(Skin skin) {
        this(skin.get(ListStyle.class));
    }

    public List(Skin skin, String string2) {
        this(skin.get(string2, ListStyle.class));
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.clear();
        this.invalidateHierarchy();
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        this.drawBackground(batch, f);
        BitmapFont bitmapFont = this.style.font;
        Drawable drawable2 = this.style.selection;
        Color color2 = this.style.fontColorSelected;
        Color color3 = this.style.fontColorUnselected;
        Object object = this.getColor();
        batch.setColor(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * f);
        float f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getWidth();
        float f5 = this.getHeight();
        object = this.style.background;
        float f6 = f2;
        float f7 = f4;
        float f8 = f5;
        if (object != null) {
            f7 = object.getLeftWidth();
            f6 = f2 + f7;
            f8 = f5 - object.getTopHeight();
            f7 = f4 - (f7 + object.getRightWidth());
        }
        f2 = drawable2.getLeftWidth();
        f4 = drawable2.getRightWidth();
        float f9 = drawable2.getTopHeight();
        f5 = bitmapFont.getDescent();
        bitmapFont.setColor(color3.r, color3.g, color3.b, color3.a * f);
        for (int i = 0; i < this.items.size; ++i) {
            object = this.cullingArea;
            if (!(object == null || f8 - this.itemHeight <= ((Rectangle)object).y + this.cullingArea.height && f8 >= this.cullingArea.y)) {
                if (f8 < this.cullingArea.y) {
                    break;
                }
            } else {
                T t = this.items.get(i);
                boolean bl = this.selection.contains(t);
                Object var19_19 = null;
                if (this.pressedIndex == i && this.style.down != null) {
                    object = this.style.down;
                } else if (bl) {
                    bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f);
                    object = drawable2;
                } else {
                    object = var19_19;
                    if (this.overIndex == i) {
                        object = var19_19;
                        if (this.style.over != null) {
                            object = this.style.over;
                        }
                    }
                }
                if (object != null) {
                    float f10 = this.itemHeight;
                    object.draw(batch, f6, f3 + f8 - f10, f7, f10);
                }
                this.drawItem(batch, bitmapFont, i, t, f6 + f2, f3 + f8 - (f9 - f5), f7 - f2 - f4);
                if (bl) {
                    bitmapFont.setColor(color3.r, color3.g, color3.b, color3.a * f);
                }
            }
            f8 -= this.itemHeight;
        }
    }

    protected void drawBackground(Batch batch, float f) {
        if (this.style.background != null) {
            Color color2 = this.getColor();
            batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, int n, T object, float f, float f2, float f3) {
        object = this.toString(object);
        return bitmapFont.draw(batch, (CharSequence)object, f, f2, 0, ((String)object).length(), f3, this.alignment, false, "...");
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    public T getItemAt(float f) {
        int n = this.getItemIndexAt(f);
        if (n == -1) {
            return null;
        }
        return this.items.get(n);
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    public int getItemIndexAt(float f) {
        int n;
        float f2 = this.getHeight();
        Drawable drawable2 = this.style.background;
        float f3 = f2;
        float f4 = f;
        if (drawable2 != null) {
            f3 = f2 - (drawable2.getTopHeight() + drawable2.getBottomHeight());
            f4 = f - drawable2.getBottomHeight();
        }
        if ((n = (int)((f3 - f4) / this.itemHeight)) >= 0 && n < this.items.size) {
            return n;
        }
        return -1;
    }

    public Array<T> getItems() {
        return this.items;
    }

    public InputListener getKeyListener() {
        return this.keyListener;
    }

    public T getOverItem() {
        int n = this.overIndex;
        T t = n == -1 ? null : (T)this.items.get(n);
        return t;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    public T getPressedItem() {
        int n = this.pressedIndex;
        T t = n == -1 ? null : (T)this.items.get(n);
        return t;
    }

    public T getSelected() {
        return this.selection.first();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.items();
        int n = orderedSet.size == 0 ? -1 : this.items.indexOf(orderedSet.first(), false);
        return n;
    }

    public ArraySelection<T> getSelection() {
        return this.selection;
    }

    public ListStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        BitmapFont bitmapFont = this.style.font;
        Drawable drawable2 = this.style.selection;
        this.itemHeight = bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        this.itemHeight += drawable2.getTopHeight() + drawable2.getBottomHeight();
        this.prefWidth = 0.0f;
        Object object = Pools.get(GlyphLayout.class);
        GlyphLayout glyphLayout = ((Pool)object).obtain();
        for (int i = 0; i < this.items.size; ++i) {
            glyphLayout.setText(bitmapFont, this.toString(this.items.get(i)));
            this.prefWidth = Math.max(glyphLayout.width, this.prefWidth);
        }
        ((Pool)object).free((GlyphLayout)glyphLayout);
        this.prefWidth += drawable2.getLeftWidth() + drawable2.getRightWidth();
        this.prefHeight = (float)this.items.size * this.itemHeight;
        object = this.style.background;
        if (object != null) {
            this.prefWidth += object.getLeftWidth() + object.getRightWidth();
            this.prefHeight += object.getTopHeight() + object.getBottomHeight();
        }
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        this.cullingArea = rectangle;
    }

    public void setItems(Array array) {
        if (array != null) {
            float f = this.getPrefWidth();
            float f2 = this.getPrefHeight();
            Array<T> array2 = this.items;
            if (array != array2) {
                array2.clear();
                this.items.addAll(array);
            }
            this.overIndex = -1;
            this.pressedIndex = -1;
            this.selection.validate();
            this.invalidate();
            if (f != this.getPrefWidth() || f2 != this.getPrefHeight()) {
                this.invalidateHierarchy();
            }
            return;
        }
        throw new IllegalArgumentException("newItems cannot be null.");
    }

    public void setItems(T ... TArray) {
        if (TArray != null) {
            float f = this.getPrefWidth();
            float f2 = this.getPrefHeight();
            this.items.clear();
            this.items.addAll(TArray);
            this.overIndex = -1;
            this.pressedIndex = -1;
            this.selection.validate();
            this.invalidate();
            if (f != this.getPrefWidth() || f2 != this.getPrefHeight()) {
                this.invalidateHierarchy();
            }
            return;
        }
        throw new IllegalArgumentException("newItems cannot be null.");
    }

    public void setSelected(T t) {
        if (this.items.contains(t, false)) {
            this.selection.set(t);
        } else if (this.selection.getRequired() && this.items.size > 0) {
            this.selection.set(this.items.first());
        } else {
            this.selection.clear();
        }
    }

    public void setSelectedIndex(int n) {
        if (n >= -1 && n < this.items.size) {
            if (n == -1) {
                this.selection.clear();
            } else {
                this.selection.set(this.items.get(n));
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("index must be >= -1 and < ");
        stringBuilder.append(this.items.size);
        stringBuilder.append(": ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setSelection(ArraySelection<T> arraySelection) {
        this.selection = arraySelection;
    }

    public void setStyle(ListStyle listStyle) {
        if (listStyle != null) {
            this.style = listStyle;
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void setTypeToSelect(boolean bl) {
        this.typeToSelect = bl;
    }

    public String toString(T t) {
        return t.toString();
    }

    public static class ListStyle {
        public Drawable background;
        public Drawable down;
        public BitmapFont font;
        public Color fontColorSelected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color fontColorUnselected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable over;
        public Drawable selection;

        public ListStyle() {
        }

        public ListStyle(BitmapFont bitmapFont, Color color2, Color color3, Drawable drawable2) {
            this.font = bitmapFont;
            this.fontColorSelected.set(color2);
            this.fontColorUnselected.set(color3);
            this.selection = drawable2;
        }

        public ListStyle(ListStyle listStyle) {
            this.font = listStyle.font;
            this.fontColorSelected.set(listStyle.fontColorSelected);
            this.fontColorUnselected.set(listStyle.fontColorUnselected);
            this.selection = listStyle.selection;
            this.down = listStyle.down;
            this.over = listStyle.over;
            this.background = listStyle.background;
        }
    }
}

