/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.SnapshotArray;

public class HorizontalGroup
extends WidgetGroup {
    private int align = 8;
    private boolean expand;
    private float fill;
    private float lastPrefHeight;
    private float padBottom;
    private float padLeft;
    private float padRight;
    private float padTop;
    private float prefHeight;
    private float prefWidth;
    private boolean reverse;
    private boolean round = true;
    private int rowAlign;
    private FloatArray rowSizes;
    private boolean sizeInvalid = true;
    private float space;
    private boolean wrap;
    private float wrapSpace;

    public HorizontalGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    private void computeSize() {
        int n = 0;
        int n2 = 0;
        this.sizeInvalid = false;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        int n3 = snapshotArray.size;
        this.prefHeight = 0.0f;
        if (this.wrap) {
            float f;
            float f2;
            float f3;
            this.prefWidth = 0.0f;
            FloatArray floatArray = this.rowSizes;
            if (floatArray == null) {
                this.rowSizes = new FloatArray();
            } else {
                floatArray.clear();
            }
            floatArray = this.rowSizes;
            float f4 = this.space;
            float f5 = this.wrapSpace;
            float f6 = this.padLeft + this.padRight;
            float f7 = this.getWidth() - f6;
            if (this.reverse) {
                n2 = n3 - 1;
                n3 = -1;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                n = -1;
            } else {
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                n = 1;
            }
            while (n2 != n3) {
                float f8;
                float f9;
                Object object = (Actor)snapshotArray.get(n2);
                if (object instanceof Layout) {
                    object = (Layout)object;
                    f8 = f9 = object.getPrefWidth();
                    if (f9 > f7) {
                        f8 = Math.max(f7, object.getMinWidth());
                    }
                    f9 = object.getPrefHeight();
                } else {
                    f8 = ((Actor)object).getWidth();
                    f9 = ((Actor)object).getHeight();
                }
                float f10 = f3 > 0.0f ? f4 : 0.0f;
                f10 = f8 + f10;
                if (f3 + f10 > f7 && f3 > 0.0f) {
                    floatArray.add(f3);
                    floatArray.add(f2);
                    this.prefWidth = Math.max(this.prefWidth, f3 + f6);
                    f3 = f;
                    if (f > 0.0f) {
                        f3 = f + f5;
                    }
                    f = f3 + f2;
                    f3 = 0.0f;
                    f2 = 0.0f;
                } else {
                    f8 = f10;
                }
                f3 += f8;
                f2 = Math.max(f2, f9);
                n2 += n;
            }
            floatArray.add(f3);
            floatArray.add(f2);
            this.prefWidth = Math.max(this.prefWidth, f3 + f6);
            f3 = f;
            if (f > 0.0f) {
                f3 = f + f5;
            }
            this.prefHeight = Math.max(this.prefHeight, f3 + f2);
        } else {
            this.prefWidth = this.padLeft + this.padRight + this.space * (float)(n3 - 1);
            for (n2 = n; n2 < n3; ++n2) {
                Object object = (Actor)snapshotArray.get(n2);
                if (object instanceof Layout) {
                    object = (Layout)object;
                    this.prefWidth += object.getPrefWidth();
                    this.prefHeight = Math.max(this.prefHeight, object.getPrefHeight());
                    continue;
                }
                this.prefWidth += ((Actor)object).getWidth();
                this.prefHeight = Math.max(this.prefHeight, ((Actor)object).getHeight());
            }
        }
        this.prefHeight += this.padTop + this.padBottom;
        if (this.round) {
            this.prefWidth = Math.round(this.prefWidth);
            this.prefHeight = Math.round(this.prefHeight);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void layoutWrapped() {
        var1_1 = this.getPrefHeight();
        if (var1_1 != this.lastPrefHeight) {
            this.lastPrefHeight = var1_1;
            this.invalidateHierarchy();
        }
        var2_2 = this.align;
        var3_3 = this.round;
        var4_4 = this.space;
        var5_5 = this.padBottom;
        var6_6 = this.fill;
        var7_7 = this.wrapSpace;
        var8_8 = this.prefWidth - this.padLeft - this.padRight;
        var9_9 = var1_1 - this.padTop;
        var10_10 = this.getWidth();
        var11_11 = this.padLeft;
        if ((var2_2 & 2) != 0) {
            var1_1 = this.getHeight() - var1_1;
lbl17:
            // 2 sources

            while (true) {
                var5_5 = var9_9 + var1_1;
                break;
            }
        } else {
            var5_5 = var9_9;
            if ((var2_2 & 4) == 0) {
                var1_1 = (this.getHeight() - var1_1) / 2.0f;
                ** continue;
            }
        }
        if ((var2_2 & 16) != 0) {
            var1_1 = var10_10 - this.prefWidth;
lbl26:
            // 2 sources

            while (true) {
                var1_1 = var11_11 + var1_1;
                break;
            }
        } else {
            var1_1 = var11_11;
            if ((var2_2 & 8) == 0) {
                var1_1 = (var10_10 - this.prefWidth) / 2.0f;
                ** continue;
            }
        }
        var12_12 = var10_10 - this.padRight;
        var13_13 = this.rowAlign;
        var14_14 = this.rowSizes;
        var15_15 = this.getChildren();
        var2_2 = var15_15.size;
        var16_16 = this.reverse;
        var17_17 = -1;
        if (var16_16) {
            --var2_2;
            var18_18 = -1;
        } else {
            var17_17 = var2_2;
            var2_2 = 0;
            var18_18 = 1;
        }
        var10_10 = 0.0f;
        var19_19 = 0;
        var11_11 = 0.0f;
        while (var2_2 != var17_17) {
            var20_20 = (Actor)var15_15.get(var2_2);
            var21_21 = null;
            if (var20_20 instanceof Layout) {
                var21_21 = (Layout)var20_20;
                var9_9 = var22_22 = var21_21.getPrefWidth();
                if (var22_22 > var12_12) {
                    var9_9 = Math.max(var12_12, var21_21.getMinWidth());
                }
                var23_23 = var21_21.getPrefHeight();
                var22_22 = var9_9;
                var9_9 = var23_23;
            } else {
                var22_22 = var20_20.getWidth();
                var9_9 = var20_20.getHeight();
            }
            if (!(var10_10 + var22_22 > var12_12) && var19_19 != 0) {
                var23_23 = var10_10;
            } else {
                if ((var13_13 & 16) != 0) {
                    var11_11 = var8_8 - var14_14.get(var19_19);
lbl69:
                    // 2 sources

                    while (true) {
                        var11_11 += var1_1;
                        break;
                    }
                } else {
                    if ((var13_13 & 8) == 0) {
                        var11_11 = (var8_8 - var14_14.get(var19_19)) / 2.0f;
                        ** continue;
                    }
                    var11_11 = var1_1;
                }
                var24_24 = var14_14.get(var19_19 + 1);
                var10_10 = var5_5;
                if (var19_19 > 0) {
                    var10_10 = var5_5 - var7_7;
                }
                var5_5 = var10_10 - var24_24;
                var19_19 += 2;
                var23_23 = var11_11;
                var11_11 = var24_24;
            }
            if (var6_6 > 0.0f) {
                var9_9 = var11_11 * var6_6;
            }
            if (var21_21 != null) {
                var10_10 = Math.max(var9_9, var21_21.getMinHeight());
                var24_24 = var21_21.getMaxHeight();
                var9_9 = var10_10;
                if (var24_24 > 0.0f) {
                    var9_9 = var10_10;
                    if (var10_10 > var24_24) {
                        var9_9 = var24_24;
                    }
                }
            }
            var10_10 = (var13_13 & 2) != 0 ? var5_5 + (var11_11 - var9_9) : ((var13_13 & 4) == 0 ? var5_5 + (var11_11 - var9_9) / 2.0f : var5_5);
            if (var3_3) {
                var20_20.setBounds(Math.round(var23_23), Math.round(var10_10), Math.round(var22_22), Math.round(var9_9));
            } else {
                var20_20.setBounds(var23_23, var10_10, var22_22, var9_9);
            }
            var10_10 = var23_23 + (var22_22 + var4_4);
            if (var21_21 != null) {
                var21_21.validate();
            }
            var2_2 += var18_18;
        }
    }

    public HorizontalGroup align(int n) {
        this.align = n;
        return this;
    }

    public HorizontalGroup bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public HorizontalGroup center() {
        this.align = 1;
        return this;
    }

    @Override
    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
        super.drawDebugBounds(shapeRenderer);
        if (!this.getDebug()) {
            return;
        }
        shapeRenderer.set(ShapeRenderer.ShapeType.Line);
        if (this.getStage() != null) {
            shapeRenderer.setColor(this.getStage().getDebugColor());
        }
        shapeRenderer.rect(this.getX() + this.padLeft, this.getY() + this.padBottom, this.getOriginX(), this.getOriginY(), this.getWidth() - this.padLeft - this.padRight, this.getHeight() - this.padBottom - this.padTop, this.getScaleX(), this.getScaleY(), this.getRotation());
    }

    public HorizontalGroup expand() {
        this.expand = true;
        return this;
    }

    public HorizontalGroup expand(boolean bl) {
        this.expand = bl;
        return this;
    }

    public HorizontalGroup fill() {
        this.fill = 1.0f;
        return this;
    }

    public HorizontalGroup fill(float f) {
        this.fill = f;
        return this;
    }

    public int getAlign() {
        return this.align;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public float getFill() {
        return this.fill;
    }

    public float getPadBottom() {
        return this.padBottom;
    }

    public float getPadLeft() {
        return this.padLeft;
    }

    public float getPadRight() {
        return this.padRight;
    }

    public float getPadTop() {
        return this.padTop;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public float getSpace() {
        return this.space;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public float getWrapSpace() {
        return this.wrapSpace;
    }

    public HorizontalGroup grow() {
        this.expand = true;
        this.fill = 1.0f;
        return this;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void layout() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        int n;
        boolean bl;
        block20: {
            block19: {
                block18: {
                    if (this.sizeInvalid) {
                        this.computeSize();
                    }
                    if (this.wrap) {
                        this.layoutWrapped();
                        return;
                    }
                    bl = this.round;
                    n = this.align;
                    f7 = this.space;
                    f6 = this.padBottom;
                    f5 = this.fill;
                    f4 = this.expand ? this.getHeight() : this.prefHeight;
                    f3 = f4 - this.padTop - f6;
                    f2 = this.padLeft;
                    if ((n & 0x10) == 0) break block18;
                    f4 = this.getWidth() - this.prefWidth;
                    break block19;
                }
                f = f2;
                if ((n & 8) != 0) break block20;
                f4 = (this.getWidth() - this.prefWidth) / 2.0f;
            }
            f = f2 + f4;
        }
        f4 = (n & 4) != 0 ? f6 : ((n & 2) != 0 ? this.getHeight() - this.padTop - f3 : f6 + (this.getHeight() - f6 - this.padTop - f3) / 2.0f);
        int n2 = this.rowAlign;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        n = 0;
        int n3 = snapshotArray.size;
        boolean bl2 = this.reverse;
        int n4 = -1;
        if (bl2) {
            n = n3 - 1;
            n3 = -1;
            f2 = f;
        } else {
            n4 = 1;
            f2 = f;
        }
        while (n != n3) {
            float f8;
            Actor actor = (Actor)snapshotArray.get(n);
            Layout layout = null;
            if (actor instanceof Layout) {
                layout = (Layout)((Object)actor);
                f8 = layout.getPrefWidth();
                f = layout.getPrefHeight();
            } else {
                f8 = actor.getWidth();
                f = actor.getHeight();
            }
            if (f5 > 0.0f) {
                f = f3 * f5;
            }
            f = f6 = f;
            if (layout != null) {
                f6 = Math.max(f6, layout.getMinHeight());
                float f9 = layout.getMaxHeight();
                f = f6;
                if (f9 > 0.0f) {
                    f = f6;
                    if (f6 > f9) {
                        f = f9;
                    }
                }
            }
            f6 = (n2 & 2) != 0 ? f3 - f + f4 : ((n2 & 4) == 0 ? (f3 - f) / 2.0f + f4 : f4);
            if (bl) {
                actor.setBounds(Math.round(f2), Math.round(f6), Math.round(f8), Math.round(f));
            } else {
                actor.setBounds(f2, f6, f8, f);
            }
            f2 += f8 + f7;
            if (layout != null) {
                layout.validate();
            }
            n += n4;
        }
        return;
    }

    public HorizontalGroup left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public HorizontalGroup pad(float f) {
        this.padTop = f;
        this.padLeft = f;
        this.padBottom = f;
        this.padRight = f;
        return this;
    }

    public HorizontalGroup pad(float f, float f2, float f3, float f4) {
        this.padTop = f;
        this.padLeft = f2;
        this.padBottom = f3;
        this.padRight = f4;
        return this;
    }

    public HorizontalGroup padBottom(float f) {
        this.padBottom = f;
        return this;
    }

    public HorizontalGroup padLeft(float f) {
        this.padLeft = f;
        return this;
    }

    public HorizontalGroup padRight(float f) {
        this.padRight = f;
        return this;
    }

    public HorizontalGroup padTop(float f) {
        this.padTop = f;
        return this;
    }

    public HorizontalGroup reverse() {
        this.reverse = true;
        return this;
    }

    public HorizontalGroup reverse(boolean bl) {
        this.reverse = bl;
        return this;
    }

    public HorizontalGroup right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    public HorizontalGroup rowAlign(int n) {
        this.rowAlign = n;
        return this;
    }

    public HorizontalGroup rowBottom() {
        this.rowAlign |= 4;
        this.rowAlign &= 0xFFFFFFFD;
        return this;
    }

    public HorizontalGroup rowCenter() {
        this.rowAlign = 1;
        return this;
    }

    public HorizontalGroup rowLeft() {
        this.rowAlign |= 8;
        this.rowAlign &= 0xFFFFFFEF;
        return this;
    }

    public HorizontalGroup rowRight() {
        this.rowAlign |= 0x10;
        this.rowAlign &= 0xFFFFFFF7;
        return this;
    }

    public HorizontalGroup rowTop() {
        this.rowAlign |= 2;
        this.rowAlign &= 0xFFFFFFFB;
        return this;
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public HorizontalGroup space(float f) {
        this.space = f;
        return this;
    }

    public HorizontalGroup top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public HorizontalGroup wrap() {
        this.wrap = true;
        return this;
    }

    public HorizontalGroup wrap(boolean bl) {
        this.wrap = bl;
        return this;
    }

    public HorizontalGroup wrapSpace(float f) {
        this.wrapSpace = f;
        return this;
    }
}

