/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public abstract class EventAction<T extends Event>
extends Action {
    boolean active;
    final Class<? extends T> eventClass;
    private final EventListener listener = new EventListener(){

        @Override
        public boolean handle(Event event) {
            if (EventAction.this.active && ClassReflection.isInstance(EventAction.this.eventClass, event)) {
                EventAction eventAction = EventAction.this;
                eventAction.result = eventAction.handle(event);
                return EventAction.this.result;
            }
            return false;
        }
    };
    boolean result;

    public EventAction(Class<? extends T> clazz) {
        this.eventClass = clazz;
    }

    @Override
    public boolean act(float f) {
        this.active = true;
        return this.result;
    }

    public abstract boolean handle(T var1);

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void restart() {
        this.result = false;
        this.active = false;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public void setTarget(Actor actor) {
        if (this.target != null) {
            this.target.removeListener(this.listener);
        }
        super.setTarget(actor);
        if (actor != null) {
            actor.addListener(this.listener);
        }
    }
}

