/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Pool;

public abstract class DelegateAction
extends Action {
    protected Action action;

    @Override
    public final boolean act(float f) {
        Pool pool = this.getPool();
        this.setPool(null);
        try {
            boolean bl = this.delegate(f);
            return bl;
        }
        finally {
            this.setPool(pool);
        }
    }

    protected abstract boolean delegate(float var1);

    public Action getAction() {
        return this.action;
    }

    @Override
    public void reset() {
        super.reset();
        this.action = null;
    }

    @Override
    public void restart() {
        Action action = this.action;
        if (action != null) {
            action.restart();
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public void setActor(Actor actor) {
        Action action = this.action;
        if (action != null) {
            action.setActor(actor);
        }
        super.setActor(actor);
    }

    @Override
    public void setTarget(Actor actor) {
        Action action = this.action;
        if (action != null) {
            action.setTarget(actor);
        }
        super.setTarget(actor);
    }

    @Override
    public String toString() {
        CharSequence charSequence;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (this.action == null) {
            charSequence = "";
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("(");
            ((StringBuilder)charSequence).append(this.action);
            ((StringBuilder)charSequence).append(")");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        stringBuilder.append((String)charSequence);
        return stringBuilder.toString();
    }
}

