/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;
import java.util.List;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -1286036817192127343L;
    private static final Vector3 tmpVector = new Vector3();
    private final Vector3 cnt;
    private final Vector3 dim;
    public final Vector3 max;
    public final Vector3 min = new Vector3();

    public BoundingBox() {
        this.max = new Vector3();
        this.cnt = new Vector3();
        this.dim = new Vector3();
        this.clr();
    }

    public BoundingBox(Vector3 vector3, Vector3 vector32) {
        this.max = new Vector3();
        this.cnt = new Vector3();
        this.dim = new Vector3();
        this.set(vector3, vector32);
    }

    public BoundingBox(BoundingBox boundingBox) {
        this.max = new Vector3();
        this.cnt = new Vector3();
        this.dim = new Vector3();
        this.set(boundingBox);
    }

    static final float max(float f, float f2) {
        if (!(f > f2)) {
            f = f2;
        }
        return f;
    }

    static final float min(float f, float f2) {
        float f3 = f;
        if (f > f2) {
            f3 = f2;
        }
        return f3;
    }

    public BoundingBox clr() {
        return this.set(this.min.set(0.0f, 0.0f, 0.0f), this.max.set(0.0f, 0.0f, 0.0f));
    }

    public boolean contains(Vector3 vector3) {
        boolean bl = this.min.x <= vector3.x && this.max.x >= vector3.x && this.min.y <= vector3.y && this.max.y >= vector3.y && this.min.z <= vector3.z && this.max.z >= vector3.z;
        return bl;
    }

    public boolean contains(BoundingBox boundingBox) {
        boolean bl = !this.isValid() || this.min.x <= boundingBox.min.x && this.min.y <= boundingBox.min.y && this.min.z <= boundingBox.min.z && this.max.x >= boundingBox.max.x && this.max.y >= boundingBox.max.y && this.max.z >= boundingBox.max.z;
        return bl;
    }

    public BoundingBox ext(float f, float f2, float f3) {
        Vector3 vector3 = this.min;
        vector3 = vector3.set(BoundingBox.min(vector3.x, f), BoundingBox.min(this.min.y, f2), BoundingBox.min(this.min.z, f3));
        Vector3 vector32 = this.max;
        return this.set(vector3, vector32.set(BoundingBox.max(vector32.x, f), BoundingBox.max(this.max.y, f2), BoundingBox.max(this.max.z, f3)));
    }

    public BoundingBox ext(Vector3 vector3) {
        Vector3 vector32 = this.min;
        Vector3 vector33 = vector32.set(BoundingBox.min(vector32.x, vector3.x), BoundingBox.min(this.min.y, vector3.y), BoundingBox.min(this.min.z, vector3.z));
        vector32 = this.max;
        return this.set(vector33, vector32.set(Math.max(vector32.x, vector3.x), Math.max(this.max.y, vector3.y), Math.max(this.max.z, vector3.z)));
    }

    public BoundingBox ext(Vector3 vector3, float f) {
        Vector3 vector32 = this.min;
        Vector3 vector33 = vector32.set(BoundingBox.min(vector32.x, vector3.x - f), BoundingBox.min(this.min.y, vector3.y - f), BoundingBox.min(this.min.z, vector3.z - f));
        vector32 = this.max;
        return this.set(vector33, vector32.set(BoundingBox.max(vector32.x, vector3.x + f), BoundingBox.max(this.max.y, vector3.y + f), BoundingBox.max(this.max.z, vector3.z + f)));
    }

    public BoundingBox ext(BoundingBox boundingBox) {
        Vector3 vector3 = this.min;
        vector3 = vector3.set(BoundingBox.min(vector3.x, boundingBox.min.x), BoundingBox.min(this.min.y, boundingBox.min.y), BoundingBox.min(this.min.z, boundingBox.min.z));
        Vector3 vector32 = this.max;
        return this.set(vector3, vector32.set(BoundingBox.max(vector32.x, boundingBox.max.x), BoundingBox.max(this.max.y, boundingBox.max.y), BoundingBox.max(this.max.z, boundingBox.max.z)));
    }

    public BoundingBox ext(BoundingBox boundingBox, Matrix4 matrix4) {
        this.ext(tmpVector.set(boundingBox.min.x, boundingBox.min.y, boundingBox.min.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.min.x, boundingBox.min.y, boundingBox.max.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.min.x, boundingBox.max.y, boundingBox.min.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.min.x, boundingBox.max.y, boundingBox.max.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.max.x, boundingBox.min.y, boundingBox.min.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.max.x, boundingBox.min.y, boundingBox.max.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.max.x, boundingBox.max.y, boundingBox.min.z).mul(matrix4));
        this.ext(tmpVector.set(boundingBox.max.x, boundingBox.max.y, boundingBox.max.z).mul(matrix4));
        return this;
    }

    public Vector3 getCenter(Vector3 vector3) {
        return vector3.set(this.cnt);
    }

    public float getCenterX() {
        return this.cnt.x;
    }

    public float getCenterY() {
        return this.cnt.y;
    }

    public float getCenterZ() {
        return this.cnt.z;
    }

    public Vector3 getCorner000(Vector3 vector3) {
        return vector3.set(this.min.x, this.min.y, this.min.z);
    }

    public Vector3 getCorner001(Vector3 vector3) {
        return vector3.set(this.min.x, this.min.y, this.max.z);
    }

    public Vector3 getCorner010(Vector3 vector3) {
        return vector3.set(this.min.x, this.max.y, this.min.z);
    }

    public Vector3 getCorner011(Vector3 vector3) {
        return vector3.set(this.min.x, this.max.y, this.max.z);
    }

    public Vector3 getCorner100(Vector3 vector3) {
        return vector3.set(this.max.x, this.min.y, this.min.z);
    }

    public Vector3 getCorner101(Vector3 vector3) {
        return vector3.set(this.max.x, this.min.y, this.max.z);
    }

    public Vector3 getCorner110(Vector3 vector3) {
        return vector3.set(this.max.x, this.max.y, this.min.z);
    }

    public Vector3 getCorner111(Vector3 vector3) {
        return vector3.set(this.max.x, this.max.y, this.max.z);
    }

    public float getDepth() {
        return this.dim.z;
    }

    public Vector3 getDimensions(Vector3 vector3) {
        return vector3.set(this.dim);
    }

    public float getHeight() {
        return this.dim.y;
    }

    public Vector3 getMax(Vector3 vector3) {
        return vector3.set(this.max);
    }

    public Vector3 getMin(Vector3 vector3) {
        return vector3.set(this.min);
    }

    public float getWidth() {
        return this.dim.x;
    }

    public BoundingBox inf() {
        this.min.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.max.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.cnt.set(0.0f, 0.0f, 0.0f);
        this.dim.set(0.0f, 0.0f, 0.0f);
        return this;
    }

    public boolean intersects(BoundingBox boundingBox) {
        boolean bl = this.isValid();
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        float f = Math.abs(this.cnt.x - boundingBox.cnt.x);
        float f2 = this.dim.x / 2.0f;
        float f3 = boundingBox.dim.x / 2.0f;
        float f4 = Math.abs(this.cnt.y - boundingBox.cnt.y);
        float f5 = this.dim.y / 2.0f;
        float f6 = boundingBox.dim.y / 2.0f;
        float f7 = Math.abs(this.cnt.z - boundingBox.cnt.z);
        float f8 = this.dim.z / 2.0f;
        float f9 = boundingBox.dim.z / 2.0f;
        bl = bl2;
        if (f <= f2 + f3) {
            bl = bl2;
            if (f4 <= f5 + f6) {
                bl = bl2;
                if (f7 <= f8 + f9) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isValid() {
        boolean bl = this.min.x <= this.max.x && this.min.y <= this.max.y && this.min.z <= this.max.z;
        return bl;
    }

    public BoundingBox mul(Matrix4 matrix4) {
        float f = this.min.x;
        float f2 = this.min.y;
        float f3 = this.min.z;
        float f4 = this.max.x;
        float f5 = this.max.y;
        float f6 = this.max.z;
        this.inf();
        this.ext(tmpVector.set(f, f2, f3).mul(matrix4));
        this.ext(tmpVector.set(f, f2, f6).mul(matrix4));
        this.ext(tmpVector.set(f, f5, f3).mul(matrix4));
        this.ext(tmpVector.set(f, f5, f6).mul(matrix4));
        this.ext(tmpVector.set(f4, f2, f3).mul(matrix4));
        this.ext(tmpVector.set(f4, f2, f6).mul(matrix4));
        this.ext(tmpVector.set(f4, f5, f3).mul(matrix4));
        this.ext(tmpVector.set(f4, f5, f6).mul(matrix4));
        return this;
    }

    public BoundingBox set(Vector3 vector3, Vector3 vector32) {
        Vector3 vector33 = this.min;
        float f = vector3.x < vector32.x ? vector3.x : vector32.x;
        float f2 = vector3.y < vector32.y ? vector3.y : vector32.y;
        float f3 = vector3.z < vector32.z ? vector3.z : vector32.z;
        vector33.set(f, f2, f3);
        vector33 = this.max;
        f = vector3.x > vector32.x ? vector3.x : vector32.x;
        f2 = vector3.y > vector32.y ? vector3.y : vector32.y;
        f3 = vector3.z > vector32.z ? vector3.z : vector32.z;
        vector33.set(f, f2, f3);
        this.cnt.set(this.min).add(this.max).scl(0.5f);
        this.dim.set(this.max).sub(this.min);
        return this;
    }

    public BoundingBox set(BoundingBox boundingBox) {
        return this.set(boundingBox.min, boundingBox.max);
    }

    public BoundingBox set(List<Vector3> object) {
        this.inf();
        object = object.iterator();
        while (object.hasNext()) {
            this.ext((Vector3)object.next());
        }
        return this;
    }

    public BoundingBox set(Vector3[] vector3Array) {
        this.inf();
        int n = vector3Array.length;
        for (int i = 0; i < n; ++i) {
            this.ext(vector3Array[i]);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.min);
        stringBuilder.append("|");
        stringBuilder.append(this.max);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

