/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Rectangle
implements Shape2D,
Serializable {
    private static final long serialVersionUID = 5733252015138115702L;
    public static final Rectangle tmp = new Rectangle();
    public static final Rectangle tmp2 = new Rectangle();
    public float height;
    public float width;
    public float x;
    public float y;

    public Rectangle() {
    }

    public Rectangle(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public Rectangle(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public float area() {
        return this.width * this.height;
    }

    @Override
    public boolean contains(float f, float f2) {
        float f3 = this.x;
        boolean bl = f3 <= f && f3 + this.width >= f && (f = this.y) <= f2 && f + this.height >= f2;
        return bl;
    }

    public boolean contains(Circle circle) {
        boolean bl = circle.x - circle.radius >= this.x && circle.x + circle.radius <= this.x + this.width && circle.y - circle.radius >= this.y && circle.y + circle.radius <= this.y + this.height;
        return bl;
    }

    public boolean contains(Rectangle rectangle) {
        float f;
        float f2 = rectangle.x;
        float f3 = rectangle.width + f2;
        float f4 = rectangle.y;
        float f5 = rectangle.height + f4;
        float f6 = this.x;
        boolean bl = f2 > f6 && f2 < f6 + (f = this.width) && f3 > f6 && f3 < f6 + f && f4 > (f2 = this.y) && f4 < f2 + (f3 = this.height) && f5 > f2 && f5 < f2 + f3;
        return bl;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Rectangle)object;
        if (NumberUtils.floatToRawIntBits(this.height) != NumberUtils.floatToRawIntBits(((Rectangle)object).height)) {
            return false;
        }
        if (NumberUtils.floatToRawIntBits(this.width) != NumberUtils.floatToRawIntBits(((Rectangle)object).width)) {
            return false;
        }
        if (NumberUtils.floatToRawIntBits(this.x) != NumberUtils.floatToRawIntBits(((Rectangle)object).x)) {
            return false;
        }
        return NumberUtils.floatToRawIntBits(this.y) == NumberUtils.floatToRawIntBits(((Rectangle)object).y);
    }

    public Rectangle fitInside(Rectangle rectangle) {
        float f = this.getAspectRatio();
        if (f < rectangle.getAspectRatio()) {
            float f2 = rectangle.height;
            this.setSize(f * f2, f2);
        } else {
            float f3 = rectangle.width;
            this.setSize(f3, f3 / f);
        }
        this.setPosition(rectangle.x + rectangle.width / 2.0f - this.width / 2.0f, rectangle.y + rectangle.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public Rectangle fitOutside(Rectangle rectangle) {
        float f = this.getAspectRatio();
        if (f > rectangle.getAspectRatio()) {
            float f2 = rectangle.height;
            this.setSize(f * f2, f2);
        } else {
            float f3 = rectangle.width;
            this.setSize(f3, f3 / f);
        }
        this.setPosition(rectangle.x + rectangle.width / 2.0f - this.width / 2.0f, rectangle.y + rectangle.height / 2.0f - this.height / 2.0f);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rectangle fromString(String string2) {
        int n = string2.indexOf(44, 1);
        int n2 = n + 1;
        int n3 = string2.indexOf(44, n2);
        int n4 = n3 + 1;
        int n5 = string2.indexOf(44, n4);
        if (n != -1 && n3 != -1 && n5 != -1 && string2.charAt(0) == '[' && string2.charAt(string2.length() - 1) == ']') {
            try {
                return this.set(Float.parseFloat(string2.substring(1, n)), Float.parseFloat(string2.substring(n2, n3)), Float.parseFloat(string2.substring(n4, n5)), Float.parseFloat(string2.substring(n5 + 1, string2.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Malformed Rectangle: ");
        stringBuilder.append(string2);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public float getAspectRatio() {
        float f = this.height;
        f = f == 0.0f ? Float.NaN : this.width / f;
        return f;
    }

    public Vector2 getCenter(Vector2 vector2) {
        vector2.x = this.x + this.width / 2.0f;
        vector2.y = this.y + this.height / 2.0f;
        return vector2;
    }

    public float getHeight() {
        return this.height;
    }

    public Vector2 getPosition(Vector2 vector2) {
        return vector2.set(this.x, this.y);
    }

    public Vector2 getSize(Vector2 vector2) {
        return vector2.set(this.width, this.height);
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int hashCode() {
        return (((NumberUtils.floatToRawIntBits(this.height) + 31) * 31 + NumberUtils.floatToRawIntBits(this.width)) * 31 + NumberUtils.floatToRawIntBits(this.x)) * 31 + NumberUtils.floatToRawIntBits(this.y);
    }

    public Rectangle merge(float f, float f2) {
        float f3 = Math.min(this.x, f);
        f = Math.max(this.x + this.width, f);
        this.x = f3;
        this.width = f - f3;
        f = Math.min(this.y, f2);
        f2 = Math.max(this.y + this.height, f2);
        this.y = f;
        this.height = f2 - f;
        return this;
    }

    public Rectangle merge(Rectangle rectangle) {
        float f = Math.min(this.x, rectangle.x);
        float f2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        this.x = f;
        this.width = f2 - f;
        f2 = Math.min(this.y, rectangle.y);
        f = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        this.y = f2;
        this.height = f - f2;
        return this;
    }

    public Rectangle merge(Vector2 vector2) {
        return this.merge(vector2.x, vector2.y);
    }

    public Rectangle merge(Vector2[] vector2Array) {
        float f = this.x;
        float f2 = this.width + f;
        float f3 = this.y;
        float f4 = this.height + f3;
        for (int i = 0; i < vector2Array.length; ++i) {
            Vector2 vector2 = vector2Array[i];
            f = Math.min(f, vector2.x);
            f2 = Math.max(f2, vector2.x);
            f3 = Math.min(f3, vector2.y);
            f4 = Math.max(f4, vector2.y);
        }
        this.x = f;
        this.width = f2 - f;
        this.y = f3;
        this.height = f4 - f3;
        return this;
    }

    public boolean overlaps(Rectangle rectangle) {
        float f = this.x;
        float f2 = rectangle.x;
        boolean bl = f < rectangle.width + f2 && f + this.width > f2 && (f = this.y) < rectangle.height + (f2 = rectangle.y) && f + this.height > f2;
        return bl;
    }

    public float perimeter() {
        return (this.width + this.height) * 2.0f;
    }

    public Rectangle set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        return this;
    }

    public Rectangle set(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        return this;
    }

    public Rectangle setCenter(float f, float f2) {
        this.setPosition(f - this.width / 2.0f, f2 - this.height / 2.0f);
        return this;
    }

    public Rectangle setCenter(Vector2 vector2) {
        this.setPosition(vector2.x - this.width / 2.0f, vector2.y - this.height / 2.0f);
        return this;
    }

    public Rectangle setHeight(float f) {
        this.height = f;
        return this;
    }

    public Rectangle setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Rectangle setPosition(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
        return this;
    }

    public Rectangle setSize(float f) {
        this.width = f;
        this.height = f;
        return this;
    }

    public Rectangle setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        return this;
    }

    public Rectangle setWidth(float f) {
        this.width = f;
        return this;
    }

    public Rectangle setX(float f) {
        this.x = f;
        return this;
    }

    public Rectangle setY(float f) {
        this.y = f;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.x);
        stringBuilder.append(",");
        stringBuilder.append(this.y);
        stringBuilder.append(",");
        stringBuilder.append(this.width);
        stringBuilder.append(",");
        stringBuilder.append(this.height);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

