/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import java.util.Arrays;
import java.util.List;

public final class Intersector {
    static Vector3 best;
    private static final Vector3 dir;
    private static final Vector2 e;
    private static final Vector2 ep1;
    private static final Vector2 ep2;
    private static final FloatArray floatArray;
    private static final FloatArray floatArray2;
    private static final Vector3 i;
    static Vector3 intersection;
    private static final Vector2 ip;
    private static final Plane p;
    private static final Vector2 s;
    private static final Vector3 start;
    static Vector3 tmp;
    static Vector3 tmp1;
    static Vector3 tmp2;
    static Vector3 tmp3;
    private static final Vector3 v0;
    private static final Vector3 v1;
    private static final Vector3 v2;
    static Vector2 v2tmp;

    static {
        v0 = new Vector3();
        v1 = new Vector3();
        v2 = new Vector3();
        floatArray = new FloatArray();
        floatArray2 = new FloatArray();
        ip = new Vector2();
        ep1 = new Vector2();
        ep2 = new Vector2();
        s = new Vector2();
        e = new Vector2();
        p = new Plane(new Vector3(), 0.0f);
        i = new Vector3();
        dir = new Vector3();
        start = new Vector3();
        best = new Vector3();
        tmp = new Vector3();
        tmp1 = new Vector3();
        tmp2 = new Vector3();
        tmp3 = new Vector3();
        v2tmp = new Vector2();
        intersection = new Vector3();
    }

    static float det(float f, float f2, float f3, float f4) {
        return f * f4 - f2 * f3;
    }

    static double detd(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public static float distanceLinePoint(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (float)Math.sqrt((f3 -= f) * f3 + (f4 -= f2) * f4);
        return Math.abs((f5 - f) * f4 - (f6 - f2) * f3) / f7;
    }

    public static float distanceSegmentPoint(float f, float f2, float f3, float f4, float f5, float f6) {
        return Intersector.nearestSegmentPoint(f, f2, f3, f4, f5, f6, v2tmp).dst(f5, f6);
    }

    public static float distanceSegmentPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Intersector.nearestSegmentPoint(vector2, vector22, vector23, v2tmp).dst(vector23);
    }

    public static float intersectLinePlane(float f, float f2, float f3, float f4, float f5, float f6, Plane plane, Vector3 vector3) {
        Vector3 vector32 = tmp.set(f4, f5, f6).sub(f, f2, f3);
        Vector3 vector33 = tmp2.set(f, f2, f3);
        f = vector32.dot(plane.getNormal());
        if (f != 0.0f) {
            f = -(vector33.dot(plane.getNormal()) + plane.getD()) / f;
            if (vector3 != null) {
                vector3.set(vector33).add(vector32.scl(f));
            }
            return f;
        }
        if (plane.testPoint(vector33) == Plane.PlaneSide.OnPlane) {
            if (vector3 != null) {
                vector3.set(vector33);
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public static boolean intersectLinePolygon(Vector2 vector2, Vector2 vector22, Polygon object) {
        object = ((Polygon)object).getTransformedVertices();
        float f = vector2.x;
        float f2 = vector2.y;
        float f3 = vector22.x;
        float f4 = vector22.y;
        int n = ((Object)object).length;
        reference var8_8 = object[n - 2];
        Object object2 = object[n - 1];
        for (int i = 0; i < n; i += 2) {
            Object object3 = object[i + 1];
            reference var13_13 = object3 - object2;
            Object object4 = object[i];
            reference var14_14 = object4 - var8_8;
            float f5 = (f3 - f) * var13_13 - (f4 - f2) * var14_14;
            if (f5 != 0.0f && (var8_8 = (var14_14 * (f2 - object2) - var13_13 * (f - var8_8)) / f5) >= 0.0f && var8_8 <= 1.0f) {
                return true;
            }
            var8_8 = object4;
            object2 = object3;
        }
        return false;
    }

    public static boolean intersectLines(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector2 vector2) {
        float f9 = (f8 -= f6) * (f3 -= f) - (f7 -= f5) * (f4 -= f2);
        if (f9 == 0.0f) {
            return false;
        }
        if (vector2 != null) {
            f5 = (f7 * (f2 - f6) - f8 * (f - f5)) / f9;
            vector2.set(f + f3 * f5, f2 + f4 * f5);
        }
        return true;
    }

    public static boolean intersectLines(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        float f = vector2.x;
        float f2 = vector2.y;
        float f3 = vector22.x;
        float f4 = vector22.y;
        float f5 = vector23.x;
        float f6 = vector23.y;
        float f7 = vector24.x;
        float f8 = vector24.y - f6;
        float f9 = f8 * (f3 -= f) - (f7 -= f5) * (f4 -= f2);
        if (f9 == 0.0f) {
            return false;
        }
        if (vector25 != null) {
            f6 = (f7 * (f2 - f6) - f8 * (f - f5)) / f9;
            vector25.set(f + f3 * f6, f2 + f4 * f6);
        }
        return true;
    }

    public static boolean intersectPolygonEdges(FloatArray object, FloatArray object2) {
        int n = ((FloatArray)object).size - 2;
        int n2 = ((FloatArray)object2).size - 2;
        object = ((FloatArray)object).items;
        object2 = ((FloatArray)object2).items;
        Object object3 = object[n];
        Object object4 = object[n + 1];
        for (int i = 0; i <= n; i += 2) {
            Object object5 = object[i];
            Object object6 = object[i + 1];
            Object object7 = object2[n2];
            Object object8 = object2[n2 + 1];
            for (int j = 0; j <= n2; j += 2) {
                Object object9 = object2[j];
                Object object10 = object2[j + 1];
                if (Intersector.intersectSegments((float)object3, (float)object4, (float)object5, (float)object6, (float)object7, (float)object8, (float)object9, (float)object10, null)) {
                    return true;
                }
                object7 = object9;
                object8 = object10;
            }
            object3 = object5;
            object4 = object6;
        }
        return false;
    }

    public static boolean intersectPolygons(Polygon object, Polygon polygon, Polygon polygon2) {
        if (((Polygon)object).getVertices().length != 0 && polygon.getVertices().length != 0) {
            Vector2 vector2 = ip;
            Vector2 vector22 = ep1;
            Vector2 vector23 = ep2;
            Vector2 vector24 = s;
            Vector2 vector25 = e;
            FloatArray floatArray = Intersector.floatArray;
            FloatArray floatArray2 = Intersector.floatArray2;
            floatArray.clear();
            floatArray2.clear();
            floatArray2.addAll(((Polygon)object).getTransformedVertices());
            object = polygon.getTransformedVertices();
            int n = ((Object)object).length - 2;
            for (int i = 0; i <= n; i += 2) {
                vector22.set((float)object[i], (float)object[i + 1]);
                if (i < n) {
                    vector23.set((float)object[i + 2], (float)object[i + 3]);
                } else {
                    vector23.set((float)object[0], (float)object[1]);
                }
                if (floatArray2.size == 0) {
                    return false;
                }
                vector24.set(floatArray2.get(floatArray2.size - 2), floatArray2.get(floatArray2.size - 1));
                for (int j = 0; j < floatArray2.size; j += 2) {
                    vector25.set(floatArray2.get(j), floatArray2.get(j + 1));
                    boolean bl = Intersector.pointLineSide(vector23, vector22, vector24) > 0;
                    if (Intersector.pointLineSide(vector23, vector22, vector25) > 0) {
                        if (!bl) {
                            Intersector.intersectLines(vector24, vector25, vector22, vector23, vector2);
                            if (floatArray.size < 2 || floatArray.get(floatArray.size - 2) != vector2.x || floatArray.get(floatArray.size - 1) != vector2.y) {
                                floatArray.add(vector2.x);
                                floatArray.add(vector2.y);
                            }
                        }
                        floatArray.add(vector25.x);
                        floatArray.add(vector25.y);
                    } else if (bl) {
                        Intersector.intersectLines(vector24, vector25, vector22, vector23, vector2);
                        floatArray.add(vector2.x);
                        floatArray.add(vector2.y);
                    }
                    vector24.set(vector25.x, vector25.y);
                }
                floatArray2.clear();
                floatArray2.addAll(floatArray);
                floatArray.clear();
            }
            if (floatArray2.size != 0) {
                if (polygon2 != null) {
                    if (polygon2.getVertices().length == floatArray2.size) {
                        System.arraycopy(floatArray2.items, 0, polygon2.getVertices(), 0, floatArray2.size);
                    } else {
                        polygon2.setVertices(floatArray2.toArray());
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean intersectPolygons(FloatArray floatArray, FloatArray floatArray2) {
        if (Intersector.isPointInPolygon(floatArray.items, 0, floatArray.size, floatArray2.items[0], floatArray2.items[1])) {
            return true;
        }
        if (Intersector.isPointInPolygon(floatArray2.items, 0, floatArray2.size, floatArray.items[0], floatArray.items[1])) {
            return true;
        }
        return Intersector.intersectPolygonEdges(floatArray, floatArray2);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean intersectRayBounds(Ray var0, BoundingBox var1_1, Vector3 var2_2) {
        block37: {
            block38: {
                block35: {
                    block36: {
                        block33: {
                            block34: {
                                block31: {
                                    block32: {
                                        block29: {
                                            block30: {
                                                if (var1_1.contains(var0.origin)) {
                                                    if (var2_2 != null) {
                                                        var2_2.set(var0.origin);
                                                    }
                                                    return true;
                                                }
                                                var3_3 = false;
                                                if (!(var0.origin.x <= var1_1.min.x) || !(var0.direction.x > 0.0f) || !((var4_4 = (var1_1.min.x - var0.origin.x) / var0.direction.x) >= 0.0f)) ** GOTO lbl-1000
                                                Intersector.v2.set(var0.direction).scl(var4_4).add(var0.origin);
                                                if (Intersector.v2.y >= var1_1.min.y && Intersector.v2.y <= var1_1.max.y && Intersector.v2.z >= var1_1.min.z && Intersector.v2.z <= var1_1.max.z) {
                                                    var3_3 = true;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    var4_4 = 0.0f;
                                                }
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(var0.origin.x >= var1_1.max.x)) break block29;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(var0.direction.x < 0.0f)) break block29;
                                                var7_7 = (var1_1.max.x - var0.origin.x) / var0.direction.x;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(var7_7 >= 0.0f)) break block29;
                                                Intersector.v2.set(var0.direction).scl(var7_7).add(var0.origin);
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(Intersector.v2.y >= var1_1.min.y)) break block29;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(Intersector.v2.y <= var1_1.max.y)) break block29;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(Intersector.v2.z >= var1_1.min.z)) break block29;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(Intersector.v2.z <= var1_1.max.z)) break block29;
                                                if (!var3_3) break block30;
                                                var5_5 = var3_3;
                                                var6_6 = var4_4;
                                                if (!(var7_7 < var4_4)) break block29;
                                            }
                                            var6_6 = var7_7;
                                            var5_5 = true;
                                        }
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(var0.origin.y <= var1_1.min.y)) break block31;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(var0.direction.y > 0.0f)) break block31;
                                        var7_7 = (var1_1.min.y - var0.origin.y) / var0.direction.y;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(var7_7 >= 0.0f)) break block31;
                                        Intersector.v2.set(var0.direction).scl(var7_7).add(var0.origin);
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(Intersector.v2.x >= var1_1.min.x)) break block31;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(Intersector.v2.x <= var1_1.max.x)) break block31;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(Intersector.v2.z >= var1_1.min.z)) break block31;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(Intersector.v2.z <= var1_1.max.z)) break block31;
                                        if (!var5_5) break block32;
                                        var3_3 = var5_5;
                                        var4_4 = var6_6;
                                        if (!(var7_7 < var6_6)) break block31;
                                    }
                                    var4_4 = var7_7;
                                    var3_3 = true;
                                }
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(var0.origin.y >= var1_1.max.y)) break block33;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(var0.direction.y < 0.0f)) break block33;
                                var6_6 = (var1_1.max.y - var0.origin.y) / var0.direction.y;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(var6_6 >= 0.0f)) break block33;
                                Intersector.v2.set(var0.direction).scl(var6_6).add(var0.origin);
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(Intersector.v2.x >= var1_1.min.x)) break block33;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(Intersector.v2.x <= var1_1.max.x)) break block33;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(Intersector.v2.z >= var1_1.min.z)) break block33;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(Intersector.v2.z <= var1_1.max.z)) break block33;
                                if (!var3_3) break block34;
                                var5_5 = var3_3;
                                var7_7 = var4_4;
                                if (!(var6_6 < var4_4)) break block33;
                            }
                            var7_7 = var6_6;
                            var5_5 = true;
                        }
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(var0.origin.z <= var1_1.min.z)) break block35;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(var0.direction.z > 0.0f)) break block35;
                        var4_4 = (var1_1.min.z - var0.origin.z) / var0.direction.z;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(var4_4 >= 0.0f)) break block35;
                        Intersector.v2.set(var0.direction).scl(var4_4).add(var0.origin);
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(Intersector.v2.x >= var1_1.min.x)) break block35;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(Intersector.v2.x <= var1_1.max.x)) break block35;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(Intersector.v2.y >= var1_1.min.y)) break block35;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(Intersector.v2.y <= var1_1.max.y)) break block35;
                        if (!var5_5) break block36;
                        var3_3 = var5_5;
                        var6_6 = var7_7;
                        if (!(var4_4 < var7_7)) break block35;
                    }
                    var6_6 = var4_4;
                    var3_3 = true;
                }
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(var0.origin.z >= var1_1.max.z)) break block37;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(var0.direction.z < 0.0f)) break block37;
                var7_7 = (var1_1.max.z - var0.origin.z) / var0.direction.z;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(var7_7 >= 0.0f)) break block37;
                Intersector.v2.set(var0.direction).scl(var7_7).add(var0.origin);
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(Intersector.v2.x >= var1_1.min.x)) break block37;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(Intersector.v2.x <= var1_1.max.x)) break block37;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(Intersector.v2.y >= var1_1.min.y)) break block37;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(Intersector.v2.y <= var1_1.max.y)) break block37;
                if (!var3_3) break block38;
                var5_5 = var3_3;
                var4_4 = var6_6;
                if (!(var7_7 < var6_6)) break block37;
            }
            var4_4 = var7_7;
            var5_5 = true;
        }
        if (var5_5 && var2_2 != null) {
            var2_2.set(var0.direction).scl(var4_4).add(var0.origin);
            if (var2_2.x < var1_1.min.x) {
                var2_2.x = var1_1.min.x;
            } else if (var2_2.x > var1_1.max.x) {
                var2_2.x = var1_1.max.x;
            }
            if (var2_2.y < var1_1.min.y) {
                var2_2.y = var1_1.min.y;
            } else if (var2_2.y > var1_1.max.y) {
                var2_2.y = var1_1.max.y;
            }
            if (var2_2.z < var1_1.min.z) {
                var2_2.z = var1_1.min.z;
            } else if (var2_2.z > var1_1.max.z) {
                var2_2.z = var1_1.max.z;
            }
        }
        return var5_5;
    }

    public static boolean intersectRayBoundsFast(Ray ray, Vector3 vector3, Vector3 vector32) {
        float f;
        float f2;
        float f3;
        float f4 = 1.0f / ray.direction.x;
        float f5 = 1.0f / ray.direction.y;
        float f6 = 1.0f / ray.direction.z;
        float f7 = (vector3.x - vector32.x * 0.5f - ray.origin.x) * f4;
        if (!(f7 > (f4 *= vector3.x + vector32.x * 0.5f - ray.origin.x))) {
            f3 = f7;
            f7 = f4;
            f4 = f3;
        }
        f3 = (vector3.y - vector32.y * 0.5f - ray.origin.y) * f5;
        if (!(f3 > (f5 *= vector3.y + vector32.y * 0.5f - ray.origin.y))) {
            f2 = f3;
            f3 = f5;
            f5 = f2;
        }
        f2 = (vector3.z - vector32.z * 0.5f - ray.origin.z) * f6;
        f6 = (vector3.z + vector32.z * 0.5f - ray.origin.z) * f6;
        if (f2 > f6) {
            f = f6;
        } else {
            f = f2;
            f2 = f6;
        }
        f4 = Math.max(Math.max(f4, f5), f);
        f7 = Math.min(Math.min(f7, f3), f2);
        boolean bl = f7 >= 0.0f && f7 >= f4;
        return bl;
    }

    public static boolean intersectRayBoundsFast(Ray ray, BoundingBox boundingBox) {
        return Intersector.intersectRayBoundsFast(ray, boundingBox.getCenter(tmp1), boundingBox.getDimensions(tmp2));
    }

    public static boolean intersectRayPlane(Ray ray, Plane plane, Vector3 vector3) {
        float f = ray.direction.dot(plane.getNormal());
        if (f != 0.0f) {
            f = -(ray.origin.dot(plane.getNormal()) + plane.getD()) / f;
            if (f < 0.0f) {
                return false;
            }
            if (vector3 != null) {
                vector3.set(ray.origin).add(v0.set(ray.direction).scl(f));
            }
            return true;
        }
        if (plane.testPoint(ray.origin) == Plane.PlaneSide.OnPlane) {
            if (vector3 != null) {
                vector3.set(ray.origin);
            }
            return true;
        }
        return false;
    }

    public static float intersectRayRay(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        float f = vector23.x;
        float f2 = vector2.x;
        float f3 = vector23.y;
        float f4 = vector2.y;
        float f5 = vector22.x * vector24.y - vector22.y * vector24.x;
        if (f5 == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float f6 = vector24.x / f5;
        return (f - f2) * (vector24.y / f5) - (f3 - f4) * f6;
    }

    public static boolean intersectRaySphere(Ray ray, Vector3 vector3, float f, Vector3 vector32) {
        float f2 = ray.direction.dot(vector3.x - ray.origin.x, vector3.y - ray.origin.y, vector3.z - ray.origin.z);
        if (f2 < 0.0f) {
            return false;
        }
        float f3 = vector3.dst2(ray.origin.x + ray.direction.x * f2, ray.origin.y + ray.direction.y * f2, ray.origin.z + ray.direction.z * f2);
        if (f3 > (f *= f)) {
            return false;
        }
        if (vector32 != null) {
            vector32.set(ray.direction).scl(f2 - (float)Math.sqrt(f - f3)).add(ray.origin);
        }
        return true;
    }

    public static boolean intersectRayTriangle(Ray ray, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        float f;
        Vector3 vector35 = v0.set(vector32).sub(vector3);
        Vector3 vector36 = v1.set(vector33).sub(vector3);
        Vector3 vector37 = v2.set(ray.direction).crs(vector36);
        float f2 = vector35.dot(vector37);
        if (MathUtils.isZero(f2)) {
            p.set(vector3, vector32, vector33);
            if (p.testPoint(ray.origin) == Plane.PlaneSide.OnPlane && Intersector.isPointInTriangle(ray.origin, vector3, vector32, vector33)) {
                if (vector34 != null) {
                    vector34.set(ray.origin);
                }
                return true;
            }
            return false;
        }
        float f3 = 1.0f / f2;
        vector3 = i.set(ray.origin).sub(vector3);
        f2 = vector3.dot(vector37) * f3;
        if (!(f2 < 0.0f || f2 > 1.0f || (f = ray.direction.dot(vector3 = vector3.crs(vector35)) * f3) < 0.0f || f2 + f > 1.0f)) {
            f2 = vector36.dot(vector3) * f3;
            if (f2 < 0.0f) {
                return false;
            }
            if (vector34 != null) {
                if (f2 <= 1.0E-6f) {
                    vector34.set(ray.origin);
                } else {
                    ray.getEndPoint(vector34, f2);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean intersectRayTriangles(Ray serializable, List<Vector3> list, Vector3 vector3) {
        if (list.size() % 3 == 0) {
            boolean bl = false;
            float f = Float.MAX_VALUE;
            for (int i = 0; i < list.size(); i += 3) {
                boolean bl2 = bl;
                float f2 = f;
                if (Intersector.intersectRayTriangle(serializable, list.get(i), list.get(i + 1), list.get(i + 2), tmp)) {
                    float f3 = serializable.origin.dst2(tmp);
                    bl2 = bl;
                    f2 = f;
                    if (f3 < f) {
                        best.set(tmp);
                        f2 = f3;
                        bl2 = true;
                    }
                }
                bl = bl2;
                f = f2;
            }
            if (!bl) {
                return false;
            }
            if (vector3 != null) {
                vector3.set(best);
            }
            return true;
        }
        serializable = new RuntimeException("triangle list size is not a multiple of 3");
        throw serializable;
    }

    public static boolean intersectRayTriangles(Ray serializable, float[] fArray, Vector3 vector3) {
        if (fArray.length % 9 == 0) {
            boolean bl = false;
            float f = Float.MAX_VALUE;
            for (int i = 0; i < fArray.length; i += 9) {
                boolean bl2 = bl;
                float f2 = f;
                if (Intersector.intersectRayTriangle(serializable, tmp1.set(fArray[i], fArray[i + 1], fArray[i + 2]), tmp2.set(fArray[i + 3], fArray[i + 4], fArray[i + 5]), tmp3.set(fArray[i + 6], fArray[i + 7], fArray[i + 8]), tmp)) {
                    float f3 = serializable.origin.dst2(tmp);
                    bl2 = bl;
                    f2 = f;
                    if (f3 < f) {
                        best.set(tmp);
                        f2 = f3;
                        bl2 = true;
                    }
                }
                bl = bl2;
                f = f2;
            }
            if (!bl) {
                return false;
            }
            if (vector3 != null) {
                vector3.set(best);
            }
            return true;
        }
        serializable = new RuntimeException("triangles array size is not a multiple of 9");
        throw serializable;
    }

    public static boolean intersectRayTriangles(Ray serializable, float[] fArray, short[] sArray, int n, Vector3 vector3) {
        if (sArray.length % 3 == 0) {
            boolean bl = false;
            float f = Float.MAX_VALUE;
            for (int i = 0; i < sArray.length; i += 3) {
                int n2 = sArray[i] * n;
                int n3 = sArray[i + 1] * n;
                int n4 = sArray[i + 2] * n;
                boolean bl2 = bl;
                float f2 = f;
                if (Intersector.intersectRayTriangle(serializable, tmp1.set(fArray[n2], fArray[n2 + 1], fArray[n2 + 2]), tmp2.set(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]), tmp3.set(fArray[n4], fArray[n4 + 1], fArray[n4 + 2]), tmp)) {
                    float f3 = serializable.origin.dst2(tmp);
                    bl2 = bl;
                    f2 = f;
                    if (f3 < f) {
                        best.set(tmp);
                        f2 = f3;
                        bl2 = true;
                    }
                }
                bl = bl2;
                f = f2;
            }
            if (!bl) {
                return false;
            }
            if (vector3 != null) {
                vector3.set(best);
            }
            return true;
        }
        serializable = new RuntimeException("triangle list size is not a multiple of 3");
        throw serializable;
    }

    public static boolean intersectRectangles(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (rectangle.overlaps(rectangle2)) {
            rectangle3.x = Math.max(rectangle.x, rectangle2.x);
            rectangle3.width = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - rectangle3.x;
            rectangle3.y = Math.max(rectangle.y, rectangle2.y);
            rectangle3.height = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - rectangle3.y;
            return true;
        }
        return false;
    }

    public static boolean intersectSegmentCircle(Vector2 vector2, Vector2 vector22, Vector2 vector23, float f) {
        tmp.set(vector22.x - vector2.x, vector22.y - vector2.y, 0.0f);
        tmp1.set(vector23.x - vector2.x, vector23.y - vector2.y, 0.0f);
        float f2 = tmp.len();
        float f3 = tmp1.dot(tmp.nor());
        if (f3 <= 0.0f) {
            tmp2.set(vector2.x, vector2.y, 0.0f);
        } else if (f3 >= f2) {
            tmp2.set(vector22.x, vector22.y, 0.0f);
        } else {
            tmp3.set(tmp.scl(f3));
            tmp2.set(Intersector.tmp3.x + vector2.x, Intersector.tmp3.y + vector2.y, 0.0f);
        }
        f2 = vector23.x - Intersector.tmp2.x;
        f3 = vector23.y - Intersector.tmp2.y;
        boolean bl = f2 * f2 + f3 * f3 <= f;
        return bl;
    }

    public static float intersectSegmentCircleDisplace(Vector2 vector2, Vector2 vector22, Vector2 vector23, float f, Vector2 vector24) {
        float f2 = vector23.x;
        float f3 = vector2.x;
        float f4 = vector22.x;
        float f5 = vector2.x;
        float f6 = vector23.y;
        float f7 = vector2.y;
        float f8 = vector22.y;
        float f9 = vector2.y;
        float f10 = vector2.dst(vector22);
        if (!((f10 = ((f2 - f3) * (f4 - f5) + (f6 - f7) * (f8 - f9)) / (f10 * f10)) < 0.0f) && !(f10 > 1.0f)) {
            tmp.set(vector22.x, vector22.y, 0.0f).sub(vector2.x, vector2.y, 0.0f);
            tmp2.set(vector2.x, vector2.y, 0.0f).add(tmp.scl(f10));
            f10 = tmp2.dst(vector23.x, vector23.y, 0.0f);
            if (f10 < f) {
                vector24.set(vector23).sub(Intersector.tmp2.x, Intersector.tmp2.y).nor();
                return f10;
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    public static boolean intersectSegmentPlane(Vector3 vector3, Vector3 vector32, Plane plane, Vector3 vector33) {
        float f = (vector32 = v0.set(vector32).sub(vector3)).dot(plane.getNormal());
        if (f == 0.0f) {
            return false;
        }
        f = -(vector3.dot(plane.getNormal()) + plane.getD()) / f;
        if (!(f < 0.0f) && !(f > 1.0f)) {
            vector33.set(vector3).add(vector32.scl(f));
            return true;
        }
        return false;
    }

    public static boolean intersectSegmentPolygon(Vector2 vector2, Vector2 vector22, Polygon object) {
        object = ((Polygon)object).getTransformedVertices();
        float f = vector2.x;
        float f2 = vector2.y;
        float f3 = vector22.x;
        float f4 = vector22.y;
        int n = ((Object)object).length;
        Object object2 = object[n - 2];
        Object object3 = object[n - 1];
        for (int i = 0; i < n; i += 2) {
            Object object4 = object[i + 1];
            reference var13_13 = object4 - object3;
            float f5 = f3 - f;
            Object object5 = object[i];
            reference var15_15 = object5 - object2;
            float f6 = f4 - f2;
            reference var17_17 = var13_13 * f5 - var15_15 * f6;
            if (var17_17 != 0.0f && (var13_13 = (var15_15 * (object3 = (Object)(f2 - object3)) - var13_13 * (object2 = (Object)(f - object2))) / var17_17) >= 0.0f && var13_13 <= 1.0f && (object2 = (Object)((f5 * object3 - f6 * object2) / var17_17)) >= 0.0f && object2 <= 1.0f) {
                return true;
            }
            object2 = object5;
            object3 = object4;
        }
        return false;
    }

    public static boolean intersectSegmentRectangle(float f, float f2, float f3, float f4, Rectangle rectangle) {
        float f5 = rectangle.x + rectangle.width;
        float f6 = rectangle.y + rectangle.height;
        if (Intersector.intersectSegments(f, f2, f3, f4, rectangle.x, rectangle.y, rectangle.x, f6, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f, f2, f3, f4, rectangle.x, rectangle.y, f5, rectangle.y, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f, f2, f3, f4, f5, rectangle.y, f5, f6, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f, f2, f3, f4, rectangle.x, f6, f5, f6, null)) {
            return true;
        }
        return rectangle.contains(f, f2);
    }

    public static boolean intersectSegmentRectangle(Vector2 vector2, Vector2 vector22, Rectangle rectangle) {
        return Intersector.intersectSegmentRectangle(vector2.x, vector2.y, vector22.x, vector22.y, rectangle);
    }

    public static boolean intersectSegments(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector2 vector2) {
        float f9 = (f8 -= f6) * (f3 -= f) - (f7 -= f5) * (f4 -= f2);
        if (f9 == 0.0f) {
            return false;
        }
        if (!((f7 = (f7 * (f6 = f2 - f6) - f8 * (f5 = f - f5)) / f9) < 0.0f || f7 > 1.0f || (f5 = (f6 * f3 - f5 * f4) / f9) < 0.0f || f5 > 1.0f)) {
            if (vector2 != null) {
                vector2.set(f + f3 * f7, f2 + f4 * f7);
            }
            return true;
        }
        return false;
    }

    public static boolean intersectSegments(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        float f = vector2.x;
        float f2 = vector2.y;
        float f3 = vector22.x;
        float f4 = vector22.y;
        float f5 = vector23.x;
        float f6 = vector23.y;
        float f7 = vector24.x;
        float f8 = vector24.y - f6;
        float f9 = f7 - f5;
        if ((f7 = f8 * (f3 -= f) - f9 * (f4 -= f2)) == 0.0f) {
            return false;
        }
        if (!((f8 = (f9 * (f6 = f2 - f6) - f8 * (f5 = f - f5)) / f7) < 0.0f || f8 > 1.0f || (f5 = (f6 * f3 - f5 * f4) / f7) < 0.0f || f5 > 1.0f)) {
            if (vector25 != null) {
                vector25.set(f + f3 * f8, f2 + f4 * f8);
            }
            return true;
        }
        return false;
    }

    public static boolean isPointInPolygon(Array<Vector2> array, Vector2 vector2) {
        Vector2 vector22 = array.peek();
        float f = vector2.x;
        float f2 = vector2.y;
        vector2 = vector22;
        boolean bl = false;
        for (int i = 0; i < array.size; ++i) {
            boolean bl2;
            block6: {
                block5: {
                    vector22 = array.get(i);
                    if (vector22.y < f2 && vector2.y >= f2) break block5;
                    bl2 = bl;
                    if (!(vector2.y < f2)) break block6;
                    bl2 = bl;
                    if (!(vector22.y >= f2)) break block6;
                }
                bl2 = bl;
                if (vector22.x + (f2 - vector22.y) / (vector2.y - vector22.y) * (vector2.x - vector22.x) < f) {
                    bl2 = bl ^ true;
                }
            }
            vector2 = vector22;
            bl = bl2;
        }
        return bl;
    }

    public static boolean isPointInPolygon(float[] fArray, int n, int n2, float f, float f2) {
        boolean bl;
        block12: {
            int n3;
            boolean bl2;
            float f3;
            float f4;
            float f5;
            block11: {
                f5 = fArray[n];
                f4 = fArray[n + 1];
                f3 = f4;
                bl2 = false;
                for (n3 = n + 3; n3 < n + n2; n3 += 2) {
                    float f6;
                    block10: {
                        block9: {
                            f6 = fArray[n3];
                            if (f6 < f2 && f3 >= f2) break block9;
                            bl = bl2;
                            if (!(f3 < f2)) break block10;
                            bl = bl2;
                            if (!(f6 >= f2)) break block10;
                        }
                        float f7 = fArray[n3 - 1];
                        bl = bl2;
                        if (f7 + (f2 - f6) / (f3 - f6) * (fArray[n3 - 3] - f7) < f) {
                            bl = bl2 ^ true;
                        }
                    }
                    f3 = f6;
                    bl2 = bl;
                }
                if (f4 < f2 && f3 >= f2) break block11;
                bl = bl2;
                if (!(f3 < f2)) break block12;
                bl = bl2;
                if (!(f4 >= f2)) break block12;
            }
            bl = bl2;
            if (f5 + (f2 - f4) / (f3 - f4) * (fArray[n3 - 3] - f5) < f) {
                bl = bl2 ^ true;
            }
        }
        return bl;
    }

    public static boolean isPointInTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        boolean bl;
        float f9;
        float f10;
        boolean bl2 = (f7 - f3) * f10 - (f8 - f4) * f9 > 0.0f;
        if (bl2 == (bl = (f5 - f3) * (f10 = f2 - f4) - (f6 - f4) * (f9 = f - f3) > 0.0f)) {
            return false;
        }
        bl2 = (f7 - f5) * (f2 - f6) - (f8 - f6) * (f - f5) > 0.0f;
        return bl2 == bl;
    }

    public static boolean isPointInTriangle(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        boolean bl;
        float f;
        float f2;
        boolean bl2 = (vector24.x - vector22.x) * f2 - (vector24.y - vector22.y) * f > 0.0f;
        if (bl2 == (bl = (vector23.x - vector22.x) * (f2 = vector2.y - vector22.y) - (vector23.y - vector22.y) * (f = vector2.x - vector22.x) > 0.0f)) {
            return false;
        }
        bl2 = (vector24.x - vector23.x) * (vector2.y - vector23.y) - (vector24.y - vector23.y) * (vector2.x - vector23.x) > 0.0f;
        return bl2 == bl;
    }

    public static boolean isPointInTriangle(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        v0.set(vector32).sub(vector3);
        v1.set(vector33).sub(vector3);
        v2.set(vector34).sub(vector3);
        float f = v0.dot(v1);
        float f2 = v0.dot(v2);
        float f3 = v1.dot(v2);
        vector3 = v2;
        if (f3 * f2 - vector3.dot(vector3) * f < 0.0f) {
            return false;
        }
        vector3 = v1;
        return !(f * f3 - f2 * vector3.dot(vector3) < 0.0f);
    }

    public static Vector2 nearestSegmentPoint(float f, float f2, float f3, float f4, float f5, float f6, Vector2 vector2) {
        float f7 = f3 - f;
        float f8 = f4 - f2;
        float f9 = f7 * f7 + f8 * f8;
        if (f9 == 0.0f) {
            return vector2.set(f, f2);
        }
        if ((f5 = ((f5 - f) * f7 + (f6 - f2) * f8) / f9) < 0.0f) {
            return vector2.set(f, f2);
        }
        if (f5 > 1.0f) {
            return vector2.set(f3, f4);
        }
        return vector2.set(f + f7 * f5, f2 + f5 * f8);
    }

    public static Vector2 nearestSegmentPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        float f = vector2.dst2(vector22);
        if (f == 0.0f) {
            return vector24.set(vector2);
        }
        if ((f = ((vector23.x - vector2.x) * (vector22.x - vector2.x) + (vector23.y - vector2.y) * (vector22.y - vector2.y)) / f) < 0.0f) {
            return vector24.set(vector2);
        }
        if (f > 1.0f) {
            return vector24.set(vector22);
        }
        return vector24.set(vector2.x + (vector22.x - vector2.x) * f, vector2.y + f * (vector22.y - vector2.y));
    }

    public static boolean overlapConvexPolygons(Polygon polygon, Polygon polygon2) {
        return Intersector.overlapConvexPolygons(polygon, polygon2, null);
    }

    public static boolean overlapConvexPolygons(Polygon polygon, Polygon polygon2, MinimumTranslationVector minimumTranslationVector) {
        return Intersector.overlapConvexPolygons(polygon.getTransformedVertices(), polygon2.getTransformedVertices(), minimumTranslationVector);
    }

    public static boolean overlapConvexPolygons(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, MinimumTranslationVector minimumTranslationVector) {
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n6;
        float f9;
        int n7 = n + n2;
        int n8 = n3 + n4;
        float f10 = Float.MAX_VALUE;
        int n9 = n;
        float f11 = 0.0f;
        float f12 = 0.0f;
        while (n9 < n7) {
            block24: {
                block26: {
                    block25: {
                        f9 = fArray[n9];
                        float f13 = fArray[n9 + 1];
                        n6 = n9 + 2;
                        float f14 = fArray[n6 % n2];
                        float f15 = fArray[(n9 + 3) % n2];
                        f8 = f13 - f15;
                        f7 = -(f9 - f14);
                        f6 = (float)Math.sqrt(f8 * f8 + f7 * f7);
                        f5 = f8 / f6;
                        f4 = f7 / f6;
                        f7 = f6 = fArray[0] * f5 + fArray[1] * f4;
                        for (n9 = n; n9 < n7; n9 += 2) {
                            f3 = fArray[n9] * f5 + fArray[n9 + 1] * f4;
                            if (f3 < f7) {
                                f8 = f3;
                                f2 = f6;
                            } else {
                                f2 = f6;
                                f8 = f7;
                                if (f3 > f6) {
                                    f2 = f3;
                                    f8 = f7;
                                }
                            }
                            f6 = f2;
                            f7 = f8;
                        }
                        f3 = fArray2[0] * f5 + fArray2[1] * f4;
                        f = f3;
                        n5 = 0;
                        f2 = f5;
                        f8 = f4;
                        f5 = f7;
                        f4 = f6;
                        f6 = f;
                        f7 = f3;
                        f3 = f12;
                        f12 = f15;
                        for (n9 = n3; n9 < n8; n9 += 2) {
                            f = fArray2[n9];
                            int n10 = n9 + 1;
                            n5 -= Intersector.pointLineSide(f9, f13, f14, f12, f, fArray2[n10]);
                            f = f2 * fArray2[n9] + f8 * fArray2[n10];
                            if (f < f6) {
                                f6 = f;
                                continue;
                            }
                            if (!(f > f7)) continue;
                            f7 = f;
                        }
                        if (!(f5 <= f6 && f4 >= f6 || f6 <= f5 && f7 >= f5)) break block24;
                        f9 = Math.min(f4, f7) - Math.max(f5, f6);
                        if (f5 < f6 && f4 > f7) break block25;
                        f12 = f9;
                        if (!(f6 < f5)) break block26;
                        f12 = f9;
                        if (!(f7 > f4)) break block26;
                    }
                    f12 = (f12 = Math.abs(f5 - f6)) < (f7 = Math.abs(f4 - f7)) ? f9 + f12 : f9 + f7;
                }
                if (f12 < f10) {
                    f11 = n5 >= 0 ? f2 : -f2;
                    f7 = n5 >= 0 ? f8 : -f8;
                    f6 = f12;
                    f12 = f7;
                } else {
                    f12 = f3;
                    f6 = f10;
                }
                n9 = n6;
                f10 = f6;
                continue;
            }
            return false;
        }
        n9 = n3;
        f8 = f10;
        f2 = f12;
        f3 = f11;
        n2 = n7;
        while (n9 < n8) {
            block27: {
                block29: {
                    block28: {
                        f7 = fArray2[n9];
                        f = fArray2[n9 + 1];
                        n7 = n9 + 2;
                        f4 = fArray2[n7 % n4];
                        f9 = fArray2[(n9 + 3) % n4];
                        f6 = f - f9;
                        f12 = -(f7 - f4);
                        f11 = (float)Math.sqrt(f6 * f6 + f12 * f12);
                        f10 = f6 / f11;
                        f6 = f12 / f11;
                        f12 = fArray[0] * f10 + fArray[1] * f6;
                        f11 = f12;
                        n9 = 0;
                        for (n5 = n; n5 < n2; n5 += 2) {
                            f5 = fArray[n5];
                            n6 = n5 + 1;
                            f5 = f5 * f10 + fArray[n6] * f6;
                            n9 -= Intersector.pointLineSide(f7, f, f4, f9, fArray[n5], fArray[n6]);
                            if (f5 < f11) {
                                f11 = f5;
                                continue;
                            }
                            if (!(f5 > f12)) continue;
                            f12 = f5;
                        }
                        f5 = f10 * fArray2[0] + f6 * fArray2[1];
                        f9 = f5;
                        for (n5 = n3; n5 < n8; n5 += 2) {
                            f = fArray2[n5] * f10 + f6 * fArray2[n5 + 1];
                            if (f < f5) {
                                f7 = f;
                                f4 = f9;
                            } else {
                                f4 = f9;
                                f7 = f5;
                                if (f > f9) {
                                    f4 = f;
                                    f7 = f5;
                                }
                            }
                            f9 = f4;
                            f5 = f7;
                        }
                        if (!(f11 <= f5 && f12 >= f5 || f5 <= f11 && f9 >= f11)) break block27;
                        f4 = Math.min(f12, f9) - Math.max(f11, f5);
                        if (f11 < f5 && f12 > f9) break block28;
                        f7 = f4;
                        if (!(f5 < f11)) break block29;
                        f7 = f4;
                        if (!(f9 > f12)) break block29;
                    }
                    f7 = (f11 = Math.abs(f11 - f5)) < (f12 = Math.abs(f12 - f9)) ? f4 + f11 : f4 + f12;
                }
                f12 = f8;
                if (f7 < f8) {
                    f12 = n9 < 0 ? f10 : -f10;
                    f11 = n9 < 0 ? f6 : -f6;
                    f3 = f12;
                    f12 = f7;
                    f2 = f11;
                }
                n9 = n7;
                f8 = f12;
                continue;
            }
            return false;
        }
        if (minimumTranslationVector != null) {
            minimumTranslationVector.normal.set(f3, f2);
            minimumTranslationVector.depth = f8;
        }
        return true;
    }

    public static boolean overlapConvexPolygons(float[] fArray, float[] fArray2, MinimumTranslationVector minimumTranslationVector) {
        return Intersector.overlapConvexPolygons(fArray, 0, fArray.length, fArray2, 0, fArray2.length, minimumTranslationVector);
    }

    public static boolean overlaps(Circle circle, Circle circle2) {
        return circle.overlaps(circle2);
    }

    public static boolean overlaps(Circle circle, Rectangle rectangle) {
        float f = circle.x;
        float f2 = circle.y;
        if (circle.x < rectangle.x) {
            f = rectangle.x;
        } else if (circle.x > rectangle.x + rectangle.width) {
            f = rectangle.x + rectangle.width;
        }
        if (circle.y < rectangle.y) {
            f2 = rectangle.y;
        } else if (circle.y > rectangle.y + rectangle.height) {
            f2 = rectangle.y + rectangle.height;
        }
        boolean bl = (f -= circle.x) * f + (f2 -= circle.y) * f2 < circle.radius * circle.radius;
        return bl;
    }

    public static boolean overlaps(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.overlaps(rectangle2);
    }

    public static int pointLineSide(float f, float f2, float f3, float f4, float f5, float f6) {
        return (int)Math.signum((f3 - f) * (f6 - f2) - (f4 - f2) * (f5 - f));
    }

    public static int pointLineSide(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return (int)Math.signum((vector22.x - vector2.x) * (vector23.y - vector2.y) - (vector22.y - vector2.y) * (vector23.x - vector2.x));
    }

    private static void splitEdge(float[] fArray, int n, int n2, int n3, Plane plane, float[] fArray2, int n4) {
        float f = Intersector.intersectLinePlane(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n2], fArray[n2 + 1], fArray[n2 + 2], plane, intersection);
        fArray2[n4 + 0] = Intersector.intersection.x;
        fArray2[n4 + 1] = Intersector.intersection.y;
        fArray2[n4 + 2] = Intersector.intersection.z;
        for (int i = 3; i < n3; ++i) {
            float f2 = fArray[n + i];
            fArray2[n4 + i] = f2 + (fArray[n2 + i] - f2) * f;
        }
    }

    public static void splitTriangle(float[] fArray, Plane plane, SplitTriangle splitTriangle) {
        int n = fArray.length / 3;
        int n2 = plane.testPoint(fArray[0], fArray[1], fArray[2]) == Plane.PlaneSide.Back ? 1 : 0;
        int n3 = plane.testPoint(fArray[n + 0], fArray[n + 1], fArray[n + 2]) == Plane.PlaneSide.Back ? 1 : 0;
        int n4 = n * 2;
        int n5 = plane.testPoint(fArray[n4 + 0], fArray[n4 + 1], fArray[n4 + 2]) == Plane.PlaneSide.Back ? 1 : 0;
        splitTriangle.reset();
        if (n2 == n3 && n3 == n5) {
            splitTriangle.total = 1;
            if (n2 != 0) {
                splitTriangle.numBack = 1;
                System.arraycopy(fArray, 0, splitTriangle.back, 0, fArray.length);
            } else {
                splitTriangle.numFront = 1;
                System.arraycopy(fArray, 0, splitTriangle.front, 0, fArray.length);
            }
            return;
        }
        splitTriangle.total = 3;
        splitTriangle.numFront = (n2 ^ 1) + (n3 ^ 1) + (n5 ^ 1);
        splitTriangle.numBack = splitTriangle.total - splitTriangle.numFront;
        splitTriangle.setSide(n2 ^ true);
        if (n2 != n3) {
            Intersector.splitEdge(fArray, 0, n, n, plane, splitTriangle.edgeSplit, 0);
            splitTriangle.add(fArray, 0, n);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
            splitTriangle.setSide(splitTriangle.getSide() ^ true);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
        } else {
            splitTriangle.add(fArray, 0, n);
        }
        int n6 = n + n;
        if (n3 != n5) {
            Intersector.splitEdge(fArray, n, n6, n, plane, splitTriangle.edgeSplit, 0);
            splitTriangle.add(fArray, n, n);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
            splitTriangle.setSide(splitTriangle.getSide() ^ true);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
        } else {
            splitTriangle.add(fArray, n, n);
        }
        if (n5 != n2) {
            Intersector.splitEdge(fArray, n6, 0, n, plane, splitTriangle.edgeSplit, 0);
            splitTriangle.add(fArray, n6, n);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
            splitTriangle.setSide(splitTriangle.getSide() ^ true);
            splitTriangle.add(splitTriangle.edgeSplit, 0, n);
        } else {
            splitTriangle.add(fArray, n6, n);
        }
        if (splitTriangle.numFront == 2) {
            System.arraycopy(splitTriangle.front, n4, splitTriangle.front, n * 3, n4);
            System.arraycopy(splitTriangle.front, 0, splitTriangle.front, n * 5, n);
        } else {
            System.arraycopy(splitTriangle.back, n4, splitTriangle.back, n * 3, n4);
            System.arraycopy(splitTriangle.back, 0, splitTriangle.back, n * 5, n);
        }
    }

    public static class MinimumTranslationVector {
        public float depth = 0.0f;
        public Vector2 normal = new Vector2();
    }

    public static class SplitTriangle {
        public float[] back;
        int backOffset = 0;
        float[] edgeSplit;
        public float[] front;
        boolean frontCurrent = false;
        int frontOffset = 0;
        public int numBack;
        public int numFront;
        public int total;

        public SplitTriangle(int n) {
            int n2 = n * 3 * 2;
            this.front = new float[n2];
            this.back = new float[n2];
            this.edgeSplit = new float[n];
        }

        void add(float[] fArray, int n, int n2) {
            if (this.frontCurrent) {
                System.arraycopy(fArray, n, this.front, this.frontOffset, n2);
                this.frontOffset += n2;
            } else {
                System.arraycopy(fArray, n, this.back, this.backOffset, n2);
                this.backOffset += n2;
            }
        }

        boolean getSide() {
            return this.frontCurrent;
        }

        void reset() {
            this.frontCurrent = false;
            this.frontOffset = 0;
            this.backOffset = 0;
            this.numFront = 0;
            this.numBack = 0;
            this.total = 0;
        }

        void setSide(boolean bl) {
            this.frontCurrent = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SplitTriangle [front=");
            stringBuilder.append(Arrays.toString(this.front));
            stringBuilder.append(", back=");
            stringBuilder.append(Arrays.toString(this.back));
            stringBuilder.append(", numFront=");
            stringBuilder.append(this.numFront);
            stringBuilder.append(", numBack=");
            stringBuilder.append(this.numBack);
            stringBuilder.append(", total=");
            stringBuilder.append(this.total);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

