/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Ellipse
implements Shape2D,
Serializable {
    private static final long serialVersionUID = 7381533206532032099L;
    public float height;
    public float width;
    public float x;
    public float y;

    public Ellipse() {
    }

    public Ellipse(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public Ellipse(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.width = circle.radius * 2.0f;
        this.height = circle.radius * 2.0f;
    }

    public Ellipse(Ellipse ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.width = ellipse.width;
        this.height = ellipse.height;
    }

    public Ellipse(Vector2 vector2, float f, float f2) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.width = f;
        this.height = f2;
    }

    public Ellipse(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.width = vector22.x;
        this.height = vector22.y;
    }

    public float area() {
        return this.width * this.height * (float)Math.PI / 4.0f;
    }

    public float circumference() {
        float f = this.width / 2.0f;
        float f2 = f * 3.0f;
        float f3 = this.height / 2.0f;
        if (!(f2 > f3) && !(f3 * 3.0f > f)) {
            return (float)(Math.sqrt((f * f + f3 * f3) / 2.0f) * 6.2831854820251465);
        }
        double d = (f + f3) * 3.0f;
        double d2 = Math.sqrt((f2 + f3) * (f + f3 * 3.0f));
        Double.isNaN(d);
        return (float)((d - d2) * 3.1415927410125732);
    }

    @Override
    public boolean contains(float f, float f2) {
        float f3 = f - this.x;
        f = f2 - this.y;
        f2 = this.width;
        boolean bl = (f2 = f3 * f3 / (f2 * 0.5f * f2 * 0.5f)) + f * f / ((f3 = this.height) * 0.5f * f3 * 0.5f) <= 1.0f;
        return bl;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (Ellipse)object;
            if (this.x != ((Ellipse)object).x || this.y != ((Ellipse)object).y || this.width != ((Ellipse)object).width || this.height != ((Ellipse)object).height) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return (((NumberUtils.floatToRawIntBits(this.height) + 53) * 53 + NumberUtils.floatToRawIntBits(this.width)) * 53 + NumberUtils.floatToRawIntBits(this.x)) * 53 + NumberUtils.floatToRawIntBits(this.y);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public void set(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.width = circle.radius * 2.0f;
        this.height = circle.radius * 2.0f;
    }

    public void set(Ellipse ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.width = ellipse.width;
        this.height = ellipse.height;
    }

    public void set(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.width = vector22.x;
        this.height = vector22.y;
    }

    public Ellipse setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Ellipse setPosition(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
        return this;
    }

    public Ellipse setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        return this;
    }
}

