/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class EarClippingTriangulator {
    private static final int CONCAVE = -1;
    private static final int CONVEX = 1;
    private short[] indices;
    private final ShortArray indicesArray = new ShortArray();
    private final ShortArray triangles;
    private int vertexCount;
    private final IntArray vertexTypes = new IntArray();
    private float[] vertices;

    public EarClippingTriangulator() {
        this.triangles = new ShortArray();
    }

    private int classifyVertex(int n) {
        Object[] objectArray = this.indices;
        int n2 = objectArray[this.previousIndex(n)] * 2;
        int n3 = objectArray[n] * 2;
        n = objectArray[this.nextIndex(n)] * 2;
        objectArray = this.vertices;
        return EarClippingTriangulator.computeSpannedAreaSign(objectArray[n2], objectArray[n2 + 1], objectArray[n3], objectArray[n3 + 1], objectArray[n], objectArray[n + 1]);
    }

    private static int computeSpannedAreaSign(float f, float f2, float f3, float f4, float f5, float f6) {
        return (int)Math.signum(f * (f6 - f4) + f3 * (f2 - f6) + f5 * (f4 - f2));
    }

    private void cutEarTip(int n) {
        short[] sArray = this.indices;
        ShortArray shortArray = this.triangles;
        shortArray.add(sArray[this.previousIndex(n)]);
        shortArray.add(sArray[n]);
        shortArray.add(sArray[this.nextIndex(n)]);
        this.indicesArray.removeIndex(n);
        this.vertexTypes.removeIndex(n);
        --this.vertexCount;
    }

    private int findEarTip() {
        int n;
        int n2 = this.vertexCount;
        for (n = 0; n < n2; ++n) {
            if (!this.isEarTip(n)) continue;
            return n;
        }
        int[] nArray = this.vertexTypes.items;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] == -1) continue;
            return n;
        }
        return 0;
    }

    private boolean isEarTip(int n) {
        int[] nArray = this.vertexTypes.items;
        if (nArray[n] == -1) {
            return false;
        }
        int n2 = this.previousIndex(n);
        int n3 = this.nextIndex(n);
        short[] sArray = this.indices;
        int n4 = sArray[n2] * 2;
        n = sArray[n] * 2;
        int n5 = sArray[n3] * 2;
        float[] fArray = this.vertices;
        float f = fArray[n4];
        float f2 = fArray[n4 + 1];
        float f3 = fArray[n];
        float f4 = fArray[n + 1];
        float f5 = fArray[n5];
        float f6 = fArray[n5 + 1];
        n = this.nextIndex(n3);
        while (n != n2) {
            float f7;
            float f8;
            if (nArray[n] != 1 && EarClippingTriangulator.computeSpannedAreaSign(f5, f6, f, f2, f8 = fArray[n4 = sArray[n] * 2], f7 = fArray[n4 + 1]) >= 0 && EarClippingTriangulator.computeSpannedAreaSign(f, f2, f3, f4, f8, f7) >= 0 && EarClippingTriangulator.computeSpannedAreaSign(f3, f4, f5, f6, f8, f7) >= 0) {
                return false;
            }
            n = this.nextIndex(n);
        }
        return true;
    }

    private int nextIndex(int n) {
        return (n + 1) % this.vertexCount;
    }

    private int previousIndex(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = this.vertexCount;
        }
        return n2 - 1;
    }

    private void triangulate() {
        int n;
        Object[] objectArray = this.vertexTypes.items;
        while ((n = this.vertexCount) > 3) {
            int n2 = this.findEarTip();
            this.cutEarTip(n2);
            int n3 = this.previousIndex(n2);
            n = n2;
            if (n2 == this.vertexCount) {
                n = 0;
            }
            objectArray[n3] = this.classifyVertex(n3);
            objectArray[n] = this.classifyVertex(n);
        }
        if (n == 3) {
            ShortArray shortArray = this.triangles;
            objectArray = this.indices;
            shortArray.add(objectArray[0]);
            shortArray.add(objectArray[1]);
            shortArray.add(objectArray[2]);
        }
    }

    public ShortArray computeTriangles(FloatArray floatArray) {
        return this.computeTriangles(floatArray.items, 0, floatArray.size);
    }

    public ShortArray computeTriangles(float[] fArray) {
        return this.computeTriangles(fArray, 0, fArray.length);
    }

    public ShortArray computeTriangles(float[] object, int n, int n2) {
        int n3;
        this.vertices = object;
        this.vertexCount = n3 = n2 / 2;
        int n4 = n / 2;
        Object object2 = this.indicesArray;
        ((ShortArray)object2).clear();
        ((ShortArray)object2).ensureCapacity(n3);
        ((ShortArray)object2).size = n3;
        object2 = ((ShortArray)object2).items;
        this.indices = (short[])object2;
        if (GeometryUtils.isClockwise((float[])object, n, n2)) {
            for (n = 0; n < n3; n = (int)((short)(n + 1))) {
                object2[n] = (short)(n4 + n);
            }
        } else {
            for (n = 0; n < n3; ++n) {
                object2[n] = (short)(n4 + (n3 - 1) - n);
            }
        }
        object = this.vertexTypes;
        ((IntArray)object).clear();
        ((IntArray)object).ensureCapacity(n3);
        for (n = 0; n < n3; ++n) {
            ((IntArray)object).add(this.classifyVertex(n));
        }
        object = this.triangles;
        ((ShortArray)object).clear();
        ((ShortArray)object).ensureCapacity(Math.max(0, n3 - 2) * 3);
        this.triangulate();
        return object;
    }
}

