/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class DelaunayTriangulator {
    private static final int COMPLETE = 1;
    private static final float EPSILON = 1.0E-6f;
    private static final int INCOMPLETE = 2;
    private static final int INSIDE = 0;
    private final Vector2 centroid;
    private final BooleanArray complete;
    private final IntArray edges;
    private final ShortArray originalIndices;
    private final IntArray quicksortStack = new IntArray();
    private float[] sortedPoints;
    private final float[] superTriangle;
    private final ShortArray triangles = new ShortArray(false, 16);

    public DelaunayTriangulator() {
        this.originalIndices = new ShortArray(false, 0);
        this.edges = new IntArray();
        this.complete = new BooleanArray(false, 16);
        this.superTriangle = new float[6];
        this.centroid = new Vector2();
    }

    private int circumCircle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = Math.abs(f4 - f6);
        float f10 = Math.abs(f6 - f8);
        int n = 2;
        if (f9 < 1.0E-6f) {
            if (f10 < 1.0E-6f) {
                return 2;
            }
            f4 = -(f7 - f5) / (f8 - f6);
            f7 = (f7 + f5) / 2.0f;
            f8 = (f8 + f6) / 2.0f;
            f3 = (f3 + f5) / 2.0f;
            f4 = f4 * (f3 - f7) + f8;
        } else {
            f9 = -(f5 - f3) / (f6 - f4);
            float f11 = (f3 + f5) / 2.0f;
            f4 = (f4 + f6) / 2.0f;
            if (f10 < 1.0E-6f) {
                f3 = (f7 + f5) / 2.0f;
            } else {
                f3 = -(f7 - f5) / (f8 - f6);
                f3 = (f9 * f11 - (f7 + f5) / 2.0f * f3 + (f8 + f6) / 2.0f - f4) / (f9 - f3);
            }
            f4 += f9 * (f3 - f11);
        }
        f5 -= f3;
        f5 = f5 * f5 + (f6 -= f4) * f6;
        f6 = f - f3;
        f6 *= f6;
        f2 -= f4;
        if (f2 * f2 + f6 - f5 <= 1.0E-6f) {
            return 0;
        }
        int n2 = n;
        if (f > f3) {
            n2 = n;
            if (f6 > f5) {
                n2 = 1;
            }
        }
        return n2;
    }

    private int quicksortPartition(float[] fArray, int n, int n2, short[] sArray) {
        int n3;
        int n4;
        float f = fArray[n];
        int n5 = n + 2;
        while (n5 < n2) {
            n4 = n5;
            while (true) {
                n3 = n2;
                if (n4 >= n2) break;
                n3 = n2;
                if (!(fArray[n4] <= f)) break;
                n4 += 2;
            }
            while (fArray[n3] > f) {
                n3 -= 2;
            }
            n5 = n4;
            n2 = n3;
            if (n4 >= n3) continue;
            float f2 = fArray[n4];
            fArray[n4] = fArray[n3];
            fArray[n3] = f2;
            n2 = n4 + 1;
            f2 = fArray[n2];
            n5 = n3 + 1;
            fArray[n2] = fArray[n5];
            fArray[n5] = f2;
            n2 = n4 / 2;
            short s = sArray[n2];
            n5 = n3 / 2;
            sArray[n2] = sArray[n5];
            sArray[n5] = s;
            n5 = n4;
            n2 = n3;
        }
        fArray[n] = fArray[n2];
        fArray[n2] = f;
        n4 = n + 1;
        f = fArray[n4];
        n3 = n2 + 1;
        fArray[n4] = fArray[n3];
        fArray[n3] = f;
        n3 = n / 2;
        n4 = sArray[n3];
        n = n2 / 2;
        sArray[n3] = sArray[n];
        sArray[n] = (short)n4;
        return n2;
    }

    private void sort(float[] fArray, int n) {
        int n2;
        int n3 = n / 2;
        this.originalIndices.clear();
        this.originalIndices.ensureCapacity(n3);
        short[] sArray = this.originalIndices.items;
        for (n2 = 0; n2 < n3; n2 = (int)((short)(n2 + 1))) {
            sArray[n2] = (short)n2;
        }
        IntArray intArray = this.quicksortStack;
        intArray.add(0);
        intArray.add(n - 1 - 1);
        while (intArray.size > 0) {
            n3 = intArray.pop();
            if (n3 <= (n2 = intArray.pop())) continue;
            int n4 = this.quicksortPartition(fArray, n2, n3, sArray);
            int n5 = n4 - n2;
            if (n5 > (n = n3 - n4)) {
                intArray.add(n2);
                intArray.add(n4 - 2);
            }
            intArray.add(n4 + 2);
            intArray.add(n3);
            if (n < n5) continue;
            intArray.add(n2);
            intArray.add(n4 - 2);
        }
    }

    public ShortArray computeTriangles(FloatArray floatArray, boolean bl) {
        return this.computeTriangles(floatArray.items, 0, floatArray.size, bl);
    }

    public ShortArray computeTriangles(float[] object, int n, int n2, boolean bl) {
        if (n2 <= Short.MAX_VALUE) {
            int n3;
            float f;
            float f2;
            int n4;
            Object object2;
            ShortArray shortArray = this.triangles;
            shortArray.clear();
            if (n2 < 6) {
                return shortArray;
            }
            shortArray.ensureCapacity(n2);
            if (!bl) {
                object2 = this.sortedPoints;
                if (object2 == null || ((float[])object2).length < n2) {
                    this.sortedPoints = new float[n2];
                }
                System.arraycopy(object, n, this.sortedPoints, 0, n2);
                object2 = this.sortedPoints;
                this.sort((float[])object2, n2);
                n = 0;
            } else {
                object2 = object;
            }
            int n5 = n + n2;
            float f3 = object2[0];
            float f4 = object2[1];
            float f5 = f4;
            float f6 = f3;
            for (n4 = n + 2; n4 < n5; ++n4) {
                f2 = object2[n4];
                f = f6;
                if (f2 < f6) {
                    f = f2;
                }
                f6 = f3;
                if (f2 > f3) {
                    f6 = f2;
                }
                f3 = object2[++n4];
                f2 = f5;
                if (f3 < f5) {
                    f2 = f3;
                }
                f5 = f4;
                if (f3 > f4) {
                    f5 = f3;
                }
                f3 = f6;
                f6 = f;
                f4 = f5;
                f5 = f2;
            }
            f = f3 - f6;
            f2 = f4 - f5;
            if (!(f > f2)) {
                f = f2;
            }
            f3 = (f3 + f6) / 2.0f;
            f4 = (f4 + f5) / 2.0f;
            float[] fArray = this.superTriangle;
            fArray[0] = f3 - (f *= 20.0f);
            fArray[1] = f5 = f4 - f;
            fArray[2] = f3;
            fArray[3] = f4 + f;
            fArray[4] = f3 + f;
            fArray[5] = f5;
            object = this.edges;
            ((IntArray)object).ensureCapacity(n2 / 2);
            BooleanArray booleanArray = this.complete;
            booleanArray.clear();
            booleanArray.ensureCapacity(n2);
            shortArray.add(n5);
            shortArray.add(n5 + 2);
            shortArray.add(n5 + 4);
            booleanArray.add(false);
            n2 = n5;
            for (n4 = n; n4 < n2; n4 += 2) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                float f7 = object2[n4];
                float f8 = object2[n4 + 1];
                short[] sArray = shortArray.items;
                Object[] objectArray = booleanArray.items;
                for (n5 = shortArray.size - 1; n5 >= 0; n5 -= 3) {
                    n10 = n5 / 3;
                    if (objectArray[n10]) continue;
                    n9 = n5 - 2;
                    n3 = sArray[n9];
                    n8 = sArray[n5 - 1];
                    n7 = sArray[n5];
                    if (n3 >= n2) {
                        n6 = n3 - n2;
                        f4 = fArray[n6];
                        f5 = fArray[n6 + 1];
                    } else {
                        f4 = object2[n3];
                        f5 = object2[n3 + 1];
                    }
                    if (n8 >= n2) {
                        n6 = n8 - n2;
                        f6 = fArray[n6];
                        f3 = fArray[n6 + 1];
                    } else {
                        f6 = object2[n8];
                        f3 = object2[n8 + 1];
                    }
                    if (n7 >= n2) {
                        n6 = n7 - n2;
                        f = fArray[n6];
                        f2 = fArray[n6 + 1];
                    } else {
                        f = object2[n7];
                        f2 = object2[n7 + 1];
                    }
                    Object object3 = object;
                    n6 = this.circumCircle(f7, f8, f4, f5, f6, f3, f, f2);
                    if (n6 != 0) {
                        if (n6 != 1) continue;
                        objectArray[n10] = true;
                        continue;
                    }
                    ((IntArray)object3).add(n3, n8, n8, n7);
                    ((IntArray)object3).add(n7, n3);
                    shortArray.removeRange(n9, n5);
                    booleanArray.removeIndex(n10);
                }
                objectArray = ((IntArray)object).items;
                n10 = ((IntArray)object).size;
                for (n5 = 0; n5 < n10; n5 += 2) {
                    n7 = objectArray[n5];
                    if (n7 == -1) continue;
                    n6 = n5 + 1;
                    boolean bl2 = objectArray[n6];
                    n9 = 0;
                    for (n8 = n5 + 2; n8 < n10; n8 += 2) {
                        n3 = n9;
                        if (n7 == objectArray[n8 + 1]) {
                            n3 = n9;
                            if (bl2 == objectArray[n8]) {
                                objectArray[n8] = -1;
                                n3 = 1;
                            }
                        }
                        n9 = n3;
                    }
                    if (n9 != 0) continue;
                    shortArray.add(n7);
                    shortArray.add(objectArray[n6]);
                    shortArray.add(n4);
                    booleanArray.add(false);
                }
                ((IntArray)object).clear();
            }
            n3 = 0;
            n5 = 0;
            object2 = shortArray.items;
            for (n4 = shortArray.size - 1; n4 >= 0; n4 -= 3) {
                if (object2[n4] < n2 && object2[n4 - 1] < n2 && object2[n4 - 2] < n2) continue;
                shortArray.removeIndex(n4);
                shortArray.removeIndex(n4 - 1);
                shortArray.removeIndex(n4 - 2);
            }
            if (!bl) {
                object = this.originalIndices.items;
                n4 = shortArray.size;
                for (n2 = 0; n2 < n4; ++n2) {
                    object2[n2] = (short)(object[object2[n2] / 2] * 2);
                }
            }
            if (n == 0) {
                n2 = shortArray.size;
                for (n = n5; n < n2; ++n) {
                    object2[n] = (short)(object2[n] / 2);
                }
            } else {
                n4 = shortArray.size;
                for (n2 = n3; n2 < n4; ++n2) {
                    object2[n2] = (short)((object2[n2] - n) / 2);
                }
            }
            return shortArray;
        }
        object = new IllegalArgumentException("count must be <= 32767");
        throw object;
    }

    public ShortArray computeTriangles(float[] fArray, boolean bl) {
        return this.computeTriangles(fArray, 0, fArray.length, bl);
    }

    public void trim(ShortArray shortArray, float[] fArray, float[] fArray2, int n, int n2) {
        short[] sArray = shortArray.items;
        for (int i = shortArray.size - 1; i >= 0; i -= 3) {
            int n3 = i - 2;
            int n4 = sArray[n3] * 2;
            int n5 = i - 1;
            int n6 = sArray[n5] * 2;
            int n7 = sArray[i] * 2;
            GeometryUtils.triangleCentroid(fArray[n4], fArray[n4 + 1], fArray[n6], fArray[n6 + 1], fArray[n7], fArray[n7 + 1], this.centroid);
            if (Intersector.isPointInPolygon(fArray2, n, n2, this.centroid.x, this.centroid.y)) continue;
            shortArray.removeIndex(i);
            shortArray.removeIndex(n5);
            shortArray.removeIndex(n3);
        }
    }
}

