/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

public class OrthogonalTiledMapRenderer
extends BatchTiledMapRenderer {
    public OrthogonalTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f) {
        super(tiledMap, f);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f, Batch batch) {
        super(tiledMap, f, batch);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Object object = this.batch.getColor();
        float f = Color.toFloatBits(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * tiledMapTileLayer.getOpacity());
        int n = tiledMapTileLayer.getWidth();
        int n2 = tiledMapTileLayer.getHeight();
        float f2 = tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f3 = tiledMapTileLayer.getTileHeight() * this.unitScale;
        Object object2 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale;
        float f4 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale;
        int n3 = Math.max(0, (int)((this.viewBounds.x - object2) / f2));
        int n4 = Math.min(n, (int)((this.viewBounds.x + this.viewBounds.width + f2 - object2) / f2));
        n = Math.max(0, (int)((this.viewBounds.y - f4) / f3));
        n2 = Math.min(n2, (int)((this.viewBounds.y + this.viewBounds.height + f3 - f4) / f3));
        f4 = (float)n2 * f3 + f4;
        object2 = (float)n3 * f2 + object2;
        object = this.vertices;
        while (n2 >= n) {
            float f5 = object2;
            float f6 = object2;
            for (int i = n3; i < n4; ++i) {
                Object object3 = tiledMapTileLayer.getCell(i, n2);
                if (object3 == null) {
                    object2 = f5 + f2;
                } else {
                    TiledMapTile tiledMapTile = ((TiledMapTileLayer.Cell)object3).getTile();
                    if (tiledMapTile != null) {
                        boolean bl = ((TiledMapTileLayer.Cell)object3).getFlipHorizontally();
                        boolean bl2 = ((TiledMapTileLayer.Cell)object3).getFlipVertically();
                        int n5 = ((TiledMapTileLayer.Cell)object3).getRotation();
                        object3 = tiledMapTile.getTextureRegion();
                        float f7 = f5 + tiledMapTile.getOffsetX() * this.unitScale;
                        float f8 = tiledMapTile.getOffsetY() * this.unitScale + f4;
                        float f9 = f7 + (float)((TextureRegion)object3).getRegionWidth() * this.unitScale;
                        float f10 = (float)((TextureRegion)object3).getRegionHeight() * this.unitScale + f8;
                        float f11 = ((TextureRegion)object3).getU();
                        float f12 = ((TextureRegion)object3).getV2();
                        float f13 = ((TextureRegion)object3).getU2();
                        object2 = ((TextureRegion)object3).getV();
                        object[0] = f7;
                        object[1] = f8;
                        object[2] = f;
                        object[3] = f11;
                        object[4] = f12;
                        object[5] = f7;
                        object[6] = f10;
                        object[7] = f;
                        object[8] = f11;
                        object[9] = object2;
                        object[10] = f9;
                        object[11] = f10;
                        object[12] = f;
                        object[13] = f13;
                        object[14] = object2;
                        object[15] = f9;
                        object[16] = f8;
                        object[17] = f;
                        object[18] = f13;
                        object[19] = f12;
                        if (bl) {
                            object2 = object[3];
                            object[3] = object[13];
                            object[13] = object2;
                            object2 = object[8];
                            object[8] = object[18];
                            object[18] = object2;
                        }
                        if (bl2) {
                            object2 = object[4];
                            object[4] = object[14];
                            object[14] = object2;
                            object2 = object[9];
                            object[9] = object[19];
                            object[19] = object2;
                        }
                        if (n5 != 0) {
                            if (n5 != 1) {
                                if (n5 != 2) {
                                    if (n5 == 3) {
                                        object2 = object[4];
                                        object[4] = object[19];
                                        object[19] = object[14];
                                        object[14] = object[9];
                                        object[9] = object2;
                                        object2 = object[3];
                                        object[3] = object[18];
                                        object[18] = object[13];
                                        object[13] = object[8];
                                        object[8] = object2;
                                    }
                                } else {
                                    object2 = object[3];
                                    object[3] = object[13];
                                    object[13] = object2;
                                    object2 = object[8];
                                    object[8] = object[18];
                                    object[18] = object2;
                                    object2 = object[4];
                                    object[4] = object[14];
                                    object[14] = object2;
                                    object2 = object[9];
                                    object[9] = object[19];
                                    object[19] = object2;
                                }
                            } else {
                                object2 = object[4];
                                object[4] = object[9];
                                object[9] = object[14];
                                object[14] = object[19];
                                object[19] = object2;
                                object2 = object[3];
                                object[3] = object[8];
                                object[8] = object[13];
                                object[13] = object[18];
                                object[18] = object2;
                            }
                        }
                        this.batch.draw(((TextureRegion)object3).getTexture(), (float[])object, 0, 20);
                    }
                    object2 = f5 + f2;
                }
                f5 = object2;
            }
            f4 -= f3;
            --n2;
            object2 = f6;
        }
    }
}

