/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTile;

public class TiledMapTileLayer
extends MapLayer {
    private Cell[][] cells;
    private int height;
    private float tileHeight;
    private float tileWidth;
    private int width;

    public TiledMapTileLayer(int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.tileWidth = n3;
        this.tileHeight = n4;
        this.cells = new Cell[n][n2];
    }

    public Cell getCell(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.cells[n][n2];
        }
        return null;
    }

    public int getHeight() {
        return this.height;
    }

    public float getTileHeight() {
        return this.tileHeight;
    }

    public float getTileWidth() {
        return this.tileWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public void setCell(int n, int n2, Cell cell) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.cells[n][n2] = cell;
        }
    }

    public static class Cell {
        public static final int ROTATE_0 = 0;
        public static final int ROTATE_180 = 2;
        public static final int ROTATE_270 = 3;
        public static final int ROTATE_90 = 1;
        private boolean flipHorizontally;
        private boolean flipVertically;
        private int rotation;
        private TiledMapTile tile;

        public boolean getFlipHorizontally() {
            return this.flipHorizontally;
        }

        public boolean getFlipVertically() {
            return this.flipVertically;
        }

        public int getRotation() {
            return this.rotation;
        }

        public TiledMapTile getTile() {
            return this.tile;
        }

        public Cell setFlipHorizontally(boolean bl) {
            this.flipHorizontally = bl;
            return this;
        }

        public Cell setFlipVertically(boolean bl) {
            this.flipVertically = bl;
            return this;
        }

        public Cell setRotation(int n) {
            this.rotation = n;
            return this;
        }

        public Cell setTile(TiledMapTile tiledMapTile) {
            this.tile = tiledMapTile;
            return this;
        }
    }
}

