/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.InstanceData;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class InstanceBufferObjectSubData
implements InstanceData {
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    int bufferHandle;
    final ByteBuffer byteBuffer;
    boolean isBound = false;
    final boolean isDirect;
    boolean isDirty = false;
    final boolean isStatic;
    final int usage;

    public InstanceBufferObjectSubData(boolean bl, int n, VertexAttributes vertexAttributes) {
        this.isStatic = bl;
        this.attributes = vertexAttributes;
        this.byteBuffer = BufferUtils.newByteBuffer(this.attributes.vertexSize * n);
        this.isDirect = true;
        n = bl ? 35044 : 35048;
        this.usage = n;
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.bufferHandle = this.createBufferObject();
        this.buffer.flip();
        this.byteBuffer.flip();
    }

    public InstanceBufferObjectSubData(boolean bl, int n, VertexAttribute ... vertexAttributeArray) {
        this(bl, n, new VertexAttributes(vertexAttributeArray));
    }

    private void bufferChanged() {
        if (this.isBound) {
            Gdx.gl20.glBufferData(34962, this.byteBuffer.limit(), null, this.usage);
            Gdx.gl20.glBufferSubData(34962, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    private int createBufferObject() {
        int n = Gdx.gl20.glGenBuffer();
        Gdx.gl20.glBindBuffer(34962, n);
        Gdx.gl20.glBufferData(34962, this.byteBuffer.capacity(), null, this.usage);
        Gdx.gl20.glBindBuffer(34962, 0);
        return n;
    }

    @Override
    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null);
    }

    @Override
    public void bind(ShaderProgram shaderProgram, int[] object) {
        Object object2 = Gdx.gl20;
        object2.glBindBuffer(34962, this.bufferHandle);
        boolean bl = this.isDirty;
        int n = 0;
        int n2 = 0;
        if (bl) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            object2.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
        int n3 = this.attributes.size();
        if (object == null) {
            for (n = n2; n < n3; ++n) {
                object = this.attributes.get(n);
                n2 = shaderProgram.getAttributeLocation(object.alias);
                if (n2 < 0) continue;
                shaderProgram.enableVertexAttribute(n2 += object.unit);
                shaderProgram.setVertexAttribute(n2, object.numComponents, object.type, object.normalized, this.attributes.vertexSize, object.offset);
                Gdx.gl30.glVertexAttribDivisor(n2, 1);
            }
        } else {
            while (n < n3) {
                object2 = this.attributes.get(n);
                n2 = object[n];
                if (n2 >= 0) {
                    shaderProgram.enableVertexAttribute(n2 += ((VertexAttribute)object2).unit);
                    shaderProgram.setVertexAttribute(n2, ((VertexAttribute)object2).numComponents, ((VertexAttribute)object2).type, ((VertexAttribute)object2).normalized, this.attributes.vertexSize, ((VertexAttribute)object2).offset);
                    Gdx.gl30.glVertexAttribDivisor(n2, 1);
                }
                ++n;
            }
        }
        this.isBound = true;
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glBindBuffer(34962, 0);
        gL20.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    public int getBufferHandle() {
        return this.bufferHandle;
    }

    @Override
    public int getNumInstances() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public int getNumMaxInstances() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = this.createBufferObject();
        this.isDirty = true;
    }

    @Override
    public void setInstanceData(FloatBuffer floatBuffer, int n) {
        this.isDirty = true;
        if (this.isDirect) {
            BufferUtils.copy(floatBuffer, this.byteBuffer, n);
            this.buffer.position(0);
            this.buffer.limit(n);
        } else {
            this.buffer.clear();
            this.buffer.put(floatBuffer);
            this.buffer.flip();
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.buffer.limit() << 2);
        }
        this.bufferChanged();
    }

    @Override
    public void setInstanceData(float[] fArray, int n, int n2) {
        this.isDirty = true;
        if (this.isDirect) {
            BufferUtils.copy(fArray, this.byteBuffer, n2, n);
            this.buffer.position(0);
            this.buffer.limit(n2);
        } else {
            this.buffer.clear();
            this.buffer.put(fArray, n, n2);
            this.buffer.flip();
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.buffer.limit() << 2);
        }
        this.bufferChanged();
    }

    @Override
    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null);
    }

    @Override
    public void unbind(ShaderProgram shaderProgram, int[] object) {
        GL20 gL20 = Gdx.gl20;
        int n = this.attributes.size();
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                object = this.attributes.get(i);
                int n2 = shaderProgram.getAttributeLocation(object.alias);
                if (n2 < 0) continue;
                shaderProgram.disableVertexAttribute(n2 + object.unit);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                VertexAttribute vertexAttribute = this.attributes.get(i);
                int n3 = object[i];
                if (n3 < 0) continue;
                shaderProgram.enableVertexAttribute(n3 + vertexAttribute.unit);
            }
        }
        gL20.glBindBuffer(34962, 0);
        this.isBound = false;
    }

    @Override
    public void updateInstanceData(int n, FloatBuffer floatBuffer, int n2, int n3) {
        this.isDirty = true;
        if (this.isDirect) {
            int n4 = this.byteBuffer.position();
            this.byteBuffer.position(n * 4);
            floatBuffer.position(n2 * 4);
            BufferUtils.copy(floatBuffer, this.byteBuffer, n3);
            this.byteBuffer.position(n4);
            this.bufferChanged();
            return;
        }
        throw new GdxRuntimeException("Buffer must be allocated direct.");
    }

    @Override
    public void updateInstanceData(int n, float[] fArray, int n2, int n3) {
        this.isDirty = true;
        if (this.isDirect) {
            int n4 = this.byteBuffer.position();
            this.byteBuffer.position(n * 4);
            BufferUtils.copy(fArray, n2, n3, (Buffer)this.byteBuffer);
            this.byteBuffer.position(n4);
            this.bufferChanged();
            return;
        }
        throw new GdxRuntimeException("Buffer must be allocated direct.");
    }
}

