/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FrameBufferCubemap
extends GLFrameBuffer<Cubemap> {
    private static final Cubemap.CubemapSide[] cubemapSides = Cubemap.CubemapSide.values();
    private int currentSide;

    FrameBufferCubemap() {
    }

    public FrameBufferCubemap(Pixmap.Format format, int n, int n2, boolean bl) {
        this(format, n, n2, bl, false);
    }

    public FrameBufferCubemap(Pixmap.Format format, int n, int n2, boolean bl, boolean bl2) {
        GLFrameBuffer.FrameBufferCubemapBuilder frameBufferCubemapBuilder = new GLFrameBuffer.FrameBufferCubemapBuilder(n, n2);
        frameBufferCubemapBuilder.addBasicColorTextureAttachment(format);
        if (bl) {
            frameBufferCubemapBuilder.addBasicDepthRenderBuffer();
        }
        if (bl2) {
            frameBufferCubemapBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = frameBufferCubemapBuilder;
        this.build();
    }

    protected FrameBufferCubemap(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Cubemap>> gLFrameBufferBuilder) {
        super(gLFrameBufferBuilder);
    }

    @Override
    protected void attachFrameBufferColorTexture(Cubemap cubemapSideArray) {
        GL20 gL20 = Gdx.gl20;
        int n = cubemapSideArray.getTextureObjectHandle();
        cubemapSideArray = Cubemap.CubemapSide.values();
        int n2 = cubemapSideArray.length;
        for (int i = 0; i < n2; ++i) {
            gL20.glFramebufferTexture2D(36160, 36064, cubemapSideArray[i].glEnum, n, 0);
        }
    }

    @Override
    public void bind() {
        this.currentSide = -1;
        super.bind();
    }

    protected void bindSide(Cubemap.CubemapSide cubemapSide) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, cubemapSide.glEnum, ((Cubemap)this.getColorBufferTexture()).getTextureObjectHandle(), 0);
    }

    @Override
    protected Cubemap createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec object) {
        object = new GLOnlyTextureData(this.bufferBuilder.width, this.bufferBuilder.height, 0, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).internalFormat, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).format, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).type);
        object = new Cubemap((TextureData)object, (TextureData)object, (TextureData)object, (TextureData)object, (TextureData)object, (TextureData)object);
        ((GLTexture)object).setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        ((GLTexture)object).setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        return object;
    }

    @Override
    protected void disposeColorTexture(Cubemap cubemap) {
        cubemap.dispose();
    }

    public Cubemap.CubemapSide getSide() {
        int n = this.currentSide;
        Cubemap.CubemapSide cubemapSide = n < 0 ? null : cubemapSides[n];
        return cubemapSide;
    }

    public boolean nextSide() {
        int n = this.currentSide;
        if (n <= 5) {
            if (n == 5) {
                return false;
            }
            this.currentSide = n + 1;
            this.bindSide(this.getSide());
            return true;
        }
        throw new GdxRuntimeException("No remaining sides.");
    }
}

