/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureArrayData;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FileTextureArrayData
implements TextureArrayData {
    private int depth;
    private Pixmap.Format format;
    private boolean prepared;
    private TextureData[] textureDatas;
    boolean useMipMaps;

    public FileTextureArrayData(Pixmap.Format format, boolean bl, FileHandle[] fileHandleArray) {
        this.format = format;
        this.useMipMaps = bl;
        this.depth = fileHandleArray.length;
        this.textureDatas = new TextureData[fileHandleArray.length];
        for (int i = 0; i < fileHandleArray.length; ++i) {
            this.textureDatas[i] = TextureData.Factory.loadFromFile(fileHandleArray[i], format, bl);
        }
    }

    @Override
    public void consumeTextureArrayData() {
        Object object;
        for (int i = 0; i < ((TextureData[])(object = this.textureDatas)).length; ++i) {
            if (object[i].getType() == TextureData.TextureDataType.Custom) {
                this.textureDatas[i].consumeCustomData(35866);
                continue;
            }
            TextureData textureData = this.textureDatas[i];
            object = textureData.consumePixmap();
            boolean bl = textureData.disposePixmap();
            if (textureData.getFormat() != ((Pixmap)object).getFormat()) {
                Pixmap pixmap = new Pixmap(((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), textureData.getFormat());
                pixmap.setBlending(Pixmap.Blending.None);
                pixmap.drawPixmap((Pixmap)object, 0, 0, 0, 0, ((Pixmap)object).getWidth(), ((Pixmap)object).getHeight());
                if (textureData.disposePixmap()) {
                    ((Pixmap)object).dispose();
                }
                object = pixmap;
                bl = true;
            }
            Gdx.gl30.glTexSubImage3D(35866, 0, 0, 0, i, ((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), 1, ((Pixmap)object).getGLInternalFormat(), ((Pixmap)object).getGLType(), ((Pixmap)object).getPixels());
            if (!bl) continue;
            ((Pixmap)object).dispose();
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getGLType() {
        return Pixmap.Format.toGlType(this.format);
    }

    @Override
    public int getHeight() {
        return this.textureDatas[0].getHeight();
    }

    @Override
    public int getInternalFormat() {
        return Pixmap.Format.toGlFormat(this.format);
    }

    @Override
    public int getWidth() {
        return this.textureDatas[0].getWidth();
    }

    @Override
    public boolean isManaged() {
        TextureData[] textureDataArray = this.textureDatas;
        int n = textureDataArray.length;
        for (int i = 0; i < n; ++i) {
            if (textureDataArray[i].isManaged()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() {
        TextureData[] textureDataArray = this.textureDatas;
        int n = textureDataArray.length;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            TextureData textureData = textureDataArray[i];
            textureData.prepare();
            if (n2 == -1) {
                n2 = textureData.getWidth();
                n3 = textureData.getHeight();
                continue;
            }
            if (n2 == textureData.getWidth() && n3 == textureData.getHeight()) {
                continue;
            }
            throw new GdxRuntimeException("Error whilst preparing TextureArray: TextureArray Textures must have equal dimensions.");
        }
        this.prepared = true;
    }
}

