/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;

public class RenderContext {
    private int blendDFactor;
    private int blendSFactor;
    private boolean blending;
    private int cullFace;
    private int depthFunc;
    private boolean depthMask;
    private float depthRangeFar;
    private float depthRangeNear;
    public final TextureBinder textureBinder;

    public RenderContext(TextureBinder textureBinder) {
        this.textureBinder = textureBinder;
    }

    public void begin() {
        Gdx.gl.glDisable(2929);
        this.depthFunc = 0;
        Gdx.gl.glDepthMask(true);
        this.depthMask = true;
        Gdx.gl.glDisable(3042);
        this.blending = false;
        Gdx.gl.glDisable(2884);
        this.blendDFactor = 0;
        this.blendSFactor = 0;
        this.cullFace = 0;
        this.textureBinder.begin();
    }

    public void end() {
        if (this.depthFunc != 0) {
            Gdx.gl.glDisable(2929);
        }
        if (!this.depthMask) {
            Gdx.gl.glDepthMask(true);
        }
        if (this.blending) {
            Gdx.gl.glDisable(3042);
        }
        if (this.cullFace > 0) {
            Gdx.gl.glDisable(2884);
        }
        this.textureBinder.end();
    }

    public void setBlending(boolean bl, int n, int n2) {
        if (bl != this.blending) {
            this.blending = bl;
            if (bl) {
                Gdx.gl.glEnable(3042);
            } else {
                Gdx.gl.glDisable(3042);
            }
        }
        if (bl && (this.blendSFactor != n || this.blendDFactor != n2)) {
            Gdx.gl.glBlendFunc(n, n2);
            this.blendSFactor = n;
            this.blendDFactor = n2;
        }
    }

    public void setCullFace(int n) {
        if (n != this.cullFace) {
            this.cullFace = n;
            if (n != 1028 && n != 1029 && n != 1032) {
                Gdx.gl.glDisable(2884);
            } else {
                Gdx.gl.glEnable(2884);
                Gdx.gl.glCullFace(n);
            }
        }
    }

    public void setDepthMask(boolean bl) {
        if (this.depthMask != bl) {
            GL20 gL20 = Gdx.gl;
            this.depthMask = bl;
            gL20.glDepthMask(bl);
        }
    }

    public void setDepthTest(int n) {
        this.setDepthTest(n, 0.0f, 1.0f);
    }

    public void setDepthTest(int n, float f, float f2) {
        int n2 = this.depthFunc;
        boolean bl = true;
        n2 = n2 != 0 ? 1 : 0;
        if (n == 0) {
            bl = false;
        }
        if (this.depthFunc != n) {
            this.depthFunc = n;
            if (bl) {
                Gdx.gl.glEnable(2929);
                Gdx.gl.glDepthFunc(n);
            } else {
                Gdx.gl.glDisable(2929);
            }
        }
        if (bl) {
            GL20 gL20;
            if (n2 == 0 || this.depthFunc != n) {
                gL20 = Gdx.gl;
                this.depthFunc = n;
                gL20.glDepthFunc(n);
            }
            if (n2 == 0 || this.depthRangeNear != f || this.depthRangeFar != f2) {
                gL20 = Gdx.gl;
                this.depthRangeNear = f;
                this.depthRangeFar = f2;
                gL20.glDepthRangef(f, f2);
            }
        }
    }
}

