/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import java.util.Comparator;

public class DefaultRenderableSorter
implements RenderableSorter,
Comparator<Renderable> {
    private Camera camera;
    private final Vector3 tmpV1 = new Vector3();
    private final Vector3 tmpV2 = new Vector3();

    private Vector3 getTranslation(Matrix4 matrix4, Vector3 vector3, Vector3 vector32) {
        if (vector3.isZero()) {
            matrix4.getTranslation(vector32);
        } else if (!matrix4.hasRotationOrScaling()) {
            matrix4.getTranslation(vector32).add(vector3);
        } else {
            vector32.set(vector3).mul(matrix4);
        }
        return vector32;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compare(Renderable renderable, Renderable renderable2) {
        void var6_8;
        boolean bl = renderable.material.has(BlendingAttribute.Type);
        int n2 = 0;
        int n3 = 1;
        if (bl && ((BlendingAttribute)renderable.material.get((long)BlendingAttribute.Type)).blended) {
            boolean n4 = true;
        } else {
            boolean bl2 = false;
        }
        int n = renderable2.material.has(BlendingAttribute.Type) && ((BlendingAttribute)renderable2.material.get((long)BlendingAttribute.Type)).blended ? 1 : 0;
        if (var6_8 != n) {
            n = var6_8 != false ? n3 : -1;
            return n;
        }
        this.getTranslation(renderable.worldTransform, renderable.meshPart.center, this.tmpV1);
        this.getTranslation(renderable2.worldTransform, renderable2.meshPart.center, this.tmpV2);
        float f = (int)(this.camera.position.dst2(this.tmpV1) * 1000.0f) - (int)(this.camera.position.dst2(this.tmpV2) * 1000.0f);
        if (f < 0.0f) {
            n = -1;
        } else {
            n = n2;
            if (f > 0.0f) {
                n = 1;
            }
        }
        n2 = n;
        if (var6_8 != false) {
            n2 = -n;
        }
        return n2;
    }

    @Override
    public void sort(Camera camera, Array<Renderable> array) {
        this.camera = camera;
        array.sort(this);
    }
}

