/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public class BaseAnimationController {
    private static final Transform tmpT;
    private static final ObjectMap<Node, Transform> transforms;
    private boolean applying = false;
    public final ModelInstance target;
    private final Pool<Transform> transformPool = new Pool<Transform>(){

        @Override
        protected Transform newObject() {
            return new Transform();
        }
    };

    static {
        transforms = new ObjectMap();
        tmpT = new Transform();
    }

    public BaseAnimationController(ModelInstance modelInstance) {
        this.target = modelInstance;
    }

    /*
     * WARNING - void declaration
     */
    protected static void applyAnimation(ObjectMap<Node, Transform> object, Pool<Transform> object22, float f, Animation object3, float f2) {
        void var4_6;
        Iterator<NodeAnimation> iterator;
        if (object == null) {
            object = ((Animation)((Object)iterator)).nodeAnimations.iterator();
            while (object.hasNext()) {
                BaseAnimationController.applyNodeAnimationDirectly(object.next(), (float)var4_6);
            }
        } else {
            void var2_4;
            Iterator iterator2 = ((ObjectMap)((Object)object)).keys().iterator();
            while (iterator2.hasNext()) {
                ((Node)iterator2.next()).isAnimated = false;
            }
            iterator = ((Animation)((Object)iterator)).nodeAnimations.iterator();
            while (iterator.hasNext()) {
                BaseAnimationController.applyNodeAnimationBlending(iterator.next(), (ObjectMap<Node, Transform>)((Object)object), (Pool<Transform>)object22, (float)var2_4, (float)var4_6);
            }
            for (ObjectMap.Entry entry : ((ObjectMap)((Object)object)).entries()) {
                if (((Node)entry.key).isAnimated) continue;
                ((Node)entry.key).isAnimated = true;
                ((Transform)entry.value).lerp(((Node)entry.key).translation, ((Node)entry.key).rotation, ((Node)entry.key).scale, (float)var2_4);
            }
        }
    }

    private static final void applyNodeAnimationBlending(NodeAnimation object, ObjectMap<Node, Transform> objectMap, Pool<Transform> pool, float f, float f2) {
        Node node = ((NodeAnimation)object).node;
        node.isAnimated = true;
        Transform transform = BaseAnimationController.getNodeAnimationTransform((NodeAnimation)object, f2);
        object = objectMap.get(node, null);
        if (object != null) {
            if (f > 0.999999f) {
                ((Transform)object).set(transform);
            } else {
                ((Transform)object).lerp(transform, f);
            }
        } else if (f > 0.999999f) {
            objectMap.put(node, pool.obtain().set(transform));
        } else {
            objectMap.put(node, pool.obtain().set(node.translation, node.rotation, node.scale).lerp(transform, f));
        }
    }

    private static final void applyNodeAnimationDirectly(NodeAnimation nodeAnimation, float f) {
        Node node = nodeAnimation.node;
        node.isAnimated = true;
        BaseAnimationController.getNodeAnimationTransform(nodeAnimation, f).toMatrix4(node.localTransform);
    }

    static final <T> int getFirstKeyframeIndexAtTime(Array<NodeKeyframe<T>> array, float f) {
        int n;
        block6: {
            int n2 = array.size - 1;
            int n3 = 0;
            int n4 = 0;
            n = n3;
            if (n2 > 0) {
                n = n3;
                if (!(f < array.get((int)0).keytime)) {
                    int n5 = n2;
                    if (f > array.get((int)n2).keytime) {
                        n = n3;
                    } else {
                        while (true) {
                            n = n4;
                            if (n4 >= n5) break block6;
                            n2 = (n4 + n5) / 2;
                            n = n2 + 1;
                            if (f > array.get((int)n).keytime) {
                                n4 = n;
                                continue;
                            }
                            if (!(f < array.get((int)n2).keytime)) break;
                            n5 = n2 - 1;
                        }
                        return n2;
                    }
                }
            }
        }
        return n;
    }

    private static final Transform getNodeAnimationTransform(NodeAnimation nodeAnimation, float f) {
        Transform transform = tmpT;
        BaseAnimationController.getTranslationAtTime(nodeAnimation, f, transform.translation);
        BaseAnimationController.getRotationAtTime(nodeAnimation, f, transform.rotation);
        BaseAnimationController.getScalingAtTime(nodeAnimation, f, transform.scale);
        return transform;
    }

    private static final Quaternion getRotationAtTime(NodeAnimation object, float f, Quaternion quaternion) {
        if (((NodeAnimation)object).rotation == null) {
            return quaternion.set(((NodeAnimation)object).node.rotation);
        }
        if (((NodeAnimation)object).rotation.size == 1) {
            return quaternion.set((Quaternion)((NodeAnimation)object).rotation.get((int)0).value);
        }
        int n = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).rotation, f);
        NodeKeyframe<Quaternion> nodeKeyframe = ((NodeAnimation)object).rotation.get(n);
        quaternion.set((Quaternion)nodeKeyframe.value);
        if (++n < ((NodeAnimation)object).rotation.size) {
            object = ((NodeAnimation)object).rotation.get(n);
            f = (f - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            quaternion.slerp((Quaternion)((NodeKeyframe)object).value, f);
        }
        return quaternion;
    }

    private static final Vector3 getScalingAtTime(NodeAnimation object, float f, Vector3 vector3) {
        if (((NodeAnimation)object).scaling == null) {
            return vector3.set(((NodeAnimation)object).node.scale);
        }
        if (((NodeAnimation)object).scaling.size == 1) {
            return vector3.set((Vector3)((NodeAnimation)object).scaling.get((int)0).value);
        }
        int n = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).scaling, f);
        NodeKeyframe<Vector3> nodeKeyframe = ((NodeAnimation)object).scaling.get(n);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n < ((NodeAnimation)object).scaling.size) {
            object = ((NodeAnimation)object).scaling.get(n);
            f = (f - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f);
        }
        return vector3;
    }

    private static final Vector3 getTranslationAtTime(NodeAnimation object, float f, Vector3 vector3) {
        if (((NodeAnimation)object).translation == null) {
            return vector3.set(((NodeAnimation)object).node.translation);
        }
        if (((NodeAnimation)object).translation.size == 1) {
            return vector3.set((Vector3)((NodeAnimation)object).translation.get((int)0).value);
        }
        int n = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).translation, f);
        NodeKeyframe<Vector3> nodeKeyframe = ((NodeAnimation)object).translation.get(n);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n < ((NodeAnimation)object).translation.size) {
            object = ((NodeAnimation)object).translation.get(n);
            f = (f - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f);
        }
        return vector3;
    }

    protected void apply(Animation animation, float f, float f2) {
        if (this.applying) {
            BaseAnimationController.applyAnimation(transforms, this.transformPool, f2, animation, f);
            return;
        }
        throw new GdxRuntimeException("You must call begin() before adding an animation");
    }

    protected void applyAnimation(Animation animation, float f) {
        if (!this.applying) {
            BaseAnimationController.applyAnimation(null, null, 1.0f, animation, f);
            this.target.calculateTransforms();
            return;
        }
        throw new GdxRuntimeException("Call end() first");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyAnimations(Animation animation, float f, Animation animation2, float f2, float f3) {
        if (animation2 != null && f3 != 0.0f) {
            if (animation != null && f3 != 1.0f) {
                if (this.applying) throw new GdxRuntimeException("Call end() first");
                this.begin();
                this.apply(animation, f, 1.0f);
                this.apply(animation2, f2, f3);
                this.end();
                return;
            } else {
                this.applyAnimation(animation2, f2);
            }
            return;
        } else {
            this.applyAnimation(animation, f);
        }
    }

    protected void begin() {
        if (!this.applying) {
            this.applying = true;
            return;
        }
        throw new GdxRuntimeException("You must call end() after each call to being()");
    }

    protected void end() {
        if (this.applying) {
            for (ObjectMap.Entry entry : transforms.entries()) {
                ((Transform)entry.value).toMatrix4(((Node)entry.key).localTransform);
                this.transformPool.free((Transform)entry.value);
            }
            transforms.clear();
            this.target.calculateTransforms();
            this.applying = false;
            return;
        }
        GdxRuntimeException gdxRuntimeException = new GdxRuntimeException("You must call begin() first");
        throw gdxRuntimeException;
    }

    protected void removeAnimation(Animation object) {
        object = ((Animation)object).nodeAnimations.iterator();
        while (object.hasNext()) {
            ((NodeAnimation)object.next()).node.isAnimated = false;
        }
    }

    public static final class Transform
    implements Pool.Poolable {
        public final Quaternion rotation;
        public final Vector3 scale;
        public final Vector3 translation = new Vector3();

        public Transform() {
            this.rotation = new Quaternion();
            this.scale = new Vector3(1.0f, 1.0f, 1.0f);
        }

        public Transform idt() {
            this.translation.set(0.0f, 0.0f, 0.0f);
            this.rotation.idt();
            this.scale.set(1.0f, 1.0f, 1.0f);
            return this;
        }

        public Transform lerp(Transform transform, float f) {
            return this.lerp(transform.translation, transform.rotation, transform.scale, f);
        }

        public Transform lerp(Vector3 vector3, Quaternion quaternion, Vector3 vector32, float f) {
            this.translation.lerp(vector3, f);
            this.rotation.slerp(quaternion, f);
            this.scale.lerp(vector32, f);
            return this;
        }

        @Override
        public void reset() {
            this.idt();
        }

        public Transform set(Transform transform) {
            return this.set(transform.translation, transform.rotation, transform.scale);
        }

        public Transform set(Vector3 vector3, Quaternion quaternion, Vector3 vector32) {
            this.translation.set(vector3);
            this.rotation.set(quaternion);
            this.scale.set(vector32);
            return this;
        }

        public Matrix4 toMatrix4(Matrix4 matrix4) {
            return matrix4.set(this.translation, this.rotation, this.scale);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.translation.toString());
            stringBuilder.append(" - ");
            stringBuilder.append(this.rotation.toString());
            stringBuilder.append(" - ");
            stringBuilder.append(this.scale.toString());
            return stringBuilder.toString();
        }
    }
}

