/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.particles.values.MeshSpawnShapeValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.CumulativeDistribution;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;

public final class WeightMeshSpawnShapeValue
extends MeshSpawnShapeValue {
    private CumulativeDistribution<MeshSpawnShapeValue.Triangle> distribution = new CumulativeDistribution();

    public WeightMeshSpawnShapeValue() {
    }

    public WeightMeshSpawnShapeValue(WeightMeshSpawnShapeValue weightMeshSpawnShapeValue) {
        super(weightMeshSpawnShapeValue);
        this.load(weightMeshSpawnShapeValue);
    }

    public void calculateWeights() {
        int n;
        this.distribution.clear();
        Object object = this.mesh.getVertexAttributes();
        int n2 = this.mesh.getNumIndices();
        Object object2 = this.mesh.getNumVertices();
        short s = (short)(((VertexAttributes)object).vertexSize / 4);
        short s2 = (short)(((VertexAttributes)object).findByUsage((int)1).offset / 4);
        float[] fArray = new float[object2 * s];
        this.mesh.getVertices(fArray);
        Object object3 = 0;
        if (n2 > 0) {
            object = new short[n2];
            this.mesh.getIndices((short[])object);
            for (n = object3; n < n2; n += 3) {
                reference var9_9 = object[n] * s + s2;
                object2 = object[n + 1] * s + s2;
                object3 = object[n + 2] * s + s2;
                float f = fArray[var9_9];
                float f2 = fArray[var9_9 + true];
                float f3 = fArray[var9_9 + 2];
                float f4 = fArray[object2];
                float f5 = fArray[object2 + 1];
                float f6 = fArray[object2 + 2];
                float f7 = fArray[object3];
                float f8 = fArray[object3 + 1];
                float f9 = fArray[object3 + 2];
                float f10 = Math.abs(((f5 - f8) * f + (f8 - f2) * f4 + (f2 - f5) * f7) / 2.0f);
                this.distribution.add(new MeshSpawnShapeValue.Triangle(f, f2, f3, f4, f5, f6, f7, f8, f9), f10);
            }
        } else {
            for (n = 0; n < object2; n += s) {
                object3 = n + s2;
                int n3 = object3 + s;
                n2 = n3 + s;
                float f = fArray[object3];
                float f11 = fArray[object3 + 1];
                float f12 = fArray[object3 + 2];
                float f13 = fArray[n3];
                float f14 = fArray[n3 + 1];
                float f15 = fArray[n3 + 2];
                float f16 = fArray[n2];
                float f17 = fArray[n2 + 1];
                float f18 = fArray[n2 + 2];
                float f19 = Math.abs(((f14 - f17) * f + (f17 - f11) * f13 + (f11 - f14) * f16) / 2.0f);
                this.distribution.add(new MeshSpawnShapeValue.Triangle(f, f11, f12, f13, f14, f15, f16, f17, f18), f19);
            }
        }
        this.distribution.generateNormalized();
    }

    @Override
    public SpawnShapeValue copy() {
        return new WeightMeshSpawnShapeValue(this);
    }

    @Override
    public void init() {
        this.calculateWeights();
    }

    @Override
    public void spawnAux(Vector3 vector3, float f) {
        MeshSpawnShapeValue.Triangle triangle = this.distribution.value();
        f = MathUtils.random();
        float f2 = MathUtils.random();
        vector3.set(triangle.x1 + (triangle.x2 - triangle.x1) * f + (triangle.x3 - triangle.x1) * f2, triangle.y1 + (triangle.y2 - triangle.y1) * f + (triangle.y3 - triangle.y1) * f2, triangle.z1 + f * (triangle.z2 - triangle.z1) + f2 * (triangle.z3 - triangle.z1));
    }
}

