/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.renderers;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.batches.ModelInstanceParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ModelInstanceControllerRenderData;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderer;

public class ModelInstanceRenderer
extends ParticleControllerRenderer<ModelInstanceControllerRenderData, ModelInstanceParticleBatch> {
    private boolean hasColor;
    private boolean hasRotation;
    private boolean hasScale;

    public ModelInstanceRenderer() {
        super(new ModelInstanceControllerRenderData());
    }

    public ModelInstanceRenderer(ModelInstanceParticleBatch modelInstanceParticleBatch) {
        this();
        this.setBatch(modelInstanceParticleBatch);
    }

    @Override
    public void allocateChannels() {
        ((ModelInstanceControllerRenderData)this.renderData).positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
    }

    @Override
    public ParticleControllerComponent copy() {
        return new ModelInstanceRenderer((ModelInstanceParticleBatch)this.batch);
    }

    @Override
    public void init() {
        ((ModelInstanceControllerRenderData)this.renderData).modelInstanceChannel = (ParallelArray.ObjectChannel)this.controller.particles.getChannel(ParticleChannels.ModelInstance);
        ((ModelInstanceControllerRenderData)this.renderData).colorChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Color);
        ((ModelInstanceControllerRenderData)this.renderData).scaleChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Scale);
        ((ModelInstanceControllerRenderData)this.renderData).rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Rotation3D);
        ParallelArray.FloatChannel floatChannel = ((ModelInstanceControllerRenderData)this.renderData).colorChannel;
        boolean bl = true;
        boolean bl2 = floatChannel != null;
        this.hasColor = bl2;
        bl2 = ((ModelInstanceControllerRenderData)this.renderData).scaleChannel != null;
        this.hasScale = bl2;
        bl2 = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel != null ? bl : false;
        this.hasRotation = bl2;
    }

    @Override
    public boolean isCompatible(ParticleBatch<?> particleBatch) {
        return particleBatch instanceof ModelInstanceParticleBatch;
    }

    @Override
    public void update() {
        int n = this.controller.particles.size;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            float f;
            float f2;
            float f3;
            float f4;
            int n4;
            Object object = ((ModelInstance[])((ModelInstanceControllerRenderData)this.renderData).modelInstanceChannel.data)[n2];
            float f5 = this.hasScale ? ((ModelInstanceControllerRenderData)this.renderData).scaleChannel.data[n2] : 1.0f;
            if (this.hasRotation) {
                n4 = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel.strideSize * n2;
                f4 = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel.data[n4 + 0];
                f3 = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel.data[n4 + 1];
                f2 = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel.data[n4 + 2];
                f = ((ModelInstanceControllerRenderData)this.renderData).rotationChannel.data[n4 + 3];
            } else {
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 1.0f;
            }
            ((ModelInstance)object).transform.set(((ModelInstanceControllerRenderData)this.renderData).positionChannel.data[n3 + 0], ((ModelInstanceControllerRenderData)this.renderData).positionChannel.data[n3 + 1], ((ModelInstanceControllerRenderData)this.renderData).positionChannel.data[n3 + 2], f4, f3, f2, f, f5, f5, f5);
            if (this.hasColor) {
                n4 = ((ModelInstanceControllerRenderData)this.renderData).colorChannel.strideSize * n2;
                ColorAttribute colorAttribute = (ColorAttribute)((ModelInstance)object).materials.get(0).get(ColorAttribute.Diffuse);
                object = (BlendingAttribute)((ModelInstance)object).materials.get(0).get(BlendingAttribute.Type);
                colorAttribute.color.r = ((ModelInstanceControllerRenderData)this.renderData).colorChannel.data[n4 + 0];
                colorAttribute.color.g = ((ModelInstanceControllerRenderData)this.renderData).colorChannel.data[n4 + 1];
                colorAttribute.color.b = ((ModelInstanceControllerRenderData)this.renderData).colorChannel.data[n4 + 2];
                if (object != null) {
                    ((BlendingAttribute)object).opacity = ((ModelInstanceControllerRenderData)this.renderData).colorChannel.data[n4 + 3];
                }
            }
            ++n2;
            n3 += ((ModelInstanceControllerRenderData)this.renderData).positionChannel.strideSize;
        }
        super.update();
    }
}

