/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.values.GradientColorValue;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class ColorInfluencer
extends Influencer {
    ParallelArray.FloatChannel colorChannel;

    @Override
    public void allocateChannels() {
        this.colorChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Color);
    }

    public static class Random
    extends ColorInfluencer {
        ParallelArray.FloatChannel colorChannel;

        @Override
        public void activateParticles(int n, int n2) {
            int n3 = n * this.colorChannel.strideSize;
            int n4 = this.colorChannel.strideSize;
            for (n = n3; n < n2 * n4 + n3; n += this.colorChannel.strideSize) {
                this.colorChannel.data[n + 0] = MathUtils.random();
                this.colorChannel.data[n + 1] = MathUtils.random();
                this.colorChannel.data[n + 2] = MathUtils.random();
                this.colorChannel.data[n + 3] = MathUtils.random();
            }
        }

        @Override
        public void allocateChannels() {
            this.colorChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Color);
        }

        @Override
        public Random copy() {
            return new Random();
        }
    }

    public static class Single
    extends ColorInfluencer {
        ParallelArray.FloatChannel alphaInterpolationChannel;
        public ScaledNumericValue alphaValue;
        public GradientColorValue colorValue = new GradientColorValue();
        ParallelArray.FloatChannel lifeChannel;

        public Single() {
            this.alphaValue = new ScaledNumericValue();
            this.alphaValue.setHigh(1.0f);
        }

        public Single(Single single) {
            this();
            this.set(single);
        }

        @Override
        public void activateParticles(int n, int n2) {
            int n3 = this.colorChannel.strideSize * n;
            int n4 = this.alphaInterpolationChannel.strideSize * n;
            int n5 = n * this.lifeChannel.strideSize + 2;
            int n6 = this.colorChannel.strideSize;
            n = n3;
            while (n < n2 * n6 + n3) {
                float f = this.alphaValue.newLowValue();
                float f2 = this.alphaValue.newHighValue() - f;
                this.colorValue.getColor(0.0f, this.colorChannel.data, n);
                this.colorChannel.data[n + 3] = this.alphaValue.getScale(this.lifeChannel.data[n5]) * f2 + f;
                this.alphaInterpolationChannel.data[n4 + 0] = f;
                this.alphaInterpolationChannel.data[n4 + 1] = f2;
                n += this.colorChannel.strideSize;
                n4 += this.alphaInterpolationChannel.strideSize;
                n5 += this.lifeChannel.strideSize;
            }
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            ParticleChannels.Interpolation.id = this.controller.particleChannels.newId();
            this.alphaInterpolationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation);
            this.lifeChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
        }

        @Override
        public Single copy() {
            return new Single(this);
        }

        @Override
        public void read(Json json, JsonValue jsonValue) {
            this.alphaValue = json.readValue("alpha", ScaledNumericValue.class, jsonValue);
            this.colorValue = json.readValue("color", GradientColorValue.class, jsonValue);
        }

        public void set(Single single) {
            this.colorValue.load(single.colorValue);
            this.alphaValue.load(single.alphaValue);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.colorChannel.strideSize;
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            while (n3 < n * n2 + 0) {
                float f = this.lifeChannel.data[n4];
                this.colorValue.getColor(f, this.colorChannel.data, n3);
                this.colorChannel.data[n3 + 3] = this.alphaInterpolationChannel.data[n5 + 0] + this.alphaInterpolationChannel.data[n5 + 1] * this.alphaValue.getScale(f);
                n3 += this.colorChannel.strideSize;
                n5 += this.alphaInterpolationChannel.strideSize;
                n4 += this.lifeChannel.strideSize;
            }
        }

        @Override
        public void write(Json json) {
            json.writeValue("alpha", this.alphaValue);
            json.writeValue("color", this.colorValue);
        }
    }
}

