/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ModelInstanceControllerRenderData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class ModelInstanceParticleBatch
implements ParticleBatch<ModelInstanceControllerRenderData> {
    int bufferedParticlesCount;
    Array<ModelInstanceControllerRenderData> controllersRenderData = new Array(false, 5);

    @Override
    public void begin() {
        this.controllersRenderData.clear();
        this.bufferedParticlesCount = 0;
    }

    @Override
    public void draw(ModelInstanceControllerRenderData modelInstanceControllerRenderData) {
        this.controllersRenderData.add(modelInstanceControllerRenderData);
        this.bufferedParticlesCount += modelInstanceControllerRenderData.controller.particles.size;
    }

    @Override
    public void end() {
    }

    public int getBufferedCount() {
        return this.bufferedParticlesCount;
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        for (ModelInstanceControllerRenderData modelInstanceControllerRenderData : this.controllersRenderData) {
            int n = modelInstanceControllerRenderData.controller.particles.size;
            for (int i = 0; i < n; ++i) {
                ((ModelInstance[])modelInstanceControllerRenderData.modelInstanceChannel.data)[i].getRenderables(array, pool);
            }
        }
    }

    @Override
    public void load(AssetManager assetManager, ResourceData resourceData) {
    }

    @Override
    public void save(AssetManager assetManager, ResourceData resourceData) {
    }
}

