/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.util.Iterator;

public class ResourceData<T>
implements Json.Serializable {
    private int currentLoadIndex = 0;
    private Array<SaveData> data;
    public T resource;
    Array<AssetData> sharedAssets;
    private ObjectMap<String, SaveData> uniqueData = new ObjectMap();

    public ResourceData() {
        this.data = new Array(true, 3, SaveData.class);
        this.sharedAssets = new Array();
    }

    public ResourceData(T t) {
        this();
        this.resource = t;
    }

    public SaveData createSaveData() {
        SaveData saveData = new SaveData(this);
        this.data.add(saveData);
        return saveData;
    }

    public SaveData createSaveData(String string2) {
        SaveData saveData = new SaveData(this);
        if (!this.uniqueData.containsKey(string2)) {
            this.uniqueData.put(string2, saveData);
            return saveData;
        }
        throw new RuntimeException("Key already used, data must be unique, use a different key");
    }

    <K> int getAssetData(String string2, Class<K> clazz) {
        Iterator<AssetData> iterator = this.sharedAssets.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AssetData assetData = iterator.next();
            if (assetData.filename.equals(string2) && assetData.type.equals(clazz)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Array<AssetDescriptor> getAssetDescriptors() {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        for (AssetData assetData : this.sharedAssets) {
            array.add(new AssetDescriptor(assetData.filename, assetData.type));
        }
        return array;
    }

    public Array<AssetData> getAssets() {
        return this.sharedAssets;
    }

    public SaveData getSaveData() {
        Array<SaveData> array = this.data;
        int n = this.currentLoadIndex;
        this.currentLoadIndex = n + 1;
        return array.get(n);
    }

    public SaveData getSaveData(String string2) {
        return this.uniqueData.get(string2);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.uniqueData = json.readValue("unique", ObjectMap.class, jsonValue);
        Iterator<SaveData> iterator = this.uniqueData.entries().iterator();
        while (iterator.hasNext()) {
            ((SaveData)((ObjectMap.Entry)iterator.next()).value).resources = this;
        }
        this.data = (Array)((Object)json.readValue("data", Array.class, SaveData.class, jsonValue));
        iterator = this.data.iterator();
        while (iterator.hasNext()) {
            iterator.next().resources = this;
        }
        this.sharedAssets.addAll((Array)((Object)json.readValue("assets", Array.class, AssetData.class, jsonValue)));
        this.resource = json.readValue("resource", null, jsonValue);
    }

    @Override
    public void write(Json json) {
        json.writeValue("unique", this.uniqueData, ObjectMap.class);
        json.writeValue("data", this.data, Array.class, SaveData.class);
        json.writeValue("assets", this.sharedAssets.toArray(AssetData.class), AssetData[].class);
        json.writeValue("resource", this.resource, null);
    }

    public static class AssetData<T>
    implements Json.Serializable {
        public String filename;
        public Class<T> type;

        public AssetData() {
        }

        public AssetData(String string2, Class<T> clazz) {
            this.filename = string2;
            this.type = clazz;
        }

        @Override
        public void read(Json json, JsonValue object) {
            this.filename = json.readValue("filename", String.class, (JsonValue)object);
            String string2 = json.readValue("type", String.class, (JsonValue)object);
            try {
                this.type = ClassReflection.forName(string2);
                return;
            }
            catch (ReflectionException reflectionException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Class not found: ");
                ((StringBuilder)object).append(string2);
                throw new GdxRuntimeException(((StringBuilder)object).toString(), reflectionException);
            }
        }

        @Override
        public void write(Json json) {
            json.writeValue("filename", this.filename);
            json.writeValue("type", this.type.getName());
        }
    }

    public static interface Configurable<T> {
        public void load(AssetManager var1, ResourceData<T> var2);

        public void save(AssetManager var1, ResourceData<T> var2);
    }

    public static class SaveData
    implements Json.Serializable {
        IntArray assets;
        ObjectMap<String, Object> data = new ObjectMap();
        private int loadIndex = 0;
        protected ResourceData resources;

        public SaveData() {
            this.assets = new IntArray();
        }

        public SaveData(ResourceData resourceData) {
            this.assets = new IntArray();
            this.resources = resourceData;
        }

        public <K> K load(String string2) {
            return (K)this.data.get(string2);
        }

        public AssetDescriptor loadAsset() {
            if (this.loadIndex == this.assets.size) {
                return null;
            }
            Object object = this.resources.sharedAssets;
            IntArray intArray = this.assets;
            int n = this.loadIndex;
            this.loadIndex = n + 1;
            object = ((Array)object).get(intArray.get(n));
            return new AssetDescriptor(((AssetData)object).filename, ((AssetData)object).type);
        }

        @Override
        public void read(Json json, JsonValue jsonValue) {
            this.data = json.readValue("data", ObjectMap.class, jsonValue);
            this.assets.addAll(json.readValue("indices", int[].class, jsonValue));
        }

        public void save(String string2, Object object) {
            this.data.put(string2, object);
        }

        public <K> void saveAsset(String string2, Class<K> clazz) {
            int n;
            int n2 = n = this.resources.getAssetData(string2, clazz);
            if (n == -1) {
                this.resources.sharedAssets.add(new AssetData<K>(string2, clazz));
                n2 = this.resources.sharedAssets.size - 1;
            }
            this.assets.add(n2);
        }

        @Override
        public void write(Json json) {
            json.writeValue("data", this.data, ObjectMap.class);
            json.writeValue("indices", this.assets.toArray(), int[].class);
        }
    }
}

