/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

public class MeshPart {
    private static final BoundingBox bounds = new BoundingBox();
    public final Vector3 center = new Vector3();
    public final Vector3 halfExtents = new Vector3();
    public String id;
    public Mesh mesh;
    public int offset;
    public int primitiveType;
    public float radius = -1.0f;
    public int size;

    public MeshPart() {
    }

    public MeshPart(MeshPart meshPart) {
        this.set(meshPart);
    }

    public MeshPart(String string2, Mesh mesh, int n, int n2, int n3) {
        this.set(string2, mesh, n, n2, n3);
    }

    public boolean equals(MeshPart meshPart) {
        boolean bl = meshPart == this || meshPart != null && meshPart.mesh == this.mesh && meshPart.primitiveType == this.primitiveType && meshPart.offset == this.offset && meshPart.size == this.size;
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MeshPart)) {
            return false;
        }
        return this.equals((MeshPart)object);
    }

    public void render(ShaderProgram shaderProgram) {
        this.mesh.render(shaderProgram, this.primitiveType, this.offset, this.size);
    }

    public void render(ShaderProgram shaderProgram, boolean bl) {
        this.mesh.render(shaderProgram, this.primitiveType, this.offset, this.size, bl);
    }

    public MeshPart set(MeshPart meshPart) {
        this.id = meshPart.id;
        this.mesh = meshPart.mesh;
        this.offset = meshPart.offset;
        this.size = meshPart.size;
        this.primitiveType = meshPart.primitiveType;
        this.center.set(meshPart.center);
        this.halfExtents.set(meshPart.halfExtents);
        this.radius = meshPart.radius;
        return this;
    }

    public MeshPart set(String string2, Mesh mesh, int n, int n2, int n3) {
        this.id = string2;
        this.mesh = mesh;
        this.offset = n;
        this.size = n2;
        this.primitiveType = n3;
        this.center.set(0.0f, 0.0f, 0.0f);
        this.halfExtents.set(0.0f, 0.0f, 0.0f);
        this.radius = -1.0f;
        return this;
    }

    public void update() {
        this.mesh.calculateBoundingBox(bounds, this.offset, this.size);
        bounds.getCenter(this.center);
        bounds.getDimensions(this.halfExtents).scl(0.5f);
        this.radius = this.halfExtents.len();
    }
}

