/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.environment;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.AmbientCubemap;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class SphericalHarmonics {
    private static final float[] coeff = new float[]{0.282095f, 0.488603f, 0.488603f, 0.488603f, 1.092548f, 1.092548f, 1.092548f, 0.315392f, 0.546274f};
    public final float[] data;

    public SphericalHarmonics() {
        this.data = new float[27];
    }

    public SphericalHarmonics(float[] fArray) {
        if (fArray.length == 27) {
            this.data = (float[])fArray.clone();
            return;
        }
        throw new GdxRuntimeException("Incorrect array size");
    }

    private static final float clamp(float f) {
        float f2;
        if (f < 0.0f) {
            f2 = 0.0f;
        } else {
            f2 = f;
            if (f > 1.0f) {
                f2 = 1.0f;
            }
        }
        return f2;
    }

    public SphericalHarmonics set(float f, float f2, float f3) {
        float[] fArray;
        for (int i = 0; i < (fArray = this.data).length; ++i) {
            int n = i + 1;
            fArray[i] = f;
            i = n + 1;
            fArray[n] = f2;
            fArray[i] = f3;
        }
        return this;
    }

    public SphericalHarmonics set(Color color2) {
        return this.set(color2.r, color2.g, color2.b);
    }

    public SphericalHarmonics set(AmbientCubemap ambientCubemap) {
        return this.set(ambientCubemap.data);
    }

    public SphericalHarmonics set(float[] fArray) {
        float[] fArray2;
        for (int i = 0; i < (fArray2 = this.data).length; ++i) {
            fArray2[i] = fArray[i];
        }
        return this;
    }
}

