/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.IndexArray;
import com.badlogic.gdx.graphics.glutils.IndexBufferObject;
import com.badlogic.gdx.graphics.glutils.IndexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.graphics.glutils.InstanceBufferObject;
import com.badlogic.gdx.graphics.glutils.InstanceData;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexArray;
import com.badlogic.gdx.graphics.glutils.VertexBufferObject;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectWithVAO;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

public class Mesh
implements Disposable {
    static final Map<Application, Array<Mesh>> meshes = new HashMap<Application, Array<Mesh>>();
    boolean autoBind = true;
    final IndexData indices;
    InstanceData instances;
    boolean isInstanced = false;
    final boolean isVertexArray;
    private final Vector3 tmpV = new Vector3();
    final VertexData vertices;

    public Mesh(VertexDataType vertexDataType, boolean bl, int n, int n2, VertexAttributes vertexAttributes) {
        int n3 = 1.$SwitchMap$com$badlogic$gdx$graphics$Mesh$VertexDataType[vertexDataType.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    this.vertices = new VertexArray(n, vertexAttributes);
                    this.indices = new IndexArray(n2);
                    this.isVertexArray = true;
                } else {
                    this.vertices = new VertexBufferObjectWithVAO(bl, n, vertexAttributes);
                    this.indices = new IndexBufferObjectSubData(bl, n2);
                    this.isVertexArray = false;
                }
            } else {
                this.vertices = new VertexBufferObjectSubData(bl, n, vertexAttributes);
                this.indices = new IndexBufferObjectSubData(bl, n2);
                this.isVertexArray = false;
            }
        } else {
            this.vertices = new VertexBufferObject(bl, n, vertexAttributes);
            this.indices = new IndexBufferObject(bl, n2);
            this.isVertexArray = false;
        }
        Mesh.addManagedMesh(Gdx.app, this);
    }

    public Mesh(VertexDataType vertexDataType, boolean bl, int n, int n2, VertexAttribute ... vertexAttributeArray) {
        this(vertexDataType, bl, n, n2, new VertexAttributes(vertexAttributeArray));
    }

    protected Mesh(VertexData vertexData, IndexData indexData, boolean bl) {
        this.vertices = vertexData;
        this.indices = indexData;
        this.isVertexArray = bl;
        Mesh.addManagedMesh(Gdx.app, this);
    }

    public Mesh(boolean bl, int n, int n2, VertexAttributes vertexAttributes) {
        this.vertices = this.makeVertexBuffer(bl, n, vertexAttributes);
        this.indices = new IndexBufferObject(bl, n2);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.app, this);
    }

    public Mesh(boolean bl, int n, int n2, VertexAttribute ... vertexAttributeArray) {
        this.vertices = this.makeVertexBuffer(bl, n, new VertexAttributes(vertexAttributeArray));
        this.indices = new IndexBufferObject(bl, n2);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.app, this);
    }

    public Mesh(boolean bl, boolean bl2, int n, int n2, VertexAttributes vertexAttributes) {
        this.vertices = this.makeVertexBuffer(bl, n, vertexAttributes);
        this.indices = new IndexBufferObject(bl2, n2);
        this.isVertexArray = false;
        Mesh.addManagedMesh(Gdx.app, this);
    }

    private static void addManagedMesh(Application application, Mesh mesh) {
        Array<Mesh> array;
        Array<Mesh> array2 = array = meshes.get(application);
        if (array == null) {
            array2 = new Array();
        }
        array2.add(mesh);
        meshes.put(application, array2);
    }

    public static void clearAllMeshes(Application application) {
        meshes.remove(application);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed meshes/app: { ");
        for (Application application : meshes.keySet()) {
            stringBuilder.append(Mesh.meshes.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static void invalidateAllMeshes(Application object) {
        if ((object = meshes.get(object)) == null) {
            return;
        }
        for (int i = 0; i < ((Array)object).size; ++i) {
            ((Mesh)((Array)object).get((int)i)).vertices.invalidate();
            ((Mesh)((Array)object).get((int)i)).indices.invalidate();
        }
    }

    private VertexData makeVertexBuffer(boolean bl, int n, VertexAttributes vertexAttributes) {
        if (Gdx.gl30 != null) {
            return new VertexBufferObjectWithVAO(bl, n, vertexAttributes);
        }
        return new VertexBufferObject(bl, n, vertexAttributes);
    }

    public static void transform(Matrix4 serializable, float[] fArray, int n, int n2, int n3, int n4, int n5) {
        if (n2 >= 0 && n3 >= 1 && n2 + n3 <= n) {
            if (n4 >= 0 && n5 >= 1 && (n4 + n5) * n <= fArray.length) {
                Vector3 vector3 = new Vector3();
                n2 += n4 * n;
                int n6 = 0;
                int n7 = 0;
                int n8 = n2;
                if (n3 != 1) {
                    n8 = n2;
                    if (n3 != 2) {
                        if (n3 == 3) {
                            for (n4 = n7; n4 < n5; ++n4) {
                                float f = fArray[n2];
                                n8 = n2 + 1;
                                float f2 = fArray[n8];
                                n3 = n2 + 2;
                                vector3.set(f, f2, fArray[n3]).mul((Matrix4)serializable);
                                fArray[n2] = vector3.x;
                                fArray[n8] = vector3.y;
                                fArray[n3] = vector3.z;
                                n2 += n;
                            }
                        }
                    } else {
                        for (n4 = n6; n4 < n5; ++n4) {
                            float f = fArray[n8];
                            n2 = n8 + 1;
                            vector3.set(f, fArray[n2], 0.0f).mul((Matrix4)serializable);
                            fArray[n8] = vector3.x;
                            fArray[n2] = vector3.y;
                            n8 += n;
                        }
                    }
                } else {
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector3.set(fArray[n8], 0.0f, 0.0f).mul((Matrix4)serializable);
                        fArray[n8] = vector3.x;
                        n8 += n;
                    }
                }
                return;
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("start = ");
            ((StringBuilder)serializable).append(n4);
            ((StringBuilder)serializable).append(", count = ");
            ((StringBuilder)serializable).append(n5);
            ((StringBuilder)serializable).append(", vertexSize = ");
            ((StringBuilder)serializable).append(n);
            ((StringBuilder)serializable).append(", length = ");
            ((StringBuilder)serializable).append(fArray.length);
            throw new IndexOutOfBoundsException(((StringBuilder)serializable).toString());
        }
        serializable = new IndexOutOfBoundsException();
        throw serializable;
    }

    public static void transformUV(Matrix3 serializable, float[] fArray, int n, int n2, int n3, int n4) {
        if (n3 >= 0 && n4 >= 1 && (n3 + n4) * n <= fArray.length) {
            Vector2 vector2 = new Vector2();
            n3 = n2 + n3 * n;
            for (n2 = 0; n2 < n4; ++n2) {
                float f = fArray[n3];
                int n5 = n3 + 1;
                vector2.set(f, fArray[n5]).mul((Matrix3)serializable);
                fArray[n3] = vector2.x;
                fArray[n5] = vector2.y;
                n3 += n;
            }
            return;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("start = ");
        ((StringBuilder)serializable).append(n3);
        ((StringBuilder)serializable).append(", count = ");
        ((StringBuilder)serializable).append(n4);
        ((StringBuilder)serializable).append(", vertexSize = ");
        ((StringBuilder)serializable).append(n);
        ((StringBuilder)serializable).append(", length = ");
        ((StringBuilder)serializable).append(fArray.length);
        serializable = new IndexOutOfBoundsException(((StringBuilder)serializable).toString());
        throw serializable;
    }

    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null);
    }

    public void bind(ShaderProgram shaderProgram, int[] nArray) {
        this.vertices.bind(shaderProgram, nArray);
        InstanceData instanceData = this.instances;
        if (instanceData != null && instanceData.getNumInstances() > 0) {
            this.instances.bind(shaderProgram, nArray);
        }
        if (this.indices.getNumIndices() > 0) {
            this.indices.bind();
        }
    }

    public BoundingBox calculateBoundingBox() {
        BoundingBox boundingBox = new BoundingBox();
        this.calculateBoundingBox(boundingBox);
        return boundingBox;
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, int n, int n2) {
        return this.extendBoundingBox(boundingBox.inf(), n, n2);
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, int n, int n2, Matrix4 matrix4) {
        return this.extendBoundingBox(boundingBox.inf(), n, n2, matrix4);
    }

    public void calculateBoundingBox(BoundingBox serializable) {
        int n = this.getNumVertices();
        if (n != 0) {
            int n2;
            FloatBuffer floatBuffer = this.vertices.getBuffer();
            ((BoundingBox)serializable).inf();
            VertexAttribute vertexAttribute = this.getVertexAttribute(1);
            int n3 = vertexAttribute.offset / 4;
            int n4 = this.vertices.getAttributes().vertexSize / 4;
            int n5 = vertexAttribute.numComponents;
            int n6 = 0;
            int n7 = 0;
            int n8 = n3;
            if (n5 != 1) {
                n8 = n3;
                if (n5 != 2) {
                    if (n5 == 3) {
                        for (n8 = n7; n8 < n; ++n8) {
                            ((BoundingBox)serializable).ext(floatBuffer.get(n3), floatBuffer.get(n3 + 1), floatBuffer.get(n3 + 2));
                            n3 += n4;
                        }
                    }
                } else {
                    for (n2 = n6; n2 < n; ++n2) {
                        ((BoundingBox)serializable).ext(floatBuffer.get(n8), floatBuffer.get(n8 + 1), 0.0f);
                        n8 += n4;
                    }
                }
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    ((BoundingBox)serializable).ext(floatBuffer.get(n8), 0.0f, 0.0f);
                    n8 += n4;
                }
            }
            return;
        }
        serializable = new GdxRuntimeException("No vertices defined");
        throw serializable;
    }

    public float calculateRadius(float f, float f2, float f3) {
        return this.calculateRadius(f, f2, f3, 0, this.getNumIndices(), null);
    }

    public float calculateRadius(float f, float f2, float f3, int n, int n2) {
        return this.calculateRadius(f, f2, f3, n, n2, null);
    }

    public float calculateRadius(float f, float f2, float f3, int n, int n2, Matrix4 matrix4) {
        return (float)Math.sqrt(this.calculateRadiusSquared(f, f2, f3, n, n2, matrix4));
    }

    public float calculateRadius(Vector3 vector3) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, 0, this.getNumIndices(), null);
    }

    public float calculateRadius(Vector3 vector3, int n, int n2) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, n, n2, null);
    }

    public float calculateRadius(Vector3 vector3, int n, int n2, Matrix4 matrix4) {
        return this.calculateRadius(vector3.x, vector3.y, vector3.z, n, n2, matrix4);
    }

    public float calculateRadiusSquared(float f, float f2, float f3, int n, int n2, Matrix4 serializable) {
        int n3;
        int n4 = this.getNumIndices();
        if (n >= 0 && n2 >= 1 && (n3 = n + n2) <= n4) {
            FloatBuffer floatBuffer = this.vertices.getBuffer();
            ShortBuffer shortBuffer = this.indices.getBuffer();
            VertexAttribute vertexAttribute = this.getVertexAttribute(1);
            n4 = vertexAttribute.offset / 4;
            int n5 = this.vertices.getAttributes().vertexSize / 4;
            n2 = vertexAttribute.numComponents;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        n2 = n;
                        n = n4;
                        while (true) {
                            f4 = f5;
                            if (n2 < n3) {
                                n4 = shortBuffer.get(n2) * n5 + n;
                                this.tmpV.set(floatBuffer.get(n4), floatBuffer.get(n4 + 1), floatBuffer.get(n4 + 2));
                                if (serializable != null) {
                                    this.tmpV.mul((Matrix4)serializable);
                                }
                                float f6 = this.tmpV.sub(f, f2, f3).len2();
                                f4 = f5;
                                if (f6 > f5) {
                                    f4 = f6;
                                }
                                ++n2;
                                f5 = f4;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    f4 = 0.0f;
                    while (n < n3) {
                        n2 = shortBuffer.get(n) * n5 + n4;
                        this.tmpV.set(floatBuffer.get(n2), floatBuffer.get(n2 + 1), 0.0f);
                        if (serializable != null) {
                            this.tmpV.mul((Matrix4)serializable);
                        }
                        float f7 = this.tmpV.sub(f, f2, f3).len2();
                        f5 = f4;
                        if (f7 > f4) {
                            f5 = f7;
                        }
                        ++n;
                        f4 = f5;
                    }
                }
            } else {
                f4 = 0.0f;
                while (n < n3) {
                    n2 = shortBuffer.get(n);
                    this.tmpV.set(floatBuffer.get(n2 * n5 + n4), 0.0f, 0.0f);
                    if (serializable != null) {
                        this.tmpV.mul((Matrix4)serializable);
                    }
                    float f8 = this.tmpV.sub(f, f2, f3).len2();
                    f5 = f4;
                    if (f8 > f4) {
                        f5 = f8;
                    }
                    ++n;
                    f4 = f5;
                }
            }
            return f4;
        }
        serializable = new GdxRuntimeException("Not enough indices");
        throw serializable;
    }

    public Mesh copy(boolean bl) {
        return this.copy(bl, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Mesh copy(boolean var1_1, boolean var2_2, int[] var3_3) {
        block26: {
            block27: {
                var4_4 = this.getVertexSize() / 4;
                var5_5 = this.getNumVertices();
                var6_6 = new float[var5_5 * var4_4];
                this.getVertices(0, var6_6.length, var6_6);
                var7_7 = null;
                if (var3_3 /* !! */  == null) ** GOTO lbl-1000
                var9_9 = 0;
                var10_10 = 0;
                for (var8_8 = 0; var8_8 < var3_3 /* !! */ .length; ++var8_8) {
                    var11_11 = var9_9;
                    var12_12 = var10_10;
                    if (this.getVertexAttribute(var3_3 /* !! */ [var8_8]) != null) {
                        var11_11 = var9_9 + this.getVertexAttribute((int)var3_3 /* !! */ [var8_8]).numComponents;
                        var12_12 = var10_10 + 1;
                    }
                    var9_9 = var11_11;
                    var10_10 = var12_12;
                }
                if (var9_9 > 0) {
                    var13_13 = new VertexAttribute[var10_10];
                    var14_14 = new short[var9_9];
                    var9_9 = 0;
                    var10_10 = 0;
                    var8_8 = -1;
                    var11_11 = -1;
                    while (true) {
                        var15_15 = var13_13;
                        var16_16 = var14_14;
                        var12_12 = var10_10;
                        if (var9_9 < var3_3 /* !! */ .length) {
                            var16_16 = this.getVertexAttribute(var3_3 /* !! */ [var9_9]);
                            if (var16_16 != null) {
                                for (var12_12 = 0; var12_12 < var16_16.numComponents; ++var12_12) {
                                    var14_14[++var8_8] = (short)(var16_16.offset + var12_12);
                                }
                                var13_13[++var11_11] = var16_16.copy();
                                var10_10 += var16_16.numComponents;
                            }
                            ++var9_9;
                            continue;
                        }
                        break;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    var16_16 = var15_15 = null;
                    var12_12 = 0;
                }
                var14_14 = var16_16;
                var9_9 = var12_12;
                if (var16_16 == null) {
                    var14_14 = new short[var4_4];
                    for (var10_10 = 0; var10_10 < var4_4; var10_10 = (int)((short)(var10_10 + 1))) {
                        var14_14[var10_10] = (short)var10_10;
                    }
                    var9_9 = var4_4;
                }
                var17_17 = this.getNumIndices();
                var10_10 = var5_5;
                var3_3 /* !! */  = (int[])var6_6;
                var16_16 = var7_7;
                if (var17_17 <= 0) break block26;
                var7_7 = new short[var17_17];
                this.getIndices(var7_7);
                if (var2_2) break block27;
                var10_10 = var5_5;
                var3_3 /* !! */  = (int[])var6_6;
                var16_16 = var7_7;
                if (var9_9 == var4_4) break block26;
            }
            var3_3 /* !! */  = (int[])new float[var6_6.length];
            var10_10 = 0;
            for (var11_11 = 0; var11_11 < var17_17; ++var11_11) {
                var18_18 = var7_7[var11_11] * var4_4;
                if (var2_2) {
                    var8_8 = 0;
                    var12_12 = -1;
                    while (true) {
                        var19_19 = 0;
                        var5_5 = var12_12;
                        if (var8_8 < var10_10) {
                            var5_5 = var12_12;
                            if (var12_12 < 0) {
                                var20_20 = true;
                                for (var5_5 = var19_19; var5_5 < var14_14.length && var20_20; ++var5_5) {
                                    if (var3_3 /* !! */ [var8_8 * var9_9 + var5_5] == var6_6[var18_18 + var14_14[var5_5]]) continue;
                                    var20_20 = false;
                                }
                                if (var20_20) {
                                    var12_12 = var8_8;
                                }
                                var8_8 = (short)(var8_8 + 1);
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    var5_5 = -1;
                }
                if (var5_5 > 0) {
                    var7_7[var11_11] = (short)var5_5;
                    continue;
                }
                for (var8_8 = 0; var8_8 < var14_14.length; ++var8_8) {
                    var3_3 /* !! */ [var10_10 * var9_9 + var8_8] = (int)var6_6[var14_14[var8_8] + var18_18];
                }
                var7_7[var11_11] = (short)var10_10;
                ++var10_10;
            }
            var16_16 = var7_7;
        }
        if (var15_15 == null) {
            var8_8 = var16_16 == null ? 0 : ((short[])var16_16).length;
            var15_15 = new Mesh(var1_1, var10_10, var8_8, this.getVertexAttributes());
        } else {
            var8_8 = var16_16 == null ? 0 : ((short[])var16_16).length;
            var15_15 = new Mesh(var1_1, var10_10, var8_8, (VertexAttribute[])var15_15);
        }
        var15_15.setVertices(var3_3 /* !! */ , 0, var10_10 * var9_9);
        if (var16_16 != null) {
            var15_15.setIndices((short[])var16_16);
        }
        return var15_15;
    }

    public Mesh disableInstancedRendering() {
        if (this.isInstanced) {
            this.isInstanced = false;
            this.instances.dispose();
            this.instances = null;
        }
        return this;
    }

    @Override
    public void dispose() {
        if (meshes.get(Gdx.app) != null) {
            meshes.get(Gdx.app).removeValue(this, true);
        }
        this.vertices.dispose();
        InstanceData instanceData = this.instances;
        if (instanceData != null) {
            instanceData.dispose();
        }
        this.indices.dispose();
    }

    public Mesh enableInstancedRendering(boolean bl, int n, VertexAttribute ... vertexAttributeArray) {
        if (!this.isInstanced) {
            this.isInstanced = true;
            this.instances = new InstanceBufferObject(bl, n, vertexAttributeArray);
            return this;
        }
        throw new GdxRuntimeException("Trying to enable InstancedRendering on same Mesh instance twice. Use disableInstancedRendering to clean up old InstanceData first");
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox, int n, int n2) {
        return this.extendBoundingBox(boundingBox, n, n2, null);
    }

    public BoundingBox extendBoundingBox(BoundingBox serializable, int n, int n2, Matrix4 matrix4) {
        int n3;
        int n4 = this.getNumIndices();
        int n5 = this.getNumVertices();
        if (n4 != 0) {
            n5 = n4;
        }
        if (n >= 0 && n2 >= 1 && (n3 = n + n2) <= n5) {
            FloatBuffer floatBuffer = this.vertices.getBuffer();
            ShortBuffer shortBuffer = this.indices.getBuffer();
            VertexAttribute vertexAttribute = this.getVertexAttribute(1);
            int n6 = vertexAttribute.offset / 4;
            n5 = this.vertices.getAttributes().vertexSize / 4;
            n2 = vertexAttribute.numComponents;
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        if (n4 > 0) {
                            while (n < n3) {
                                n2 = shortBuffer.get(n) * n5 + n6;
                                this.tmpV.set(floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2));
                                if (matrix4 != null) {
                                    this.tmpV.mul(matrix4);
                                }
                                ((BoundingBox)serializable).ext(this.tmpV);
                                ++n;
                            }
                        } else {
                            for (n2 = n; n2 < n3; ++n2) {
                                n = n2 * n5 + n6;
                                this.tmpV.set(floatBuffer.get(n), floatBuffer.get(n + 1), floatBuffer.get(n + 2));
                                if (matrix4 != null) {
                                    this.tmpV.mul(matrix4);
                                }
                                ((BoundingBox)serializable).ext(this.tmpV);
                            }
                        }
                    }
                } else if (n4 > 0) {
                    while (n < n3) {
                        n2 = shortBuffer.get(n) * n5 + n6;
                        this.tmpV.set(floatBuffer.get(n2), floatBuffer.get(n2 + 1), 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        ((BoundingBox)serializable).ext(this.tmpV);
                        ++n;
                    }
                } else {
                    for (n2 = n; n2 < n3; ++n2) {
                        n = n2 * n5 + n6;
                        this.tmpV.set(floatBuffer.get(n), floatBuffer.get(n + 1), 0.0f);
                        if (matrix4 != null) {
                            this.tmpV.mul(matrix4);
                        }
                        ((BoundingBox)serializable).ext(this.tmpV);
                    }
                }
            } else if (n4 > 0) {
                while (n < n3) {
                    n2 = shortBuffer.get(n);
                    this.tmpV.set(floatBuffer.get(n2 * n5 + n6), 0.0f, 0.0f);
                    if (matrix4 != null) {
                        this.tmpV.mul(matrix4);
                    }
                    ((BoundingBox)serializable).ext(this.tmpV);
                    ++n;
                }
            } else {
                for (n2 = n; n2 < n3; ++n2) {
                    this.tmpV.set(floatBuffer.get(n2 * n5 + n6), 0.0f, 0.0f);
                    if (matrix4 != null) {
                        this.tmpV.mul(matrix4);
                    }
                    ((BoundingBox)serializable).ext(this.tmpV);
                }
            }
            return serializable;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Invalid part specified ( offset=");
        ((StringBuilder)serializable).append(n);
        ((StringBuilder)serializable).append(", count=");
        ((StringBuilder)serializable).append(n2);
        ((StringBuilder)serializable).append(", max=");
        ((StringBuilder)serializable).append(n5);
        ((StringBuilder)serializable).append(" )");
        serializable = new GdxRuntimeException(((StringBuilder)serializable).toString());
        throw serializable;
    }

    public void getIndices(int n, int n2, short[] object, int n3) {
        int n4 = this.getNumIndices();
        int n5 = n2;
        if (n2 < 0) {
            n5 = n4 - n;
        }
        if (n >= 0 && n < n4 && n + n5 <= n4) {
            if (((Object)object).length - n3 >= n5) {
                n2 = this.getIndicesBuffer().position();
                this.getIndicesBuffer().position(n);
                this.getIndicesBuffer().get((short[])object, n3, n5);
                this.getIndicesBuffer().position(n2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("not enough room in indices array, has ");
            stringBuilder.append(((Object)object).length);
            stringBuilder.append(" shorts, needs ");
            stringBuilder.append(n5);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid range specified, offset: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(", count: ");
        ((StringBuilder)object).append(n5);
        ((StringBuilder)object).append(", max: ");
        ((StringBuilder)object).append(n4);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public void getIndices(int n, short[] sArray, int n2) {
        this.getIndices(n, -1, sArray, n2);
    }

    public void getIndices(short[] sArray) {
        this.getIndices(sArray, 0);
    }

    public void getIndices(short[] sArray, int n) {
        this.getIndices(0, sArray, n);
    }

    public ShortBuffer getIndicesBuffer() {
        return this.indices.getBuffer();
    }

    public int getMaxIndices() {
        return this.indices.getNumMaxIndices();
    }

    public int getMaxVertices() {
        return this.vertices.getNumMaxVertices();
    }

    public int getNumIndices() {
        return this.indices.getNumIndices();
    }

    public int getNumVertices() {
        return this.vertices.getNumVertices();
    }

    public VertexAttribute getVertexAttribute(int n) {
        VertexAttributes vertexAttributes = this.vertices.getAttributes();
        int n2 = vertexAttributes.size();
        for (int i = 0; i < n2; ++i) {
            if (vertexAttributes.get((int)i).usage != n) continue;
            return vertexAttributes.get(i);
        }
        return null;
    }

    public VertexAttributes getVertexAttributes() {
        return this.vertices.getAttributes();
    }

    public int getVertexSize() {
        return this.vertices.getAttributes().vertexSize;
    }

    public float[] getVertices(int n, int n2, float[] fArray) {
        return this.getVertices(n, n2, fArray, 0);
    }

    public float[] getVertices(int n, int n2, float[] fArray, int n3) {
        int n4 = this.getNumVertices() * this.getVertexSize() / 4;
        int n5 = n2;
        if (n2 == -1) {
            n5 = n2 = n4 - n;
            if (n2 > fArray.length - n3) {
                n5 = fArray.length - n3;
            }
        }
        if (n >= 0 && n5 > 0 && n + n5 <= n4 && n3 >= 0 && n3 < fArray.length) {
            if (fArray.length - n3 >= n5) {
                n2 = this.getVerticesBuffer().position();
                this.getVerticesBuffer().position(n);
                this.getVerticesBuffer().get(fArray, n3, n5);
                this.getVerticesBuffer().position(n2);
                return fArray;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("not enough room in vertices array, has ");
            stringBuilder.append(fArray.length);
            stringBuilder.append(" floats, needs ");
            stringBuilder.append(n5);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        throw new IndexOutOfBoundsException();
    }

    public float[] getVertices(int n, float[] fArray) {
        return this.getVertices(n, -1, fArray);
    }

    public float[] getVertices(float[] fArray) {
        return this.getVertices(0, -1, fArray);
    }

    public FloatBuffer getVerticesBuffer() {
        return this.vertices.getBuffer();
    }

    public void render(ShaderProgram shaderProgram, int n) {
        int n2 = this.indices.getNumMaxIndices() > 0 ? this.getNumIndices() : this.getNumVertices();
        this.render(shaderProgram, n, 0, n2, this.autoBind);
    }

    public void render(ShaderProgram shaderProgram, int n, int n2, int n3) {
        this.render(shaderProgram, n, n2, n3, this.autoBind);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(ShaderProgram object, int n, int n2, int n3, boolean bl) {
        if (n3 == 0) {
            return;
        }
        if (bl) {
            this.bind((ShaderProgram)object);
        }
        if (this.isVertexArray) {
            if (this.indices.getNumIndices() > 0) {
                ShortBuffer shortBuffer = this.indices.getBuffer();
                int n4 = shortBuffer.position();
                int n5 = shortBuffer.limit();
                shortBuffer.position(n2);
                shortBuffer.limit(n2 + n3);
                Gdx.gl20.glDrawElements(n, n3, 5123, shortBuffer);
                shortBuffer.position(n4);
                shortBuffer.limit(n5);
            } else {
                Gdx.gl20.glDrawArrays(n, n2, n3);
            }
        } else {
            int n6 = this.isInstanced ? this.instances.getNumInstances() : 0;
            if (this.indices.getNumIndices() > 0) {
                if (n3 + n2 > this.indices.getNumMaxIndices()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Mesh attempting to access memory outside of the index buffer (count: ");
                    ((StringBuilder)object).append(n3);
                    ((StringBuilder)object).append(", offset: ");
                    ((StringBuilder)object).append(n2);
                    ((StringBuilder)object).append(", max: ");
                    ((StringBuilder)object).append(this.indices.getNumMaxIndices());
                    ((StringBuilder)object).append(")");
                    throw new GdxRuntimeException(((StringBuilder)object).toString());
                }
                if (this.isInstanced && n6 > 0) {
                    Gdx.gl30.glDrawElementsInstanced(n, n3, 5123, n2 * 2, n6);
                } else {
                    Gdx.gl20.glDrawElements(n, n3, 5123, n2 * 2);
                }
            } else if (this.isInstanced && n6 > 0) {
                Gdx.gl30.glDrawArraysInstanced(n, n2, n3, n6);
            } else {
                Gdx.gl20.glDrawArrays(n, n2, n3);
            }
        }
        if (bl) {
            this.unbind((ShaderProgram)object);
        }
    }

    public void scale(float f, float f2, float f3) {
        int n;
        Object object = this.getVertexAttribute(1);
        int n2 = ((VertexAttribute)object).offset / 4;
        int n3 = ((VertexAttribute)object).numComponents;
        int n4 = this.getNumVertices();
        int n5 = this.getVertexSize() / 4;
        object = new float[n4 * n5];
        this.getVertices((float[])object);
        int n6 = 0;
        int n7 = 0;
        int n8 = n2;
        if (n3 != 1) {
            n8 = n2;
            if (n3 != 2) {
                if (n3 == 3) {
                    for (n8 = n7; n8 < n4; ++n8) {
                        object[n2] = object[n2] * f;
                        n = n2 + 1;
                        object[n] = object[n] * f2;
                        n = n2 + 2;
                        object[n] = object[n] * f3;
                        n2 += n5;
                    }
                }
            } else {
                for (n = n6; n < n4; ++n) {
                    object[n8] = object[n8] * f;
                    n2 = n8 + 1;
                    object[n2] = object[n2] * f2;
                    n8 += n5;
                }
            }
        } else {
            for (n = 0; n < n4; ++n) {
                object[n8] = object[n8] * f;
                n8 += n5;
            }
        }
        this.setVertices((float[])object);
    }

    public void setAutoBind(boolean bl) {
        this.autoBind = bl;
    }

    public Mesh setIndices(short[] sArray) {
        this.indices.setIndices(sArray, 0, sArray.length);
        return this;
    }

    public Mesh setIndices(short[] sArray, int n, int n2) {
        this.indices.setIndices(sArray, n, n2);
        return this;
    }

    public Mesh setInstanceData(FloatBuffer floatBuffer) {
        InstanceData instanceData = this.instances;
        if (instanceData != null) {
            instanceData.setInstanceData(floatBuffer, floatBuffer.limit());
            return this;
        }
        throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
    }

    public Mesh setInstanceData(FloatBuffer floatBuffer, int n) {
        InstanceData instanceData = this.instances;
        if (instanceData != null) {
            instanceData.setInstanceData(floatBuffer, n);
            return this;
        }
        throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
    }

    public Mesh setInstanceData(float[] fArray) {
        InstanceData instanceData = this.instances;
        if (instanceData != null) {
            instanceData.setInstanceData(fArray, 0, fArray.length);
            return this;
        }
        throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
    }

    public Mesh setInstanceData(float[] fArray, int n, int n2) {
        InstanceData instanceData = this.instances;
        if (instanceData != null) {
            instanceData.setInstanceData(fArray, n, n2);
            return this;
        }
        throw new GdxRuntimeException("An InstanceBufferObject must be set before setting instance data!");
    }

    public Mesh setVertices(float[] fArray) {
        this.vertices.setVertices(fArray, 0, fArray.length);
        return this;
    }

    public Mesh setVertices(float[] fArray, int n, int n2) {
        this.vertices.setVertices(fArray, n, n2);
        return this;
    }

    public void transform(Matrix4 matrix4) {
        this.transform(matrix4, 0, this.getNumVertices());
    }

    public void transform(Matrix4 matrix4, int n, int n2) {
        Object object = this.getVertexAttribute(1);
        int n3 = ((VertexAttribute)object).offset / 4;
        int n4 = this.getVertexSize() / 4;
        int n5 = ((VertexAttribute)object).numComponents;
        this.getNumVertices();
        int n6 = n2 * n4;
        object = new float[n6];
        this.getVertices(n *= n4, n6, (float[])object);
        Mesh.transform(matrix4, (float[])object, n4, n3, n5, 0, n2);
        this.updateVertices(n, (float[])object);
    }

    public void transformUV(Matrix3 matrix3) {
        this.transformUV(matrix3, 0, this.getNumVertices());
    }

    protected void transformUV(Matrix3 matrix3, int n, int n2) {
        int n3 = this.getVertexAttribute((int)16).offset / 4;
        int n4 = this.getVertexSize() / 4;
        float[] fArray = new float[this.getNumVertices() * n4];
        this.getVertices(0, fArray.length, fArray);
        Mesh.transformUV(matrix3, fArray, n4, n3, n, n2);
        this.setVertices(fArray, 0, fArray.length);
    }

    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null);
    }

    public void unbind(ShaderProgram shaderProgram, int[] nArray) {
        this.vertices.unbind(shaderProgram, nArray);
        InstanceData instanceData = this.instances;
        if (instanceData != null && instanceData.getNumInstances() > 0) {
            this.instances.unbind(shaderProgram, nArray);
        }
        if (this.indices.getNumIndices() > 0) {
            this.indices.unbind();
        }
    }

    public Mesh updateInstanceData(int n, FloatBuffer floatBuffer) {
        return this.updateInstanceData(n, floatBuffer, 0, floatBuffer.limit());
    }

    public Mesh updateInstanceData(int n, FloatBuffer floatBuffer, int n2, int n3) {
        this.instances.updateInstanceData(n, floatBuffer, n2, n3);
        return this;
    }

    public Mesh updateInstanceData(int n, float[] fArray) {
        return this.updateInstanceData(n, fArray, 0, fArray.length);
    }

    public Mesh updateInstanceData(int n, float[] fArray, int n2, int n3) {
        this.instances.updateInstanceData(n, fArray, n2, n3);
        return this;
    }

    public Mesh updateVertices(int n, float[] fArray) {
        return this.updateVertices(n, fArray, 0, fArray.length);
    }

    public Mesh updateVertices(int n, float[] fArray, int n2, int n3) {
        this.vertices.updateVertices(n, fArray, n2, n3);
        return this;
    }

    public static enum VertexDataType {
        VertexArray,
        VertexBufferObject,
        VertexBufferObjectSubData,
        VertexBufferObjectWithVAO;

    }
}

