/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.SharedPreferences;
import android.os.Build;
import com.badlogic.gdx.Preferences;
import java.util.Map;

public class AndroidPreferences
implements Preferences {
    SharedPreferences.Editor editor;
    SharedPreferences sharedPrefs;

    public AndroidPreferences(SharedPreferences sharedPreferences) {
        this.sharedPrefs = sharedPreferences;
    }

    private void edit() {
        if (this.editor == null) {
            this.editor = this.sharedPrefs.edit();
        }
    }

    @Override
    public void clear() {
        this.edit();
        this.editor.clear();
    }

    @Override
    public boolean contains(String string2) {
        return this.sharedPrefs.contains(string2);
    }

    @Override
    public void flush() {
        if (this.editor != null) {
            if (Build.VERSION.SDK_INT >= 9) {
                this.editor.apply();
            } else {
                this.editor.commit();
            }
            this.editor = null;
        }
    }

    @Override
    public Map<String, ?> get() {
        return this.sharedPrefs.getAll();
    }

    @Override
    public boolean getBoolean(String string2) {
        return this.sharedPrefs.getBoolean(string2, false);
    }

    @Override
    public boolean getBoolean(String string2, boolean bl) {
        return this.sharedPrefs.getBoolean(string2, bl);
    }

    @Override
    public float getFloat(String string2) {
        return this.sharedPrefs.getFloat(string2, 0.0f);
    }

    @Override
    public float getFloat(String string2, float f) {
        return this.sharedPrefs.getFloat(string2, f);
    }

    @Override
    public int getInteger(String string2) {
        return this.sharedPrefs.getInt(string2, 0);
    }

    @Override
    public int getInteger(String string2, int n) {
        return this.sharedPrefs.getInt(string2, n);
    }

    @Override
    public long getLong(String string2) {
        return this.sharedPrefs.getLong(string2, 0L);
    }

    @Override
    public long getLong(String string2, long l) {
        return this.sharedPrefs.getLong(string2, l);
    }

    @Override
    public String getString(String string2) {
        return this.sharedPrefs.getString(string2, "");
    }

    @Override
    public String getString(String string2, String string3) {
        return this.sharedPrefs.getString(string2, string3);
    }

    @Override
    public Preferences put(Map<String, ?> object) {
        this.edit();
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                this.putBoolean((String)entry.getKey(), (Boolean)entry.getValue());
            }
            if (entry.getValue() instanceof Integer) {
                this.putInteger((String)entry.getKey(), (Integer)entry.getValue());
            }
            if (entry.getValue() instanceof Long) {
                this.putLong((String)entry.getKey(), (Long)entry.getValue());
            }
            if (entry.getValue() instanceof String) {
                this.putString((String)entry.getKey(), (String)entry.getValue());
            }
            if (!(entry.getValue() instanceof Float)) continue;
            this.putFloat((String)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
        return this;
    }

    @Override
    public Preferences putBoolean(String string2, boolean bl) {
        this.edit();
        this.editor.putBoolean(string2, bl);
        return this;
    }

    @Override
    public Preferences putFloat(String string2, float f) {
        this.edit();
        this.editor.putFloat(string2, f);
        return this;
    }

    @Override
    public Preferences putInteger(String string2, int n) {
        this.edit();
        this.editor.putInt(string2, n);
        return this;
    }

    @Override
    public Preferences putLong(String string2, long l) {
        this.edit();
        this.editor.putLong(string2, l);
        return this;
    }

    @Override
    public Preferences putString(String string2, String string3) {
        this.edit();
        this.editor.putString(string2, string3);
        return this;
    }

    @Override
    public void remove(String string2) {
        this.edit();
        this.editor.remove(string2);
    }
}

