/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.InputFilter;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.backends.android.AndroidInput;

class AndroidOnscreenKeyboard
implements View.OnKeyListener,
View.OnTouchListener {
    final Context context;
    Dialog dialog;
    final Handler handler;
    final AndroidInput input;
    TextView textView;

    public AndroidOnscreenKeyboard(Context context, Handler handler, AndroidInput androidInput) {
        this.context = context;
        this.handler = handler;
        this.input = androidInput;
    }

    public static TextView createView(Context context) {
        return new TextView(context){
            Editable editable = new PassThroughEditable();

            protected boolean getDefaultEditable() {
                return true;
            }

            protected MovementMethod getDefaultMovementMethod() {
                return ArrowKeyMovementMethod.getInstance();
            }

            public Editable getEditableText() {
                return this.editable;
            }

            public boolean onKeyDown(int n, KeyEvent keyEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("down keycode: ");
                stringBuilder.append(keyEvent.getKeyCode());
                Log.d((String)"Test", (String)stringBuilder.toString());
                return super.onKeyDown(n, keyEvent);
            }

            public boolean onKeyUp(int n, KeyEvent keyEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("up keycode: ");
                stringBuilder.append(keyEvent.getKeyCode());
                Log.d((String)"Test", (String)stringBuilder.toString());
                return super.onKeyUp(n, keyEvent);
            }
        };
    }

    Dialog createDialog() {
        this.textView = AndroidOnscreenKeyboard.createView(this.context);
        this.textView.setOnKeyListener((View.OnKeyListener)this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2, 80);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.textView.setFocusable(true);
        this.textView.setFocusableInTouchMode(true);
        layoutParams = this.textView;
        layoutParams.setImeOptions(layoutParams.getImeOptions() | 0x10000000);
        layoutParams = new FrameLayout(this.context);
        layoutParams.setLayoutParams(new ViewGroup.LayoutParams(-1, 0));
        layoutParams.addView((View)this.textView);
        layoutParams.setOnTouchListener((View.OnTouchListener)this);
        this.dialog = new Dialog(this.context, 0x1030011);
        this.dialog.setContentView((View)layoutParams);
        return this.dialog;
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return false;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return false;
    }

    public void setVisible(boolean bl) {
        Dialog dialog;
        if (bl && (dialog = this.dialog) != null) {
            dialog.dismiss();
            this.dialog = null;
        }
        if (bl && this.dialog == null && !this.input.isPeripheralAvailable(Input.Peripheral.HardwareKeyboard)) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidOnscreenKeyboard androidOnscreenKeyboard = AndroidOnscreenKeyboard.this;
                    androidOnscreenKeyboard.dialog = androidOnscreenKeyboard.createDialog();
                    AndroidOnscreenKeyboard.this.dialog.show();
                    AndroidOnscreenKeyboard.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            AndroidOnscreenKeyboard.this.dialog.getWindow().setSoftInputMode(32);
                            InputMethodManager inputMethodManager = (InputMethodManager)AndroidOnscreenKeyboard.this.context.getSystemService("input_method");
                            if (inputMethodManager != null) {
                                inputMethodManager.showSoftInput((View)AndroidOnscreenKeyboard.this.textView, 2);
                            }
                        }
                    });
                    androidOnscreenKeyboard = AndroidOnscreenKeyboard.this.dialog.getWindow().findViewById(0x1020002);
                    androidOnscreenKeyboard.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener((View)androidOnscreenKeyboard){
                        private int keyboardHeight;
                        private boolean keyboardShowing;
                        int[] screenloc = new int[2];
                        final /* synthetic */ View val$content;
                        {
                            this.val$content = view;
                        }

                        public boolean onPreDraw() {
                            this.val$content.getLocationOnScreen(this.screenloc);
                            this.keyboardHeight = Math.abs(this.screenloc[1]);
                            if (this.keyboardHeight > 0) {
                                this.keyboardShowing = true;
                            }
                            if (this.keyboardHeight == 0 && this.keyboardShowing) {
                                AndroidOnscreenKeyboard.this.dialog.dismiss();
                                AndroidOnscreenKeyboard.this.dialog = null;
                            }
                            return true;
                        }
                    });
                }
            });
        } else if (!bl && (dialog = this.dialog) != null) {
            dialog.dismiss();
        }
    }

    public static class PassThroughEditable
    implements Editable {
        public Editable append(char c) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("append: ");
            stringBuilder.append(c);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public Editable append(CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("append: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public Editable append(CharSequence charSequence, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("append: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public char charAt(int n) {
            Log.d((String)"Editable", (String)"charAt");
            return '\u0000';
        }

        public void clear() {
            Log.d((String)"Editable", (String)"clear");
        }

        public void clearSpans() {
            Log.d((String)"Editable", (String)"clearSpanes");
        }

        public Editable delete(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("delete, ");
            stringBuilder.append(n);
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            Log.d((String)"Editable", (String)"getChars");
        }

        public InputFilter[] getFilters() {
            Log.d((String)"Editable", (String)"getFilters");
            return new InputFilter[0];
        }

        public int getSpanEnd(Object object) {
            Log.d((String)"Editable", (String)"getSpanEnd");
            return 0;
        }

        public int getSpanFlags(Object object) {
            Log.d((String)"Editable", (String)"getSpanFlags");
            return 0;
        }

        public int getSpanStart(Object object) {
            Log.d((String)"Editable", (String)"getSpanStart");
            return 0;
        }

        public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
            Log.d((String)"Editable", (String)"getSpans");
            return null;
        }

        public Editable insert(int n, CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public Editable insert(int n, CharSequence charSequence, int n2, int n3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public int length() {
            Log.d((String)"Editable", (String)"length");
            return 0;
        }

        public int nextSpanTransition(int n, int n2, Class clazz) {
            Log.d((String)"Editable", (String)"nextSpanTransition");
            return 0;
        }

        public void removeSpan(Object object) {
            Log.d((String)"Editable", (String)"removeSpan");
        }

        public Editable replace(int n, int n2, CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("replace: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public Editable replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("replace: ");
            stringBuilder.append((Object)charSequence);
            Log.d((String)"Editable", (String)stringBuilder.toString());
            return this;
        }

        public void setFilters(InputFilter[] inputFilterArray) {
            Log.d((String)"Editable", (String)"setFilters");
        }

        public void setSpan(Object object, int n, int n2, int n3) {
            Log.d((String)"Editable", (String)"setSpan");
        }

        public CharSequence subSequence(int n, int n2) {
            Log.d((String)"Editable", (String)"subSequence");
            return null;
        }
    }
}

