/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidApplicationLogger;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidEventListener;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SnapshotArray;

public class AndroidFragmentApplication
extends Fragment
implements AndroidApplicationBase {
    private final Array<AndroidEventListener> androidEventListeners;
    protected ApplicationLogger applicationLogger;
    protected AndroidAudio audio;
    protected Callbacks callbacks;
    protected AndroidClipboard clipboard;
    protected final Array<Runnable> executedRunnables;
    protected AndroidFiles files;
    protected boolean firstResume = true;
    protected AndroidGraphics graphics;
    public Handler handler;
    protected AndroidInput input;
    protected final SnapshotArray<LifecycleListener> lifecycleListeners;
    protected ApplicationListener listener;
    protected int logLevel = 2;
    protected AndroidNet net;
    protected final Array<Runnable> runnables = new Array();

    static {
        GdxNativesLoader.load();
    }

    public AndroidFragmentApplication() {
        this.executedRunnables = new Array();
        this.lifecycleListeners = new SnapshotArray(LifecycleListener.class);
        this.androidEventListeners = new Array();
    }

    private boolean isAnyParentFragmentRemoving() {
        for (Fragment fragment = this.getParentFragment(); fragment != null; fragment = fragment.getParentFragment()) {
            if (!fragment.isRemoving()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndroidEventListener(AndroidEventListener androidEventListener) {
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            this.androidEventListeners.add(androidEventListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.add(lifecycleListener);
            return;
        }
    }

    protected FrameLayout.LayoutParams createLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    protected void createWakeLock(boolean bl) {
        if (bl) {
            this.getActivity().getWindow().addFlags(128);
        }
    }

    @Override
    public void debug(String string2, String string3) {
        if (this.logLevel >= 3) {
            Log.d((String)string2, (String)string3);
        }
    }

    @Override
    public void debug(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 3) {
            Log.d((String)string2, (String)string3, (Throwable)throwable);
        }
    }

    @Override
    public void error(String string2, String string3) {
        if (this.logLevel >= 1) {
            Log.e((String)string2, (String)string3);
        }
    }

    @Override
    public void error(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 1) {
            Log.e((String)string2, (String)string3, (Throwable)throwable);
        }
    }

    @Override
    public void exit() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AndroidFragmentApplication.this.callbacks.exit();
            }
        });
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    @Override
    public Window getApplicationWindow() {
        return this.getActivity().getWindow();
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    @Override
    public Context getContext() {
        return this.getActivity();
    }

    @Override
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public AndroidInput getInput() {
        return this.input;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public SnapshotArray<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Preferences getPreferences(String string2) {
        return new AndroidPreferences(this.getActivity().getSharedPreferences(string2, 0));
    }

    @Override
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public WindowManager getWindowManager() {
        return (WindowManager)this.getContext().getSystemService("window");
    }

    public View initializeForView(ApplicationListener applicationListener) {
        return this.initializeForView(applicationListener, new AndroidApplicationConfiguration());
    }

    public View initializeForView(ApplicationListener applicationListener, AndroidApplicationConfiguration object) {
        if (this.getVersion() >= 9) {
            this.setApplicationLogger(new AndroidApplicationLogger());
            ResolutionStrategy resolutionStrategy = ((AndroidApplicationConfiguration)object).resolutionStrategy == null ? new FillResolutionStrategy() : ((AndroidApplicationConfiguration)object).resolutionStrategy;
            this.graphics = new AndroidGraphics(this, (AndroidApplicationConfiguration)object, resolutionStrategy);
            this.input = AndroidInputFactory.newAndroidInput(this, (Context)this.getActivity(), this.graphics.view, (AndroidApplicationConfiguration)object);
            this.audio = new AndroidAudio((Context)this.getActivity(), (AndroidApplicationConfiguration)object);
            this.files = new AndroidFiles(this.getResources().getAssets(), this.getActivity().getFilesDir().getAbsolutePath());
            this.net = new AndroidNet(this, (AndroidApplicationConfiguration)object);
            this.listener = applicationListener;
            this.handler = new Handler();
            this.clipboard = new AndroidClipboard((Context)this.getActivity());
            this.addLifecycleListener(new LifecycleListener(){

                @Override
                public void dispose() {
                    AndroidFragmentApplication.this.audio.dispose();
                }

                @Override
                public void pause() {
                    AndroidFragmentApplication.this.audio.pause();
                }

                @Override
                public void resume() {
                    AndroidFragmentApplication.this.audio.resume();
                }
            });
            Gdx.app = this;
            Gdx.input = this.getInput();
            Gdx.audio = this.getAudio();
            Gdx.files = this.getFiles();
            Gdx.graphics = this.getGraphics();
            Gdx.net = this.getNet();
            this.createWakeLock(((AndroidApplicationConfiguration)object).useWakelock);
            this.useImmersiveMode(((AndroidApplicationConfiguration)object).useImmersiveMode);
            if (((AndroidApplicationConfiguration)object).useImmersiveMode && this.getVersion() >= 19) {
                try {
                    object = Class.forName("com.badlogic.gdx.backends.android.AndroidVisibilityListener");
                    applicationListener = ((Class)object).newInstance();
                    ((Class)object).getDeclaredMethod("createListener", AndroidApplicationBase.class).invoke((Object)applicationListener, this);
                }
                catch (Exception exception) {
                    this.log("AndroidApplication", "Failed to create AndroidVisibilityListener", exception);
                }
            }
            if (this.getResources().getConfiguration().keyboard != 1) {
                ((AndroidInput)this.getInput()).keyboardAvailable = true;
            }
            return this.graphics.getView();
        }
        throw new GdxRuntimeException("LibGDX requires Android API Level 9 or later.");
    }

    @Override
    public void log(String string2, String string3) {
        if (this.logLevel >= 2) {
            Log.i((String)string2, (String)string3);
        }
    }

    @Override
    public void log(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 2) {
            Log.i((String)string2, (String)string3, (Throwable)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            for (int i = 0; i < this.androidEventListeners.size; ++i) {
                this.androidEventListeners.get(i).onActivityResult(n, n2, intent);
            }
            return;
        }
    }

    public void onAttach(Activity activity) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!(activity instanceof Callbacks)) break block2;
                        this.callbacks = (Callbacks)activity;
                        break block3;
                    }
                    if (!(this.getParentFragment() instanceof Callbacks)) break block4;
                    this.callbacks = (Callbacks)this.getParentFragment();
                    break block3;
                }
                if (!(this.getTargetFragment() instanceof Callbacks)) break block5;
                this.callbacks = (Callbacks)this.getTargetFragment();
            }
            super.onAttach(activity);
            return;
        }
        throw new RuntimeException("Missing AndroidFragmentApplication.Callbacks. Please implement AndroidFragmentApplication.Callbacks on the parent activity, fragment or target fragment.");
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        int n = configuration.hardKeyboardHidden;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        this.input.keyboardAvailable = bl;
    }

    public void onDetach() {
        super.onDetach();
        this.callbacks = null;
    }

    public void onPause() {
        boolean bl = this.graphics.isContinuousRendering();
        boolean bl2 = AndroidGraphics.enforceContinuousRendering;
        AndroidGraphics.enforceContinuousRendering = true;
        this.graphics.setContinuousRendering(true);
        this.graphics.pause();
        this.input.onPause();
        if (this.isRemoving() || this.isAnyParentFragmentRemoving() || this.getActivity().isFinishing()) {
            this.graphics.clearManagedCaches();
            this.graphics.destroy();
        }
        AndroidGraphics.enforceContinuousRendering = bl2;
        this.graphics.setContinuousRendering(bl);
        this.graphics.onPauseGLSurfaceView();
        super.onPause();
    }

    public void onResume() {
        Gdx.app = this;
        Gdx.input = this.getInput();
        Gdx.audio = this.getAudio();
        Gdx.files = this.getFiles();
        Gdx.graphics = this.getGraphics();
        Gdx.net = this.getNet();
        this.input.onResume();
        AndroidGraphics androidGraphics = this.graphics;
        if (androidGraphics != null) {
            androidGraphics.onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.graphics.resume();
        } else {
            this.firstResume = false;
        }
        super.onResume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAndroidEventListener(AndroidEventListener androidEventListener) {
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            this.androidEventListeners.removeValue(androidEventListener, true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.removeValue(lifecycleListener, true);
            return;
        }
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        this.getActivity().runOnUiThread(runnable);
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Override
    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    @Override
    @TargetApi(value=19)
    public void useImmersiveMode(boolean bl) {
        if (bl && this.getVersion() >= 19) {
            try {
                View view = this.graphics.getView();
                View.class.getMethod("setSystemUiVisibility", Integer.TYPE).invoke((Object)view, 5894);
            }
            catch (Exception exception) {
                this.log("AndroidApplication", "Failed to setup immersive mode, a throwable has occurred.", exception);
            }
        }
    }

    public static interface Callbacks {
        public void exit();
    }
}

