/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class AndroidFileHandle
extends FileHandle {
    private final AssetManager assets;

    AndroidFileHandle(AssetManager assetManager, File file, Files.FileType fileType) {
        super(file, fileType);
        this.assets = assetManager;
    }

    AndroidFileHandle(AssetManager assetManager, String string2, Files.FileType fileType) {
        super(string2.replace('\\', '/'), fileType);
        this.assets = assetManager;
    }

    @Override
    public FileHandle child(String string2) {
        string2 = string2.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new AndroidFileHandle(this.assets, new File(string2), this.type);
        }
        return new AndroidFileHandle(this.assets, new File(this.file, string2), this.type);
    }

    @Override
    public boolean exists() {
        if (this.type == Files.FileType.Internal) {
            String string2 = this.file.getPath();
            boolean bl = true;
            try {
                this.assets.open(string2).close();
                return true;
            }
            catch (Exception exception) {
                try {
                    int n = this.assets.list(string2).length;
                    if (n <= 0) {
                        bl = false;
                    }
                    return bl;
                }
                catch (Exception exception2) {
                    return false;
                }
            }
        }
        return super.exists();
    }

    @Override
    public File file() {
        if (this.type == Files.FileType.Local) {
            return new File(Gdx.files.getLocalStoragePath(), this.file.getPath());
        }
        return super.file();
    }

    public AssetFileDescriptor getAssetFileDescriptor() throws IOException {
        Object object = this.assets;
        object = object != null ? object.openFd(this.path()) : null;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDirectory() {
        if (this.type != Files.FileType.Internal) return super.isDirectory();
        boolean bl = false;
        try {
            int n = this.assets.list(this.file.getPath()).length;
            if (n <= 0) return bl;
            return true;
        }
        catch (IOException iOException) {
            return bl;
        }
    }

    @Override
    public long lastModified() {
        return super.lastModified();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long length() {
        Throwable throwable2;
        long l;
        block16: {
            if (this.type == Files.FileType.Internal) {
                AssetFileDescriptor assetFileDescriptor;
                AssetFileDescriptor assetFileDescriptor2;
                block15: {
                    AssetFileDescriptor assetFileDescriptor3;
                    assetFileDescriptor2 = null;
                    assetFileDescriptor = null;
                    assetFileDescriptor = assetFileDescriptor3 = this.assets.openFd(this.file.getPath());
                    assetFileDescriptor2 = assetFileDescriptor3;
                    l = assetFileDescriptor3.getLength();
                    if (assetFileDescriptor3 == null) break block15;
                    assetFileDescriptor3.close();
                }
                return l;
                catch (Throwable throwable2) {
                    if (assetFileDescriptor != null) {
                        assetFileDescriptor.close();
                    }
                    throw throwable2;
                }
                catch (IOException iOException) {
                    if (assetFileDescriptor2 == null) break block16;
                    assetFileDescriptor2.close();
                }
            }
        }
        return super.length();
        catch (IOException iOException) {
            return l;
        }
        {
            catch (IOException iOException) {
                throw throwable2;
            }
        }
        {
            catch (IOException iOException) {
                return super.length();
            }
        }
    }

    @Override
    public FileHandle[] list() {
        if (this.type == Files.FileType.Internal) {
            int n;
            String[] stringArray = this.assets.list(this.file.getPath());
            FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
            try {
                n = fileHandleArray.length;
            }
            catch (Exception exception) {
                fileHandleArray = new StringBuilder();
                fileHandleArray.append("Error listing children: ");
                fileHandleArray.append(this.file);
                fileHandleArray.append(" (");
                fileHandleArray.append((Object)this.type);
                fileHandleArray.append(")");
                throw new GdxRuntimeException(fileHandleArray.toString(), exception);
            }
            for (int i = 0; i < n; ++i) {
                AssetManager assetManager = this.assets;
                File file = new File(this.file, stringArray[i]);
                fileHandleArray[i] = new AndroidFileHandle(assetManager, file, this.type);
                continue;
            }
            return fileHandleArray;
        }
        return super.list();
    }

    @Override
    public FileHandle[] list(FileFilter fileHandleArray) {
        if (this.type == Files.FileType.Internal) {
            String[] stringArray = this.assets.list(this.file.getPath());
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = fileHandleArray2.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                AssetManager assetManager = this.assets;
                File file = new File(this.file, string2);
                AndroidFileHandle androidFileHandle = new AndroidFileHandle(assetManager, file, this.type);
                if (!fileHandleArray.accept(((FileHandle)androidFileHandle).file())) continue;
                fileHandleArray2[n2] = androidFileHandle;
                ++n2;
                continue;
            }
            try {
                if (n2 < stringArray.length) {
                    fileHandleArray = new FileHandle[n2];
                    System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
                } else {
                    fileHandleArray = fileHandleArray2;
                }
                return fileHandleArray;
            }
            catch (Exception exception) {
                fileHandleArray = new StringBuilder();
                fileHandleArray.append("Error listing children: ");
                fileHandleArray.append(this.file);
                fileHandleArray.append(" (");
                fileHandleArray.append((Object)this.type);
                fileHandleArray.append(")");
                throw new GdxRuntimeException(fileHandleArray.toString(), exception);
            }
        }
        return super.list((FileFilter)fileHandleArray);
    }

    @Override
    public FileHandle[] list(FilenameFilter fileHandleArray) {
        if (this.type == Files.FileType.Internal) {
            String[] stringArray = this.assets.list(this.file.getPath());
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = fileHandleArray2.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!fileHandleArray.accept(this.file, string2)) continue;
                AssetManager assetManager = this.assets;
                File file = new File(this.file, string2);
                fileHandleArray2[n2] = new AndroidFileHandle(assetManager, file, this.type);
                ++n2;
                continue;
            }
            try {
                if (n2 < stringArray.length) {
                    fileHandleArray = new FileHandle[n2];
                    System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
                } else {
                    fileHandleArray = fileHandleArray2;
                }
                return fileHandleArray;
            }
            catch (Exception exception) {
                fileHandleArray2 = new StringBuilder();
                fileHandleArray2.append("Error listing children: ");
                fileHandleArray2.append(this.file);
                fileHandleArray2.append(" (");
                fileHandleArray2.append((Object)this.type);
                fileHandleArray2.append(")");
                throw new GdxRuntimeException(fileHandleArray2.toString(), exception);
            }
        }
        return super.list((FilenameFilter)fileHandleArray);
    }

    @Override
    public FileHandle[] list(String fileHandleArray) {
        if (this.type == Files.FileType.Internal) {
            String[] stringArray = this.assets.list(this.file.getPath());
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = fileHandleArray2.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string2.endsWith((String)fileHandleArray)) continue;
                AssetManager assetManager = this.assets;
                File file = new File(this.file, string2);
                fileHandleArray2[n2] = new AndroidFileHandle(assetManager, file, this.type);
                ++n2;
                continue;
            }
            try {
                if (n2 < stringArray.length) {
                    fileHandleArray = new FileHandle[n2];
                    System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
                } else {
                    fileHandleArray = fileHandleArray2;
                }
                return fileHandleArray;
            }
            catch (Exception exception) {
                fileHandleArray2 = new StringBuilder();
                fileHandleArray2.append("Error listing children: ");
                fileHandleArray2.append(this.file);
                fileHandleArray2.append(" (");
                fileHandleArray2.append((Object)this.type);
                fileHandleArray2.append(")");
                throw new GdxRuntimeException(fileHandleArray2.toString(), exception);
            }
        }
        return super.list((String)fileHandleArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer map(FileChannel.MapMode object) {
        void var1_4;
        Object object2;
        block8: {
            Object object3;
            Object object4;
            GdxRuntimeException gdxRuntimeException;
            block9: {
                long l;
                long l2;
                if (this.type != Files.FileType.Internal) {
                    return super.map((FileChannel.MapMode)object);
                }
                gdxRuntimeException = null;
                object2 = object4 = null;
                try {
                    AssetFileDescriptor assetFileDescriptor = this.getAssetFileDescriptor();
                    object2 = object4;
                    l2 = assetFileDescriptor.getStartOffset();
                    object2 = object4;
                    l = assetFileDescriptor.getDeclaredLength();
                    object2 = object4;
                    object2 = object4;
                    object3 = new FileInputStream(assetFileDescriptor.getFileDescriptor());
                }
                catch (Throwable throwable) {
                    break block8;
                }
                catch (Exception exception) {
                    object = gdxRuntimeException;
                    break block9;
                }
                try {
                    object = ((FileInputStream)object3).getChannel().map((FileChannel.MapMode)object, l2, l);
                    ((ByteBuffer)object).order(ByteOrder.nativeOrder());
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block8;
                }
                catch (Exception exception) {
                    object = object3;
                    object3 = exception;
                    break block9;
                }
                StreamUtils.closeQuietly((Closeable)object3);
                return object;
            }
            object2 = object;
            {
                object2 = object;
                object2 = object;
                object4 = new StringBuilder();
                object2 = object;
                ((StringBuilder)object4).append("Error memory mapping file: ");
                object2 = object;
                ((StringBuilder)object4).append(this);
                object2 = object;
                ((StringBuilder)object4).append(" (");
                object2 = object;
                ((StringBuilder)object4).append((Object)this.type);
                object2 = object;
                ((StringBuilder)object4).append(")");
                object2 = object;
                gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object4).toString(), (Throwable)object3);
                object2 = object;
                throw gdxRuntimeException;
            }
        }
        StreamUtils.closeQuietly(object2);
        throw var1_4;
    }

    @Override
    public FileHandle parent() {
        File file;
        File file2 = file = this.file.getParentFile();
        if (file == null) {
            file2 = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new AndroidFileHandle(this.assets, file2, this.type);
    }

    @Override
    public InputStream read() {
        if (this.type == Files.FileType.Internal) {
            try {
                InputStream inputStream = this.assets.open(this.file.getPath());
                return inputStream;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Error reading file: ");
                stringBuilder.append(this.file);
                stringBuilder.append(" (");
                stringBuilder.append((Object)this.type);
                stringBuilder.append(")");
                throw new GdxRuntimeException(stringBuilder.toString(), iOException);
            }
        }
        return super.read();
    }

    @Override
    public FileHandle sibling(String string2) {
        string2 = string2.replace('\\', '/');
        if (this.file.getPath().length() != 0) {
            return Gdx.files.getFileHandle(new File(this.file.getParent(), string2).getPath(), this.type);
        }
        throw new GdxRuntimeException("Cannot get the sibling of the root.");
    }
}

