/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Editor;
import age.of.civilizations2.jakowski.lukasz.Editor_Continents;
import age.of.civilizations2.jakowski.lukasz.Editor_GrowthRate;
import age.of.civilizations2.jakowski.lukasz.Editor_LevelOfPort;
import age.of.civilizations2.jakowski.lukasz.Editor_MapRegions;
import age.of.civilizations2.jakowski.lukasz.Editor_NeighboringProvinces;
import age.of.civilizations2.jakowski.lukasz.Editor_ProvinceTexture;
import age.of.civilizations2.jakowski.lukasz.Editor_Regions;
import age.of.civilizations2.jakowski.lukasz.Editor_ShiftArmy;
import age.of.civilizations2.jakowski.lukasz.Editor_ShiftPort;
import age.of.civilizations2.jakowski.lukasz.Editor_TerrainType;
import age.of.civilizations2.jakowski.lukasz.Editors;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import java.util.List;

class EditorManager {
    protected static int GROWTH_RATE = -1;
    protected static int LEVEL_OF_PORT = -1;
    protected static int NEIGHBORING_PROVINCES = -1;
    protected static int PROVINCE_CONTINENTS = -1;
    protected static int PROVINCE_MAP_REGIONS = -1;
    protected static int PROVINCE_PIXMAP = -1;
    protected static int PROVINCE_REGIONS = -1;
    protected static int SHIFT_ARMY = -1;
    protected static int SHIFT_PORT = -1;
    protected static int TERRAIN_TYPE = -1;
    protected static int WASTELAND = -1;
    private int inUseID = -1;
    private List<Editor> lEditors = new ArrayList<Editor>();

    protected EditorManager() {
    }

    private final int addEditor(Editor editor) {
        this.lEditors.add(editor);
        return this.lEditors.size() - 1;
    }

    protected final void draw(SpriteBatch spriteBatch) {
        int n = this.inUseID;
        if (n >= 0) {
            this.lEditors.get(n).draw(spriteBatch);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean keyDown(int n) {
        int n2 = this.inUseID;
        if (n2 < 0) return false;
        this.lEditors.get(n2).keyDown(n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean keyUp(int n) {
        int n2 = this.inUseID;
        if (n2 < 0) return false;
        this.lEditors.get(n2).keyUp(n);
        return true;
    }

    protected final void resetInUseEditors() {
        for (int i = 0; i < this.lEditors.size(); ++i) {
            this.lEditors.get(i).setInUse(false);
        }
        this.inUseID = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void setInUse(Editors editors) {
        switch (1.$SwitchMap$age$of$civilizations2$jakowski$lukasz$Editors[editors.ordinal()]) {
            case 10: {
                if (NEIGHBORING_PROVINCES < 0) {
                    NEIGHBORING_PROVINCES = this.addEditor(new Editor_NeighboringProvinces());
                }
                this.inUseID = NEIGHBORING_PROVINCES;
                return;
            }
            case 9: {
                if (GROWTH_RATE < 0) {
                    GROWTH_RATE = this.addEditor(new Editor_GrowthRate());
                }
                this.inUseID = GROWTH_RATE;
                return;
            }
            case 8: {
                if (PROVINCE_MAP_REGIONS < 0) {
                    PROVINCE_MAP_REGIONS = this.addEditor(new Editor_MapRegions());
                }
                this.inUseID = PROVINCE_MAP_REGIONS;
                return;
            }
            case 7: {
                if (PROVINCE_REGIONS < 0) {
                    PROVINCE_REGIONS = this.addEditor(new Editor_Regions());
                }
                this.inUseID = PROVINCE_REGIONS;
                return;
            }
            case 6: {
                if (PROVINCE_CONTINENTS < 0) {
                    PROVINCE_CONTINENTS = this.addEditor(new Editor_Continents());
                }
                this.inUseID = PROVINCE_CONTINENTS;
                return;
            }
            case 5: {
                if (PROVINCE_PIXMAP < 0) {
                    PROVINCE_PIXMAP = this.addEditor(new Editor_ProvinceTexture());
                }
                this.lEditors.get(PROVINCE_PIXMAP).setInUse(true);
                this.inUseID = PROVINCE_PIXMAP;
                return;
            }
            case 4: {
                if (LEVEL_OF_PORT < 0) {
                    LEVEL_OF_PORT = this.addEditor(new Editor_LevelOfPort());
                }
                this.inUseID = LEVEL_OF_PORT;
                return;
            }
            case 3: {
                if (SHIFT_PORT < 0) {
                    SHIFT_PORT = this.addEditor(new Editor_ShiftPort());
                }
                this.inUseID = SHIFT_PORT;
                return;
            }
            case 2: {
                if (SHIFT_ARMY < 0) {
                    SHIFT_ARMY = this.addEditor(new Editor_ShiftArmy());
                }
                this.inUseID = SHIFT_ARMY;
                return;
            }
            case 1: {
                if (TERRAIN_TYPE < 0) {
                    TERRAIN_TYPE = this.addEditor(new Editor_TerrainType());
                }
                this.inUseID = TERRAIN_TYPE;
                return;
            }
        }
    }

    protected void touchDown(int n, int n2, int n3, int n4) {
        int n5 = this.inUseID;
        if (n5 >= 0) {
            this.lEditors.get(n5).touchDown(n, n2, n3, n4);
        }
    }

    protected void touchDragged(int n, int n2, int n3) {
        int n4 = this.inUseID;
        if (n4 >= 0) {
            this.lEditors.get(n4).touchDragged(n, n2, n3);
        }
    }

    protected void touchUp(int n, int n2, int n3, int n4) {
        int n5 = this.inUseID;
        if (n5 >= 0) {
            this.lEditors.get(n5).touchUp(n, n2, n3, n4);
        }
    }
}

