/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface CharSequence {
    public int length();

    public char charAt(int var1);

    public CharSequence subSequence(int var1, int var2);

    public String toString();

    default public IntStream chars() {
        return StreamSupport.intStream(() -> {
            class CharIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CharIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.cur < CharSequence.this.length();
                }

                @Override
                public int nextInt() {
                    if (this.hasNext()) {
                        return CharSequence.this.charAt(this.cur++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer intConsumer) {
                    while (this.cur < CharSequence.this.length()) {
                        intConsumer.accept(CharSequence.this.charAt(this.cur));
                        ++this.cur;
                    }
                }
            }
            return Spliterators.spliterator(new CharIterator(), (long)this.length(), 16);
        }, 16464, false);
    }

    default public IntStream codePoints() {
        return StreamSupport.intStream(() -> {
            class CodePointIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CodePointIterator() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void forEachRemaining(IntConsumer intConsumer) {
                    int n = CharSequence.this.length();
                    int n2 = this.cur;
                    try {
                        while (n2 < n) {
                            char c;
                            if (!Character.isHighSurrogate(c = CharSequence.this.charAt(n2++)) || n2 >= n) {
                                intConsumer.accept(c);
                                continue;
                            }
                            char c2 = CharSequence.this.charAt(n2);
                            if (Character.isLowSurrogate(c2)) {
                                ++n2;
                                intConsumer.accept(Character.toCodePoint(c, c2));
                                continue;
                            }
                            intConsumer.accept(c);
                        }
                    }
                    finally {
                        this.cur = n2;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.cur < CharSequence.this.length();
                }

                @Override
                public int nextInt() {
                    char c;
                    char c2;
                    int n = CharSequence.this.length();
                    if (this.cur >= n) {
                        throw new NoSuchElementException();
                    }
                    if (Character.isHighSurrogate(c2 = CharSequence.this.charAt(this.cur++)) && this.cur < n && Character.isLowSurrogate(c = CharSequence.this.charAt(this.cur))) {
                        ++this.cur;
                        return Character.toCodePoint(c2, c);
                    }
                    return c2;
                }
            }
            return Spliterators.spliteratorUnknownSize(new CodePointIterator(), 16);
        }, 16, false);
    }
}

