/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz.desktop;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.desktop.DesktopLinkHandler;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;

public class DesktopLauncher {
    public static String icon = "ic_32x32.png";

    public static void main(String[] arg) {
        String sLine;
        FileReader fr;
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        String title = "Age of Civilizations II";
        try {
            fr = new FileReader("zetvl_custom.ini");
            BufferedReader bfr = new BufferedReader(fr);
            while ((sLine = bfr.readLine()) != null) {
                String[] tempR = sLine.replace(";", "").split("=");
                try {
                    switch (tempR[0]) {
                        case "TITLE": {
                            title = tempR[1];
                            break;
                        }
                        case "ICON": {
                            icon = tempR[1];
                        }
                    }
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException var13) {
                    break;
                }
            }
            fr.close();
        }
        catch (IOException bfr) {
            // empty catch block
        }
        if (!new File(icon).exists()) {
            System.err.println("The icon configuration item is invalid: " + icon);
            icon = "ic_32x32.png";
        }
        config.title = title;
        config.backgroundFPS = 15;
        config.addIcon(icon, Files.FileType.Internal);
        config.resizable = false;
        int tWidth = -1;
        int tHeight = -1;
        boolean tFullscreen = true;
        int tSamples = -1;
        boolean tVSync = false;
        boolean tBorderless = false;
        System.out.println(Charset.defaultCharset().displayName());
        try {
            fr = new FileReader("config.ini");
            BufferedReader bfr = new BufferedReader(fr);
            while ((sLine = bfr.readLine()) != null) {
                String[] tempR = sLine.replace(";", "").split("=");
                try {
                    switch (tempR[0]) {
                        case "FULLSCREEN": {
                            tFullscreen = Boolean.parseBoolean(tempR[1]);
                            break;
                        }
                        case "WIDTH": {
                            tWidth = Integer.parseInt(tempR[1]);
                            break;
                        }
                        case "HEIGHT": {
                            tHeight = Integer.parseInt(tempR[1]);
                            break;
                        }
                        case "ANTIALIASING": {
                            tSamples = Integer.parseInt(tempR[1]);
                            break;
                        }
                        case "VSYNC": {
                            tVSync = Boolean.parseBoolean(tempR[1]);
                            break;
                        }
                        case "BORDERLESS": {
                            tBorderless = Boolean.parseBoolean(tempR[1]);
                        }
                    }
                }
                catch (IndexOutOfBoundsException var13) {
                    tWidth = -1;
                    tHeight = -1;
                    tFullscreen = true;
                    tSamples = -1;
                    tVSync = false;
                    break;
                }
                catch (IllegalArgumentException var14) {
                    tWidth = -1;
                    tHeight = -1;
                    tFullscreen = true;
                    tSamples = -1;
                    tVSync = false;
                    break;
                }
            }
            fr.close();
        }
        catch (IOException var15) {
            tWidth = -1;
            tHeight = -1;
            tFullscreen = true;
            tSamples = -1;
            tVSync = false;
        }
        config.undecorated = tBorderless;
        if (tSamples != -1) {
            config.samples = tSamples;
        }
        config.vSyncEnabled = tVSync;
        if (tWidth <= 0 && tHeight <= 0) {
            config.setFromDisplayMode(LwjglApplicationConfiguration.getDesktopDisplayMode());
        } else {
            config.width = tWidth;
            config.height = tHeight;
        }
        config.fullscreen = tFullscreen;
        if (!config.fullscreen) {
            config.x = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().x + (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth() - config.width) / 2;
            config.y = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().y + (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight() - config.height) / 2;
        }
        config.audioDeviceBufferSize = 1024;
        config.audioDeviceBufferCount = 16;
        if (tBorderless) {
            config.width = LwjglApplicationConfiguration.getDesktopDisplayMode().width;
            config.height = LwjglApplicationConfiguration.getDesktopDisplayMode().height;
            config.x = 0;
            config.y = 0;
            config.fullscreen = false;
        }
        new LwjglApplication((ApplicationListener)new AoCGame(new DesktopLinkHandler()), config);
    }
}

