/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileHandle createZipFile(List<FileHandle> files, FileHandle outputZip) {
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            bos = new BufferedOutputStream(outputZip.write(false));
            zos = new ZipOutputStream(bos);
            byte[] buffer = new byte[4096];
            for (FileHandle file : files) {
                if (file.isDirectory()) continue;
                String entryName = file.name();
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                BufferedInputStream bis = null;
                try {
                    int bytesRead;
                    bis = new BufferedInputStream(file.read());
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        zos.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    Gdx.app.error("ZipUtils", "\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: " + file.path(), e);
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            Gdx.app.error("ZipUtils", "\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", e);
                        }
                    }
                }
                zos.closeEntry();
            }
            zos.finish();
            FileHandle fileHandle = outputZip;
            return fileHandle;
        }
        catch (IOException e) {
            Gdx.app.error("ZipUtils", "\u521b\u5efaZIP\u6587\u4ef6\u5931\u8d25: " + outputZip.path(), e);
            FileHandle fileHandle = null;
            return fileHandle;
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                Gdx.app.error("ZipUtils", "\u5173\u95edZIP\u8f93\u51fa\u6d41\u5931\u8d25", e);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                Gdx.app.error("ZipUtils", "\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", e);
            }
        }
    }

    public static FileHandle createZipFile(List<FileHandle> files, String zipFileName) {
        FileHandle tempDir = Gdx.files.local("temp/");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
            if (!tempDir.isDirectory()) {
                Gdx.app.error("ZipUtils", "\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u76ee\u5f55: " + tempDir.path());
                return null;
            }
        }
        FileHandle zipFile = tempDir.child(zipFileName);
        return ZipUtils.createZipFile(files, zipFile);
    }
}

