/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import com.badlogic.gdx.Gdx;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class WarCiv_GameData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int iCivID = 0;
    protected int InitialRanking = 1;
    protected int InitialRanking2 = 1;
    private int iCasualties = 0;
    private float iCapitulationPoints = 0.0f;
    private int iCivilianDeaths = 0;
    private int iEconomicLosses = 0;
    private int iConqueredProvinces = 0;
    private List<Integer> iFromCiv = new ArrayList<Integer>();
    private List<Integer> iFromCasualty = new ArrayList<Integer>();

    public int getInitialRanking() {
        return this.InitialRanking;
    }

    public void setInitialRanking(int initialRanking) {
        if (initialRanking < this.InitialRanking2) {
            this.InitialRanking = initialRanking;
        }
    }

    protected WarCiv_GameData(int nCivID) {
        this.iCivID = nCivID;
        this.InitialRanking = CFG.game.getCiv(nCivID).getRankPosition();
        this.InitialRanking2 = CFG.game.getCiv(nCivID).getRankPosition();
    }

    protected final int getCivID() {
        return this.iCivID;
    }

    protected final void setCivID(int iCivID) {
        this.iCivID = iCivID;
    }

    protected final int getCasualties() {
        return this.iCasualties;
    }

    protected final List<Integer> getFromCiv() {
        return this.iFromCiv;
    }

    protected final List<Integer> getFromCasualty() {
        return this.iFromCasualty;
    }

    protected final void setFromCiv(List<Integer> civ) {
        this.iFromCiv = civ;
    }

    protected final void setFromCasualty(List<Integer> casualty) {
        this.iFromCasualty = casualty;
    }

    protected void addFromCiv(int civId, int casualties) {
        if (this.iFromCiv == null) {
            this.iFromCiv = new ArrayList<Integer>();
            this.iFromCasualty = new ArrayList<Integer>();
        }
        if (this.iFromCiv != null && !this.iFromCiv.isEmpty()) {
            int index = this.iFromCiv.indexOf(civId);
            if (index != -1) {
                Gdx.app.log("From", String.valueOf(civId));
                this.iFromCasualty.set(index, this.iFromCasualty.get(index) + casualties);
            } else {
                Gdx.app.log("From", "length " + this.iFromCiv.size());
                Gdx.app.log("From", "New " + civId);
                this.iFromCiv.add(civId);
                this.iFromCasualty.add(casualties);
            }
        } else {
            Gdx.app.log("From", "out " + civId);
            if (this.iFromCiv != null) {
                Gdx.app.log("From", "yes " + civId);
                this.iFromCiv.add(civId);
                this.iFromCasualty.add(casualties);
            }
        }
    }

    protected final float getWarCapitulationPoints() {
        return this.iCapitulationPoints;
    }

    protected final void setCapitulationPoints(int nCapitulationPoints) {
        this.iCapitulationPoints = nCapitulationPoints;
    }

    protected final void addCasualties(int nCasualties) {
        this.iCasualties += nCasualties;
    }

    protected final int getCivilianDeaths() {
        return this.iCivilianDeaths;
    }

    protected final void addCivilianDeaths(int nCivilianDeaths) {
        this.iCivilianDeaths += nCivilianDeaths;
    }

    protected final int getEconomicLosses() {
        return this.iEconomicLosses;
    }

    protected final void addEconomicLosses(int nEconomicLosses) {
        this.iEconomicLosses += nEconomicLosses;
    }

    protected final int getConqueredProvinces() {
        return this.iConqueredProvinces;
    }

    protected final void setConqueredProvinces(int iConqueredProvinces) {
        this.iConqueredProvinces = iConqueredProvinces;
    }

    protected final void addConqueredProvinces() {
        ++this.iConqueredProvinces;
    }
}

