/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.CFG_Zetvl;
import age.of.civilizations2.jakowski.lukasz.Province;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class ProvinceConnections {
    public static void AutoConnectionFinal() {
        AoCGame.mLinkHandler.toast("By Fanillanus");
        float scale = CFG.map.getMapBG().getMapScale();
        int provincesSize = CFG.game.getProvincesSize();
        long startTime = System.nanoTime();
        ArrayList polygons = new ArrayList(provincesSize);
        HashMap<Point, Set> pointMap = new HashMap<Point, Set>();
        for (int polyIdx = 0; polyIdx < provincesSize; ++polyIdx) {
            Province province = CFG.game.getProvince(polyIdx);
            int pointsSize = province.getPointsSize();
            ArrayList<Point> polyPoints = new ArrayList<Point>(pointsSize);
            for (int j = 0; j < pointsSize; ++j) {
                int x = (int)((float)province.getPointsX(j) / scale);
                int y = (int)((float)province.getPointsY(j) / scale);
                Point p = new Point(x, y);
                polyPoints.add(p);
                pointMap.computeIfAbsent(p, k -> new HashSet(4)).add(polyIdx);
            }
            polygons.add(polyPoints);
        }
        HashSet<IntPair> connections = new HashSet<IntPair>();
        for (Set sharedPolys : pointMap.values()) {
            if (sharedPolys.size() < 2) continue;
            ArrayList polyList = new ArrayList(sharedPolys);
            Collections.sort(polyList);
            for (int i = 0; i < polyList.size(); ++i) {
                for (int j = i + 1; j < polyList.size(); ++j) {
                    connections.add(new IntPair((Integer)polyList.get(i), (Integer)polyList.get(j)));
                }
            }
        }
        System.out.println("Connections found: " + connections.size());
        System.out.printf("Point processing time: %.3f seconds%n", (double)(System.nanoTime() - startTime) / 1.0E9);
        long connectionStart = System.nanoTime();
        int processed = 0;
        for (IntPair pair : connections) {
            ProvinceConnections.ProvinceConnection(pair.a, pair.b);
            System.out.print("\rconnected: " + ++processed + "/" + connections.size());
        }
        System.out.printf("Connection processing time: %.3f seconds%n", (double)(System.nanoTime() - connectionStart) / 1.0E9);
        if (CFG.isDesktop()) {
            CFG_Zetvl.writeProvincesGameData();
        }
    }

    public static void AConnections() {
        FileHandle mapDir = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path());
        FileHandle updateDir = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "update");
        Set<String> excludedPairs = Collections.newSetFromMap(new ConcurrentHashMap());
        FileHandle connectorFile = mapDir.child("connector.txt");
        if (connectorFile.exists()) {
            String[] lines;
            String content = connectorFile.readString("UTF-8");
            for (String line : lines = content.split("\\r?\\n")) {
                String[] parts;
                for (String part : parts = line.split(";")) {
                    String[] ids = part.split(",");
                    if (ids.length != 2) continue;
                    try {
                        int id1 = Integer.parseInt(ids[0].trim());
                        int id2 = Integer.parseInt(ids[1].trim());
                        ProvinceConnections.ProvinceConnection(id1, id2);
                        Gdx.app.log("AoC", "Checked [" + id1 + " - " + id2 + "]");
                    }
                    catch (NumberFormatException e) {
                        Gdx.app.error("AoC: AutoConnection", "Invalid ID format: " + part);
                    }
                }
            }
        } else {
            FileHandle[] files = updateDir.list();
            Array<FileHandle> sortedFiles = new Array<FileHandle>(files);
            sortedFiles.sort((f1, f2) -> {
                int num1 = ProvinceConnections.parseFileNameToInt(f1);
                int num2 = ProvinceConnections.parseFileNameToInt(f2);
                return Integer.compare(num1, num2);
            });
            ConcurrentHashMap<FileHandle, String[]> fileContentMap = new ConcurrentHashMap<FileHandle, String[]>();
            ((Stream)Arrays.stream(files).parallel()).forEach(file -> {
                String content = file.readString("UTF-8").trim();
                fileContentMap.put((FileHandle)file, content.split(";"));
            });
            for (int i = 0; i < sortedFiles.size; ++i) {
                for (int j = i + 1; j < sortedFiles.size; ++j) {
                    FileHandle file1 = sortedFiles.get(i);
                    FileHandle file2 = sortedFiles.get(j);
                    String pairKey = file1.name() + "-" + file2.name();
                    if (excludedPairs.contains(pairKey)) continue;
                    ProvinceConnections.processFiles(file1, file2, fileContentMap, excludedPairs);
                }
            }
        }
    }

    private static int parseFileNameToInt(FileHandle file) {
        return Integer.parseInt(file.nameWithoutExtension());
    }

    private static void processFiles(FileHandle file1, FileHandle file2, Map<FileHandle, String[]> fileContentMap, Set<String> excludedPairs) {
        String[] content2;
        String[] content1 = fileContentMap.get(file1);
        if (ProvinceConnections.checkContent(content1, content2 = fileContentMap.get(file2))) {
            Gdx.app.log("AoC: AutoConnection", "Added [" + file1.name() + " - " + file2.name() + "]");
            ProvinceConnections.ProvinceConnection(ProvinceConnections.parseFileNameToInt(file1), ProvinceConnections.parseFileNameToInt(file2));
            excludedPairs.add(file1.name() + "-" + file2.name());
        }
    }

    private static boolean checkContent(String[] content1, String[] content2) {
        if (content1.length == 2 && content2.length == 2) {
            String[] coords1 = content1[0].split(",");
            String[] coords2 = content2[0].split(",");
            String[] altCoords1 = content1[1].split(",");
            String[] altCoords2 = content2[1].split(",");
            for (int i = 0; i < coords1.length; ++i) {
                for (int j = 0; j < coords2.length; ++j) {
                    if (!coords1[i].equals(coords2[j]) || i >= altCoords1.length || j >= altCoords2.length || !altCoords1[i].equals(altCoords2[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static void ProvinceConnection(int ID1, int ID2) {
        if (ID1 != ID2) {
            int i;
            for (i = 0; i < CFG.game.getProvince(ID2).getNeighboringProvincesSize(); ++i) {
                if (CFG.game.getProvince(ID2).getNeighboringProvinces(i) != ID1) continue;
                return;
            }
            for (i = 0; i < CFG.game.getProvince(ID2).getNeighboringSeaProvincesSize(); ++i) {
                if (CFG.game.getProvince(ID2).getNeighboringSeaProvinces(i) != ID1) continue;
                return;
            }
            for (i = 0; i < CFG.game.getProvince(ID1).getNeighboringSeaProvincesSize(); ++i) {
                if (CFG.game.getProvince(ID1).getNeighboringSeaProvinces(i) != ID2) continue;
                return;
            }
            if (CFG.game.getProvince(ID1).getSeaProvince()) {
                CFG.game.getProvince(ID1).addNeighboringProvince(ID2);
            } else if (CFG.game.getProvince(ID2).getSeaProvince()) {
                CFG.game.getProvince(ID1).addNeighboringSeaProvince(ID2);
                CFG.game.getProvince(ID1).setLevelOfPort(1);
            } else {
                CFG.game.getProvince(ID1).addNeighboringProvince(ID2);
            }
            if (CFG.game.getProvince(ID2).getSeaProvince()) {
                CFG.game.getProvince(ID2).addNeighboringProvince(ID1);
            } else if (CFG.game.getProvince(ID1).getSeaProvince()) {
                CFG.game.getProvince(ID2).addNeighboringSeaProvince(ID1);
                CFG.game.getProvince(ID2).setLevelOfPort(1);
            } else {
                CFG.game.getProvince(ID2).addNeighboringProvince(ID1);
            }
            ArrayList<Short> nPointsX = new ArrayList<Short>();
            ArrayList<Short> nPointsY = new ArrayList<Short>();
            for (int i2 = 0; i2 < CFG.game.getProvince(ID2).getPointsSize(); ++i2) {
                boolean found = false;
                int j = 0;
                if (j < CFG.game.getProvince(ID1).getPointsSize()) {
                    int o;
                    found = true;
                    boolean l1 = false;
                    int oSize = CFG.game.getProvince(ID1).getPointsSize();
                    for (o = 0; o < oSize; ++o) {
                        if (CFG.game.getProvince(ID2).getPointsX(CFG.game.getProvince(ID2).getPointsSize() - 1) != CFG.game.getProvince(ID1).getPointsX(o) || CFG.game.getProvince(ID2).getPointsY(CFG.game.getProvince(ID2).getPointsSize() - 1) != CFG.game.getProvince(ID1).getPointsY(o)) continue;
                        l1 = true;
                    }
                    if (l1) {
                        l1 = false;
                        oSize = CFG.game.getProvince(ID2).getPointsSize();
                        for (o = 0; o < oSize; ++o) {
                            if (CFG.game.getProvince(ID1).getPointsX(CFG.game.getProvince(ID1).getPointsSize() - 1) != CFG.game.getProvince(ID2).getPointsX(o) || CFG.game.getProvince(ID1).getPointsY(CFG.game.getProvince(ID1).getPointsSize() - 1) != CFG.game.getProvince(ID2).getPointsY(o)) continue;
                            l1 = true;
                        }
                        if (!l1) {
                            f1 = false;
                            block6: for (ox = CFG.game.getProvince(ID1).getPointsSize() - 1; ox >= 0; --ox) {
                                if (!f1) {
                                    nSize = CFG.game.getProvince(ID2).getPointsSize();
                                    for (n = 0; n < nSize; ++n) {
                                        if (CFG.game.getProvince(ID1).getPointsX(ox) != CFG.game.getProvince(ID2).getPointsX(n) || CFG.game.getProvince(ID1).getPointsY(ox) != CFG.game.getProvince(ID2).getPointsY(n)) continue;
                                        f1 = true;
                                        nPointsX.add((short)CFG.game.getProvince(ID1).getPointsX(ox));
                                        nPointsY.add((short)CFG.game.getProvince(ID1).getPointsY(ox));
                                        continue block6;
                                    }
                                    continue;
                                }
                                end = true;
                                nSize = CFG.game.getProvince(ID2).getPointsSize();
                                for (n = 0; n < nSize; ++n) {
                                    if (CFG.game.getProvince(ID1).getPointsX(ox) != CFG.game.getProvince(ID2).getPointsX(n) || CFG.game.getProvince(ID1).getPointsY(ox) != CFG.game.getProvince(ID2).getPointsY(n)) continue;
                                    end = false;
                                    nPointsX.add((short)CFG.game.getProvince(ID1).getPointsX(ox));
                                    nPointsY.add((short)CFG.game.getProvince(ID1).getPointsY(ox));
                                    break;
                                }
                                if (!end) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (ox = CFG.game.getProvince(ID2).getPointsSize() - 1; ox >= 0; --ox) {
                                boolean t1 = false;
                                nSize = CFG.game.getProvince(ID1).getPointsSize();
                                for (n = 0; n < nSize; ++n) {
                                    if (CFG.game.getProvince(ID2).getPointsX(ox) != CFG.game.getProvince(ID1).getPointsX(n) || CFG.game.getProvince(ID2).getPointsY(ox) != CFG.game.getProvince(ID1).getPointsY(n)) continue;
                                    t1 = true;
                                    break;
                                }
                                if (t1) continue;
                                ++ox;
                                while (ox < CFG.game.getProvince(ID2).getPointsSize() - 1) {
                                    nPointsX.add((short)CFG.game.getProvince(ID2).getPointsX(ox));
                                    nPointsY.add((short)CFG.game.getProvince(ID2).getPointsY(ox));
                                    ++ox;
                                }
                                break;
                            }
                            for (int h = 0; h < CFG.game.getProvince(ID2).getPointsSize(); ++h) {
                                boolean addT = false;
                                for (n = 0; n < CFG.game.getProvince(ID1).getPointsSize(); ++n) {
                                    if (CFG.game.getProvince(ID2).getPointsX(h) != CFG.game.getProvince(ID1).getPointsX(n) || CFG.game.getProvince(ID2).getPointsY(h) != CFG.game.getProvince(ID1).getPointsY(n)) continue;
                                    addT = true;
                                    break;
                                }
                                if (addT) {
                                    nPointsX.add((short)CFG.game.getProvince(ID2).getPointsX(h));
                                    nPointsY.add((short)CFG.game.getProvince(ID2).getPointsY(h));
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        f1 = false;
                        block14: for (ox = CFG.game.getProvince(ID2).getPointsSize() - 1; ox >= 0; --ox) {
                            if (!f1) {
                                nSize = CFG.game.getProvince(ID1).getPointsSize();
                                for (n = 0; n < nSize; ++n) {
                                    if (CFG.game.getProvince(ID2).getPointsX(ox) != CFG.game.getProvince(ID1).getPointsX(n) || CFG.game.getProvince(ID2).getPointsY(ox) != CFG.game.getProvince(ID1).getPointsY(n)) continue;
                                    f1 = true;
                                    nPointsX.add((short)CFG.game.getProvince(ID2).getPointsX(ox));
                                    nPointsY.add((short)CFG.game.getProvince(ID2).getPointsY(ox));
                                    continue block14;
                                }
                                continue;
                            }
                            end = true;
                            nSize = CFG.game.getProvince(ID1).getPointsSize();
                            for (n = 0; n < nSize; ++n) {
                                if (CFG.game.getProvince(ID2).getPointsX(ox) != CFG.game.getProvince(ID1).getPointsX(n) || CFG.game.getProvince(ID2).getPointsY(ox) != CFG.game.getProvince(ID1).getPointsY(n)) continue;
                                end = false;
                                nPointsX.add((short)CFG.game.getProvince(ID2).getPointsX(ox));
                                nPointsY.add((short)CFG.game.getProvince(ID2).getPointsY(ox));
                                break;
                            }
                            if (!end) {
                                continue;
                            }
                            break;
                        }
                    }
                }
                if (found) break;
            }
            for (int a = 0; a < nPointsX.size(); ++a) {
                nPointsX.set(a, (short)((Short)nPointsX.get(a) / CFG.map.getMapBG().getMapScale()));
                nPointsY.set(a, (short)((Short)nPointsY.get(a) / CFG.map.getMapBG().getMapScale()));
            }
            if (ID1 > ID2) {
                CFG.game.getProvince(ID2).addProvinceBorder(ID1, nPointsX, nPointsY);
            } else {
                CFG.game.getProvince(ID1).addProvinceBorder(ID2, nPointsX, nPointsY);
            }
            CFG.game.buildGameProvinceData2(ID1);
            CFG.game.buildGameProvinceData2(ID2);
            CFG.menuManager.rebuildMapEditor_Connections_IDs(ID1);
        }
    }

    static class Point {
        final int x;
        final int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point p = (Point)o;
            return this.x == p.x && this.y == p.y;
        }

        public int hashCode() {
            return 31 * this.x + this.y;
        }
    }

    static class IntPair {
        final int a;
        final int b;

        IntPair(int a, int b) {
            this.a = Math.min(a, b);
            this.b = Math.max(a, b);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntPair)) {
                return false;
            }
            IntPair other = (IntPair)o;
            return this.a == other.a && this.b == other.b;
        }

        public int hashCode() {
            return 31 * this.a + this.b;
        }
    }
}

