/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Image;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class ImageManager {
    private static final List<Image> images = new ArrayList<Image>();

    ImageManager() {
    }

    public Texture addAdaptiveImage(File file, int windowWidth, int windowHeight) {
        int texHeight;
        Texture texture = new Texture(String.valueOf(file));
        int texWidth = texture.getWidth();
        float scale = texWidth * windowHeight > (texHeight = texture.getHeight()) * windowWidth ? (float)windowWidth / (float)texWidth : (float)windowHeight / (float)texHeight;
        TextureRegion region = new TextureRegion(texture, 0, 0, (int)((float)texWidth * scale), (int)((float)texHeight * scale));
        return region.getTexture();
    }

    protected static int addImage(String imageName) {
        return ImageManager.addImage(imageName, Texture.TextureFilter.Linear);
    }

    protected static final int addImage(String imageName, Texture.TextureFilter nTextureFilter) {
        return ImageManager.addImage(imageName, Pixmap.Format.RGBA8888, nTextureFilter);
    }

    protected static final int addImage(String imageName, Pixmap.Format nFormat, Texture.TextureFilter nTextureFilter) {
        images.add(new Image(new Texture(Gdx.files.internal(imageName), nFormat, true), nTextureFilter));
        return images.size() - 1;
    }

    protected static final int addImage(String imageName, Pixmap.Format nFormat, Texture.TextureFilter nTextureFilter, Texture.TextureWrap nTextureWrap) {
        images.add(new Image(new Texture(Gdx.files.internal(imageName), nFormat, true), nTextureFilter, nTextureWrap));
        return images.size() - 1;
    }

    protected static final Image getImage(int ID) {
        return images.get(ID);
    }

    protected static final int getImagesSize() {
        return images.size();
    }

    protected static final void dispose() {
        for (int i = 0; i < images.size(); ++i) {
            images.get(i).dispose();
        }
        images.clear();
    }
}

