/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Button_Menu;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import age.of.civilizations2.jakowski.lukasz.LANServer;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.MenuElement;
import age.of.civilizations2.jakowski.lukasz.SliderMenu;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;

public class Menu_Multiplayer
extends SliderMenu {
    private Button_Menu lanButton;
    private boolean isLANRunning = false;
    private final float heightRatio = (float)CFG.GAME_HEIGHT / 1080.0f;
    private final int buttonHeight = (int)(60.0f * this.heightRatio);

    public Menu_Multiplayer() {
        ArrayList<MenuElement> menuElements = new ArrayList<MenuElement>();
        int spacing = (int)(20.0f * this.heightRatio);
        int totalHeight = this.buttonHeight * 2 + spacing;
        int startY = CFG.GAME_HEIGHT / 2 + totalHeight / 2;
        int btnWidth = 400;
        int centerX = CFG.GAME_WIDTH / 2 - btnWidth / 2;
        int lanBtnWidth = 200;
        this.lanButton = new Button_Menu(CFG.langManager.get("LAN a\u011f\u0131 kur"), -1, 20, CFG.GAME_HEIGHT - this.buttonHeight - 20, lanBtnWidth, this.buttonHeight, true);
        menuElements.add(this.lanButton);
        menuElements.add(new Button_Menu(CFG.langManager.get("DirectConnect"), -1, centerX, startY - this.buttonHeight, btnWidth, this.buttonHeight, true));
        menuElements.add(new Button_Menu(CFG.langManager.get("BrowseLobbies"), -1, centerX, startY - this.buttonHeight + this.buttonHeight, btnWidth, this.buttonHeight, true));
        int backBtnWidth = 200;
        int backBtnX = CFG.GAME_WIDTH / 2 - backBtnWidth / 2;
        menuElements.add(new Button_Menu("Back", -1, backBtnX, startY - this.buttonHeight - spacing - this.buttonHeight, backBtnWidth, this.buttonHeight, true));
        this.initMenu(null, 0, 0, CFG.GAME_WIDTH, CFG.GAME_HEIGHT, menuElements);
    }

    @Override
    protected void actionElement(int iID) {
        if (iID == 0) {
            if (!this.isLANRunning) {
                if (LANServer.start()) {
                    this.isLANRunning = true;
                    this.lanButton.setText("Ba\u011flant\u0131y\u0131 kes");
                    CFG.toast.setInView("LAN a\u011f\u0131 ba\u015far\u0131yla kuruldu!", CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                    CFG.toast.setTimeInView(3000);
                } else {
                    CFG.toast.setInView("LAN a\u011f\u0131 kurulamad\u0131!", CFG.COLOR_TEXT_MODIFIER_NEGATIVE2);
                    CFG.toast.setTimeInView(3000);
                }
            } else {
                LANServer.stop();
                this.isLANRunning = false;
                this.lanButton.setText("LAN a\u011f\u0131 kur");
                CFG.toast.setInView("LAN a\u011f\u0131 kapat\u0131ld\u0131", CFG.COLOR_TEXT_MODIFIER_NEGATIVE2);
                CFG.toast.setTimeInView(3000);
            }
        } else if (iID == 1) {
            CFG.menuManager.setViewID(Menu.eMULTIPLAYER_DIRECTCONNECT);
        } else if (iID == 2) {
            CFG.menuManager.setViewID(Menu.eMULTIPLAYER_BROWSE);
        } else if (iID == 3) {
            CFG.menuManager.setViewID(Menu.eMAINMENU);
        }
    }

    @Override
    protected void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean sliderMenuIsActive) {
        oSB.setColor(new Color(0.0f, 0.0f, 0.0f, 0.6f));
        ImageManager.getImage(Images.gradient).draw(oSB, iTranslateX, -ImageManager.getImage(Images.gradient).getHeight() + iTranslateY, CFG.GAME_WIDTH, CFG.PADDING * 3);
        ImageManager.getImage(Images.gradient).draw(oSB, iTranslateX, CFG.GAME_HEIGHT - ImageManager.getImage(Images.gradient).getHeight() - CFG.PADDING * 3 + iTranslateY, CFG.GAME_WIDTH, CFG.PADDING * 3, false, true);
        oSB.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        ImageManager.getImage(Images.patt2).draw(oSB, iTranslateX, -ImageManager.getImage(Images.patt2).getHeight(), CFG.GAME_WIDTH, CFG.GAME_HEIGHT, 0.0f, 0);
        oSB.setColor(Color.WHITE);
        float heightRatio = (float)CFG.GAME_HEIGHT / 1080.0f;
        int panelW = 440;
        int panelH = (int)(200.0f * heightRatio);
        int panelX = CFG.GAME_WIDTH / 2 - panelW / 2;
        int panelY = CFG.GAME_HEIGHT / 2 - panelH / 2;
        ImageManager.getImage(Images.main_menu_edge).draw2(oSB, panelX, panelY, panelW, panelH + this.buttonHeight);
        ImageManager.getImage(Images.main_menu_edge2).draw2(oSB, panelX, panelY, panelW, panelH + this.buttonHeight);
        super.draw(oSB, iTranslateX, iTranslateY, sliderMenuIsActive);
    }
}

