/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class LANServer {
    private static final int PORT = 28082;
    private static Set<ClientHandler> clients = Collections.synchronizedSet(new HashSet());
    private static ServerSocket serverSocket;
    private static boolean isRunning;
    private static Thread serverThread;

    public static boolean start() {
        try {
            serverSocket = new ServerSocket(28082);
            System.out.println("Server 28082 portunda \u00e7al\u0131\u015f\u0131yor...");
            isRunning = true;
            serverThread = new Thread(() -> {
                while (isRunning) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        ClientHandler clientHandler = new ClientHandler(clientSocket);
                        clients.add(clientHandler);
                        new Thread(clientHandler).start();
                    }
                    catch (IOException e) {
                        if (!isRunning) continue;
                        e.printStackTrace();
                    }
                }
            });
            serverThread.start();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void stop() {
        isRunning = false;
        try {
            if (serverSocket != null && !serverSocket.isClosed()) {
                serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        clients.forEach(client -> client.close());
        clients.clear();
    }

    public static boolean isRunning() {
        return isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void broadcast(byte[] message, ClientHandler sender) {
        Set<ClientHandler> set = clients;
        synchronized (set) {
            for (ClientHandler client : clients) {
                if (client == sender) continue;
                client.sendMessage(message);
            }
        }
    }

    static void removeClient(ClientHandler client) {
        clients.remove(client);
    }

    static {
        isRunning = false;
    }

    static class ClientHandler
    implements Runnable {
        private Socket socket;
        private InputStream in;
        private OutputStream out;
        private UUID uid;
        private volatile boolean running = true;

        ClientHandler(Socket socket) {
            this.socket = socket;
            this.uid = UUID.randomUUID();
            try {
                this.in = socket.getInputStream();
                this.out = socket.getOutputStream();
                byte[] uidBytes = ClientHandler.asBytes(this.uid);
                ByteBuffer buffer = ByteBuffer.allocate(4 + uidBytes.length);
                buffer.putInt(uidBytes.length);
                buffer.put(uidBytes);
                this.out.write(buffer.array());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    byte[] lengthBytes = this.in.readNBytes(4);
                    if (lengthBytes.length < 4) {
                        break;
                    }
                    int length = ByteBuffer.wrap(lengthBytes).getInt();
                    if (length <= 0) {
                        break;
                    }
                    byte[] msgBytes = this.in.readNBytes(length);
                    if (msgBytes.length < length) {
                        break;
                    }
                    System.out.println("Gelen mesaj: " + Arrays.toString(msgBytes));
                    LANServer.broadcast(ClientHandler.merge(lengthBytes, msgBytes), this);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
                LANServer.removeClient(this);
                System.out.println("Bir client \u00e7\u0131kt\u0131.");
            }
        }

        void sendMessage(byte[] msgWithLength) {
            try {
                this.out.write(msgWithLength);
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void close() {
            this.running = false;
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static byte[] merge(byte[] a, byte[] b) {
            byte[] result = new byte[a.length + b.length];
            System.arraycopy(a, 0, result, 0, a.length);
            System.arraycopy(b, 0, result, a.length, b.length);
            return result;
        }

        private static byte[] asBytes(UUID uuid) {
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            return bb.array();
        }
    }
}

