/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AI;
import age.of.civilizations2.jakowski.lukasz.BuildingsManager;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Civilization;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.LobbyInfo;
import age.of.civilizations2.jakowski.lukasz.M_P2P;
import age.of.civilizations2.jakowski.lukasz.MessageCategory;
import age.of.civilizations2.jakowski.lukasz.Message_HighInflation;
import age.of.civilizations2.jakowski.lukasz.Save_Provinces_GameData;
import com.badlogic.gdx.Gdx;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

class Game_NextTurnUpdate {
    protected static int INFLATION_PEAK_VALUE = 100;
    protected static final float INFLATION_STARTS_AT = 0.235f;
    protected static final float INFLATION_MODIFIER = 18.12746f;
    protected static float LEAGUE_BUDGET = 1.0f;
    protected static final float TAXES_INFLUENCE_POP = 0.3f;
    protected static final float TAXES_INFLUENCE_PRODUCTION = 0.175f;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_DEFAULT = 9;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MAX = 20;
    protected static final int PERCENTAGE_OF_INCOME_FOR_LORD_MIN = 0;
    protected static final float PERCENTAGE_OF_INCOME_FOR_WAR_REPARATIONS = 0.08f;
    protected static final float EMPLOYEMENT_PER_ECONOMY = 1.025f;
    protected static final float EMPLOYEMENT_PER_ECONOMY_OLD = 1.775f;
    protected static final float DEFENSIVE_POSITION_MILITARY_UPKEEP_PER_TUR = 0.008f;
    protected static final int BUDGET_MAX = 200;

    Game_NextTurnUpdate() {
    }

    protected final void updatePlayableProvinces() {
        int i;
        CFG.oAI.PLAYABLE_PROVINCES = 0;
        for (i = 0; i < CFG.game.getProvincesSize(); ++i) {
            if (CFG.game.getProvince(i).getSeaProvince() || CFG.game.getProvince(i).getWasteland() >= 0) continue;
            AI oa\u0131 = CFG.oAI;
            ++oa\u0131.PLAYABLE_PROVINCES;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = 0;
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            if (CFG.game.getCiv(i).getNumOfProvinces() <= 0) continue;
            AI oa\u01312 = CFG.oAI;
            ++oa\u01312.NUM_OF_CIVS_IN_THE_GAME;
        }
        CFG.oAI.NUM_OF_CIVS_IN_THE_GAME = Math.max(1, CFG.oAI.NUM_OF_CIVS_IN_THE_GAME);
        CFG.oAI.updateMinRivals();
    }

    protected final void updateInflationPeakValue() {
        int i;
        INFLATION_PEAK_VALUE = 1;
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            if (CFG.game.getCiv(i).getNumOfProvinces() <= 0) continue;
            INFLATION_PEAK_VALUE = Math.max(INFLATION_PEAK_VALUE, CFG.game.getCiv((int)i).iIncomeTaxation + CFG.game.getCiv((int)i).iIncomeProduction);
            LEAGUE_BUDGET = (int)Math.max(LEAGUE_BUDGET, (float)(CFG.game.getCiv((int)i).iIncomeTaxation + CFG.game.getCiv((int)i).iIncomeProduction - CFG.game.getCiv((int)i).iAdministrationCosts));
        }
        LEAGUE_BUDGET = (int)(LEAGUE_BUDGET * 0.9f);
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            if (CFG.game.getCiv(i).getNumOfProvinces() <= 0) continue;
            CFG.game.getCiv((int)i).iLeague = Math.min((int)((float)Math.max(CFG.game.getCiv((int)i).iIncomeTaxation + CFG.game.getCiv((int)i).iIncomeProduction - CFG.game.getCiv((int)i).iAdministrationCosts, 0) / LEAGUE_BUDGET * 10.0f), 10);
        }
        for (i = 0; i < CFG.game.getPlayersSize(); ++i) {
            if (!(this.getInflationPerc(CFG.game.getPlayer(i).getCivID()) > 0.0049f)) continue;
            CFG.game.getCiv((int)CFG.game.getPlayer((int)i).getCivID()).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_HighInflation(CFG.game.getPlayer(i).getCivID(), 0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void updateCivs_Money() {
        if (LobbyInfo.lobbyUid != null && !LobbyInfo.lobbyUid.isEmpty()) {
            if (!LobbyInfo.isHost) return;
            for (int i = 1; i < CFG.game.getCivsSize(); ++i) {
                this.getBalance_UpdateBudget_Prepare(i);
            }
            ByteBuffer buffer = ByteBuffer.allocate(4 + CFG.game.getCivsSize() * 12);
            buffer.putInt(CFG.game.getCivsSize());
            for (int i = 0; i < CFG.game.getCivsSize(); ++i) {
                long newMoney = CFG.game.getCiv(i).getMoney() + (long)this.getBalance(i);
                buffer.putLong(newMoney);
                buffer.putInt(CFG.game.getCiv(i).getLoansSize());
            }
            byte[] lobbyUidBytes = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
            ByteBuffer msgBuffer = ByteBuffer.allocate(4 + lobbyUidBytes.length + buffer.position());
            msgBuffer.putInt(lobbyUidBytes.length);
            msgBuffer.put(lobbyUidBytes);
            msgBuffer.put(buffer.array(), 0, buffer.position());
            M_P2P.sendMessage(MessageCategory.MONEY_SYNC, msgBuffer.array());
            buffer.rewind();
            int civCount = buffer.getInt();
            for (int i = 0; i < civCount; ++i) {
                long money = buffer.getLong();
                int loans = buffer.getInt();
                CFG.game.getCiv(i).setMoney(money);
                CFG.game.getCiv(i).updateLoansNextTurn();
            }
        } else {
            int i;
            for (i = 1; i < CFG.game.getCivsSize(); ++i) {
                this.getBalance_UpdateBudget_Prepare(i);
            }
            for (i = 1; i < CFG.game.getCivsSize(); ++i) {
                if (CFG.game.getCiv(i).getNumOfProvinces() <= 0) continue;
                CFG.game.getCiv(i).setMoney(CFG.game.getCiv(i).getMoney() + (long)this.getBalance(i));
                CFG.game.getCiv(i).updateLoansNextTurn();
            }
        }
        Gdx.app.log("AoC", "updateCivs_Money END");
    }

    protected final void updateProvinceStability() {
        int i;
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            CFG.game.getCiv((int)i).lProvincesWithLowStability.clear();
            CFG.game.getCiv((int)i).fStability = 0.0f;
        }
        for (i = 0; i < CFG.game.getProvincesSize(); ++i) {
            if (CFG.game.getProvince(i).getSeaProvince() || CFG.game.getProvince(i).getWasteland() >= 0) continue;
            CFG.game.getProvince(i).updateProvinceStability();
            if (CFG.game.getProvince(i).getCivID() <= 0) continue;
            Civilization civ = CFG.game.getCiv(CFG.game.getProvince(i).getCivID());
            civ.fStability += CFG.game.getProvince(i).getProvinceStability();
        }
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            for (int j = CFG.game.getCiv((int)i).lProvincesWithLowStability.size() - 1; j >= 0; --j) {
                if (!CFG.game.getCiv(i).isAssimilateOrganized(CFG.game.getCiv((int)i).lProvincesWithLowStability.get(j))) continue;
                CFG.game.getCiv((int)i).lProvincesWithLowStability.remove(j);
            }
            CFG.game.getCiv(i).setStability(CFG.game.getCiv((int)i).fStability / (float)CFG.game.getCiv(i).getNumOfProvinces());
        }
    }

    protected final int getBalance(int nCivID) {
        return (int)(this.getIncome(nCivID) - this.getExpenses(nCivID));
    }

    protected final int getAdministration_Capital(int nCivID) {
        return CFG.game.getCiv(nCivID).getCapitalProvinceID() < 0 ? (CFG.game.getCiv(nCivID).getNumOfProvinces() > 0 ? CFG.game.getCiv(nCivID).getProvinceID(0) : 0) : CFG.game.getCiv(nCivID).getCapitalProvinceID();
    }

    protected final void getBalance_UpdateBudget_Prepare(int nCivID) {
        CFG.game.getCiv((int)nCivID).iIncomeTaxation = 0;
        CFG.game.getCiv((int)nCivID).iIncomeProduction = 0;
        CFG.game.getCiv((int)nCivID).iAdministrationCosts = 0;
        int nCapital = this.getAdministration_Capital(nCivID);
        float incomeModifer = this.taxIncome_Modifier(nCivID);
        for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Taxation = this.getProvinceIncome_Taxation(CFG.game.getCiv(nCivID).getProvinceID(i), nCivID, incomeModifer);
            CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Production = this.getProvinceIncome_Production(CFG.game.getCiv(nCivID).getProvinceID(i), nCivID, incomeModifer);
            CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iAdministrationCost = Math.min(CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Taxation + CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Production, this.getProvinceAdministration(CFG.game.getCiv(nCivID).getProvinceID(i), nCapital));
            Civilization civ = CFG.game.getCiv(nCivID);
            civ.iIncomeTaxation += (int)CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Taxation;
            Civilization civ2 = CFG.game.getCiv(nCivID);
            civ2.iIncomeProduction += (int)CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iIncome_Production;
            Civilization civ3 = CFG.game.getCiv(nCivID);
            civ3.iAdministrationCosts += (int)CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).iAdministrationCost;
            if (CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getBalance_LastTurn() < 0) {
                Save_Provinces_GameData saveProvinceData = CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).saveProvinceData;
                ++saveProvinceData.iNumOfTurnsWithBalanceOnMinus;
                continue;
            }
            CFG.game.getProvince((int)CFG.game.getCiv((int)nCivID).getProvinceID((int)i)).saveProvinceData.iNumOfTurnsWithBalanceOnMinus = 0;
        }
        CFG.game.getCiv((int)nCivID).iBudget = (int)(this.getIncome(nCivID) - (float)CFG.game.getCiv((int)nCivID).iAdministrationCosts);
    }

    protected final float getHappinessChange_ByTaxation(int nCivID) {
        return 0.042f + ((CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION + CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(nCivID).getTechnologyLevel() / 21.73f) * 100.0f - CFG.game.getCiv(nCivID).getTaxationLevel() * 100.0f) * (CFG.game.getCiv(nCivID).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION ? 1.45f : 1.0f) * 0.02675f;
    }

    protected final float getHappinessChange_ByTaxation_Occupied(int nCivID) {
        return 0.034f + ((CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION + CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION * CFG.game.getCiv(nCivID).getTechnologyLevel() / 21.73f) * 100.0f - CFG.game.getCiv(nCivID).getTaxationLevel() * 100.0f) * (CFG.game.getCiv(nCivID).getTaxationLevel() > CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).ACCEPTABLE_TAXATION ? 1.45f : 1.0f) * 0.02675f;
    }

    protected float taxIncome_Modifier(int nCivID) {
        if (CFG.game.getCiv(nCivID).getControlledByPlayer()) {
            switch (CFG.DIFFICULTY) {
                case 0: {
                    return 1.25f;
                }
                case 2: {
                    return 1.0f;
                }
                case 3: {
                    return 0.975f;
                }
                case 4: {
                    return 0.95f;
                }
            }
            return 1.025f;
        }
        switch (CFG.DIFFICULTY) {
            case 0: {
                return 0.925f;
            }
            case 2: {
                return 1.025f;
            }
            case 3: {
                return 1.04f;
            }
            case 4: {
                return 1.065f;
            }
        }
        return 1.0f;
    }

    protected final int getMilitarySpendings(int nCivID, int iBudget) {
        return Math.max(0, (int)(this.getMilitaryUpkeep_Total(nCivID) / (float)iBudget * 100.0f));
    }

    protected final float getIncome(int nCivID) {
        float tempTotal = 0.0f;
        tempTotal += (float)CFG.game.getCiv((int)nCivID).iIncomeTaxation;
        tempTotal += (float)CFG.game.getCiv((int)nCivID).iIncomeProduction;
        tempTotal += this.getIncome_FromVassalsOfCiv(nCivID);
        tempTotal += this.getIncome_Debuff_IsVassal(nCivID);
        tempTotal += this.getIncome_Buff_WarReparations(nCivID);
        return (int)(tempTotal += this.getIncome_Debuff_WarReparations(nCivID));
    }

    protected final float getIncome_TaxesLevel(int nCivID) {
        return this.getIncome_TaxesLevel_Taxation(nCivID) + this.getIncome_TaxesLevel_Production(nCivID);
    }

    protected final float getIncome_TaxesLevel_Taxation(int nCivID) {
        float tempTotal = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            tempTotal += this.getProvinceIncome_Taxation(CFG.game.getCiv(nCivID).getProvinceID(i));
        }
        return tempTotal;
    }

    protected final float getIncome_TaxesLevel_Production(int nCivID) {
        float tempTotal = 0.0f;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            tempTotal += this.getProvinceIncome_Production(CFG.game.getCiv(nCivID).getProvinceID(i));
        }
        return tempTotal;
    }

    protected final float getIncome_Debuff_IsVassal(int nCivID) {
        if (CFG.game.getCiv(nCivID).getPuppetOfCivID() != nCivID) {
            return -this.getIncome_Vassals(CFG.game.getCiv(nCivID).getPuppetOfCivID(), nCivID);
        }
        return 0.0f;
    }

    protected final float getIncome_FromVassalsOfCiv(int nCivID) {
        float tempTotal = 0.0f;
        for (int i = CFG.game.getCiv((int)nCivID).civGameData.lVassals.size() - 1; i >= 0; --i) {
            tempTotal += this.getIncome_Vassals(nCivID, CFG.game.getCiv((int)nCivID).civGameData.lVassals.get((int)i).iCivID);
        }
        return tempTotal;
    }

    protected final float getIncome_Debuff_WarReparations(int nCivID) {
        float tempTotal = 0.0f;
        for (int i = CFG.game.getCiv(nCivID).getWarReparationsPaysSize() - 1; i >= 0; --i) {
            tempTotal -= this.getWarReparationsMoney(nCivID);
        }
        return tempTotal;
    }

    protected final float getIncome_Buff_WarReparations(int nCivID) {
        float tempTotal = 0.0f;
        for (int i = CFG.game.getCiv(nCivID).getWarReparationsGetsSize() - 1; i >= 0; --i) {
            tempTotal += this.getWarReparationsMoney(CFG.game.getCiv((int)nCivID).getWarReparationsGets((int)i).iFromCivID);
        }
        return tempTotal;
    }

    protected final float getIncome_Vassals(int nForCivID, int nIsVassal) {
        if (CFG.game.getCiv(nIsVassal).getPuppetOfCivID() == nForCivID) {
            return this.getVassalizationMoney(nIsVassal);
        }
        return 0.0f;
    }

    protected final float getVassalizationMoney(int nVassalID) {
        return (float)CFG.game.getCiv((int)nVassalID).iIncomeTaxation * ((float)CFG.game.getCiv(CFG.game.getCiv(nVassalID).getPuppetOfCivID()).getVassal_Tribute(nVassalID) / 100.0f);
    }

    protected final float getWarReparationsMoney(int nCivID) {
        return (float)CFG.game.getCiv((int)nCivID).iIncomeTaxation * 0.08f;
    }

    protected final float getProvinceIncomeAndExpenses_Total(int nProvinceID) {
        return this.getProvinceIncome_Taxation(nProvinceID) + this.getProvinceIncome_Production(nProvinceID) - (CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getCapitalProvinceID() >= 0 ? this.getProvinceAdministration(nProvinceID, CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getCapitalProvinceID()) : 0.0f);
    }

    protected final float getProvinceIncome_Taxation(int nProvinceID) {
        return this.getProvinceIncome_Taxation(nProvinceID, CFG.game.getProvince(nProvinceID).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(nProvinceID).getCivID()));
    }

    protected final float getProvinceIncome_Taxation(int nProvinceID, int nCivID, float incomeModifer) {
        if (CFG.game.getProvince(nProvinceID).isOccupied()) {
            return this.getProvinceAdministration(nProvinceID, CFG.game_NextTurnUpdate.getAdministration_Capital(nCivID));
        }
        return (float)(Math.pow((float)this.getProvince_EmploymentPopulation(nProvinceID) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(nCivID).getTechnologyLevel() * 21.923813f), 0.8386) + Math.pow((float)this.getProvince_UnemploymentPopulation(nProvinceID) * (CFG.gameAges.getAge_IncomeTaxation_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeTaxation_PerTechnology(Game_Calendar.CURRENT_AGEID) * CFG.game.getCiv(nCivID).getTechnologyLevel() * 21.923813f), 0.7936)) * CFG.gameAges.getAge_TreasuryModifier(Game_Calendar.CURRENT_AGEID) * (0.675f + 0.325f * CFG.game.getProvince(nProvinceID).getProvinceStability()) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).INCOME_TAXATION + CFG.game.getCiv(nCivID).getModifier_IncomeTaxation() + (CFG.game.getProvince(nProvinceID).getIsCapital() ? 0.1f : 0.0f) - 0.16584f + 0.3674786f * CFG.game.getProvince(nProvinceID).getHappiness()) * (0.7f + 0.3f * CFG.game.getCiv(nCivID).getTaxationLevel()) * incomeModifer * Game_Calendar.GAME_SPEED;
    }

    protected final int getProvince_EmploymentPopulation(int nProvinceID) {
        return (int)Math.min((float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation(), (float)CFG.game.getProvince(nProvinceID).getEconomy() * (1.775f + 0.1725f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel() + 0.0925f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTechnologyLevel()));
    }

    protected final int getProvince_UnemploymentPopulation(int nProvinceID) {
        return Math.max(CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation() - this.getProvince_EmploymentPopulation(nProvinceID), 0);
    }

    protected final int getEmploymentPopulation(int nCivID) {
        int out = 0;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            out += this.getProvince_EmploymentPopulation(CFG.game.getCiv(nCivID).getProvinceID(i));
        }
        return out;
    }

    protected final int getUnemploymentPopulation(int nCivID) {
        int out = 0;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            out += this.getProvince_UnemploymentPopulation(CFG.game.getCiv(nCivID).getProvinceID(i));
        }
        return out;
    }

    protected final float getProvinceIncome_Production(int nProvinceID) {
        return this.getProvinceIncome_Production(nProvinceID, CFG.game.getProvince(nProvinceID).getCivID(), this.taxIncome_Modifier(CFG.game.getProvince(nProvinceID).getCivID()));
    }

    protected final float getProvinceIncome_Production(int nProvinceID, int nCivID, float incomeModifer) {
        if (CFG.game.getProvince(nProvinceID).isOccupied()) {
            return (float)((int)Math.min((float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation() * (1.025f + 0.1725f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel() + 0.0425f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTechnologyLevel()), (float)CFG.game.getProvince(nProvinceID).getEconomy())) * (CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID) * CFG.game.getProvince(nProvinceID).getDevelopmentLevel()) * (0.0685f + 0.575f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTechnologyLevel() + 0.8625f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel()) * (0.425f + 0.575f * CFG.game.getProvince(nProvinceID).getProvinceStability()) * CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)nProvinceID).getCivID()).getIdeologyID()).INCOME_PRODUCTION + BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(nProvinceID).getLevelOfPort()) + CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getModifier_IncomeProduction() + (CFG.game.getProvince(nProvinceID).getIsCapital() ? 0.2f : 0.0f) + BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(nProvinceID).getLevelOfWorkshop())) * (0.825f + 0.175f * CFG.game.getCiv(nCivID).getTaxationLevel()) * incomeModifer * Game_Calendar.GAME_SPEED * 0.1f;
        }
        return (float)((int)Math.min((float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation() * (1.025f + 0.1725f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel() + 0.0425f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTechnologyLevel()), (float)CFG.game.getProvince(nProvinceID).getEconomy())) * (CFG.gameAges.getAge_IncomeProduction_Base(Game_Calendar.CURRENT_AGEID) + CFG.gameAges.getAge_IncomeProduction_PerDevelopment(Game_Calendar.CURRENT_AGEID) * CFG.game.getProvince(nProvinceID).getDevelopmentLevel()) * (0.0685f + 0.575f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTechnologyLevel() + 0.8625f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel()) * (0.425f + 0.575f * CFG.game.getProvince(nProvinceID).getProvinceStability()) * CFG.gameAges.getAge_TreasuryModifier_Production(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)nProvinceID).getCivID()).getIdeologyID()).INCOME_PRODUCTION + BuildingsManager.getPort_IncomeProduction(CFG.game.getProvince(nProvinceID).getLevelOfPort()) + CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getModifier_IncomeProduction() + (CFG.game.getProvince(nProvinceID).getIsCapital() ? 0.2f : 0.0f) + BuildingsManager.getWorkshop_IncomeProduction(CFG.game.getProvince(nProvinceID).getLevelOfWorkshop())) * (0.825f + 0.175f * CFG.game.getCiv(nCivID).getTaxationLevel()) * incomeModifer * Game_Calendar.GAME_SPEED;
    }

    protected final float getExpenses(int nCivID) {
        float tempTotal = 0.0f;
        tempTotal += (float)CFG.game.getCiv((int)nCivID).iAdministrationCosts;
        tempTotal += this.getMilitaryUpkeep_Total(nCivID);
        tempTotal += this.getInvestments_Total(nCivID, CFG.game.getCiv((int)nCivID).iBudget);
        tempTotal += this.getGoodsSpendings(nCivID, CFG.game.getCiv((int)nCivID).iBudget);
        tempTotal += this.getInterestCost(nCivID);
        tempTotal += this.getInflation(nCivID);
        return (int)Math.ceil(tempTotal += (float)CFG.game.getCiv(nCivID).getLoans_GoldTotalPerTurn());
    }

    protected final float getExpenses_Budget(int nCivID) {
        float tempTotal = 0.0f;
        return (int)Math.ceil(tempTotal += (float)CFG.game.getCiv((int)nCivID).iAdministrationCosts);
    }

    protected final float getInflation(int nCivID) {
        if (CFG.game.getCiv(nCivID).getMoney() < 0L) {
            return 0.0f;
        }
        try {
            if ((float)CFG.game.getCiv(nCivID).getMoney() / (((float)INFLATION_PEAK_VALUE * 1.1275f + (float)(CFG.game.getCiv((int)nCivID).iIncomeTaxation + CFG.game.getCiv((int)nCivID).iIncomeProduction) * 0.4f) * 18.12746f) > 0.235f) {
                return 1.0f + (float)CFG.game.getCiv(nCivID).getMoney() * ((float)CFG.game.getCiv(nCivID).getMoney() / ((float)INFLATION_PEAK_VALUE * 18.12746f) - 0.235f) * 0.0679248f;
            }
        }
        catch (ArithmeticException ex) {
            return 0.0f;
        }
        return 0.0f;
    }

    protected final float getInflationPerc(int nCivID) {
        return Math.max(this.getInflation(nCivID) / (float)CFG.game.getCiv(nCivID).getMoney(), 0.0f);
    }

    protected final float getInterestCost(int nCivID) {
        if (CFG.game.getCiv(nCivID).getMoney() < 0L) {
            return Math.min((float)Math.abs(CFG.game.getCiv(nCivID).getMoney()) * 0.01274f, Math.abs((float)CFG.game.getCiv((int)nCivID).iBudget * 0.075f));
        }
        return 0.0f;
    }

    protected final float getAdministrationCost_Update(int nCivID) {
        float tempTotal;
        block3: {
            tempTotal = 0.0f;
            try {
                for (int i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
                    tempTotal += this.getProvinceAdministration(CFG.game.getCiv(nCivID).getProvinceID(i), CFG.game_NextTurnUpdate.getAdministration_Capital(nCivID));
                }
            }
            catch (IndexOutOfBoundsException ex) {
                if (!CFG.LOGS) break block3;
                CFG.exceptionStack(ex);
            }
        }
        return tempTotal;
    }

    protected final float getProvinceAdministration(int nProvinceID, int nCapital) {
        return (float)Math.pow((float)CFG.game.getProvince(nProvinceID).getEconomy() * Math.min(1.0f, (float)CFG.game.getProvince(nProvinceID).getEconomy() / (float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation()) * 0.003248f + (float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation() * (0.0024f + 7.25E-4f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel()), 0.93478) * (1.0f + (this.getDistanceFromCapital_PercOfMax(nCapital, nProvinceID) / (1.5275f + CFG.game.getProvince(nProvinceID).getProvinceStability() / 8.0f) * CFG.gameAges.getAge_AdministrationCost_Distance(Game_Calendar.CURRENT_AGEID) + 0.13468f - 0.13468f * CFG.game.getProvince(nProvinceID).getHappiness()) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)nProvinceID).getCivID()).getIdeologyID()).ADMINISTRATION_COST_DISTANCE) * (0.9325f + 0.0715f * CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getTaxationLevel() + 0.0325f * (1.0f - CFG.game.getProvince(nProvinceID).getProvinceStability())) * CFG.gameAges.getAge_TreasuryModifier_Administration(Game_Calendar.CURRENT_AGEID) * (CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)nProvinceID).getCivID()).getIdeologyID()).ADMINISTRATION_COST + CFG.game.getCiv(CFG.game.getProvince(nProvinceID).getCivID()).getModifier_Administation()) * (nProvinceID == nCapital ? CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)CFG.game.getProvince((int)nProvinceID).getCivID()).getIdeologyID()).ADMINISTRATION_COST_CAPITAL : 1.0f) * Game_Calendar.GAME_SPEED;
    }

    protected final float getDistanceFromCapital(int nCapital, int toProvinceID) {
        try {
            if (CFG.map.getMapWorldMap(CFG.map.getActiveMapID())) {
                return Math.min(Math.min((float)Math.sqrt(Math.pow(CFG.game.getProvince(toProvinceID).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real() - CFG.game.getProvince(nCapital).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(toProvinceID).getCenterY_Real() - CFG.game.getProvince(nCapital).getCenterY_Real(), 2.0)), (float)Math.sqrt(Math.pow(CFG.game.getProvince(toProvinceID).getCenterX_Real() - (CFG.game.getProvince(nCapital).getCenterX_Real() + CFG.map.getMapBG().getWidth_Real()), 2.0) + Math.pow(CFG.game.getProvince(toProvinceID).getCenterY_Real() - CFG.game.getProvince(nCapital).getCenterY_Real(), 2.0))), (float)Math.sqrt(Math.pow(CFG.game.getProvince(toProvinceID).getCenterX_Real() - CFG.game.getProvince(nCapital).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(toProvinceID).getCenterY_Real() - CFG.game.getProvince(nCapital).getCenterY_Real(), 2.0)));
            }
            return (float)Math.sqrt(Math.pow(CFG.game.getProvince(toProvinceID).getCenterX_Real() - CFG.game.getProvince(nCapital).getCenterX_Real(), 2.0) + Math.pow(CFG.game.getProvince(toProvinceID).getCenterY_Real() - CFG.game.getProvince(nCapital).getCenterY_Real(), 2.0));
        }
        catch (IndexOutOfBoundsException ex) {
            return CFG.map.getMapBG().getMaxDistance();
        }
    }

    protected final float getDistanceFromCapital_PercOfMax(int nCapital, int toProvinceID) {
        return this.getDistanceFromCapital(nCapital, toProvinceID) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    protected final float getDistanceFromAToB_PercOfMax(int nProvinceA, int nProvinceB) {
        return this.getDistanceFromCapital(nProvinceA, nProvinceB) / (float)CFG.map.getMapBG().getMaxDistance();
    }

    protected final float getMilitaryUpkeep_Total(int nCivID) {
        int i;
        float tempTotal = 0.0f;
        for (i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            tempTotal += this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getProvinceID(i), nCivID);
        }
        for (i = 0; i < CFG.game.getCiv(nCivID).getArmyInAnotherProvinceSize(); ++i) {
            tempTotal += this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getArmyInAnotherProvince(i), nCivID);
        }
        for (i = 0; i < CFG.game.getCiv(nCivID).getMoveUnitsSize(); ++i) {
            tempTotal += this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getMoveUnits(i).getFromProvinceID(), CFG.game.getCiv(nCivID).getMoveUnits(i).getNumOfUnits(), nCivID);
        }
        for (i = 0; i < CFG.game.getCiv(nCivID).getMoveUnitsPlunderSize(); ++i) {
            tempTotal += this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getMoveUnits_Plunder(i).getFromProvinceID(), CFG.game.getCiv(nCivID).getMoveUnits_Plunder(i).getNumOfUnits(), nCivID);
        }
        return (int)Math.ceil(tempTotal);
    }

    protected final float getMilitaryUpkeep(int nProvinceID, int nCivID) {
        return this.getMilitaryUpkeep(nProvinceID, CFG.game.getProvince(nProvinceID).getArmyCivID(nCivID), nCivID);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess(int nProvinceID, int nArmy, int nCivID) {
        int out = 0;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getRecruitArmySize(); ++i) {
            if (CFG.game.getCiv(nCivID).getRecruitArmy(i).getProvinceID() == nProvinceID) continue;
            out += (int)this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(nCivID).getRecruitArmy(i).getArmy(), nCivID);
        }
        return (float)out + this.getMilitaryUpkeep(nProvinceID, nArmy, nCivID);
    }

    protected final float getMilitaryUpkeep_WithAllRecruitmentsInProcess_Disband(int nProvinceID, int nArmy, int nCivID) {
        int out = 0;
        for (int i = 0; i < CFG.game.getCiv(nCivID).getRecruitArmySize(); ++i) {
            if (CFG.game.getCiv(nCivID).getRecruitArmy(i).getProvinceID() == nProvinceID) continue;
            out += (int)this.getMilitaryUpkeep(CFG.game.getCiv(nCivID).getRecruitArmy(i).getProvinceID(), CFG.game.getCiv(nCivID).getRecruitArmy(i).getArmy(), nCivID);
        }
        return (float)out - this.getMilitaryUpkeep(nProvinceID, nArmy, nCivID);
    }

    protected final float getMilitaryUpkeep(int nProvinceID, int nArmy, int nCivID) {
        return (float)Math.pow((float)nArmy * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - 0.1275f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel() - 0.10479f * CFG.game.getCiv(nCivID).getTechnologyLevel()) * (1.0f + CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(nProvinceID).getTerrainTypeID())) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * (1.0f + (float)CFG.game.getCiv(nCivID).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + CFG.game.getCiv(nCivID).getWarWeariness() + CFG.game.getCiv(nCivID).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(nProvinceID).getLevelOfSupply())) * Game_Calendar.GAME_SPEED * (1.0f - this.getMilitaryUpkeep_DefensivePosition(nProvinceID));
    }

    protected final float getMilitaryUpkeep_WithoutDefensivePosition(int nProvinceID, int nArmy, int nCivID) {
        return (float)Math.pow((float)nArmy * CFG.gameAges.getAge_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID), 1.03f - 0.1275f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel() - 0.10479f * CFG.game.getCiv(nCivID).getTechnologyLevel()) * (1.0f + CFG.terrainTypesManager.getMilitaryUpkeep(CFG.game.getProvince(nProvinceID).getTerrainTypeID())) * CFG.ideologiesManager.getIdeology((int)CFG.game.getCiv((int)nCivID).getIdeologyID()).MILITARY_UPKEEP * CFG.gameAges.getAge_TreasuryModifier_MilitaryUpkeep(Game_Calendar.CURRENT_AGEID) * (1.0f + (float)CFG.game.getCiv(nCivID).getNumOfProvinces() / (float)CFG.game.getProvincesSize() * 0.425f + CFG.game.getCiv(nCivID).getWarWeariness() + CFG.game.getCiv(nCivID).getModifier_MilitaryUpkeep() - BuildingsManager.getSupply_Bonus(CFG.game.getProvince(nProvinceID).getLevelOfSupply())) * Game_Calendar.GAME_SPEED;
    }

    protected final float getMilitaryUpkeep_DefensivePosition(int nProvinceID) {
        return 0.008f * (float)CFG.game.getProvince(nProvinceID).getDefensivePosition();
    }

    protected final float getInvestments_Total(int nCivID, int iBudget) {
        return this.getResearchSpendings(nCivID, iBudget) + this.getInvestmentsSpendings(nCivID, iBudget);
    }

    protected final float getResearchSpendings(int nCivID, int iBudget) {
        return (float)iBudget * CFG.game.getCiv(nCivID).getSpendings_Research();
    }

    protected final float getGoodsSpendings(int nCivID, int iBudget) {
        return (float)iBudget * CFG.game.getCiv(nCivID).getSpendings_Goods();
    }

    protected final float getInvestmentsSpendings(int nCivID, int iBudget) {
        return (float)iBudget * CFG.game.getCiv(nCivID).getSpendings_Investments();
    }

    protected final void updateSpendingsOfCiv(int nCivID, int iBudget) {
        if (CFG.game.getCiv(nCivID).getCapitalProvinceID() >= 0 && CFG.game.getCiv(nCivID).getNumOfProvinces() > 0) {
            int tempMilitary;
            if (CFG.game.getCiv(nCivID).getMoney() < -500L) {
                CFG.game.getCiv(nCivID).setSpendings_Research(0.0f);
            }
            if (iBudget <= 0) {
                CFG.game.getCiv(nCivID).setSpendings_Goods(0.0f);
                CFG.game.getCiv(nCivID).setSpendings_Research(0.0f);
                CFG.game.getCiv(nCivID).setSpendings_Investments(0.0f);
            }
            if ((tempMilitary = this.getMilitarySpendings(nCivID, iBudget)) + (int)(CFG.game.getCiv(nCivID).getSpendings_Goods() * 100.0f) > 200) {
                CFG.game.getCiv(nCivID).setSpendings_Goods((float)(200 - tempMilitary) / 100.0f);
            }
            if ((tempMilitary += (int)(CFG.game.getCiv(nCivID).getSpendings_Goods() * 100.0f)) + (int)(CFG.game.getCiv(nCivID).getSpendings_Research() * 100.0f) + (int)(CFG.game.getCiv(nCivID).getSpendings_Investments() * 100.0f) > 200) {
                if (tempMilitary > 200) {
                    CFG.game.getCiv(nCivID).setSpendings_Research(0.0f);
                    CFG.game.getCiv(nCivID).setSpendings_Investments(0.0f);
                    return;
                }
                int overBudget = (int)(CFG.game.getCiv(nCivID).getSpendings_Research() * 100.0f) + (int)(CFG.game.getCiv(nCivID).getSpendings_Investments() * 100.0f) + tempMilitary - 200;
                int tempBef = (int)(CFG.game.getCiv(nCivID).getSpendings_Research() * 100.0f);
                CFG.game.getCiv(nCivID).setSpendings_Research(CFG.game.getCiv(nCivID).getSpendings_Research() - (float)overBudget / 2.0f / 100.0f);
                overBudget -= (int)((float)tempBef - CFG.game.getCiv(nCivID).getSpendings_Research() * 100.0f);
                if ((float)overBudget < CFG.game.getCiv(nCivID).getSpendings_Investments() * 100.0f) {
                    CFG.game.getCiv(nCivID).setSpendings_Investments(CFG.game.getCiv(nCivID).getSpendings_Investments() - (float)overBudget / 100.0f);
                } else {
                    CFG.game.getCiv(nCivID).setSpendings_Investments(0.0f);
                    CFG.game.getCiv(nCivID).setSpendings_Research(CFG.game.getCiv(nCivID).getSpendings_Research() - (float)(overBudget -= (int)(CFG.game.getCiv(nCivID).getSpendings_Investments() * 100.0f)) / 100.0f);
                }
            }
        }
    }

    protected final void updateCities() {
        for (int i = 1; i < CFG.game.getCivsSize(); ++i) {
            this.updateCities(i);
        }
    }

    protected final void updateCities(int nCivID) {
        int i;
        int tempNumOfCities = (int)Math.ceil((float)(CFG.game.getCiv(nCivID).getNumOfProvinces() * CFG.settingsManager.PERCETANGE_OF_CITIES_ON_MAP) / 100.0f);
        int tMaxPopulation = 1;
        ArrayList<Integer> tempProvinces = new ArrayList<Integer>();
        for (i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            tempProvinces.add(CFG.game.getCiv(nCivID).getProvinceID(i));
            CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).setDrawCities(CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getLevelOfPort() > 0 || CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getLevelOfArmoury() > 0);
            if (CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).isOccupied() || tMaxPopulation >= CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation()) continue;
            tMaxPopulation = CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation();
        }
        for (i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
            for (int j = 0; j < CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getCitiesSize(); ++j) {
                if (CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getCity(j).getCityLevel() == CFG.getEditorCityLevel(0)) continue;
                CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getCity(j).setCityLevel(this.getLevelOfCity(tMaxPopulation, CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation(), j));
            }
        }
        for (int k = 0; k < tempNumOfCities; ++k) {
            int largestProvinceID = 0;
            int largestPopulation = CFG.game.getProvince((Integer)tempProvinces.get(largestProvinceID)).getPopulationData().getPopulation();
            int iSize = tempProvinces.size();
            for (int l = 1; l < iSize; ++l) {
                if (largestPopulation >= CFG.game.getProvince((Integer)tempProvinces.get(l)).getPopulationData().getPopulation()) continue;
                largestProvinceID = l;
                largestPopulation = CFG.game.getProvince((Integer)tempProvinces.get(largestProvinceID)).getPopulationData().getPopulation();
            }
            CFG.game.getProvince((Integer)tempProvinces.get(largestProvinceID)).setDrawCities(true);
            tempProvinces.remove(largestProvinceID);
        }
        if (CFG.game.getCiv(nCivID).getCapitalProvinceID() >= 0) {
            CFG.game.getProvince(CFG.game.getCiv(nCivID).getCapitalProvinceID()).setDrawCities(true);
        }
        tempProvinces.clear();
    }

    protected int getLevelOfCity(int nMaxPopulation, int nPopulation, int nCityID) {
        float nScore = (float)nPopulation / (float)nMaxPopulation;
        int out = 4;
        out = nScore >= 0.765f ? 1 : (nScore >= 0.575f ? 2 : (nScore >= 0.325f ? 3 : 4));
        return CFG.getEditorCityLevel(out);
    }

    protected final void buildLevelsOfCities() {
        int i;
        for (i = 0; i < CFG.game.getProvincesSize(); ++i) {
            for (int j = 0; j < CFG.game.getProvince(i).getCitiesSize(); ++j) {
                CFG.game.getProvince(i).getCity(j).setCityLevel(CFG.getEditorCityLevel(4));
            }
        }
        for (i = 1; i < CFG.game.getCivsSize(); ++i) {
            this.buildLevelsOfCities(i);
        }
    }

    protected final void buildLevelsOfCities(int nCivID) {
        block7: {
            int i;
            int tMaxPop = 0;
            for (i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
                if (tMaxPop >= CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation()) continue;
                tMaxPop = CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation();
            }
            for (i = 0; i < CFG.game.getCiv(nCivID).getNumOfProvinces(); ++i) {
                for (int j = 0; j < CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getCitiesSize(); ++j) {
                    CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getCity(j).setCityLevel(CFG.getCityLevel_Population(tMaxPop, CFG.game.getProvince(CFG.game.getCiv(nCivID).getProvinceID(i)).getPopulationData().getPopulation(), j));
                }
            }
            try {
                CFG.game.getProvince(CFG.game.getCiv(nCivID).getCapitalProvinceID()).getCity(0).setCityLevel(CFG.getEditorCityLevel(0));
            }
            catch (IndexOutOfBoundsException ex) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(ex);
                }
            }
            catch (NullPointerException ex2) {
                if (!CFG.LOGS) break block7;
                CFG.exceptionStack(ex2);
            }
        }
    }
}

