/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Button_Menu_LR_MainMenu;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.CFG_Zetvl;
import age.of.civilizations2.jakowski.lukasz.Dialog;
import age.of.civilizations2.jakowski.lukasz.Image;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.MenuElement;
import age.of.civilizations2.jakowski.lukasz.MenuElements;
import age.of.civilizations2.jakowski.lukasz.SliderMenu;
import age.of.civilizations2.jakowski.lukasz.Text;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.SerializationException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class InterfaceManager {
    public static Json json;
    public static List<Image> ZetvlTextures;
    public static Map<String, BitmapFont> ZetvlFont;
    public static List<String> ZetvlTexturesName;
    public static MainGUI EditableMainGUI;
    public static SliderMenu MenuMainGUI;
    public static List<TextureINI> textureINIS;
    public static List<Font> Fonts;
    public static ColorINI colorINI;

    public static final void init() {
        InterfaceManager.load_ColorINI();
        InterfaceManager.load_TextureINI();
        InterfaceManager.load_Main();
    }

    public static void load_font() {
        FileHandle fileHandle = Gdx.files.internal("ZetvlUniverse/interface/fonts.json");
        if (fileHandle.exists()) {
            Fonts = json.fromJson(List.class, Font.class, fileHandle.readString("UTF-8"));
            for (int i = 0; i < Fonts.size(); ++i) {
                FreeTypeFontGenerator genarator;
                String sFont = InterfaceManager.Fonts.get((int)i).path;
                try {
                    genarator = new FreeTypeFontGenerator(Gdx.files.internal(sFont));
                }
                catch (GdxRuntimeException var3) {
                    Gdx.app.error("Zetvl", "Load Font Failed!", var3);
                    continue;
                }
                FreeTypeFontGenerator.FreeTypeFontParameter params = new FreeTypeFontGenerator.FreeTypeFontParameter();
                params.characters = CFG.langManager.getMerge();
                params.size = (int)Math.max((float)CFG.settingsManager.FONT_MAIN_SIZE * InterfaceManager.Fonts.get((int)i).scale, 6.0f);
                params.color = InterfaceManager.Fonts.get((int)i).color;
                params.minFilter = Texture.TextureFilter.Linear;
                params.magFilter = Texture.TextureFilter.Linear;
                params.borderWidth = InterfaceManager.Fonts.get((int)i).border ? 1.0f : 0.0f;
                params.packer = new PixmapPacker(3379, 3379, Pixmap.Format.RGBA8888, 2, false);
                BitmapFont bitmapFont = genarator.generateFont(params);
                genarator.dispose();
                genarator = null;
                ZetvlFont.put(InterfaceManager.Fonts.get((int)i).name, bitmapFont);
            }
        } else {
            ArrayList<Font> fonts = new ArrayList<Font>();
            fonts.add(new Font("tfr"));
            fonts.add(new Font("FZRuiZHK", "game/fonts/ZHK.ttf"));
            String s = json.prettyPrint(fonts);
            Gdx.files.local("ZetvlUniverse/interface/fonts_Example.json").writeString(s, false);
        }
    }

    public static void load_TextureINI() {
        block10: {
            FileHandle fileHandle = Gdx.files.internal("ZetvlUniverse/interface/textures.json");
            try {
                textureINIS = json.fromJson(List.class, TextureINI.class, fileHandle);
                for (int i = 0; i < textureINIS.size(); ++i) {
                    fileHandle = Gdx.files.internal(InterfaceManager.textureINIS.get((int)i).path);
                    if (!fileHandle.exists()) {
                        Gdx.app.log("Zetvl-Interface", "Not Found: " + fileHandle.path());
                        continue;
                    }
                    if (InterfaceManager.textureINIS.get((int)i).Tile) {
                        ZetvlTextures.add(new Image(new Texture(fileHandle, Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear, Texture.TextureWrap.MirroredRepeat));
                    } else {
                        ZetvlTextures.add(new Image(new Texture(fileHandle, true)));
                    }
                    ZetvlTexturesName.add(InterfaceManager.textureINIS.get((int)i).name);
                    Gdx.app.log("Zetvl-Interface", "Load Success: " + InterfaceManager.textureINIS.get((int)i).path);
                    Gdx.app.log("Zetvl-Interface", "New Gui: " + InterfaceManager.textureINIS.get((int)i).name);
                }
            }
            catch (GdxRuntimeException var1) {
                if (!Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").exists()) {
                    json.setUsePrototypes(false);
                    textureINIS.add(new TextureINI("AoHGame"));
                    textureINIS.add(new TextureINI("super_event", "gfx/interface/super_event/super_event.png"));
                    textureINIS.add(new TextureINI("process_bar", "gfx/loadingscreen/bar.png", true));
                    String string = json.prettyPrint(textureINIS);
                    Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").writeString(string, false, "UTF-8");
                    json.setUsePrototypes(true);
                    textureINIS.clear();
                }
            }
            catch (SerializationException var2) {
                if (Objects.equals(var2.getMessage(), "Error reading file: ZetvlUniverse/interface/textures.json")) {
                    if (!Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").exists()) {
                        json.setUsePrototypes(false);
                        textureINIS.add(new TextureINI("AoHGame"));
                        textureINIS.add(new TextureINI("super_event", "gfx/interface/super_event/super_event.png"));
                        textureINIS.add(new TextureINI("process_bar", "gfx/loadingscreen/bar.png", true));
                        String string = json.prettyPrint(textureINIS);
                        Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").writeString(string, false, "UTF-8");
                        json.setUsePrototypes(true);
                        textureINIS.clear();
                    }
                }
                Gdx.app.error("Zetvl", var2.getMessage(), var2);
                if (Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").exists()) break block10;
                json.setUsePrototypes(false);
                textureINIS.add(new TextureINI("AoHGame"));
                textureINIS.add(new TextureINI("super_event", "gfx/interface/super_event/super_event.png"));
                textureINIS.add(new TextureINI("process_bar", "gfx/loadingscreen/bar.png", true));
                String string = json.prettyPrint(textureINIS);
                Gdx.files.local("ZetvlUniverse/interface/textures_Example.json").writeString(string, false, "UTF-8");
                json.setUsePrototypes(true);
                textureINIS.clear();
            }
        }
    }

    public static void load_Main() {
        FileHandle fileHandle = Gdx.files.internal("ZetvlUniverse/interface/main.json");
        try {
            EditableMainGUI = json.fromJson(MainGUI.class, fileHandle);
            try {
                MenuMainGUI = new Menu_Main(EditableMainGUI);
            }
            catch (Throwable ex) {
                Gdx.app.error("Zetvl", "load Interface Main Failed!", ex);
            }
        }
        catch (GdxRuntimeException | SerializationException var2) {
            if (Objects.equals(var2.getMessage(), "Error reading file: ZetvlUniverse/interface/main.json")) {
                if (!Gdx.files.local("ZetvlUniverse/interface/main_Example.json").exists()) {
                    MainGUI mainGUI = new MainGUI();
                    mainGUI.PosX = "0";
                    mainGUI.PosY = "0";
                    mainGUI.Width = "GAME_WIDTH";
                    mainGUI.Height = "GAME_HEIGHT";
                    mainGUI.DrawModule.add(new MainGUI.DrawElement(0, 0, "bg1", MainGUI.DrawElement.DrawType.Image));
                    mainGUI.DrawModule.add(new MainGUI.DrawElement(0, 0, "test1", MainGUI.DrawElement.DrawType.FontMain));
                    mainGUI.DrawModule.add(new MainGUI.DrawElement(0, 0, "test2", MainGUI.DrawElement.DrawType.FontSpec));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 3, "Games", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "NewGames", MainGUI.ActionElementType.Games, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 4 + CFG.PADDING, "Editor", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Edit", MainGUI.ActionElementType.Editor, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 5 + CFG.PADDING * 2, "Settings", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Modify Your Game", MainGUI.ActionElementType.Settings, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 6 + CFG.PADDING * 3, "Tutorial", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Start Tutorial", MainGUI.ActionElementType.Tutorial, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 7 + CFG.PADDING * 4, "About", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Author: Fanillanus, Contact Information: QQ 3156785429 | Email: XaeoFanillanus@outlook.com", MainGUI.ActionElementType.About, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 8 + CFG.PADDING * 5, "Exit", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Exit Game?", MainGUI.ActionElementType.Exit, MainGUI.MenuElementType.Button));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 9 + CFG.PADDING * 6, "AoH2", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "Age of History II", MainGUI.ActionElementType.Empty, MainGUI.MenuElementType.Text));
                    mainGUI.menuElements.add(new MainGUI.MenuElement(CFG.GAME_WIDTH / 6, CFG.BUTTON_HEIGHT * 9 + CFG.PADDING * 6, "Zetvl System", CFG.BUTTON_WIDTH * 4, CFG.BUTTON_HEIGHT, "By Fanillanus", MainGUI.ActionElementType.Empty, MainGUI.MenuElementType.Text));
                    mainGUI.menuElements.get((int)(mainGUI.menuElements.size() - 1)).DrawModule.add(new MainGUI.DrawElement(0, 0, 25, 25, "Zetvl System", MainGUI.DrawElement.DrawType.FontSpec));
                    mainGUI.menuElements.get((int)(mainGUI.menuElements.size() - 2)).DrawModule.add(new MainGUI.DrawElement(0, 0, 25, 25, "AoH2", MainGUI.DrawElement.DrawType.FontMain));
                    mainGUI.menuElements.get((int)(mainGUI.menuElements.size() - 2)).TextCustomDraw = true;
                    mainGUI.menuElements.get((int)(mainGUI.menuElements.size() - 1)).TextCustomDraw = true;
                    json.setUsePrototypes(false);
                    String write = json.prettyPrint(mainGUI);
                    Gdx.files.local("ZetvlUniverse/interface/main_Example.json").writeString(write, false);
                }
            }
            Gdx.app.error("Zetvl", var2.getMessage(), var2);
        }
    }

    public static Image getImage(String name) {
        int index = ZetvlTexturesName.indexOf(name);
        if (index == -1) {
            throw new NoSuchFieldError("No virtual field " + name + " of type age.of.civilizations2.jakowski.lukasz.Image in class Lage/of/civilizations2/jakowski/lukasz/InterfaceManager");
        }
        return ZetvlTextures.get(index);
    }

    public static BitmapFont getFont(String name) {
        return ZetvlFont.getOrDefault(name, CFG.fontMain);
    }

    protected static void drawText(SpriteBatch oSB, String sText, int nPosX, int nPosY, String font) {
        try {
            InterfaceManager.getFont(font).draw((Batch)oSB, sText, (float)nPosX, (float)(-nPosY));
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected static void drawText(SpriteBatch oSB, String sText, int nPosX, int nPosY, Color color, String font) {
        try {
            InterfaceManager.getFont(font).setColor(color);
            InterfaceManager.getFont(font).draw((Batch)oSB, sText, (float)nPosX, (float)(-nPosY));
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void load_ColorINI() {
        block11: {
            FileHandle fileHandle = Gdx.files.internal("ZetvlUniverse/interface/colorful.json");
            try {
                colorINI = json.fromJson(ColorINI.class, fileHandle);
                ColorINI tempColorINI = new ColorINI();
                try {
                    for (Field field : ColorINI.class.getDeclaredFields()) {
                        if (!Color.class.isAssignableFrom(field.getType())) continue;
                        Color sourceColor = (Color)field.get(colorINI);
                        Color targetColor = (Color)field.get(tempColorINI);
                        if (sourceColor == null || targetColor == null) continue;
                        targetColor.set(sourceColor);
                    }
                }
                catch (IllegalAccessException e) {
                    Gdx.app.error("Zetvl", "Error copying color config", e);
                }
                colorINI = tempColorINI;
                try {
                    Class<?> cfgClass = Class.forName("age.of.civilizations2.jakowski.lukasz.CFG");
                    for (Field iniField : ColorINI.class.getDeclaredFields()) {
                        if (!Color.class.isAssignableFrom(iniField.getType())) continue;
                        String fieldName = iniField.getName();
                        try {
                            Field cfgField = cfgClass.getDeclaredField(fieldName);
                            if (!Color.class.isAssignableFrom(cfgField.getType())) continue;
                            Color colorValue = (Color)iniField.get(colorINI);
                            cfgField.set(null, colorValue);
                        }
                        catch (NoSuchFieldException e) {
                            Gdx.app.log("Zetvl", "No matching field in CFG: " + fieldName);
                        }
                        catch (IllegalAccessException e) {
                            Gdx.app.error("Zetvl", "Access denied for CFG field: " + fieldName, e);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    Gdx.app.error("Zetvl", "CFG class not found", e);
                }
            }
            catch (Exception ex) {
                Gdx.app.error("Zetvl", "Color Load Failed!", ex);
                if (Gdx.files.local("ZetvlUniverse/interface/colorful_Example.json").exists()) break block11;
                json.setUsePrototypes(false);
                String string = json.prettyPrint(colorINI);
                Gdx.files.local("ZetvlUniverse/interface/colorful_Example.json").writeString(string, false, "UTF-8");
                json.setUsePrototypes(true);
            }
        }
    }

    public static void dispose() {
        int i;
        for (i = 0; i < ZetvlTextures.size(); ++i) {
            try {
                ZetvlTextures.get(i).dispose();
                continue;
            }
            catch (GdxRuntimeException gdxRuntimeException) {
                // empty catch block
            }
        }
        for (i = 0; i < ZetvlFont.size(); ++i) {
            try {
                ZetvlFont.get(i).dispose();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        textureINIS.clear();
        ZetvlTextures.clear();
        ZetvlTexturesName.clear();
    }

    protected static int ElementCalculate(String formula) {
        ExpressionBuilder builder = new ExpressionBuilder(formula);
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            builder.variable(ZetvlTexturesName.get(i) + "_WIDTH");
            builder.variable(ZetvlTexturesName.get(i) + "_HEIGHT");
        }
        builder.variable("GAME_WIDTH");
        builder.variable("GAME_HEIGHT");
        Expression expression = builder.build();
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            expression.setVariable(ZetvlTexturesName.get(i) + "_WIDTH", (double)ZetvlTextures.get(i).getWidth());
            expression.setVariable(ZetvlTexturesName.get(i) + "_HEIGHT", (double)ZetvlTextures.get(i).getHeight());
        }
        expression.setVariable("GAME_WIDTH", (double)CFG.GAME_WIDTH);
        expression.setVariable("GAME_HEIGHT", (double)CFG.GAME_HEIGHT);
        return (int)expression.evaluate();
    }

    protected static int ElementCalculate(String formula, List<String> var, List<Integer> value) {
        int i;
        int i2;
        ExpressionBuilder builder = new ExpressionBuilder(formula);
        for (i2 = 0; i2 < ZetvlTextures.size(); ++i2) {
            builder.variable(ZetvlTexturesName.get(i2) + "_WIDTH");
            builder.variable(ZetvlTexturesName.get(i2) + "_HEIGHT");
        }
        for (i2 = 0; i2 < var.size(); ++i2) {
            builder.variable(var.get(i2));
        }
        builder.variable("GAME_WIDTH");
        builder.variable("GAME_HEIGHT");
        Expression expression = builder.build();
        for (i = 0; i < ZetvlTextures.size(); ++i) {
            expression.setVariable(ZetvlTexturesName.get(i) + "_WIDTH", (double)ZetvlTextures.get(i).getWidth());
            expression.setVariable(ZetvlTexturesName.get(i) + "_HEIGHT", (double)ZetvlTextures.get(i).getHeight());
        }
        for (i = 0; i < var.size(); ++i) {
            expression.setVariable(var.get(i), (double)value.get(i).intValue());
        }
        expression.setVariable("GAME_WIDTH", (double)CFG.GAME_WIDTH);
        expression.setVariable("GAME_HEIGHT", (double)CFG.GAME_HEIGHT);
        return (int)expression.evaluate();
    }

    protected static int ElementCalculate(String formula, Map<String, Integer> var) {
        ExpressionBuilder builder = new ExpressionBuilder(formula);
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            builder.variable(ZetvlTexturesName.get(i) + "_WIDTH");
            builder.variable(ZetvlTexturesName.get(i) + "_HEIGHT");
        }
        for (Map.Entry<String, Integer> entry : var.entrySet()) {
            builder.variable(entry.getKey());
        }
        builder.variable("GAME_WIDTH");
        builder.variable("GAME_HEIGHT");
        Expression expression = builder.build();
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            expression.setVariable(ZetvlTexturesName.get(i) + "_WIDTH", (double)ZetvlTextures.get(i).getWidth());
            expression.setVariable(ZetvlTexturesName.get(i) + "_HEIGHT", (double)ZetvlTextures.get(i).getHeight());
        }
        for (Map.Entry<String, Integer> entry : var.entrySet()) {
            expression.setVariable(entry.getKey(), (double)entry.getValue().intValue());
        }
        expression.setVariable("GAME_WIDTH", (double)CFG.GAME_WIDTH);
        expression.setVariable("GAME_HEIGHT", (double)CFG.GAME_HEIGHT);
        return (int)expression.evaluate();
    }

    protected static int ElementCalculate_This(String formula, int This) {
        ExpressionBuilder builder = new ExpressionBuilder(formula);
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            builder.variable(ZetvlTexturesName.get(i) + "_WIDTH");
            builder.variable(ZetvlTexturesName.get(i) + "_HEIGHT");
        }
        builder.variable("THIS");
        builder.variable("GAME_WIDTH");
        builder.variable("GAME_HEIGHT");
        Expression expression = builder.build();
        for (int i = 0; i < ZetvlTextures.size(); ++i) {
            expression.setVariable(ZetvlTexturesName.get(i) + "_WIDTH", (double)ZetvlTextures.get(i).getWidth());
            expression.setVariable(ZetvlTexturesName.get(i) + "_HEIGHT", (double)ZetvlTextures.get(i).getHeight());
        }
        expression.setVariable("THIS", (double)This);
        expression.setVariable("GAME_WIDTH", (double)CFG.GAME_WIDTH);
        expression.setVariable("GAME_HEIGHT", (double)CFG.GAME_HEIGHT);
        return (int)expression.evaluate();
    }

    public static void actionReturn(MainGUI.ActionElementType actionElementType) {
        switch (actionElementType) {
            case Empty: {
                break;
            }
            case Games: {
                CFG.menuManager.setViewID(Menu.eGAMES);
                CFG.menuManager.setOrderOfMenu_Games();
                break;
            }
            case Editor: {
                CFG.menuManager.setViewID(Menu.eEDITOR);
                CFG.menuManager.setOrderOfMenu_Games();
                break;
            }
            case Settings: {
                CFG.menuManager.setViewID(Menu.eSETTINGS);
                CFG.menuManager.setOrderOfMenu_Games();
                break;
            }
            case Tutorial: {
                CFG.setDialogType(Dialog.START_TUTORIAL);
                break;
            }
            case About: {
                CFG.menuManager.setViewID(Menu.ZETVL_INTERFACE);
                CFG.menuManager.setOrderOfMenu_Games();
                break;
            }
            case Exit: {
                CFG.setDialogType(Dialog.EXIT_GAME);
            }
        }
    }

    public static void drawReturn(SpriteBatch oSB, int iTranslateX, int iTranslateY, List<MainGUI.DrawElement> drawElements, Map<String, Integer> integerMap, boolean isTranslate) {
        block5: for (int i = 0; i < drawElements.size(); ++i) {
            switch (drawElements.get((int)i).drawType) {
                case Image: {
                    HashMap<String, Integer> integerMap1 = new HashMap<String, Integer>(integerMap);
                    integerMap1.put("THIS_WIDTH", InterfaceManager.getImage(drawElements.get((int)i).ImageField).getWidth());
                    integerMap1.put("THIS_HEIGHT", InterfaceManager.getImage(drawElements.get((int)i).ImageField).getHeight());
                    InterfaceManager.getImage(drawElements.get((int)i).ImageField).draw(oSB, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosX, integerMap1) + iTranslateX, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosY, integerMap1) - InterfaceManager.getImage(drawElements.get((int)i).ImageField).getHeight() + iTranslateY, InterfaceManager.ElementCalculate(drawElements.get((int)i).Width, integerMap1), InterfaceManager.ElementCalculate(drawElements.get((int)i).Height, integerMap1));
                    continue block5;
                }
                case FontMain: {
                    CFG.drawText(oSB, drawElements.get((int)i).Text, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosX, integerMap) + iTranslateX, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosY, integerMap) + iTranslateY, drawElements.get((int)i).Color);
                    continue block5;
                }
                case FontSpec: {
                    CFG.drawText2(oSB, drawElements.get((int)i).Text, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosX, integerMap) + iTranslateX, InterfaceManager.ElementCalculate(drawElements.get((int)i).PosY, integerMap) + iTranslateY, drawElements.get((int)i).Color);
                }
            }
        }
    }

    static {
        ZetvlTextures = new ArrayList<Image>();
        ZetvlFont = new HashMap<String, BitmapFont>();
        ZetvlTexturesName = new ArrayList<String>();
        textureINIS = new ArrayList<TextureINI>();
        Fonts = new ArrayList<Font>();
        colorINI = new ColorINI();
        json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        json.setTypeName(null);
        json.setSerializer(Color.class, new ColorSerializer());
    }

    public static class Font {
        public String name = "";
        public String path = "";
        public float scale = 1.0f;
        public boolean border = false;
        public Color color = Color.WHITE;

        public Font() {
        }

        protected Font(String name, String path, float scale) {
            this.name = name;
            this.path = path;
            this.scale = scale;
        }

        protected Font(String name, String path, boolean border) {
            this.name = name;
            this.path = path;
            this.border = border;
        }

        protected Font(String name, String path, Color color) {
            this.name = name;
            this.path = path;
            this.color = color;
        }

        protected Font(String name, String path) {
            this.name = name;
            this.path = path;
        }

        protected Font(String name) {
            this.name = name;
            this.path = "gfx/fonts/" + name;
        }
    }

    public static class TextureINI {
        public String name = "";
        public String path = "";
        public boolean Tile = false;

        public TextureINI() {
        }

        protected TextureINI(String name, String path, boolean tile) {
            this.name = name;
            this.path = path;
            this.Tile = tile;
        }

        protected TextureINI(String name, String path) {
            this.name = name;
            this.path = path;
        }

        protected TextureINI(String name) {
            this.name = name;
            this.path = "gfx/interface/" + name + ".png";
        }
    }

    public static class MainGUI {
        public List<MenuElement> menuElements = new ArrayList<MenuElement>();
        public DrawOption DrawOption = new DrawOption();
        public List<DrawElement> DrawModule = new ArrayList<DrawElement>();
        public boolean needJoinTime = false;
        public String PosX = "MAIN_X";
        public String PosY = "MAIN_Y";
        public String Width = "MAIN_WIDTH";
        public String Height = "MAIN_HEIGHT";
        public boolean isTranslate = true;

        public static class DrawOption {
            public boolean isTranslate = false;
        }

        public static class MenuElement {
            public boolean BGCustomDraw = false;
            public boolean TextCustomDraw = false;
            public boolean canClick = true;
            public MenuElementType menuElementType = MenuElementType.Empty;
            public ActionElementType actionElementType = ActionElementType.Empty;
            public String PosX = "";
            public String PosY = "";
            public String Width = "";
            public String Height = "";
            public String Text = "";
            public String HoverText = "";
            public List<DrawElement> DrawModule = new ArrayList<DrawElement>();
            public List<DrawElement> DrawModuleBG = new ArrayList<DrawElement>();

            public MenuElement() {
            }

            public MenuElement(int PosX, int PosY, String str) {
                this.PosX = String.valueOf(PosX);
                this.PosY = String.valueOf(PosY);
                this.Text = str;
            }

            public MenuElement(int PosX, int PosY, String str, int Width, int Height) {
                this.PosX = String.valueOf(PosX);
                this.PosY = String.valueOf(PosY);
                this.Width = String.valueOf(Width);
                this.Height = String.valueOf(Height);
                this.Text = str;
            }

            public MenuElement(int PosX, int PosY, String str, int Width, int Height, String hoverText, ActionElementType actionElementType, MenuElementType menuElementType) {
                this.PosX = String.valueOf(PosX);
                this.PosY = String.valueOf(PosY);
                this.Width = String.valueOf(Width);
                this.Height = String.valueOf(Height);
                this.Text = str;
                this.HoverText = hoverText;
                this.actionElementType = actionElementType;
                this.menuElementType = menuElementType;
            }
        }

        public static class DrawElement {
            public DrawType drawType = DrawType.FontMain;
            public String Text = "";
            public Color Color = com.badlogic.gdx.graphics.Color.WHITE;
            public String ImageField = "";
            public String PosX = "";
            public String PosY = "";
            public String Width = "";
            public String Height = "";
            public int FontSize = 18;

            public DrawElement() {
            }

            public DrawElement(int PosX, int PosY, String str, DrawType drawType) {
                this.PosX = String.valueOf(PosX);
                this.PosY = String.valueOf(PosY);
                switch (drawType) {
                    case FontMain: 
                    case FontSpec: {
                        this.Text = str;
                    }
                    case Image: {
                        this.ImageField = str;
                    }
                }
            }

            public DrawElement(int PosX, int PosY, int Width, int Height, String str, DrawType drawType) {
                this.PosX = String.valueOf(PosX);
                this.PosY = String.valueOf(PosY);
                this.Width = String.valueOf(Width);
                this.Height = String.valueOf(Height);
                switch (drawType) {
                    case FontMain: 
                    case FontSpec: {
                        this.Text = str;
                    }
                    case Image: {
                        this.ImageField = str;
                    }
                }
            }

            public static enum DrawType {
                FontMain,
                FontSpec,
                Image;

            }
        }

        public static enum ActionElementType {
            Empty,
            Games,
            Editor,
            Settings,
            Tutorial,
            About,
            Exit;

        }

        public static enum MenuElementType {
            Button,
            Empty,
            Text;

        }
    }

    public static class Menu_Main
    extends SliderMenu {
        private final MenuElements menuElements = new MenuElements();
        private final MainGUI mainGUI;
        private final Map<String, Integer> integerMap = new HashMap<String, Integer>();

        protected Menu_Main(final MainGUI mainGUI) {
            int i;
            this.mainGUI = mainGUI;
            HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
            integerMap.put("MENU_X", InterfaceManager.ElementCalculate(mainGUI.PosX));
            integerMap.put("MENU_Y", InterfaceManager.ElementCalculate(mainGUI.PosY));
            integerMap.put("MENU_WIDTH", InterfaceManager.ElementCalculate(mainGUI.Width));
            integerMap.put("MENU_HEIGHT", InterfaceManager.ElementCalculate(mainGUI.Height));
            integerMap.put("BUTTON_WIDTH", CFG.BUTTON_WIDTH);
            integerMap.put("BUTTON_HEIGHT", CFG.BUTTON_HEIGHT);
            this.integerMap.putAll(integerMap);
            for (i = 0; i < mainGUI.menuElements.size(); ++i) {
                MenuElement menuElement = new MenuElement();
                final int it = i;
                final HashMap<String, Integer> integerMap2 = new HashMap<String, Integer>(integerMap);
                integerMap2.put("ELEMENT_X", InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).PosX, integerMap));
                integerMap2.put("ELEMENT_Y", InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).PosY, integerMap));
                integerMap2.put("ELEMENT_WIDTH", InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).Width, integerMap));
                integerMap2.put("ELEMENT_HEIGHT", InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).Height, integerMap));
                switch (mainGUI.menuElements.get((int)i).menuElementType) {
                    case Empty: {
                        menuElement = new MenuElement(){

                            @Override
                            protected void buildElementHover() {
                                this.menuElementHover = CFG_Zetvl.wrapLineColorElementHover(mainGUI.menuElements.get((int)it).HoverText, CFG.GAME_WIDTH / 3);
                            }
                        };
                        break;
                    }
                    case Button: {
                        menuElement = new Button_Menu_LR_MainMenu(mainGUI.menuElements.get((int)i).Text, -1, (Integer)integerMap2.get("ELEMENT_X"), (Integer)integerMap2.get("ELEMENT_Y"), (Integer)integerMap2.get("ELEMENT_WIDTH"), (Integer)integerMap2.get("ELEMENT_HEIGHT"), mainGUI.menuElements.get((int)i).canClick){

                            @Override
                            protected void buildElementHover() {
                                this.menuElementHover = CFG_Zetvl.wrapLineColorElementHover(mainGUI.menuElements.get((int)it).HoverText, CFG.GAME_WIDTH / 3);
                            }

                            @Override
                            protected void drawButtonBG(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive) {
                                if (mainGUI.menuElements.get((int)it).BGCustomDraw) {
                                    InterfaceManager.drawReturn(oSB, iTranslateX, iTranslateY, mainGUI.menuElements.get((int)it).DrawModuleBG, integerMap2, true);
                                } else {
                                    super.drawButtonBG(oSB, iTranslateX, iTranslateY, isActive);
                                }
                            }

                            @Override
                            protected void drawText(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive) {
                                if (mainGUI.menuElements.get((int)it).TextCustomDraw) {
                                    InterfaceManager.drawReturn(oSB, iTranslateX, iTranslateY, mainGUI.menuElements.get((int)it).DrawModule, integerMap2, true);
                                } else {
                                    super.drawText(oSB, iTranslateX, iTranslateY, isActive);
                                }
                            }

                            @Override
                            protected void actionElement(int iID) {
                                InterfaceManager.actionReturn(mainGUI.menuElements.get((int)it).actionElementType);
                            }
                        };
                        break;
                    }
                    case Text: {
                        menuElement = new Text(mainGUI.menuElements.get((int)i).Text, -1, (Integer)integerMap2.get("ELEMENT_X"), (Integer)integerMap2.get("ELEMENT_Y"), (Integer)integerMap2.get("ELEMENT_WIDTH"), (Integer)integerMap2.get("ELEMENT_HEIGHT")){

                            @Override
                            protected void buildElementHover() {
                                this.menuElementHover = CFG_Zetvl.wrapLineColorElementHover(mainGUI.menuElements.get((int)it).HoverText, CFG.GAME_WIDTH / 3);
                            }

                            @Override
                            protected void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
                                if (!mainGUI.menuElements.get((int)it).TextCustomDraw) {
                                    super.draw(oSB, iTranslateX, iTranslateY, isActive, scrollableY);
                                } else {
                                    block5: for (int i = 0; i < mainGUI.menuElements.get((int)it).DrawModule.size(); ++i) {
                                        switch (mainGUI.menuElements.get((int)it).DrawModule.get((int)i).drawType) {
                                            case Image: {
                                                InterfaceManager.getImage(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).ImageField).draw(oSB, InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosX), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosY) - InterfaceManager.getImage(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).ImageField).getHeight(), InterfaceManager.ElementCalculate_This(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Width, InterfaceManager.getImage(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).ImageField).getWidth()), InterfaceManager.ElementCalculate_This(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Height, InterfaceManager.getImage(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).ImageField).getHeight()));
                                                continue block5;
                                            }
                                            case FontMain: {
                                                CFG.drawText(oSB, mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Text, InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosX), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosY), mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Color);
                                                continue block5;
                                            }
                                            case FontSpec: {
                                                CFG.drawText2(oSB, mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Text, InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosX), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)it).DrawModule.get((int)i).PosY), mainGUI.menuElements.get((int)it).DrawModule.get((int)i).Color);
                                            }
                                        }
                                    }
                                }
                            }

                            @Override
                            protected void actionElement(int iID) {
                                InterfaceManager.actionReturn(mainGUI.menuElements.get((int)it).actionElementType);
                            }
                        };
                    }
                }
                this.menuElements.addMenuElement(menuElement);
            }
            for (i = 0; i < this.menuElements.getMenuElementSize(); ++i) {
                HashMap<CallSite, Integer> integerMap1 = new HashMap<CallSite, Integer>();
                integerMap1.put((CallSite)((Object)("ELEMENT_" + i + "_X")), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).PosX, integerMap));
                integerMap1.put((CallSite)((Object)("ELEMENT_" + i + "_Y")), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).PosY, integerMap));
                integerMap1.put((CallSite)((Object)("ELEMENT_" + i + "_WIDTH")), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).Width, integerMap));
                integerMap1.put((CallSite)((Object)("ELEMENT_" + i + "_HEIGHT")), InterfaceManager.ElementCalculate(mainGUI.menuElements.get((int)i).Height, integerMap));
                this.integerMap.putAll(integerMap1);
            }
            this.initMenu(null, InterfaceManager.ElementCalculate(this.mainGUI.PosX), InterfaceManager.ElementCalculate(this.mainGUI.PosY), InterfaceManager.ElementCalculate(this.mainGUI.Width), InterfaceManager.ElementCalculate(this.mainGUI.Height), this.menuElements.getMenuElements());
        }

        @Override
        protected void updateLanguage() {
            for (int i = 0; i < this.mainGUI.menuElements.size(); ++i) {
                this.getMenuElement(i).setText(this.mainGUI.menuElements.get((int)i).Text);
            }
        }

        @Override
        protected void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean sliderMenuIsActive) {
            InterfaceManager.drawReturn(oSB, iTranslateX, iTranslateY, this.mainGUI.DrawModule, this.integerMap, this.mainGUI.isTranslate);
        }

        @Override
        protected void actionElement(int nMenuElementID) {
            this.getMenuElement(nMenuElementID).actionElement(nMenuElementID);
        }
    }

    public static class ColorINI {
        public Color COLOR_TEXT_RESEARCH = new Color(0.4f, 0.6f, 0.8f, 1.0f);
        public Color COLOR_TEXT_POPULATION = new Color(0.392f, 0.533f, 0.251f, 1.0f);
        public Color COLOR_TEXT_POPULATION_HOVER = new Color(0.595f, 0.743f, 0.427f, 1.0f);
        public Color COLOR_TEXT_POPULATION_ACTIVE = new Color(0.4f, 0.51f, 0.3f, 1.0f);
        public Color COLOR_TEXT_POPULATION_GROWTHRATE_MIN = new Color(0.17254902f, 0.67058825f, 0.19607843f, 1.0f);
        public Color COLOR_TEXT_POPULATION_GROWTHRATE_MAX = new Color(0.16862746f, 0.44313726f, 0.20784314f, 1.0f);
        public Color COLOR_TEXT_HAPPINESS_MIN = new Color(0.7411765f, 0.19215687f, 0.30588236f, 1.0f);
        public Color COLOR_TEXT_HAPPINESS_MAX = new Color(0.9843137f, 0.9843137f, 0.019607844f, 1.0f);
        public Color COLOR_TEXT_RECRUITABLE_MIN = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color COLOR_TEXT_RECRUITABLE_MAX = new Color(0.11764706f, 0.13725491f, 0.29411766f, 1.0f);
        public Color COLOR_TEXT_REVOLUTION_MIN = new Color(0.8235294f, 0.5882353f, 0.29411766f, 1.0f);
        public Color COLOR_TEXT_REVOLUTION_MIN_0 = new Color(0.09019608f, 0.39215687f, 0.078431375f, 0.25f);
        public Color COLOR_TEXT_REVOLUTION_MAX = new Color(0.50980395f, 0.13725491f, 0.078431375f, 1.0f);
        public Color COLOR_TEXT_PROVINCE_STABILITY_MIN = new Color(0.5686275f, 0.13725491f, 0.09803922f, 1.0f);
        public Color COLOR_TEXT_PROVINCE_STABILITY_MAX = new Color(0.23529412f, 0.49019608f, 0.11764706f, 1.0f);
        public Color COLOR_DISTANCE_MIN = new Color(0.8627451f, 0.84313726f, 0.1764706f, 1.0f);
        public Color COLOR_DISTANCE_MAX = new Color(0.43137255f, 0.09803922f, 0.09803922f, 1.0f);
        public Color COLOR_TEXT_HAPPINESS_HOVER = new Color(0.99607843f, 0.5137255f, 0.007843138f, 1.0f);
        public Color COLOR_TEXT_HAPPINESS_ACTIVE = new Color(0.9843137f, 0.6901961f, 0.003921569f, 1.0f);
        public Color COLOR_TEXT_CHECKBOX_TRUE = new Color(0.55f, 0.8f, 0.0f, 0.25f);
        public Color COLOR_TEXT_CHECKBOX_FALSE = new Color(0.8f, 0.137f, 0.0f, 0.25f);
        public Color COLOR_TEXT_ECONOMY = new Color(0.776f, 0.518f, 0.227f, 1.0f);
        public Color COLOR_TEXT_ECONOMY_HOVER = new Color(0.708f, 0.448f, 0.173f, 1.0f);
        public Color COLOR_TEXT_ECONOMY_ACTIVE = new Color(0.552f, 0.36f, 0.141f, 1.0f);
        public Color COLOR_TEXT_TECHNOLOGY = new Color(0.8f, 0.8f, 0.8f, 1.0f);
        public Color COLOR_TEXT_CIV_INFO = new Color(0.40392157f, 0.41960785f, 0.43137255f, 1.0f);
        public Color COLOR_TEXT_CIV_INFO_HOVER = new Color(0.575f, 0.575f, 0.575f, 1.0f);
        public Color COLOR_TEXT_CIV_INFO_ACTIVE = new Color(0.66f, 0.66f, 0.66f, 1.0f);
        public Color COLOR_TEXT_CIV_INFO_TITLE = new Color(0.6862745f, 0.6862745f, 0.6862745f, 1.0f);
        public Color COLOR_TEXT_TOP_VIEWS = new Color(0.37254903f, 0.37254903f, 0.37254903f, 1.0f);
        public Color COLOR_TEXT_TOP_VIEWS_HOVER = new Color(0.44705883f, 0.4509804f, 0.45490196f, 1.0f);
        public Color COLOR_TEXT_TOP_VIEWS_ACTIVE = new Color(0.85490197f, 0.7490196f, 0.36862746f, 1.0f);
        public Color COLOR_TEXT_TOP_VIEWS_NOT_CLICKABLE = new Color(0.18431373f, 0.19215687f, 0.20784314f, 0.7f);
        public Color COLOR_COLOR_PICKER_RGB_BG = new Color(0.047058824f, 0.0627451f, 0.078431375f, 0.55f);
        public Color COLOR_LOADING_SPLIT_ACTIVE = new Color(0.96862745f, 0.76862746f, 0.41960785f, 0.65f);
        public Color COLOR_LOADING_SPLIT = new Color(0.77254903f, 0.6117647f, 0.2627451f, 0.35f);
        public Color COLOR_NEW_GAME_EDGE_LINE = new Color(0.451f, 0.329f, 0.11f, 1.0f);
        public Color COLOR_FLAG_FRAME = new Color(0.76862746f, 0.6117647f, 0.2627451f, 1.0f);
        public Color COLOR_TEXT_CIV_NAME = new Color(0.985f, 0.985f, 0.985f, 1.0f);
        public Color COLOR_TEXT_CIV_NAME_HOVERED = new Color(0.784f, 0.784f, 0.784f, 1.0f);
        public Color COLOR_TEXT_CIV_NAME_ACTIVE = new Color(0.725f, 0.725f, 0.725f, 1.0f);
        public Color COLOR_TEXT_RANK = new Color(0.819f, 0.819f, 0.819f, 1.0f);
        public Color COLOR_TEXT_RANK_HOVER = new Color(0.628f, 0.628f, 0.645f, 1.0f);
        public Color COLOR_TEXT_RANK_ACTIVE = new Color(0.584f, 0.584f, 0.599f, 1.0f);
        public Color COLOR_SLIDER_LEFT_BG = new Color(0.11764706f, 0.13725491f, 0.23529412f, 1.0f);
        public Color COLOR_SLIDER_RIGHT_BG = new Color(0.98039216f, 0.98039216f, 0.98039216f, 1.0f);
        public Color COLOR_SLIDER_LEFT_BG2 = new Color(0.078431375f, 0.23529412f, 0.039215688f, 1.0f);
        public Color COLOR_SLIDER_LEFT_BG3 = new Color(0.29411766f, 0.09803922f, 0.13725491f, 1.0f);
        public Color COLOR_SLIDER_LEFT_INSTANTLY = new Color(0.09803922f, 0.23529412f, 0.15686275f, 1.0f);
        public Color COLOR_CREATE_NEW_GAME_BOX_PLAYERS = new Color(0.4509804f, 0.32941177f, 0.10980392f, 1.0f);
        public Color COLOR_GRADIENT_DARK_BLUE = new Color(0.025f, 0.04f, 0.08f, 0.75f);
        public Color COLOR_GRADIENT_LIGHTER_DARK_BLUE = new Color(0.043f, 0.102f, 0.157f, 0.75f);
        public Color COLOR_GRADIENT_DIPLOMACY = new Color(0.09019608f, 0.16078432f, 0.26666668f, 0.75f);
        public Color COLOR_TEXT_MODIFIER_NEGATIVE = new Color(0.98039216f, 0.15686275f, 0.15686275f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_NEGATIVE2 = new Color(0.7490196f, 0.18431373f, 0.14117648f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_NEGATIVE_HOVER = new Color(0.70980394f, 0.17254902f, 0.1254902f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_NEGATIVE_ACTTIVE = new Color(0.6509804f, 0.14117648f, 0.09411765f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_NEUTRAL = new Color(0.8f, 0.8f, 0.8f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_NEUTRAL2 = new Color(0.8627451f, 0.78431374f, 0.27450982f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_POSITIVE = new Color(0.007843138f, 0.5176471f, 0.011764706f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_POSITIVE_HOVER = new Color(0.003921569f, 0.4509804f, 0.007843138f, 1.0f);
        public Color COLOR_TEXT_MODIFIER_POSITIVE_ACTIVE = new Color(0.003921569f, 0.4f, 0.007843138f, 1.0f);
        public Color COLOR_TEXT_FREE_MOVE = new Color(0.8980392f, 0.9254902f, 0.02745098f, 1.0f);
        public Color COLOR_TEXT_FREE_MOVE_ACTIVE = new Color(0.6745098f, 0.68235296f, 0.007843138f, 1.0f);
        public Color COLOR_TEXT_FREE_MOVE_HOVER = new Color(0.7607843f, 0.7764706f, 0.015686275f, 1.0f);
        public Color COLOR_TEXT_PROVINCE_VALUE = new Color(0.784f, 0.588f, 0.196f, 1.0f);
        public Color COLOR_TEXT_PROVINCE_VALUE_HOVER = new Color(0.668f, 0.473f, 0.152f, 1.0f);
        public Color COLOR_TEXT_PROVINCE_VALUE_ACTIVE = new Color(0.605f, 0.414f, 0.132f, 1.0f);
        public Color COLOR_TEXT_CNG_TOP_SCENARIO_NAME = new Color(0.9f, 0.9f, 0.9f, 1.0f);
        public Color COLOR_TEXT_CNG_TOP_SCENARIO_NAME_HOVER = new Color(0.78f, 0.78f, 0.78f, 1.0f);
        public Color COLOR_TEXT_CNG_TOP_SCENARIO_INFO = new Color(0.56f, 0.56f, 0.56f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_NS = new Color(0.7372549f, 0.7490196f, 0.7647059f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_NS_HOVER = new Color(0.57254905f, 0.58431375f, 0.5921569f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_NS_ACTIVE = new Color(0.5019608f, 0.5137255f, 0.5294118f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_LEFT_NS = new Color(0.8392157f, 0.8392157f, 0.8392157f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_LEFT_NS_HOVER = new Color(0.7137255f, 0.7137255f, 0.7137255f, 1.0f);
        public Color COLOR_TEXT_OPTIONS_LEFT_NS_ACTIVE = new Color(0.6509804f, 0.6509804f, 0.6509804f, 1.0f);
        public Color COLOR_STARTINGMONEY_MIN = new Color(0.6f, 0.20392157f, 0.023529412f, 1.0f);
        public Color COLOR_STARTINGMONEY_0 = new Color(0.84705883f, 0.9411765f, 0.6509804f, 1.0f);
        public Color COLOR_STARTINGMONEY_MAX = new Color(0.1254902f, 0.5254902f, 0.27058825f, 1.0f);
        public Color COLOR_BUTTON_MENU_HOVER_BG = new Color(1.0f, 1.0f, 1.0f, 0.9f);
        public Color COLOR_BUTTON_MENU_TEXT = new Color(0.82f, 0.82f, 0.82f, 1.0f);
        public Color COLOR_BUTTON_MENU_TEXT_NOT_CLICKABLE = new Color(0.78f, 0.78f, 0.78f, 0.4f);
        public Color COLOR_BUTTON_MENU_TEXT_HOVERED = new Color(0.71f, 0.715f, 0.72f, 1.0f);
        public Color COLOR_BUTTON_MENU_TEXT_ACTIVE = new Color(0.1f, 0.1f, 0.1f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT = new Color(0.376f, 0.388f, 0.376f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT_NOT_CLICKABLE = new Color(0.674f, 0.09f, 0.066f, 0.5f);
        public Color COLOR_BUTTON_GAME_TEXT_ACTIVE = new Color(0.768f, 0.608f, 0.263f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT_HOVERED = new Color(0.445f, 0.445f, 0.445f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT_IMPORTANT = new Color(0.548f, 0.562f, 0.548f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT_IMPORTANT_HOVER = new Color(0.665f, 0.682f, 0.665f, 1.0f);
        public Color COLOR_BUTTON_GAME_TEXT_IMPORTANT_ACTIVE = new Color(0.78f, 0.78f, 0.78f, 1.0f);
        public Color COLOR_TEXT_NUM_OF_PROVINCES = new Color(0.8039216f, 0.59607846f, 0.0f, 1.0f);
        public Color COLOR_TEXT_GOLDEN_AGE = new Color(0.9882353f, 0.8117647f, 0.2509804f, 1.0f);
        public Color COLOR_GRADIENT_TITLE_BLUE = new Color(0.105882354f, 0.16078432f, 0.2901961f, 0.775f);
        public Color COLOR_MESSAGE_TITLE = new Color(0.2f, 0.6f, 0.4f, 0.775f);
        public Color COLOR_GRADIENT_TITLE_BLUE_LIGHT_ALLIANCE = new Color(0.0f, 0.21960784f, 0.61960787f, 0.775f);
        public Color COLOR_ARMY_BG = new Color(0.0f, 0.0f, 0.0f, 0.8f);
        public Color COLOR_ARMY_CAPITAL_BG = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        public Color COLOR_ARMY_BG_ACTIVE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color COLOR_ARMY_BG_SEA = new Color(0.05490196f, 0.1254902f, 0.23529412f, 1.0f);
        public Color COLOR_ARMY_BG_ALLIANCE = new Color(0.019607844f, 0.09803922f, 0.1764706f, 1.0f);
        public Color COLOR_ARMY_TEXT = new Color(0.88235295f, 0.88235295f, 0.27450982f, 1.0f);
        public Color COLOR_ARMY_TEXT_ACTIVE = new Color(0.12156863f, 0.12156863f, 0.12156863f, 1.0f);
        public Color COLOR_ARMY_TEXT_CAPITAL_ACTIVE = new Color(0.99215686f, 0.99607843f, 0.99607843f, 1.0f);
        public Color COLOR_ARMY_TEXT_SEA = new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f);
        public Color COLOR_ARMY_TEXT_SEA_ACTIVE = new Color(0.5294118f, 0.54901963f, 0.5686275f, 1.0f);
        public Color COLOR_INGAME_GOLD = new Color(0.87058824f, 0.85882354f, 0.12941177f, 1.0f);
        public Color COLOR_INGAME_GOLD_HOVER = new Color(0.75686276f, 0.75686276f, 0.0f, 1.0f);
        public Color COLOR_INGAME_GOLD_ACTIVE = new Color(0.6901961f, 0.6901961f, 0.0f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT = new Color(0.25882354f, 0.68235296f, 0.9019608f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT_HOVER = new Color(0.2f, 0.6f, 0.8f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT_ACTIVE = new Color(0.16862746f, 0.5411765f, 0.69803923f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT_ZERO = new Color(0.7490196f, 0.18431373f, 0.14117648f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT_ZERO_HOVER = new Color(0.6431373f, 0.10980392f, 0.08235294f, 1.0f);
        public Color COLOR_INGAME_MOVEMENT_ZERO_ACTIVE = new Color(0.56078434f, 0.06666667f, 0.050980393f, 1.0f);
        public Color COLOR_INGAME_DIPLOMACY_POINTS = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color COLOR_INGAME_DIPLOMACY_POINTS_HOVER = new Color(0.7882353f, 0.7882353f, 0.8f, 1.0f);
        public Color COLOR_INGAME_DIPLOMACY_POINTS_ACTIVE = new Color(0.7529412f, 0.7529412f, 0.7529412f, 1.0f);
        public Color COLOR_BG_GAME_MENU_SHADOW = new Color(0.0f, 0.0f, 0.0f, 0.65f);
    }

    private static class ColorSerializer
    implements Json.Serializer<Color> {
        private ColorSerializer() {
        }

        @Override
        public void write(Json json, Color color, Class knownType) {
            int rgba = Color.rgba8888(color);
            json.writeValue(String.format("0x%08x", rgba));
        }

        @Override
        public Color read(Json json, JsonValue jsonData, Class type) {
            String hex = jsonData.asString();
            return this.parseRGBA8888(hex);
        }

        private Color parseRGBA8888(String hex) {
            try {
                String cleanHex = hex.startsWith("0x") ? hex.substring(2) : hex;
                long value = Long.parseLong(cleanHex, 16);
                Color color = new Color();
                Color.rgba8888ToColor(color, (int)value);
                return color;
            }
            catch (NumberFormatException e) {
                Gdx.app.error("ColorSerializer", "Invalid color format: " + hex);
                return new Color(1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }
}

