/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Civilization;
import age.of.civilizations2.jakowski.lukasz.Focus;
import age.of.civilizations2.jakowski.lukasz.Focus_Accomplish;
import age.of.civilizations2.jakowski.lukasz.Focus_Condition;
import age.of.civilizations2.jakowski.lukasz.Focus_List;
import age.of.civilizations2.jakowski.lukasz.G;
import age.of.civilizations2.jakowski.lukasz.SoundsManager;
import age.of.civilizations2.jakowski.lukasz.Zetvl;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class FocusManager {
    protected static float totalLoadTime = 0.0f;
    protected static int x_excursion = 0;
    protected static int y_excursion = 0;
    protected static int x_max = 0;
    protected static int y_max = 0;
    protected static List<Integer> showFocus = new ArrayList<Integer>();
    private static final Json json = new Json();
    static final int HORIZONTAL_MARGIN = 120;
    public static long LoadingImageTime = 0L;
    public static int NODE_BASE_WIDTH = 160;
    public static int FONT_WIDTH_PER_CHAR = 10;
    private static final int NODE_WIDTH = CFG.GAME_WIDTH / 12;
    static final int NODE_HEIGHT = CFG.GAME_HEIGHT / 12;
    private static final int VERTICAL_SPACING = NODE_HEIGHT * 3;
    private static final Map<Integer, PositionCache> layoutCache;

    public static void saveToJson(Object object, FileHandle file) {
        json.setOutputType(JsonWriter.OutputType.json);
        String jsonString = json.prettyPrint(object);
        file.writeString(jsonString, false, "UTF-8");
    }

    public static <T> T loadFromJson(Class<T> type, FileHandle file) {
        Focus_List list;
        String jsonString = file.readString("UTF-8");
        Object data = json.fromJson(type, jsonString);
        if (data instanceof Focus_List) {
            list = (Focus_List)data;
            list.init();
            FocusManager.processDependencies(list.getFocusList());
            FocusManager.validateNoCycles(list.getFocusList());
        }
        list = new Focus_List();
        if (data instanceof Focus_List) {
            list = (Focus_List)data;
        }
        for (int i = 0; i < list.getFocusSize(); ++i) {
            list.getFocus((int)i).iID = i;
        }
        list.init();
        data = list;
        return data;
    }

    public static void saveToBinary(Object object, FileHandle file) {
        try (ObjectOutputStream oos = new ObjectOutputStream(file.write(false));){
            oos.writeObject(object);
        }
        catch (IOException e) {
            Zetvl.outThrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromBinary(FileHandle file) {
        try (ObjectInputStream ois = new ObjectInputStream(file.read());){
            Focus_List list;
            Object data = ois.readObject();
            if (data instanceof Focus_List) {
                list = (Focus_List)data;
                list.init();
                FocusManager.processDependencies(list.getFocusList());
                FocusManager.validateNoCycles(list.getFocusList());
            }
            list = new Focus_List();
            if (data instanceof Focus_List) {
                list = (Focus_List)data;
            }
            for (int i = 0; i < list.getFocusSize(); ++i) {
                list.getFocus((int)i).iID = i;
            }
            list.init();
            Object object = data = list;
            return (T)object;
        }
        catch (Exception e) {
            throw new Zetvl.ZetvlException("\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    public static void onPanelShow() {
        CFG.game.getCurrentCiv().civFocus.list.getFocusList().forEach(g -> {
            g.layoutCalculated = false;
            g.x = -1;
            g.y = -1;
        });
        FocusManager.validateLayout(CFG.game.getCurrentCiv().civFocus.list.getFocusList());
    }

    public static void processDependencies(List<Focus> Focuses) {
        Focuses.forEach(g -> {
            g.postrequisites = Focuses.stream().filter(other -> other.present.contains(g.name)).map(other -> other.name).collect(Collectors.toList());
        });
    }

    protected static void validateNoCycles(List<Focus> Focuses) {
        HashMap inDegree = new HashMap();
        HashMap adjList = new HashMap();
        LinkedList queue = new LinkedList();
        Focuses.forEach(g -> {
            inDegree.put(g.name, g.present.size());
            adjList.put(g.name, new ArrayList<String>(g.postrequisites));
        });
        inDegree.entrySet().stream().filter(e -> (Integer)e.getValue() == 0).forEach(e -> queue.add((String)e.getKey()));
        int visitedCount = 0;
        while (!queue.isEmpty()) {
            String curr = (String)queue.poll();
            ++visitedCount;
            ((List)adjList.get(curr)).forEach(neighbor -> {
                inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                if ((Integer)inDegree.get(neighbor) == 0) {
                    queue.add(neighbor);
                }
            });
        }
        if (visitedCount != Focuses.size()) {
            throw new Zetvl.ZetvlException("\u68c0\u6d4b\u5230\u5faa\u73af\u4f9d\u8d56\uff01");
        }
    }

    public static void validateLayout(List<Focus> Focuses) {
        TreeMap<Integer, List> yIndex = new TreeMap<Integer, List>();
        Focuses.forEach(g -> yIndex.computeIfAbsent(g.y, k -> new ArrayList()).add(g));
        yIndex.forEach((y, sameRowFocuses) -> {
            sameRowFocuses.sort(Comparator.comparingInt(g -> g.x));
            for (int i = 1; i < sameRowFocuses.size(); ++i) {
                Focus prev = (Focus)sameRowFocuses.get(i - 1);
                Focus curr = (Focus)sameRowFocuses.get(i);
                int minSpacing = (prev.getActualWidth() + curr.getActualWidth()) / 2;
                if (curr.x - (prev.x + prev.getActualWidth()) >= minSpacing) continue;
                int newX = prev.x + prev.getActualWidth() + minSpacing;
                curr.x = Math.min(newX, CFG.GAME_WIDTH - curr.getActualWidth() - 120);
            }
        });
        Focuses.stream().filter(g -> g.cachedParents.isEmpty()).forEach(root -> FocusManager.adjustSubtree(root, 0));
    }

    private static void adjustSubtree(Focus node, int level) {
        if (node.cachedChildren.isEmpty()) {
            return;
        }
        int totalWidth = node.cachedChildren.stream().mapToInt(Focus::getActualWidth).sum();
        int avgWidth = totalWidth / node.cachedChildren.size();
        int startX = node.x - (avgWidth * node.cachedChildren.size() + NodeStyleConfig.HORIZONTAL_SPACING * (node.cachedChildren.size() - 1)) / 2;
        for (int i = 0; i < node.cachedChildren.size(); ++i) {
            Focus child = node.cachedChildren.get(i);
            child.x = startX + i * (avgWidth + NodeStyleConfig.HORIZONTAL_SPACING);
            child.y = node.y + node.getActualHeight() + VERTICAL_SPACING * (level + 1);
            child.x = Math.max(child.x, 120);
            child.x = Math.min(child.x, CFG.GAME_WIDTH - child.getActualWidth() - 120);
            FocusManager.adjustSubtree(child, level + 1);
        }
    }

    static Focus findFocus(String name, List<Focus> Focuses) {
        return Focuses.stream().filter(g -> g.name.equals(name)).findFirst().orElse(null);
    }

    private static List<Focus> getChildren(Focus parent, List<Focus> allFocuses) {
        return parent.postrequisites.stream().map(name -> FocusManager.findFocus(name, allFocuses)).filter(Objects::nonNull).sorted(Comparator.comparingInt(allFocuses::indexOf)).collect(Collectors.toList());
    }

    public static String getName(String str) {
        return Objects.equals(CFG.langManager.getFocus(str), str) ? str : CFG.langManager.getFocus(str);
    }

    public static void showFocus(int nCivID) {
        CFG.game.getCiv((int)nCivID).civFocus.list.getFocus(CFG.game.getCiv((int)nCivID).civGameData.currentFocus.iID).accomplish();
        CFG.game.getCiv((int)nCivID).civGameData.FocusTime = -1;
        CFG.soundsManager.playSound(SoundsManager.SOUND_COMPLETE_FOCUS);
        CFG.menuManager.rebuildInGame_FocusDecision(1, nCivID, CFG.game.getCiv((int)nCivID).civGameData.currentFocus.iID);
        CFG.game.getCiv((int)nCivID).civGameData.currentFocus = null;
        CFG.menuManager.setVisible_Menu_InGame_CurrentWars(true);
    }

    public static int getFocus_X(int nCivID, int nFocusID, int PADDING) {
        int SPACE = Zetvl.gfx.GET(G.focus_completed_bg).getWidth() + CFG.PADDING * 2;
        Focus_List focusTree = CFG.game.getCiv((int)nCivID).civFocus.list;
        Focus current = focusTree.getFocus(nFocusID);
        if (current.present.isEmpty()) {
            return PADDING * SPACE;
        }
        if (current.present.size() > 1) {
            int first = FocusManager.getFocus_X(nCivID, focusTree.Focus_listName.indexOf(current.present.get(0)), PADDING);
            int finalX = 0;
            return first + (finalX += first - FocusManager.getFocus_X(nCivID, focusTree.Focus_listName.indexOf(current.present.get(current.present.size() - 1)), PADDING)) / 2 + PADDING * SPACE;
        }
        return FocusManager.getFocus_X(nCivID, focusTree.Focus_listName.indexOf(current.present.get(0)), PADDING) + PADDING * SPACE;
    }

    public static int getFocus_Y(int nCivID, int nFocusID, int PADDING) {
        int SPACE = Zetvl.gfx.GET(G.focus_completed_bg).getWidth() * 2;
        Focus_List focusTree = CFG.game.getCiv((int)nCivID).civFocus.list;
        Focus current = focusTree.getFocus(nFocusID);
        if (current.present.isEmpty()) {
            return PADDING * SPACE;
        }
        if (current.present.size() > 1) {
            int first = FocusManager.getFocus_Y(nCivID, focusTree.Focus_listName.indexOf(current.present.get(0)), PADDING);
            int finalY = 0;
            return first + (finalY += first - FocusManager.getFocus_Y(nCivID, focusTree.Focus_listName.indexOf(current.present.get(current.present.size() - 1)), PADDING)) / 2 + PADDING * SPACE;
        }
        return FocusManager.getFocus_Y(nCivID, focusTree.Focus_listName.indexOf(current.present.get(0)), PADDING) + PADDING * SPACE;
    }

    public static void refreshLayoutCache(int civID) {
        Civilization civ = CFG.game.getCiv(civID);
        PositionCache cache = new PositionCache();
        cache.timestamp = System.currentTimeMillis();
        cache.x = x_excursion;
        cache.y = y_excursion;
        layoutCache.put(civID, cache);
    }

    static {
        json.setTypeName(null);
        json.setIgnoreUnknownFields(true);
        json.setUsePrototypes(false);
        json.setSerializer(Focus_Condition.class, new Focus_Condition_Serializer());
        json.setSerializer(Focus_Accomplish.class, new Focus_Accomplish_Serializer());
        layoutCache = new ConcurrentHashMap<Integer, PositionCache>();
    }

    public static class NodeStyleConfig {
        public static int HORIZONTAL_SPACING = 150;
    }

    private static class PositionCache {
        int x;
        int y;
        long timestamp;

        private PositionCache() {
        }
    }

    public static class Focus_Condition_Serializer
    implements Json.Serializer<Focus_Condition> {
        @Override
        public void write(Json json, Focus_Condition object, Class knownType) {
            json.writeObjectStart();
            json.writeFields(json);
            json.writeObjectEnd();
        }

        @Override
        public Focus_Condition read(Json json, JsonValue jsonData, Class type) {
            String typec = jsonData.getString("type");
            Class<? extends Focus_Condition> clazz = Focus_Condition.REGISTERED_CONDITIONS.get(typec);
            if (clazz == null) {
                throw new Zetvl.ZetvlException("Unknown condition type: " + typec);
            }
            return json.readValue(clazz, jsonData);
        }
    }

    public static class Focus_Accomplish_Serializer
    implements Json.Serializer<Focus_Accomplish> {
        @Override
        public void write(Json json, Focus_Accomplish object, Class knownType) {
            json.writeObjectStart();
            json.writeFields(json);
            json.writeObjectEnd();
        }

        @Override
        public Focus_Accomplish read(Json json, JsonValue jsonData, Class type) {
            String typec = jsonData.getString("type");
            Class<? extends Focus_Accomplish> clazz = Focus_Accomplish.getAccomplishClass(typec);
            if (clazz == null) {
                throw new Zetvl.ZetvlException("Unknown condition type: " + typec);
            }
            return json.readValue(clazz, jsonData);
        }
    }
}

