/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz.lwjgl3;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.desktop.DesktopLinkHandler;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class Lwjgl3Launcher {
    public static void main(String[] arg) {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setTitle("Age of Civilizations II");
        config.setWindowIcon(Files.FileType.Internal, "ic_32x32.png");
        config.setResizable(false);
        int tWidth = -1;
        int tHeight = -1;
        boolean tFullscreen = true;
        int tSamples = -1;
        boolean tVSync = false;
        try (BufferedReader bfr = new BufferedReader(new FileReader("config.ini"));){
            String sLine;
            while ((sLine = bfr.readLine()) != null) {
                String[] tempR = sLine.replace(";", "").split("=");
                if (tempR.length < 2) continue;
                switch (tempR[0]) {
                    case "FULLSCREEN": {
                        tFullscreen = Boolean.parseBoolean(tempR[1]);
                        break;
                    }
                    case "WIDTH": {
                        tWidth = Integer.parseInt(tempR[1]);
                        break;
                    }
                    case "HEIGHT": {
                        tHeight = Integer.parseInt(tempR[1]);
                        break;
                    }
                    case "ANTIALIASING": {
                        tSamples = Integer.parseInt(tempR[1]);
                        break;
                    }
                    case "VSYNC": {
                        tVSync = Boolean.parseBoolean(tempR[1]);
                    }
                }
            }
        }
        catch (IOException | NumberFormatException ex) {
            tWidth = -1;
            tHeight = -1;
            tFullscreen = true;
            tSamples = -1;
            tVSync = false;
        }
        if (tSamples != -1) {
            config.setBackBufferConfig(8, 8, 8, 8, 16, tSamples, 0);
        }
        config.useVsync(tVSync);
        if (tWidth <= 0 || tHeight <= 0) {
            config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
        } else {
            config.setWindowedMode(tWidth, tHeight);
            if (tFullscreen) {
                config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
            }
        }
        new Lwjgl3Application(new AoCGame(new DesktopLinkHandler()), config);
    }
}

