/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Image;
import age.of.civilizations2.jakowski.lukasz.Religion_GameData;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ReligionManager {
    private List<String> lReligionsNames;
    private List<String> lReligionsTags;
    private List<Color> lReligionsColors;
    private List<Image> lReligionsIcons;
    private int iReligionsSize = 0;

    protected ReligionManager() {
        this.loadReligions();
    }

    protected final void loadReligions() {
        if (this.lReligionsIcons != null && this.lReligionsIcons.size() > 0) {
            for (int i = 0; i < this.lReligionsIcons.size(); ++i) {
                this.lReligionsIcons.get(i).getTexture().dispose();
                this.lReligionsIcons.remove(i--);
            }
        }
        this.lReligionsNames = new ArrayList<String>();
        this.lReligionsTags = new ArrayList<String>();
        this.lReligionsColors = new ArrayList<Color>();
        this.lReligionsIcons = new ArrayList<Image>();
        List<String> tempTags = CFG.getFileNames("game/religions/");
        this.iReligionsSize = tempTags.size();
        for (int j = 0; j < this.iReligionsSize; ++j) {
            FileHandle fileData = Gdx.files.internal("game/religions/" + tempTags.get(j));
            try {
                Religion_GameData tempData = (Religion_GameData)CFG.deserialize(fileData.readBytes());
                this.lReligionsNames.add(CFG.langManager.get(tempData.getName()));
                this.lReligionsTags.add(tempTags.get(j));
                this.lReligionsColors.add(new Color(tempData.getColor().getR(), tempData.getColor().getG(), tempData.getColor().getB(), CFG.settingsManager.PROVINCE_ALPHA));
                try {
                    this.lReligionsIcons.add(new Image(new Texture(Gdx.files.internal("UI/icons/religions/" + tempData.getIconName() + ".png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
                }
                catch (GdxRuntimeException ex) {
                    this.lReligionsIcons.add(new Image(new Texture(Gdx.files.internal("UI/icons/religions/notfound.png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
                }
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final void saveReligionData() {
    }

    protected final String getReligionName(int i) {
        return this.lReligionsNames.get(i);
    }

    protected final String getReligionTag(int i) {
        return this.lReligionsTags.get(i);
    }

    protected final Color getReligionColor(int i) {
        return this.lReligionsColors.get(i);
    }

    protected final Image getReligionIcon(int i) {
        return this.lReligionsIcons.get(i);
    }

    protected final int getReligionsSize() {
        return this.iReligionsSize;
    }
}

