/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.DiplomacyManager;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.LobbyInfo;
import age.of.civilizations2.jakowski.lukasz.LobbyJoinData;
import age.of.civilizations2.jakowski.lukasz.M_P2P;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.Menu_CreateNewGame;
import age.of.civilizations2.jakowski.lukasz.Menu_CreateNewGame_Options_v2;
import age.of.civilizations2.jakowski.lukasz.Menu_InGame;
import age.of.civilizations2.jakowski.lukasz.Menu_MultiplayerBrowse;
import age.of.civilizations2.jakowski.lukasz.Message;
import age.of.civilizations2.jakowski.lukasz.MessageCategory;
import age.of.civilizations2.jakowski.lukasz.Message_Gift;
import age.of.civilizations2.jakowski.lukasz.Message_NonAggressionPact;
import age.of.civilizations2.jakowski.lukasz.Message_Type;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_GameData_MessageData;
import age.of.civilizations2.jakowski.lukasz.RTS;
import age.of.civilizations2.jakowski.lukasz.ViewsManager;
import com.badlogic.gdx.Gdx;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MessageHandler {
    private static int lastProcessedTurnId = -1;
    private static final Map<String, Set<Integer>> peaceAccepts = new HashMap<String, Set<Integer>>();

    /*
     * WARNING - void declaration
     */
    public static void handle(MessageCategory category, UUID uid, byte[] content) {
        switch (category) {
            case EXITS: {
                LobbyJoinData data = LobbyJoinData.fromBytes(content);
                if (LobbyInfo.name.equals(data.name) && LobbyInfo.password.equals(data.password)) {
                    ByteBuffer buffer = ByteBuffer.allocate(16 + data.name.getBytes(StandardCharsets.UTF_8).length + 1 + data.password.getBytes(StandardCharsets.UTF_8).length + 1);
                    buffer.putLong(uid.getMostSignificantBits());
                    buffer.putLong(uid.getLeastSignificantBits());
                    buffer.put(data.name.getBytes(StandardCharsets.UTF_8));
                    buffer.put((byte)0);
                    buffer.put(data.password.getBytes(StandardCharsets.UTF_8));
                    buffer.put((byte)0);
                    M_P2P.sendMessage(MessageCategory.COME, buffer.array());
                    System.out.println("[LOBBY] EXITS iste\u011fi geldi, bilgiler e\u015fle\u015fti. COME g\u00f6nderildi.");
                    break;
                }
                System.out.println("[LOBBY] EXITS iste\u011fi geldi, bilgiler e\u015fle\u015fmedi.");
                break;
            }
            case COME: {
                ByteBuffer bb = ByteBuffer.wrap(content);
                long most = bb.getLong();
                long least = bb.getLong();
                UUID joinUid = new UUID(most, least);
                String name = LobbyJoinData.readString(bb);
                String password = LobbyJoinData.readString(bb);
                if (M_P2P.getUid().equals(joinUid)) {
                    LobbyInfo.name = name;
                    LobbyInfo.password = password;
                    LobbyInfo.isHost = false;
                    LobbyInfo.gameStarted = false;
                    System.out.println("[LOBBY] COME geldi, bilgiler g\u00fcncellendi. Men\u00fc CREATE_NEW_GAME olarak ayarland\u0131.");
                    Gdx.app.postRunnable(() -> {
                        CFG.menuManager.setViewID(Menu.eCREATE_NEW_GAME);
                        CFG.menuManager.setVisible_CreateNewGame_Options(false);
                        CFG.menuManager.setVisible_CreateNewGame_CivInfo(true);
                    });
                    break;
                }
                System.out.println("[LOBBY] COME geldi ama uid e\u015fle\u015fmedi.");
                break;
            }
            case IMJOIN: {
                ByteBuffer bb = ByteBuffer.wrap(content);
                long most = bb.getLong();
                long least = bb.getLong();
                UUID joinUid = new UUID(most, least);
                String name = LobbyJoinData.readString(bb);
                String password = LobbyJoinData.readString(bb);
                if (LobbyInfo.name.equals(name) && LobbyInfo.password.equals(password)) {
                    if (!LobbyInfo.playerList.contains(joinUid.toString())) {
                        LobbyInfo.playerList.add(joinUid.toString());
                        System.out.println("[LOBBY] Oyuncu eklendi: " + joinUid);
                        Gdx.app.postRunnable(() -> CFG.toast.setInView(joinUid + " oyuna kat\u0131ld\u0131", CFG.COLOR_TEXT_MODIFIER_POSITIVE));
                    }
                } else {
                    System.out.println("[LOBBY] IMJOIN geldi, bilgiler e\u015fle\u015fmedi.");
                }
                if (!LobbyInfo.isHost) break;
                MessageHandler.sendPlayerList();
                break;
            }
            case PLAYERLIST: {
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int uidLen = buffer.getInt();
                byte[] uidBytes = new byte[uidLen];
                buffer.get(uidBytes);
                String lobbyUid = new String(uidBytes, StandardCharsets.UTF_8);
                int playerCount = buffer.getInt();
                ArrayList<String> newPlayerList = new ArrayList<String>();
                for (int i = 0; i < playerCount; ++i) {
                    int strLen = buffer.getInt();
                    byte[] strBytes = new byte[strLen];
                    buffer.get(strBytes);
                    newPlayerList.add(new String(strBytes, StandardCharsets.UTF_8));
                }
                LobbyInfo.lobbyUid = lobbyUid;
                LobbyInfo.playerList = newPlayerList;
                Gdx.app.postRunnable(() -> {
                    if (CFG.menuManager.getViewID() == Menu.eCREATE_NEW_GAME.ordinal()) {
                        CFG.menuManager.setViewID(Menu.eCREATE_NEW_GAME);
                    }
                });
                break;
            }
            case STARTGAME: {
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int uidLen = buffer.getInt();
                byte[] uidBytes = new byte[uidLen];
                buffer.get(uidBytes);
                String lobbyUid = new String(uidBytes, StandardCharsets.UTF_8);
                System.out.println("[STARTGAME] message received, lobbyUid: " + lobbyUid + ", local lobbyUid: " + LobbyInfo.lobbyUid);
                if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(lobbyUid)) break;
                if (!CFG.menuManager.getInCreateNewGame()) {
                    Gdx.app.postRunnable(() -> CFG.menuManager.setViewID(Menu.eCREATE_NEW_GAME));
                }
                LobbyInfo.endTurnPressedUids.clear();
                Gdx.app.postRunnable(Menu_CreateNewGame::newGame);
                System.out.println("[STARTGAME] Game start triggered");
                break;
            }
            case NEXT_TURN_COMMAND: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    int turnId = buffer.getInt();
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    System.out.println("[NEXT_TURN_COMMAND][ALL] Turu ge\u00e7in komutu al\u0131nd\u0131! turnId=" + turnId + " local=" + Game_Calendar.TURN_ID);
                    Gdx.app.postRunnable(() -> {
                        if (turnId > Game_Calendar.TURN_ID) {
                            System.out.println("[NEXT_TURN_COMMAND][ALL] nextTurn \u00e7a\u011f\u0131r\u0131l\u0131yor...");
                            CFG.gameAction.nextTurn();
                            lastProcessedTurnId = Game_Calendar.TURN_ID;
                        } else {
                            System.out.println("[NEXT_TURN_COMMAND][ALL] nextTurn zaten i\u015flendi, atlan\u0131yor.");
                        }
                    });
                }
                catch (Exception e) {
                    System.out.println("[NEXT_TURN_COMMAND] Hata: " + e.getMessage());
                }
                break;
            }
            case PLAYER_JOINED_TOAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int uidLen = buffer.getInt();
                    byte[] uidBytes = new byte[uidLen];
                    buffer.get(uidBytes);
                    String joinedUid = new String(uidBytes, StandardCharsets.UTF_8);
                    Gdx.app.postRunnable(() -> CFG.toast.setInView(joinedUid + " oyuna kat\u0131ld\u0131", CFG.COLOR_TEXT_MODIFIER_POSITIVE));
                }
                catch (Exception e) {
                    System.err.println("[PLAYER_JOINED_TOAST][ERROR] " + e);
                }
                break;
            }
            case PLAYER_LEFT_TOAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int uidLen = buffer.getInt();
                    byte[] uidBytes = new byte[uidLen];
                    buffer.get(uidBytes);
                    String leftUid = new String(uidBytes, StandardCharsets.UTF_8);
                    Gdx.app.postRunnable(() -> CFG.toast.setInView(leftUid + " oyundan ayr\u0131ld\u0131", CFG.COLOR_TEXT_MODIFIER_NEGATIVE2));
                }
                catch (Exception e) {
                    System.err.println("[PLAYER_LEFT_TOAST][ERROR] " + e);
                }
                break;
            }
            case ALLIANCE_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int toCivID = buffer.getInt();
                    int fromCivID = buffer.getInt();
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != toCivID) break;
                    CFG.game.getCiv((int)toCivID).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message(fromCivID, 0));
                    Gdx.app.postRunnable(() -> CFG.menuManager.rebuildInGame_Messages());
                }
                catch (Exception e) {
                    System.err.println("[ALLIANCE_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case NAP_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int toCivID = buffer.getInt();
                    int fromCivID = buffer.getInt();
                    int turns = buffer.getInt();
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != toCivID) break;
                    Gdx.app.postRunnable(() -> {
                        CFG.game.getCiv((int)toCivID).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_NonAggressionPact(fromCivID, turns));
                        CFG.menuManager.rebuildInGame_Messages();
                    });
                }
                catch (Exception e) {
                    System.err.println("[NAP_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case COUNTRY_SELECTION_SUBMIT: {
                byte[] lobbyUidBytes2;
                if (!LobbyInfo.isHost) break;
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int lobbyUidLen = buffer.getInt();
                byte[] lobbyUidBytes = new byte[lobbyUidLen];
                buffer.get(lobbyUidBytes);
                String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                int civId = buffer.getInt();
                int uidLen = buffer.getInt();
                byte[] uidBytes = new byte[uidLen];
                buffer.get(uidBytes);
                String senderUid = new String(uidBytes, StandardCharsets.UTF_8);
                LobbyInfo.playerSelectedCivIds.put(senderUid, civId);
                System.out.println("[LOBBY] COUNTRY_SELECTION_SUBMIT: " + senderUid + " -> " + civId);
                if (LobbyInfo.playerSelectedCivIds.size() != LobbyInfo.playerList.size()) break;
                System.out.println("[DEBUG] All selections received. Broadcasting COUNTRY_SELECTION_BROADCAST and sending STARTGAME.");
                try {
                    lobbyUidBytes2 = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
                    int total = 4 + lobbyUidBytes2.length + 4;
                    for (String string : LobbyInfo.playerSelectedCivIds.keySet()) {
                        total += 4 + string.getBytes().length + 4;
                    }
                    ByteBuffer bcast = ByteBuffer.allocate(total);
                    bcast.putInt(lobbyUidBytes2.length);
                    bcast.put(lobbyUidBytes2);
                    bcast.putInt(LobbyInfo.playerSelectedCivIds.size());
                    for (String playerUid : LobbyInfo.playerSelectedCivIds.keySet()) {
                        byte[] playerUidBytes = playerUid.getBytes(StandardCharsets.UTF_8);
                        bcast.putInt(playerUidBytes.length);
                        bcast.put(playerUidBytes);
                        bcast.putInt(LobbyInfo.playerSelectedCivIds.get(playerUid));
                    }
                    System.out.println("[DEBUG] Sending COUNTRY_SELECTION_BROADCAST to all clients");
                    M_P2P.sendMessage(MessageCategory.COUNTRY_SELECTION_BROADCAST, bcast.array());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                lobbyUidBytes2 = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
                ByteBuffer startBuffer = ByteBuffer.allocate(4 + lobbyUidBytes2.length);
                startBuffer.putInt(lobbyUidBytes2.length);
                startBuffer.put(lobbyUidBytes2);
                System.out.println("[DEBUG] Sending STARTGAME message to all clients");
                M_P2P.sendMessage(MessageCategory.STARTGAME, startBuffer.array());
                Gdx.app.postRunnable(Menu_CreateNewGame::newGame);
                break;
            }
            case COUNTRY_SELECTION_BROADCAST: {
                System.out.println("[LOBBY] COUNTRY_SELECTION_BROADCAST received");
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int lobbyUidLen = buffer.getInt();
                byte[] lobbyUidBytes = new byte[lobbyUidLen];
                buffer.get(lobbyUidBytes);
                String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                int count = buffer.getInt();
                LobbyInfo.playerSelectedCivIds.clear();
                for (int i = 0; i < count; ++i) {
                    int uidLen = buffer.getInt();
                    byte[] uidBytes = new byte[uidLen];
                    buffer.get(uidBytes);
                    String uidStr = new String(uidBytes, StandardCharsets.UTF_8);
                    int civId = buffer.getInt();
                    LobbyInfo.playerSelectedCivIds.put(uidStr, civId);
                }
                System.out.println("[LOBBY] COUNTRY_SELECTION_BROADCAST: " + LobbyInfo.playerSelectedCivIds);
                break;
            }
            case COUNTRY_SELECTION_REQUEST: {
                if (LobbyInfo.isHost) break;
                System.out.println("[DEBUG] Client: received COUNTRY_SELECTION_REQUEST, sending COUNTRY_SELECTION_SUBMIT");
                int selectedCivId = CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID();
                String myUid = M_P2P.getUid().toString();
                byte[] lobbyUidBytes = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
                ByteBuffer buffer = ByteBuffer.allocate(8 + lobbyUidBytes.length + 4 + myUid.getBytes().length);
                buffer.putInt(lobbyUidBytes.length);
                buffer.put(lobbyUidBytes);
                buffer.putInt(selectedCivId);
                buffer.putInt(myUid.getBytes().length);
                buffer.put(myUid.getBytes());
                M_P2P.sendMessage(MessageCategory.COUNTRY_SELECTION_SUBMIT, buffer.array());
                break;
            }
            case DECLARE_WAR_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int aggressor = buffer.getInt();
                    int defender = buffer.getInt();
                    Gdx.app.postRunnable(() -> CFG.game.declareWar(aggressor, defender, false));
                }
                catch (Exception e) {
                    System.err.println("[DECLARE_WAR_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case IMPROVE_RELATIONS_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int fromCiv = buffer.getInt();
                    int toCiv = buffer.getInt();
                    int turns = buffer.getInt();
                    if (turns > 1) {
                        CFG.game.getCiv(fromCiv).getCivilization_Diplomacy_GameData().addImproveRelations(fromCiv, toCiv, turns);
                    }
                    Gdx.app.postRunnable(() -> {
                        CFG.toast.setInView(CFG.langManager.get("DiplomatSent") + "!", CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                        CFG.toast.setTimeInView(4500);
                        CFG.updateActiveCivInfo_InGame();
                        CFG.menuManager.updateInGame_TOP_All(fromCiv);
                    });
                }
                catch (Exception e) {
                    System.err.println("[IMPROVE_RELATIONS_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case INSULT_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int fromCiv = buffer.getInt();
                    int toCiv = buffer.getInt();
                    int turns = buffer.getInt();
                    DiplomacyManager.decreaseRelation(fromCiv, toCiv, turns);
                    Gdx.app.postRunnable(() -> {
                        CFG.toast.setInView(CFG.langManager.get("Sent") + "!", CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                        CFG.toast.setTimeInView(4500);
                        CFG.updateActiveCivInfo_InGame();
                        CFG.menuManager.updateInGame_TOP_All(fromCiv);
                    });
                }
                catch (Exception e) {
                    System.err.println("[INSULT_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case GIFT_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int toCiv = buffer.getInt();
                    int fromCiv = buffer.getInt();
                    int amount = buffer.getInt();
                    System.out.println("[GIFT_REQUEST_BROADCAST] toCiv=" + toCiv + ", fromCiv=" + fromCiv + ", amount=" + amount + ", myCiv=" + CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() + ", lobbyUid=" + LobbyInfo.lobbyUid);
                    if (amount > 0) {
                        CFG.game.getCiv((int)toCiv).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Gift(fromCiv, amount));
                    }
                    Gdx.app.postRunnable(() -> {
                        CFG.menuManager.updateInGame_TOP_All(fromCiv);
                        CFG.menuManager.updateInGame_TOP_All(toCiv);
                        CFG.menuManager.rebuildInGame_Messages();
                    });
                }
                catch (Exception e) {
                    System.err.println("[GIFT_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case GIFT_RESPONSE_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int fromCiv = buffer.getInt();
                    int toCiv = buffer.getInt();
                    int accepted = buffer.getInt();
                    System.out.println("[GIFT_RESPONSE_BROADCAST] fromCiv=" + fromCiv + ", toCiv=" + toCiv + ", accepted=" + accepted);
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() == fromCiv) {
                        if (accepted == 1) {
                            CFG.toast.setInView(CFG.langManager.get("Accepted") + "!", CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                            CFG.toast.setTimeInView(4500);
                        } else {
                            CFG.toast.setInView(CFG.langManager.get("Refused") + "!", CFG.COLOR_TEXT_MODIFIER_NEGATIVE2);
                            CFG.toast.setTimeInView(4500);
                        }
                    }
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != toCiv) break;
                    int amount = 0;
                    if (accepted == 1) {
                        DiplomacyManager.acceptGift(toCiv, fromCiv, amount);
                    } else {
                        DiplomacyManager.declineGift(toCiv, fromCiv, amount);
                    }
                    for (int i = 0; i < CFG.game.getCiv((int)toCiv).getCivilization_Diplomacy_GameData().messageBox.getMessagesSize(); ++i) {
                        Message msgGift = CFG.game.getCiv((int)toCiv).getCivilization_Diplomacy_GameData().messageBox.getMessage(i);
                        if (msgGift.messageType != Message_Type.GIFT || msgGift.iFromCivID != fromCiv) continue;
                        CFG.game.getCiv((int)toCiv).getCivilization_Diplomacy_GameData().messageBox.removeMessage(i);
                        break;
                    }
                    Gdx.app.postRunnable(() -> {
                        CFG.menuManager.rebuildInGame_Messages();
                        CFG.menuManager.updateInGame_TOP_All(toCiv);
                    });
                }
                catch (Exception e) {
                    System.err.println("[GIFT_RESPONSE_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case SUPPORT_REBELS_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int fromCiv = buffer.getInt();
                    int toCiv = buffer.getInt();
                    int rebelsCiv = buffer.getInt();
                    int amount = buffer.getInt();
                    int province = buffer.getInt();
                    DiplomacyManager.supportRebels(fromCiv, toCiv, rebelsCiv, amount);
                    Gdx.app.postRunnable(() -> {
                        CFG.toast.setInView(CFG.langManager.get("Sent") + "!", CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                        CFG.toast.setTimeInView(4500);
                        CFG.menuManager.updateInGame_TOP_All(fromCiv);
                        CFG.menuManager.rebuildInGame_Messages();
                    });
                }
                catch (Exception e) {
                    System.err.println("[SUPPORT_REBELS_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case RECRUIT_ARMY_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int provinceID = buffer.getInt();
                    int armyAmount = buffer.getInt();
                    int civID = buffer.getInt();
                    int instant = buffer.getInt();
                    long moneyBeforeRecruit = buffer.getLong();
                    Gdx.app.postRunnable(() -> {
                        CFG.game.getCiv(civID).setMoney(moneyBeforeRecruit);
                        if (instant == 1) {
                            CFG.gameAction.recruitArmyInstantly(provinceID, armyAmount, civID);
                        } else {
                            CFG.game.getCiv(civID).recruitArmy_AI2(provinceID, armyAmount);
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println("[RECRUIT_ARMY_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case RECRUIT_ARMY_INSTANT_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int provinceID = buffer.getInt();
                    int armyAmount = buffer.getInt();
                    int civID = buffer.getInt();
                    Gdx.app.postRunnable(() -> CFG.gameAction.recruitArmyInstantly(provinceID, armyAmount, civID));
                }
                catch (Exception e) {
                    System.err.println("[RECRUIT_ARMY_INSTANT_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case MOVE_ARMY_BROADCAST: {
                try {
                    void var14_251;
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int fromProvinceID = buffer.getInt();
                    int toProvinceID = buffer.getInt();
                    int armyAmount = buffer.getInt();
                    int civID = buffer.getInt();
                    int regroupMode = buffer.getInt();
                    int buildLine = buffer.getInt();
                    int routeSize = 0;
                    Object var14_249 = null;
                    if (buffer.remaining() >= 4 && (routeSize = buffer.getInt()) > 0 && buffer.remaining() >= routeSize * 4) {
                        int[] nArray = new int[routeSize];
                        for (int i = 0; i < routeSize; ++i) {
                            nArray[i] = buffer.getInt();
                        }
                    }
                    int fRegroupMode = regroupMode;
                    int fRouteSize = routeSize;
                    void fRoute = var14_251;
                    int fCivID = civID;
                    int fToProvinceID = toProvinceID;
                    int fArmyAmount = armyAmount;
                    int fBuildLine = buildLine;
                    int fFromProvinceID = fromProvinceID;
                    Gdx.app.postRunnable(() -> MessageHandler.lambda$handle$17(fFromProvinceID, fToProvinceID, fArmyAmount, fCivID, fRegroupMode, fBuildLine, fRouteSize, (int[])fRoute));
                }
                catch (Exception e) {
                    System.err.println("[MOVE_ARMY_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case MOVE_CAPITAL_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int civID = buffer.getInt();
                    int newCapitalProvID = buffer.getInt();
                    if (CFG.game.getCiv(civID).getCapitalProvinceID() == newCapitalProvID) break;
                    Gdx.app.postRunnable(() -> {
                        CFG.gameAction.moveCapital(civID, newCapitalProvID);
                        CFG.updateActiveCivInfo_InGame();
                        CFG.menuManager.updateInGame_TOP_All(civID);
                    });
                }
                catch (Exception e) {
                    System.err.println("[MOVE_CAPITAL_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case MONEY_SYNC: {
                if (LobbyInfo.isHost) break;
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int lobbyUidLen = buffer.getInt();
                byte[] lobbyUidBytes = new byte[lobbyUidLen];
                buffer.get(lobbyUidBytes);
                String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                int civCount = buffer.getInt();
                for (int i = 0; i < civCount; ++i) {
                    long money = buffer.getLong();
                    int loans = buffer.getInt();
                    CFG.game.getCiv(i).setMoney(money);
                    CFG.game.getCiv(i).updateLoansNextTurn();
                }
                break;
            }
            case ALLIANCE_RESPONSE_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int toCivID = buffer.getInt();
                    int fromCivID = buffer.getInt();
                    int response = buffer.getInt();
                    if (response == 1) {
                        DiplomacyManager.acceptAllianceProposal(toCivID, fromCivID);
                        if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != toCivID) break;
                        Gdx.app.postRunnable(() -> {
                            CFG.toast.setInView(CFG.langManager.get("AllianceProposalAccepted"), CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                            CFG.toast.setTimeInView(4500);
                        });
                        break;
                    }
                    DiplomacyManager.declineAllianceProposal(toCivID, fromCivID);
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != toCivID) break;
                    Gdx.app.postRunnable(() -> {
                        CFG.toast.setInView(CFG.langManager.get("AllianceProposalDeclined"), CFG.COLOR_TEXT_MODIFIER_NEGATIVE);
                        CFG.toast.setTimeInView(4500);
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case NAP_RESPONSE_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int fromCivID = buffer.getInt();
                    int toCivID = buffer.getInt();
                    int response = buffer.getInt();
                    int turns = buffer.getInt();
                    if (response == 1) {
                        DiplomacyManager.acceptNonAggressionPact(toCivID, fromCivID, turns);
                        if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != fromCivID) break;
                        Gdx.app.postRunnable(() -> {
                            CFG.toast.setInView(CFG.langManager.get("NonAggressionPactAccepted"), CFG.COLOR_TEXT_MODIFIER_POSITIVE);
                            CFG.toast.setTimeInView(4500);
                        });
                        break;
                    }
                    DiplomacyManager.declineNonAggressionPact(toCivID, fromCivID, turns);
                    if (CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID() != fromCivID) break;
                    Gdx.app.postRunnable(() -> {
                        CFG.toast.setInView(CFG.langManager.get("NonAggressionPactDeclined"), CFG.COLOR_TEXT_MODIFIER_NEGATIVE);
                        CFG.toast.setTimeInView(4500);
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case GAME_OPTION_SYNC: {
                ByteBuffer buffer = ByteBuffer.wrap(content);
                int lobbyUidLen = buffer.getInt();
                byte[] lobbyUidBytes = new byte[lobbyUidLen];
                buffer.get(lobbyUidBytes);
                String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                int optionId = buffer.getInt();
                Gdx.app.postRunnable(() -> {
                    switch (optionId) {
                        case 6: {
                            int fog = buffer.getInt();
                            int sliderVal = buffer.getInt();
                            CFG.FOG_OF_WAR = fog;
                            if (Menu_CreateNewGame_Options_v2.optionsMenu == null) break;
                            Menu_CreateNewGame_Options_v2.optionsMenu.getMenuElement(6).setCurrent(sliderVal);
                            break;
                        }
                        case 18: {
                            float speed = buffer.getFloat();
                            int sliderVal2 = buffer.getInt();
                            Game_Calendar.GAME_SPEED = speed;
                            if (Menu_CreateNewGame_Options_v2.optionsMenu == null) break;
                            Menu_CreateNewGame_Options_v2.optionsMenu.getMenuElement(18).setCurrent(sliderVal2);
                            break;
                        }
                        case 19: {
                            float aggr = buffer.getFloat();
                            int sliderVal3 = buffer.getInt();
                            Game_Calendar.AI_AGGRESSIVNESS = aggr;
                            if (Menu_CreateNewGame_Options_v2.optionsMenu == null) break;
                            Menu_CreateNewGame_Options_v2.optionsMenu.getMenuElement(19).setCurrent(sliderVal3);
                            break;
                        }
                    }
                });
                break;
            }
            case DISBAND_ARMY_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int provinceID = buffer.getInt();
                    int numOfUnits = buffer.getInt();
                    int civID = buffer.getInt();
                    Gdx.app.postRunnable(() -> {
                        CFG.gameAction.disbandArmy(provinceID, numOfUnits, civID);
                        CFG.game.checkProvinceActionMenu();
                        CFG.menuManager.updateInGame_TOP_All(civID);
                        CFG.gameAction.updateInGame_ProvinceInfo();
                        if (CFG.menuManager.getVisibleInGame_CensusOfProvince()) {
                            CFG.menuManager.rebuildInGame_CensusOfProvince(provinceID);
                        }
                        if (CFG.viewsManager.getActiveViewID() == ViewsManager.VIEW_ARMY_MODE) {
                            CFG.updateMAX_Army();
                        }
                        CFG.game.getPlayer(CFG.PLAYER_TURNID).setNoOrders(false);
                        Menu_InGame.updateOverBudget();
                        if (RTS.isEnabled() && !RTS.PAUSE) {
                            RTS.updateTimePast_AfterAction(0.75f);
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println("[DISBAND_ARMY_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case PEACE_NEGOTIATIONS_REQUEST_BROADCAST: {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    int lobbyUidLen = buffer.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buffer.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    byte[] peaceDataBytes = new byte[buffer.remaining()];
                    buffer.get(peaceDataBytes);
                    PeaceTreaty_GameData_MessageData peaceData = PeaceTreaty_GameData_MessageData.fromByte(peaceDataBytes);
                    if (peaceData == null) break;
                    CFG.game.lPeaceTreaties.add(peaceData);
                    int iFromCivID = -1;
                    boolean toDefenders = false;
                    if (peaceData.peaceTreaty_GameData.lCivsData_Aggressors != null && peaceData.peaceTreaty_GameData.lCivsData_Aggressors.size() > 0) {
                        iFromCivID = peaceData.peaceTreaty_GameData.lCivsData_Aggressors.get((int)0).iCivID;
                        toDefenders = false;
                    } else if (peaceData.peaceTreaty_GameData.lCivsData_Defenders != null && peaceData.peaceTreaty_GameData.lCivsData_Defenders.size() > 0) {
                        iFromCivID = peaceData.peaceTreaty_GameData.lCivsData_Defenders.get((int)0).iCivID;
                        toDefenders = true;
                    }
                    DiplomacyManager.sendPeaceTreaty(toDefenders, iFromCivID, peaceData.peaceTreaty_GameData);
                    Gdx.app.postRunnable(() -> {
                        String tag = peaceData.PEACE_TREATY_TAG;
                    });
                    String loans = peaceData.PEACE_TREATY_TAG;
                }
                catch (Exception e) {
                    System.err.println("[PEACE_NEGOTIATIONS_REQUEST_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case PEACE_NEGOTIATIONS_RESPONSE_BROADCAST: {
                try {
                    ByteBuffer buf = ByteBuffer.wrap(content);
                    int lobbyUidLen = buf.getInt();
                    byte[] lobbyUidBytes = new byte[lobbyUidLen];
                    buf.get(lobbyUidBytes);
                    String msgLobbyUid = new String(lobbyUidBytes, StandardCharsets.UTF_8);
                    if (LobbyInfo.lobbyUid == null || !LobbyInfo.lobbyUid.equals(msgLobbyUid)) break;
                    int acceptedCiv = buf.getInt();
                    byte[] treatyBytes = new byte[buf.remaining()];
                    buf.get(treatyBytes);
                    PeaceTreaty_GameData_MessageData peaceData = PeaceTreaty_GameData_MessageData.fromByte(treatyBytes);
                    if (peaceData == null) break;
                    String tag = peaceData.PEACE_TREATY_TAG;
                    peaceAccepts.computeIfAbsent(tag, k -> new HashSet()).add(acceptedCiv);
                    int totalSides = peaceData.peaceTreaty_GameData.lCivsDemands_Defenders.size() + peaceData.peaceTreaty_GameData.lCivsDemands_Aggressors.size();
                    if (peaceAccepts.get(tag).size() < totalSides) break;
                    peaceData.peaceTreaty_GameData.lCivsDemands_Defenders.forEach(c -> DiplomacyManager.acceptPeaceTreaty(c.iCivID, tag));
                    peaceData.peaceTreaty_GameData.lCivsDemands_Aggressors.forEach(c -> DiplomacyManager.acceptPeaceTreaty(c.iCivID, tag));
                    peaceAccepts.remove(tag);
                }
                catch (Exception e) {
                    System.err.println("[PEACE_NEGOTIATIONS_RESPONSE_BROADCAST][ERROR] " + e);
                }
                break;
            }
            case REFRESH_REQUEST: {
                try {
                    UUID targetUid = uid;
                    if (LobbyInfo.name == null || LobbyInfo.name.isEmpty()) break;
                    byte[] nameBytes = LobbyInfo.name.getBytes(StandardCharsets.UTF_8);
                    byte[] passBytes = LobbyInfo.password.getBytes(StandardCharsets.UTF_8);
                    byte[] lobbyUidBytes = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
                    int currentPlayers = LobbyInfo.playerList.size();
                    int maxPlayers = 8;
                    ByteBuffer resp = ByteBuffer.allocate(20 + nameBytes.length + 4 + 4 + 4 + passBytes.length + 4 + lobbyUidBytes.length);
                    resp.putLong(targetUid.getMostSignificantBits());
                    resp.putLong(targetUid.getLeastSignificantBits());
                    resp.putInt(nameBytes.length);
                    resp.put(nameBytes);
                    resp.putInt(currentPlayers);
                    resp.putInt(maxPlayers);
                    resp.putInt(passBytes.length);
                    resp.put(passBytes);
                    resp.putInt(lobbyUidBytes.length);
                    resp.put(lobbyUidBytes);
                    M_P2P.sendMessage(MessageCategory.REFRESH_RESPONSE, resp.array());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case REFRESH_RESPONSE: {
                try {
                    ByteBuffer bb = ByteBuffer.wrap(content);
                    long most = bb.getLong();
                    long least = bb.getLong();
                    UUID targetUid = new UUID(most, least);
                    if (!M_P2P.getUid().equals(targetUid) || !LobbyInfo.isHost) break;
                    int nameLen = bb.getInt();
                    byte[] nameBytes = new byte[nameLen];
                    bb.get(nameBytes);
                    String name = new String(nameBytes, StandardCharsets.UTF_8);
                    int currentPlayers = bb.getInt();
                    int maxPlayers = bb.getInt();
                    int n = bb.getInt();
                    byte[] passBytes = new byte[n];
                    bb.get(passBytes);
                    String password = new String(passBytes, StandardCharsets.UTF_8);
                    int lobbyUidLen = bb.getInt();
                    byte[] lBytes = new byte[lobbyUidLen];
                    bb.get(lBytes);
                    String lobbyUid = new String(lBytes, StandardCharsets.UTF_8);
                    Menu_MultiplayerBrowse browse = Menu_MultiplayerBrowse.getInstance();
                    if (browse == null) break;
                    browse.addServer(name, currentPlayers, maxPlayers, password, lobbyUid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("[BILINMEYEN KATEGORI][" + uid + "]: " + content.length + " byte");
            }
        }
    }

    private static void sendPlayerList() {
        try {
            byte[] uidBytes = LobbyInfo.lobbyUid.getBytes(StandardCharsets.UTF_8);
            List<String> list = LobbyInfo.playerList;
            int total = 4 + uidBytes.length + 4;
            for (String s : list) {
                byte[] b = s.getBytes(StandardCharsets.UTF_8);
                total += 4 + b.length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(total);
            buffer.putInt(uidBytes.length);
            buffer.put(uidBytes);
            buffer.putInt(list.size());
            for (String s : list) {
                byte[] b = s.getBytes(StandardCharsets.UTF_8);
                buffer.putInt(b.length);
                buffer.put(b);
            }
            M_P2P.sendMessage(MessageCategory.PLAYERLIST, buffer.array());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

