/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Button_Menu;
import age.of.civilizations2.jakowski.lukasz.Button_Menu_Classic;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import age.of.civilizations2.jakowski.lukasz.M_P2P;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.MenuElement;
import age.of.civilizations2.jakowski.lukasz.Menu_MultiplayerPassword;
import age.of.civilizations2.jakowski.lukasz.MessageCategory;
import age.of.civilizations2.jakowski.lukasz.SliderMenu;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Menu_MultiplayerBrowse
extends SliderMenu {
    private static Menu_MultiplayerBrowse instance;
    private List<ServerInfo> serverList = new ArrayList<ServerInfo>();
    private Button_Menu_Classic hostButton;
    private Button_Menu_Classic refreshButton;
    private Button_Menu_Classic directConnectButton;
    private Button_Menu_Classic prevPageButton;
    private Button_Menu_Classic nextPageButton;
    private Button_Menu_Classic backButton;
    private GlyphLayout layout = new GlyphLayout();
    private int currentPage = 1;
    private int totalPages = 0;
    private final int SERVERS_PER_PAGE = 5;

    public static Menu_MultiplayerBrowse getInstance() {
        return instance;
    }

    protected Menu_MultiplayerBrowse() {
        instance = this;
        this.requestLobbyList();
        this.rebuildLobbyList();
    }

    private void rebuildLobbyList() {
        ArrayList<MenuElement> menuElements = new ArrayList<MenuElement>();
        int panelWidth = 600;
        int centerX = CFG.GAME_WIDTH / 2;
        int startY = CFG.GAME_HEIGHT / 2 - 250 + 40;
        int buttonHeight = 55;
        int spacing = 10;
        this.totalPages = (int)Math.ceil((double)this.serverList.size() / 5.0);
        if (this.totalPages == 0) {
            this.totalPages = 1;
        }
        int startIndex = (this.currentPage - 1) * 5;
        int endIndex = Math.min(startIndex + 5, this.serverList.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ServerInfo server = this.serverList.get(i);
            String displayText = server.name + " | " + server.currentPlayerCount + "/" + server.maxPlayerCount;
            if (server.password != null && !server.password.isEmpty()) {
                displayText = displayText + " [P]";
            }
            int listIndex = i - startIndex;
            menuElements.add(new Button_Menu(displayText, -1, centerX - 290, startY + 65 * listIndex, 580, 55, true));
        }
        int bottomRowY = CFG.GAME_HEIGHT / 2 - 270 + CFG.GAME_HEIGHT - (CFG.GAME_HEIGHT / 2 - 270) - (CFG.BUTTON_HEIGHT + CFG.PADDING * 4) - CFG.BUTTON_HEIGHT - CFG.PADDING;
        int midButtonWidth = 150;
        int pageButtonWidth = 55;
        int totalMidWidth = 450 + CFG.PADDING * 2;
        int midStartX = centerX - totalMidWidth / 2;
        String refreshText = CFG.langManager.get("Refresh") + " [" + this.currentPage + "/" + this.totalPages + "]";
        this.hostButton = new Button_Menu_Classic(CFG.langManager.get("HostNewGame"), -1, midStartX, bottomRowY, 150, CFG.BUTTON_HEIGHT, true, 0.85f, true);
        this.refreshButton = new Button_Menu_Classic(refreshText, -1, midStartX + 150 + CFG.PADDING, bottomRowY, 150, CFG.BUTTON_HEIGHT, true, 0.85f, true);
        this.directConnectButton = new Button_Menu_Classic(CFG.langManager.get("DirectConnect"), -1, midStartX + (150 + CFG.PADDING) * 2, bottomRowY, 150, CFG.BUTTON_HEIGHT, true, 0.85f, true);
        this.hostButton.setCustomTextColor(CFG.COLOR_BASE_SOFT_GRAYISH_WHITE);
        this.refreshButton.setCustomTextColor(CFG.COLOR_BASE_SOFT_GRAYISH_WHITE);
        this.directConnectButton.setCustomTextColor(CFG.COLOR_BASE_SOFT_GRAYISH_WHITE);
        this.prevPageButton = new Button_Menu_Classic("<<", -1, this.hostButton.getPosX() - 55 - CFG.PADDING, bottomRowY, 55, CFG.BUTTON_HEIGHT, true);
        this.nextPageButton = new Button_Menu_Classic(">>", -1, this.directConnectButton.getPosX() + this.directConnectButton.getWidth() + CFG.PADDING, bottomRowY, 55, CFG.BUTTON_HEIGHT, true);
        this.backButton = new Button_Menu_Classic(CFG.langManager.get("Back"), -1, CFG.PADDING, CFG.GAME_HEIGHT - CFG.BUTTON_HEIGHT - CFG.PADDING, 150, CFG.BUTTON_HEIGHT, true);
        menuElements.add(this.hostButton);
        menuElements.add(this.refreshButton);
        menuElements.add(this.directConnectButton);
        menuElements.add(this.prevPageButton);
        menuElements.add(this.nextPageButton);
        menuElements.add(this.backButton);
        this.initMenu(null, 0, 0, CFG.GAME_WIDTH, CFG.GAME_HEIGHT, menuElements);
        this.updateMenuElements_IsInView();
    }

    private void requestLobbyList() {
        M_P2P.sendMessage(MessageCategory.REFRESH_REQUEST, new byte[0]);
    }

    @Override
    protected void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean sliderMenuIsActive) {
        oSB.setColor(new Color(0.0f, 0.0f, 0.0f, 0.75f));
        ImageManager.getImage(Images.patt2).draw(oSB, iTranslateX, iTranslateY, CFG.GAME_WIDTH, CFG.GAME_HEIGHT, 0.0f, 0);
        oSB.setColor(Color.WHITE);
        int panelX = CFG.GAME_WIDTH / 2 - 260 - CFG.PADDING * 6;
        int panelY = CFG.GAME_HEIGHT / 2 - 270;
        int panelW = 450 + CFG.PADDING * 4 + 110;
        int panelH = CFG.GAME_HEIGHT - panelY - (CFG.BUTTON_HEIGHT + CFG.PADDING * 4);
        ImageManager.getImage(Images.main_menu_edge).draw2(oSB, panelX, panelY, panelW, panelH);
        ImageManager.getImage(Images.main_menu_edge2).draw2(oSB, panelX, panelY, panelW, panelH);
        CFG.fontMain.getData().setScale(1.0f);
        String title = CFG.langManager.get("PublicGames");
        this.layout.setText(CFG.fontMain, title);
        CFG.drawText(oSB, title, CFG.GAME_WIDTH / 2 - (int)(this.layout.width / 2.0f), panelY + 15, Color.WHITE);
        CFG.fontMain.getData().setScale(1.0f);
        super.draw(oSB, iTranslateX, iTranslateY, sliderMenuIsActive);
        int iconSize = 25;
        int verticalOffset = 45;
        ImageManager.getImage(Images.wifi).draw(oSB, this.hostButton.getPosX() + CFG.PADDING, this.hostButton.getPosY() + (this.hostButton.getHeight() - 25) / 2 - 45, 25, 25);
        ImageManager.getImage(Images.refresh).draw(oSB, this.refreshButton.getPosX() + CFG.PADDING, this.refreshButton.getPosY() + (this.refreshButton.getHeight() - 25) / 2 - 45, 25, 25);
        ImageManager.getImage(Images.users).draw(oSB, this.directConnectButton.getPosX() + CFG.PADDING, this.directConnectButton.getPosY() + (this.directConnectButton.getHeight() - 25) / 2 - 45, 25, 25);
    }

    @Override
    protected void actionElement(int iID) {
        int serverListSizeOnScreen = Math.min(5, this.serverList.size() - (this.currentPage - 1) * 5);
        if (iID < serverListSizeOnScreen) {
            int actualServerIndex = (this.currentPage - 1) * 5 + iID;
            ServerInfo selectedServer = this.serverList.get(actualServerIndex);
            if (selectedServer.password != null && !selectedServer.password.isEmpty()) {
                CFG.menuManager.setViewIDWithoutAnimation(Menu.eMULTIPLAYER_PASSWORDJOIN);
                Menu_MultiplayerPassword.roomName = selectedServer.name;
                Menu_MultiplayerPassword.roomPassword = "";
                Menu_MultiplayerPassword.lobbyUid = selectedServer.lobbyUid;
            } else {
                System.out.println("Joining room: " + selectedServer.name);
                byte[] nameBytes = selectedServer.name.getBytes(StandardCharsets.UTF_8);
                byte[] passBytes = selectedServer.password.getBytes(StandardCharsets.UTF_8);
                ByteBuffer exitsBuffer = ByteBuffer.allocate(nameBytes.length + 1 + passBytes.length + 1);
                exitsBuffer.put(nameBytes);
                exitsBuffer.put((byte)0);
                exitsBuffer.put(passBytes);
                exitsBuffer.put((byte)0);
                M_P2P.sendMessage(MessageCategory.EXITS, exitsBuffer.array());
                System.out.println("[LOBBY] EXITS mesaj\u0131 g\u00f6nderildi: " + selectedServer.name);
                ByteBuffer joinBuffer = ByteBuffer.allocate(16 + nameBytes.length + 1 + passBytes.length + 1);
                UUID myUid = M_P2P.getUid();
                joinBuffer.putLong(myUid.getMostSignificantBits());
                joinBuffer.putLong(myUid.getLeastSignificantBits());
                joinBuffer.put(nameBytes);
                joinBuffer.put((byte)0);
                joinBuffer.put(passBytes);
                joinBuffer.put((byte)0);
                M_P2P.sendMessage(MessageCategory.IMJOIN, joinBuffer.array());
                System.out.println("[LOBBY] IMJOIN mesaj\u0131 g\u00f6nderildi: " + myUid + ", " + selectedServer.name);
            }
            return;
        }
        if (this.getMenuElement(iID) == this.hostButton) {
            CFG.menuManager.setViewIDWithoutAnimation(Menu.eMULTIPLAYER_HOST);
        } else if (this.getMenuElement(iID) == this.directConnectButton) {
            CFG.menuManager.setViewIDWithoutAnimation(Menu.eMULTIPLAYER_DIRECTCONNECT);
        } else if (this.getMenuElement(iID) == this.prevPageButton) {
            if (this.currentPage > 1) {
                --this.currentPage;
                this.rebuildLobbyList();
            }
        } else if (this.getMenuElement(iID) == this.nextPageButton) {
            if (this.currentPage < this.totalPages) {
                ++this.currentPage;
                this.rebuildLobbyList();
            }
        } else if (this.getMenuElement(iID) == this.backButton) {
            CFG.menuManager.setViewID(Menu.eMAINMENU);
        } else if (this.getMenuElement(iID) == this.refreshButton) {
            this.serverList.clear();
            this.requestLobbyList();
            this.rebuildLobbyList();
        }
    }

    public void addServer(String name, int currentPlayers, int maxPlayers, String password, String lobbyUid) {
        ServerInfo server = new ServerInfo();
        server.name = name;
        server.currentPlayerCount = currentPlayers;
        server.maxPlayerCount = maxPlayers;
        server.password = password == null ? "" : password;
        server.lobbyUid = lobbyUid;
        this.serverList.add(server);
        Gdx.app.postRunnable(() -> this.rebuildLobbyList());
    }

    protected static class ServerInfo {
        String name;
        String password;
        int currentPlayerCount;
        int maxPlayerCount;
        String lobbyUid;

        protected ServerInfo() {
        }
    }
}

